/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAslicep.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAslicep.v#1 $
*/
MAparams MAslice_plane_params_templ {
   boolean plane_vis;
   boolean rot_or_trans;
   boolean plane_or_mesh;
   boolean all_nodes;
   boolean+nosave reset;
   float   scale;
   int     def_dim1;
   int     def_dim2;
   int     dim1;
   int     dim2;
   DefaultXform xform;
   float   x_rot;
   int     x_rot_deci;
   float   y_rot;
   int     y_rot_deci;
   float   z_rot;
   int     z_rot_deci;
   float   x_trans;
   int     x_trans_deci;
   float   y_trans;
   int     y_trans_deci;
   float   z_trans;
   int     z_trans_deci;
   float+nosave def_x_trans;
   float+nosave def_y_trans;
   float+nosave def_z_trans;
};

MAslice_plane_params_templ MAslice_plane_params {
   plane_vis = 1;
   rot_or_trans = 0;
   plane_or_mesh = 0;
   all_nodes = 0;
   reset =;
   scale = 1.0;
   def_dim1 = 30;
   def_dim2 = 30;
   dim1 = 30;
   dim2 = 30;
   x_rot = 0.0;
   x_rot_deci = 0;
   y_rot = 0.0;
   y_rot_deci = 0;
   z_rot = 0.0;
   z_rot_deci = 0;
   x_trans =;
   x_trans_deci = 1;
   y_trans =;
   y_trans_deci = 1;
   z_trans =;
   z_trans_deci = 1;
   init_commands = "";
   reset_commands =
     "slice_plane_params.plane_vis=1;"
    +"slice_plane_params.rot_or_trans=0;"
    +"slice_plane_params.plane_or_mesh=0;"
    +"slice_plane_params.all_nodes=0;"
    +"slice_plane_params.scale=1.0;"
    +"slice_plane_params.dim1=slice_plane_params.def_dim1;"
    +"slice_plane_params.dim2=slice_plane_params.def_dim2;"
    +"slice_plane_params.x_rot=0;"
    +"slice_plane_params.y_rot=0;"
    +"slice_plane_params.z_rot=0;"
    +"slice_plane_params.x_rot_deci=0;"
    +"slice_plane_params.y_rot_deci=0;"
    +"slice_plane_params.z_rot_deci=0;"
    +"slice_plane_params.x_trans=slice_plane_params.def_x_trans;"
    +"slice_plane_params.y_trans=slice_plane_params.def_y_trans;"
    +"slice_plane_params.z_trans=slice_plane_params.def_z_trans;"
    +"slice_plane_params.x_trans_deci=1;"
    +"slice_plane_params.y_trans_deci=1;"
    +"slice_plane_params.z_trans_deci=1;"
    ;
};

MAmacroUI+nosave MAslice_planeUI {
   MAslice_plane_params_templ+IPort2 &slice_plane_params;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;
   float+nres min0_value => .fld_in.coordinates.min_vec[0];
   float+nres max0_value => .fld_in.coordinates.max_vec[0];
   float+nres min1_value => .fld_in.coordinates.min_vec[1];
   float+nres max1_value => .fld_in.coordinates.max_vec[1];
   float+nres min2_value => .fld_in.coordinates.min_vec[2];
   float+nres max2_value => .fld_in.coordinates.max_vec[2];

   height => slice_plane_panel.height;
   MAUIframe slice_plane_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.plane_reset.y + plane_reset.height + 5;
   };
   macro+nosave plane_type {
      ilink slice_plane_params => <-.slice_plane_params;
      ilink parent => <-.slice_plane_panel;
      boolean active => !slice_plane_params.all_nodes;
      UIoption+nosave mesh_opt  {label = "MAFPLANE_MESH"; active=><-.active;};
      UIoption+nosave plane_opt {label = "MAFPLANE_PLANE"; active=><-.active;};
      MAUIradioBox+nosave radioBox {
         visible => <-.plane_vis.set;
         parent => <-.parent;
         cmdList => {<-.plane_opt, <-.mesh_opt};
         x = 130;
         y = 4;
         selectedItem => <-.slice_plane_params.plane_or_mesh;
      };
      MAUItoggle+nosave plane_vis {
         parent => <-.parent;
         label = "FPLANE_VIS_PLANE";
         x = 8;
         y = 12;
         width = 120;
         set => <-.slice_plane_params.plane_vis;
         label = "MAFPLANE_VIS_PLANE";
         active => <-.active;
      };
   };
   macro+nosave plane_trans {
      ilink slice_plane_params => <-.slice_plane_params;
      ilink parent => <-.slice_plane_panel;
      boolean active => !slice_plane_params.all_nodes;
      MAUIframe frame {
         parent => <-.parent;
         x = 5;
         y = 55;
         width = 220;
         height => max_array({<-.rot_panel.y + <-.rot_panel.height,
                              <-.trans_panel.y + <-.trans_panel.height});
      };
      UIoption+nosave rot_opt   {label = "MAFPLANE_ROTATE"; active=><-.active;};
      UIoption+nosave trans_opt {label = "MAFPLANE_TRANS"; active=><-.active;};
      MAUIradioBox+nosave switch_opt {
         parent => <-.frame;
         cmdList => {<-.rot_opt, <-.trans_opt};
         x = 5;
         y = 4;
         width = 200;
         height = 50;
         selectedItem => <-.slice_plane_params.rot_or_trans;
      };
      MAUIpanel rot_panel {
         parent => <-.frame;
         x = 0;
         y = 55;
         width = 205;
         height => <-.z_rot_slider.y + <-.z_rot_slider.height + 5; 
         visible => !<-.slice_plane_params.rot_or_trans;
      };
      MAUIslider2 x_rot_slider { 
         x = 5;
         y = 0;
         parent => <-.rot_panel;
         value => <-.slice_plane_params.x_rot;
         min = -180;
         max =  180;
         allwidth = 200;
         decimalPoints =><-.slice_plane_params.x_rot_deci;
         min_oonly = 1;
         max_oonly = 1;
         title = "MAFPLANE_XROT";
         active => <-.active;
      };
      x_rot_slider y_rot_slider { 
         decimalPoints =><-.slice_plane_params.y_rot_deci;
         y =><-.x_rot_slider.y + <-.x_rot_slider.height + 5; 
         value => <-.slice_plane_params.y_rot; 
         title = "MAFPLANE_YROT";
      };
      x_rot_slider z_rot_slider { 
         decimalPoints =><-.slice_plane_params.z_rot_deci;
         y =><-.y_rot_slider.y + <-.y_rot_slider.height + 5; 
         value => <-.slice_plane_params.z_rot; 
         title = "MAFPLANE_ZROT";
      };
      rot_panel trans_panel {
         visible => <-.slice_plane_params.rot_or_trans;
         height => <-.z_trans_slider.y + <-.z_trans_slider.height + 5; 
      };
      MAUIslider2 x_trans_slider {
         value => <-.slice_plane_params.x_trans;
         x = 5;
         y =  0; 
         allwidth = 200; 
         parent => <-.trans_panel;
         min => <-.<-.min0_value;
         max => <-.<-.max0_value;
         decimalPoints => <-.slice_plane_params.x_trans_deci;
         title = "MAFPLANE_XTRANS";
         active => <-.active;
      };
      x_trans_slider y_trans_slider {
         y =><-.x_trans_slider.y + <-.x_trans_slider.height + 5; 
         value => <-.slice_plane_params.y_trans;
         min => <-.<-.min1_value;
         max => <-.<-.max1_value;
         decimalPoints => <-.slice_plane_params.y_trans_deci;
         title = "MAFPLANE_YTRANS";
      };
      x_trans_slider z_trans_slider {
         y =><-.y_trans_slider.y + <-.y_trans_slider.height + 5; 
         value => <-.slice_plane_params.z_trans;
         min => <-.<-.min2_value;
         max => <-.<-.max2_value;
         decimalPoints => <-.slice_plane_params.z_trans_deci;
         title = "MAFPLANE_ZTRANS";
      };
   };
   macro+nosave plane_scale {
      ilink slice_plane_params => <-.slice_plane_params;
      ilink parent => <-.slice_plane_panel;
      boolean active => !slice_plane_params.all_nodes;
      MAUIframe frame {
         parent => <-.parent;
         x =><-.<-.plane_trans.frame.x;
         y =><-.<-.plane_trans.frame.y + <-.<-.plane_trans.frame.height;
         width = 220;
         height => <-.y_dim.y + <-.y_dim.height + 5;
      };
      MAUIFieldLabel scale {
         parent => <-.frame;
         x = 0;
         y = 7;
         label => "MAFPLANE_P_SCALE";
         decimalPoints = 2;
         immediateMode = 0;
         min = 0.;
         &value => <-.slice_plane_params.scale;
         active => <-.active;
      };
      MAUIFieldLabel x_dim {
         parent => <-.frame;
         y => <-.scale.y + <-.scale.height;
         label => "MAFPLANE_DIM" + " " + "MAFPLANE_XDIM";
         &value => <-.slice_plane_params.dim1;
         mode = 1; //"integer";
         decimalPoints = 0;
         min = 2;
         immediateMode = 0;
         active => <-.active;
      };
      x_dim y_dim {
         y => <-.x_dim.y + <-.x_dim.height;
         label => "MAFPLANE_DIM" + " " + "MAFPLANE_YDIM";
         &value => <-.slice_plane_params.dim2;
         active => <-.active;
      };
   };
   MAUIbutton plane_reset {
      parent => <-.slice_plane_panel;
      x =><-.plane_scale.frame.x;
      y =><-.plane_scale.frame.y + <-.plane_scale.frame.height + 5;
      width = 220;
      height = 25;
      &do => <-.slice_plane_params.reset;
      label = "MAFPLANE_RES_P";
      active => !<-.slice_plane_params.all_nodes;
   };
};

MAmodule MAslice_plane {
   MAslice_plane_params_templ+IPort2 &slice_plane_params;
   Mesh+Node_Data+IPort2 &fld_in<NEportLevels={2,1}>;

   Mesh_Unif+Space2+Dim2 slice_plane<NEportLevels={0,1}> {
      dims => {<-.slice_plane_params.dim1,<-.slice_plane_params.dim2};
      points+nres => {
         0,0,
         fld_in.coordinates.max_vec[0]-fld_in.coordinates.min_vec[0],
         fld_in.coordinates.max_vec[1]-fld_in.coordinates.min_vec[1]
      };
      &xform => <-.slice_plane_params.xform;
   };
   MADVinterp_data interp_data {
      in => <-.fld_in;
      probe => <-.slice_plane;
      comps = {0};
   };
   MADVcombine_mesh_and_data combine {
      in_mesh => slice_plane;
      in_nd => interp_data.out;
   };

   GMOD.parse_v ResetPlane {
      trigger => <-.slice_plane_params.reset;
      active => <-.slice_plane_params.reset;
      on_inst = 0;
      relative => <-.slice_plane_params;
      v_commands =
      "$push -usr\n"
     +"scale=1.0;"
     +"dim1=def_dim1;"
     +"dim2=def_dim2;"
     +"x_rot=0.0;"
     +"y_rot=0.0;"
     +"z_rot=0.0;"
     +"x_trans=def_x_trans;"
     +"y_trans=def_y_trans;"
     +"z_trans=def_z_trans;"
     +"reset=0;"
     +"$pop\n";
   };
   MAset_param set_x_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[0]);
      in_value+nres => <-.fld_in.coordinates.min_vec[0];
      def_value     => <-.slice_plane_params.def_x_trans;
      value         => <-.slice_plane_params.x_trans;
   };
   MAset_param set_y_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[1]);
      in_value+nres => <-.fld_in.coordinates.min_vec[1];
      def_value     => <-.slice_plane_params.def_y_trans;
      value         => <-.slice_plane_params.y_trans;
   };
   MAset_param set_z_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[2])
                      &is_valid(fld_in.coordinates.max_vec[2]);
      in_value+nres => (<-.fld_in.coordinates.min_vec[2]
                       +<-.fld_in.coordinates.max_vec[2]) * 0.5;
      def_value     => <-.slice_plane_params.def_z_trans;
      value         => <-.slice_plane_params.z_trans;
   };

   MAGDxform_edit+nosave XformEdit {
      scale => <-.slice_plane_params.scale;
      //shell_vis => <-.slice_plane_params.plane_vis;
      absolute = 1;
      xform => <-.slice_plane_params.xform;
      x_rot => <-.slice_plane_params.x_rot;
      y_rot => <-.slice_plane_params.y_rot;
      z_rot => <-.slice_plane_params.z_rot;
      x_trans => <-.slice_plane_params.x_trans;
      y_trans => <-.slice_plane_params.y_trans;
      z_trans => <-.slice_plane_params.z_trans;
   };

   MAdataObject+nosave DataObject {
      ilink slice_plane_params => <-.slice_plane_params;
      in => <-.slice_plane;
      Obj {
         xform =>; // never connected 
         visible => <-.slice_plane_params.plane_vis *
                   !<-.slice_plane_params.all_nodes;
         name => "ME_SLICE";
         pickable = 0;
      };
      Props.trans = 0.2;
      GMOD.copy_on_change set_plane_or_mesh {
         input => <-.slice_plane_params.plane_or_mesh + 1;
         output => <-.Modes.mode[1];
      };
   };
   fld_out => combine.out;
   olink obj_out => DataObject.obj;
};
