/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAvolren.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAvolren.v#1 $
*/
MAparams MAvolren_params {
   int     border =;
   int+nosave def_border = 128;
   float   low_min = 0;
   float   low_max = 0;
   float   high_min = 1;
   float   high_max = 1;
   boolean smooth = 0;
   boolean model = 0;
   init_commands = "";
   reset_commands = "volren_params.border=volren_params.def_border;"
                   +"volren_params.low_min=0;"
                   +"volren_params.low_max=0;"
                   +"volren_params.high_min=1;"
                   +"volren_params.high_max=1;"
                   +"volren_params.smooth=0;"
                   +"volren_params.model=0;"
                   ;
};

MAmacroUI MAvolrenUI {
   MAvolren_params+IPort2 &volren_params;
   /*** v6.0 2002.01.22 add ***/
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}>;
   /*** end v6.0 2002.01.22 add ***/
   MAdefaultObject+Port2 &obj_in;
   height => volren_panel.height;
   MAUIframe volren_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.etc_frame.y + <-.etc_frame.height + 5;
   };
   MAUIframe border_frame {
      parent => <-.volren_panel;
      x = 5;
      y = 5;
      width = 220;
      height => <-.DmapEcho.height;
   };
   MAUIframe etc_frame {
      parent => <-.volren_panel;
      x = 5;
      y => <-.border_frame.y + <-.border_frame.height + 5;
      width => <-.border_frame.width;
      height = 60;
   };
   MAUItoggle smooth_toggle {
      parent => <-.etc_frame;
      x = 5;
      y = 5;
      label => "MAVOL_SMOOTH";
      set =><-.volren_params.smooth;
   };
   MAUItoggle alpha_toggle {
      parent => <-.etc_frame;
      x = 5;
      y => smooth_toggle.y + smooth_toggle.height + 5; 
      label => "MAVOL_MODEL";
      set =><-.volren_params.model;
      /*** v6.0 2002.01.22 add ***/
      active => <-.colmap_params.UI_active;
      /*** end v6.0 2002.01.22 add ***/
   };

   macro DmapEcho {
      ilink parent => <-.border_frame;
      MAdefaultObject &obj_in<NEportLevels={2,1}> => <-.obj_in;
      float ramp[] => {
         init_array(256,0,255),init_array(256,0,255)};
      MAdefaultCamera2D DmapCamera {
         objects => {<-.Legend};
         update = 1;
      };
      BestVirtPal DmapPal { gamma = 1.0; };
      MAdefaultView DmapView {
         aspect = "Biggest";
         back_col => {0.5,0.5,0.5};
         cameras => {<-.DmapCamera};
         handle => <-.dmapechoUI.area.handle;
         virtpal => <-.DmapPal;
      };
      float+nres dmapMin => obj_in.dmap.dataMin;
      float+nres dmapMax => obj_in.dmap.dataMax;
      float+nres dmapIncr => (.dmapMax - .dmapMin) / 256.;
      float arr[512] => {
         init_array(256,0,255),init_array(256,0,255)
      };
      Mesh_Unif+Node_Data LegendField<NEportLevels={0,1}> {
         nnodes => prod(dims);
         dims = {256,2};
         ndim = 2;
         Data_Array node_data[nnode_data] {
            nvals => nnodes;
            veclen = 1;
            float values[nvals][veclen] => arr * dmapIncr + dmapMin;
            float+opt null_value;
            float min;
            float max;
            float min_vec[veclen];
            float max_vec[veclen];
         };
         nnode_data = 1;
         nspace = 3;
         points => {{-1,-1,0}, {1,1,0}};
      };
      DefaultProps DefaultProps;
      MAdefaultObject Legend<NEportLevels={0,1}> {
         input => <-.LegendField;
         dmap => obj_in.dmap;
         props => <-.DefaultProps;
         xform_mode = "Locked";
         name => name_of(<-.<-.<-) + "Legend";
      };
      macro dmapechoUI {
         ilink parent => <-.parent;
         float+nres dmapMin => <-.dmapMin;
         float+nres dmapMax => <-.dmapMax;
         float+nres dmapRange => dmapMax - dmapMin;
         string strMin => str_format("%d", dmapMin);
         string strMax => str_format("%d", dmapMax);
         olink height => high_frame.y + high_frame.height + 5;
         MAUIslider border_slider {
            parent => <-.parent;
            y = 5;
            x = 10;
            width = 195;
            min => <-.dmapMin;
            max => <-.dmapMax;
            value =><-.<-.<-.volren_params.border;
            mode = "integer";
            /*** v6.0 2002.01.22 add ***/
            active => <-.<-.<-.colmap_params.UI_active;
            /*** end v6.0 2002.01.22 add ***/
            title => "MAVOL_BORDER";
         };
         UIrenderView area {
            parent => <-.parent;
            width = 170;
            height = 20;
            x = 20;
            y => border_slider.y + border_slider.height + 10;
         };
         double rate => .area.width / dmapRange;
         MAUIpanel low_area {
            parent => <-.parent;
            x => <-.area.x;
            y => <-.area.y + <-.area.height;
            width => border_slider.value * rate; 
            height = 10;
            color.backgroundColor = MAVS_BLUE;
         };
         low_area high_area {
            x => <-.low_area.x + <-.low_area.width;
            width => <-.area.width - <-.low_area.width;
            color.backgroundColor = MAVS_RED;
         };
         MAUIlabel min_label {
            parent => <-.parent;
            label => <-.strMin;
            x => <-.area.x - .width / 2;
            y => <-.low_area.y + <-.low_area.height;
            width = 40;
            color.foregroundColor => <-.<-.low_area.color.backgroundColor;
         };
         MAUIlabel max_label {
            parent => <-.parent;
            label => <-.strMax;
            x => <-.area.x + <-.area.width - .width / 2;
            y => <-.min_label.y;
            width => min_label.width;
            color.foregroundColor => <-.<-.high_area.color.backgroundColor;
         };
         MAUIlabel border_label {
            parent => <-.parent;
            label => border_slider.value;
            x => <-.low_area.x + <-.low_area.width - width / 2;
            y => min_label.y;
            width => min_label.width;
         };
         MAUIframe low_frame {
            parent => <-.parent;
            x = 5;
            y => border_label.y + border_label.height + 0;
            width = 200;
            height => low_max_slider.y + low_max_slider.height + 10;
         };
         MAUIlabel low_title {
            parent => <-.low_frame;
            y = 5;
            width => low_frame.width;
            label => "MAVOL_LOW_T";
            color.foregroundColor => low_area.color.backgroundColor;
         };
         MAUIslider2 low_min_slider {
            parent => <-.low_frame;
            x = 5;
            y => low_title.y + low_title.height;
            min = 0.;
            max = 1.;
            value => <-.<-.<-.volren_params.low_min;
            title => "MAVOL_ALPHA" + " "+ <-.strMin + " " + "MAVOL_VALUE";
            allwidth = 185;
            color.foregroundColor => low_area.color.backgroundColor;
            min_oonly = 1;
            max_oonly = 1;
            /*** v6.0 2002.01.22 add ***/
            active => <-.<-.<-.colmap_params.UI_active;
            /*** end v6.0 2002.01.22 add ***/
         };
         low_min_slider low_max_slider {
            y => <-.low_min_slider.y + <-.low_min_slider.height + 4;
            value => <-.<-.<-.volren_params.low_max;
            title => "MAVOL_ALPHA" + " " + border_slider.value + " " + 
                     "MAVOL_VALUE";
         };
         MAUIframe high_frame {
            parent => <-.parent;
            x => low_frame.x;
            y => low_frame.y + low_frame.height + 5;
            width => low_frame.width;
            height => low_frame.height;
            };
         MAUIlabel max_title {
            parent => <-.high_frame;
            label => "MAVOL_HIGH_T";
            y = 5;
            width => high_frame.width;
            color.foregroundColor => high_area.color.backgroundColor;
         };
         low_min_slider high_min_slider {
            parent => <-.high_frame;
            y => max_title.y + max_title.height;
            value => <-.<-.<-.volren_params.high_min;
            title => "MAVOL_ALPHA" + " " + border_slider.value + " " + 
                     "MAVOL_VALUE";
            color.foregroundColor => high_area.color.backgroundColor;
         };
         low_min_slider high_max_slider {
            parent => <-.high_frame;
            y => <-.high_min_slider.y + <-.high_min_slider.height + 4;
            value => <-.<-.<-.volren_params.high_max;
            title => "MAVOL_ALPHA" + " " + <-.strMax + " " + "MAVOL_VALUE";
            color.foregroundColor => high_area.color.backgroundColor;
         };
      };
      olink height => dmapechoUI.height;
   };
};
//
MAmodule MAvolren {
   MAvolren_params+IPort2 &volren_params;
   MAset_param set_border {
      trigger+nres => is_valid(<-.fld_in.node_data[0].max) &&
                      is_valid(<-.fld_in.node_data[0].min);
      in_value+nres => (<-.fld_in.node_data[0].max
                      - <-.fld_in.node_data[0].min + 1) / 2;
      def_value => <-.volren_params.def_border;
      value => <-.volren_params.border;
   };
   fld_out => fld_in;
};
