/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/templ.v#1 $
*/
//
// MicroAVS 4.0 uses components of DV Kit
//
Node_Data MAnode_Data {
   node_data {
      &min+nres     => in.node_data[index_of(node_data)].min;
      &max+nres     => in.node_data[index_of(node_data)].max;
      &min_vec+nres => in.node_data[index_of(node_data)].min_vec;
      &max_vec+nres => in.node_data[index_of(node_data)].max_vec;
   };
};
DVread_image+nosave		MADVread_image;
DVwrite_image+nosave		MADVwrite_image;
DVfld_match+nosave		MADVfld_match;
DVnode_data_labels+nosave	MADVnode_data_labels;
DVswitch+nosave			MADVswitch;
DVglyph+nosave			MADVglyph;
DVgeo_glyph+nosave		MADVgeo_glyph;
DVextract_comp+nosave		MADVextract_comp;
DVextract_mesh+nosave		MADVextract_mesh;
DVsurf_plot+nosave		MADVsurf_plot;
DVadvect+nosave			MADVadvect;
DVbounds+nosave			MADVbounds {
   out {
      coordinates {
         &min_vec+nres    => in.coordinates.min_vec;
         &max_vec+nres    => in.coordinates.max_vec;
      };
   };
};
DVextr_vector+nosave		MADVextr_vector;
DVcontour+nosave		MADVcontour;
#ifdef OLDOLD
DVdownsize_unif+nosave 		MADVdownsize_unif;
DVdownsize_rect+nosave 		MADVdownsize_rect;
DVdownsize_struct+nosave 	MADVdownsize_struct;
#endif
DVext_edge+nosave		MADVext_edges;
DVext_face+nosave 		MADVext_face;
DVextr_scalar+nosave		MADVextr_scalar {
   out {
      node_data {
         &min+nres     => in.node_data[index_of(node_data)].min;
         &max+nres     => in.node_data[index_of(node_data)].max;
         &min_vec+nres => in.node_data[index_of(node_data)].min_vec;
         &max_vec+nres => in.node_data[index_of(node_data)].max_vec;
      };
   };
};
DVisoline+nosave		MADVisoline;
DViso+nosave			MADVisosurface;
DVcomb_comp+nosave		MADVcomb_comp;
DVoffset+nosave			MADVoffset;
DVorthoslice_unif+nosave	MADVorthoslice_unif;
DVorthoslice_struct+nosave	MADVorthoslice_struct;
DVorthoslice_rect+nosave	MADVorthoslice_rect;
DVprobe+nosave			MADVprobe;
DVscat_to_unif+nosave		MADVscat2uni;
DVinterp_data+nosave		MADVinterp_data;
DVstream+nosave			MADVstream;
DVmagnitude+nosave		MADVmagnitude;
DVcut+nosave			MADVcut;
DVexcavate_brick3d+nosave	MADVexcavate_brick3d;
DVcrop+nosave			MADVcrop;
DVextr_cell_comp+nosave		MADVextract_cell_component;
DVcell_to_node+nosave		MADVcell_to_node;
DVcell_data_labels+nosave	MADVcell_data_labels;
DVextract_mesh+nosave		MADVextract_mesh;
DVcell_centres+nosave		MADVcell_centers;
DVseparate_cells+nosave		MADVseparate_cells;
DVinterp_cell_data+nosave	MADVinterp_cell_data;
DVnmap+nosave			MADVnmap;
DVslice_gen+nosave		MADVslice_gen;
//
// MicroAVS 4.0 Custom Components
//
module+nosave MADVcombine_arrays_3 {
   prim+IPort2 &in1[];
   prim+IPort2 &in2[];
   prim+IPort2 &in3[];
   int dim=>array_size(in1);
   prim rin1[dim][1] => in1;
   prim rin2[dim][1] => in2;
   prim rin3[dim][1] => in3;
   prim+OPort2 out[array_size(in1)][3]=>combine_array(rin1,rin2,rin3);
};
module+nosave MADVinterleave_3_arrays {
   prim+IPort2 &in1[];
   prim+IPort2 &in2[];
   prim+IPort2 &in3[];
   int dim1=>array_size(in1);
   int dim2=>array_size(in2);
   int dim3=>array_size(in3);
   prim rin1[dim1][1] => in1;
   prim rin2[dim2][1] => in2;
   prim rin3[dim3][1] => in3;
   prim+OPort2 out[dim1][3]=>combine_array(rin1,rin2,rin3);
};
module+nosave MADVradius_data {
   prim+IPort2 &in_data[];
   Node_Data+OPort2 out {
      nnodes => switch((array_size(<-.in_data) > 0), array_size(<-.in_data));
      nnode_data = 1;
      node_data {
         veclen = 1;
         values => <-.<-.in_data;
         id = 668;
      };
   };
};
module+nosave MADVpoint_mesh {
   float+IPort2 &coord[][];
   int coord_dims[] => array_dims(coord);
   Mesh+OPort2  out {
      nnodes => <-.coord_dims[1];
      nspace => <-.coord_dims[0];
      coordinates.values => <-.<-.coord;
      ncell_sets = 1;
      Point cell_set {
         ncells => <-.nnodes;
         node_connect_list => init_array(ncells, 0, ncells-1);
      };
   };
};
module+nosave MADVcombine_mesh_and_data {
   Mesh+IPort2 &in_mesh;
   Node_Data+nres+IPort2 &in_nd;
   Mesh+Node_Data+OPort2 &out => merge(in_nd, in_mesh);
};

//
// Axis
// DVaxis do not use field in.
//DVaxis+nosave		MADVaxis { group in { int nnodes = 0; }; };


//
// MicroAVS 5.0 uses components of DV Kit
//
DVcoord_math+nosave		MADVcoord_math;
DVdata_math+nosave		MADVdata_math;
DV_Param_extract_scalar+nosave	MADV_Param_extract_scalar;
DV_Param_cut			MADV_Param_cut;
DVplane_dist			MADVplane_dist;
DVcomb_mesh_and_data		MADVcomb_mesh_and_data;


//
// MicroAVS 6.0 uses components of DV Kit
//
DV_OGL.illuminated_lines_mesh_mapper	MAilluminated_lines_mesh_mapper;
DV_OGL.iline_calc_texmap		MAiline_calc_texmap;
DV_OGL.iline_create_effect_data		MAiline_create_effect_data;
DV_OGL.iline_calc_tangents		MAiline_calc_tangents;
DV_OGL.Mesh_Polyline			MAMesh_Polyline<NEvisible=1>;

//
// MicroAVS 7.0 uses components of DV Kit
//
FLD_MAP.interleave_2_arrays	MAinterleave_2_arrays;
//DMAP.Dmap2Image			MADmap2Image;
