/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/arisol3d.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
MAnetwork FLDArIsoline3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ARISOLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ARISOLINE_T";
   MAGDobject_templ-nosave+IPort2 &picked_obj;
   Params {
      params.help_name = "arisol3d";
      params.name = "arisol3d";
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAnew_slice_plane_params new_slice_plane_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
                                 + extract_scalar_params.init_commands
                                 + new_slice_plane_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + extract_scalar_params.reset_commands
                                 + new_slice_plane_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      ilink pick_in =><-.picked_obj;
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAnew_slice_plane MAnew_slice_plane {
         in_pick =><-.pick_in;
         new_slice_plane_params =><-.<-.Params.new_slice_plane_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAisoline MAisoline {
         isoline_params =><-.<-.Params.isoline_params;
         fld_in =><-.MAnew_slice_plane.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAisoline.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAisoline.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink pick_obj_out => .MAnew_slice_plane.out_pick_obj;
      olink slice_obj_out => .MAnew_slice_plane.out_slice_obj;
      olink axis_obj_out => .MAnew_slice_plane.out_axis_obj;
      olink text_out => .MAisoline.text_out;
      olink bounds_out => .MAisoline.bounds_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAnew_slice_planeUI.height
               + MAextract_scalarUI.height
               + MAisolineUI.height 
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAnew_slice_planeUI MAnew_slice_planeUI {
         fld_in =><-.<-.Modules.MAnew_slice_plane.fld_in;
         parent => <-.parent;
         new_slice_plane_params =><-.<-.Params.new_slice_plane_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAisolineUI MAisolineUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_out;
         parent => <-.parent;
         isoline_params =><-.<-.Params.isoline_params;
         y =><-.MAnew_slice_planeUI.y + <-.MAnew_slice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAisolineUI.y + <-.MAisolineUI.height;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.pick_obj_out,
                             <-.Modules.slice_obj_out,
                             <-.Modules.axis_obj_out,
                             <-.Modules.text_out,
                             <-.Modules.bounds_out
                            };
};
