/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/birdte.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/birdte.v#1 $
*/
MAnetwork FLDBirdTex3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_BIRDEYE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_BIRDEYE_T";
   Params {
      params.help_name = "btex3d";
      params.name = "bird_eye";
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAorthoslice_params orthoslice_params;
      MAbird_eye_params bird_eye_params;
      init_params.init_commands => extract_scalar_params.init_commands
                                 + downsize_params.init_commands
                                 + orthoslice_params.init_commands
                                 + bird_eye_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + downsize_params.reset_commands
                                 + orthoslice_params.reset_commands
                                 + bird_eye_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in =><-.fld_in;
      };
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAorthoslice MAorthoslice {
         orthoslice_params =><-.<-.Params.orthoslice_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAbird_eye MAbird_eye {
         bird_eye_params =><-.<-.Params.bird_eye_params;
         fld_in =><-.MAorthoslice.fld_out;
      };
      fld_out => MAbird_eye.fld_out;
      olink texture_out => MAbird_eye.fld2_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAorthosliceUI.height
               + MAextract_scalarUI.height
               + MAbird_eyeUI.height 
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active; 
      }; 
#endif //OLDOLD
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAorthosliceUI MAorthosliceUI {
         fld_in =><-.<-.Modules.MAorthoslice.fld_in;
         parent => <-.parent;
         orthoslice_params =><-.<-.Params.orthoslice_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAbird_eyeUI MAbird_eyeUI {
         parent => <-.parent;
         bird_eye_params =><-.<-.Params.bird_eye_params;
         y =><-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
      };
   };
   // Input Texture Data from MAbird_eye
   DataObject {
      ilink texture_in =><-.Modules.texture_out;
      MAdefaultTexture Texture { data =><-.texture_in; };
      Obj.texture =><-.Texture; 
   };
};
MAnetwork FLDBirdTex2D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_BIRDEYE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_BIRDEYE_T";
   Params {
      params.help_name = "btex2d";
      params.name = "bird_eye";
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAbird_eye_params bird_eye_params;
      init_params.init_commands => extract_scalar_params.init_commands
                                 + downsize_params.init_commands
                                 + bird_eye_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + downsize_params.reset_commands
                                 + bird_eye_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in =><-.fld_in;
      };
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAbird_eye MAbird_eye {
         bird_eye_params =><-.<-.Params.bird_eye_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      fld_out => MAbird_eye.fld_out;
      olink texture_out => MAbird_eye.fld2_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAextract_scalarUI.height
               + MAbird_eyeUI.height 
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active; 
      }; 
#endif //OLDOLD
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAbird_eyeUI MAbird_eyeUI {
         parent => <-.parent;
         bird_eye_params =><-.<-.Params.bird_eye_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
   };
   // Input Texture Data from MAbird_eye
   DataObject {
      ilink texture_in =><-.Modules.texture_out;
      MAdefaultTexture Texture { data =><-.texture_in; };
      Obj.texture =><-.Texture; 
   };
};
