/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/extfac.v#1 $
*/
MAnetwork FLDExtface
#ifdef MAVS_USE_USER_NAME
< user_name="ME_EXTFACE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_EXTFACE_T";
   ilink-nosave+IPort2+nres in_pick;

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT

   Params {
      params.name = "extface";
      params.help_name = "extface";
      MAextract_scalar_params extract_scalar_params;
      MAext_faces_params ext_faces_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => extract_scalar_params.init_commands
                                 + ext_faces_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + ext_faces_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAext_faces MAext_faces {
         fld_in =><-.MAextract_scalar.fld_out;
         ext_faces_params =><-.<-.Params.ext_faces_params;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params=> Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAext_faces.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;

   /*  for MicroAVS5.0 cut_plane */

      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAcut_plane.out_fld;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out             => MAscalar2texture.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink texture_out   => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAext_facesUI.height
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAext_facesUI MAext_facesUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         ext_faces_params =><-.<-.Params.ext_faces_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAext_facesUI.y + <-.MAext_facesUI.height;
         active => <-.<-.Params.ext_faces_params.color;
      };
   };
/*  for MicroAVS5.0 cut_plane */

   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAcut_plane.out_fld;
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => {<-.Modules.legend_out,<-.Modules.MAcut_plane.plane_axis_obj};
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
/*  for MicroAVS5.0 cut_plane */

};
