/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/isolin.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/isolin.v#1 $
*/
MAnetwork FLDIsoline3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ISOLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ISOLINE_T";
   Params {
      params.help_name = "isolin3d";
      params.name = "isoline";
      MAplane_params plane_params;
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAorthoslice_params orthoslice_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title + " " + "MACONT_PLANE1"; };
      MAcolmap_params colmap_params { title => <-.<-.title + " " + "MACONT_PLANE1"; };
      MAdownsize_params downsize_params2;
      MAextract_scalar_params extract_scalar_params2;
      MAorthoslice_params orthoslice_params2;
      MAisoline_params isoline_params2;
      MAlegend_params2 legend_params2 { title => <-.<-.title + " " + "MACONT_PLANE2"; };
      MAcolmap_params colmap_params2 { title => <-.<-.title + " " + "MACONT_PLANE2"; };
      MAdownsize_params downsize_params3;
      MAextract_scalar_params extract_scalar_params3;
      MAorthoslice_params orthoslice_params3;
      MAisoline_params isoline_params3;
      MAlegend_params2 legend_params3 { title => <-.<-.title + " " + "MACONT_PLANE3"; };
      MAcolmap_params colmap_params3 { title => <-.<-.title + " " + "MACONT_PLANE3"; };
      init_params.init_commands => plane_params.init_commands
                                 + downsize_params.init_commands
				 + extract_scalar_params.init_commands
                                 + orthoslice_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands
                                 + downsize_params2.init_commands
                                 + extract_scalar_params2.init_commands
                                 + orthoslice_params2.init_commands
                                 + isoline_params2.init_commands
                                 + legend_params2.init_commands
                                 + colmap_params2.init_commands
                                 + downsize_params3.init_commands
                                 + extract_scalar_params3.init_commands
                                 + orthoslice_params3.init_commands
                                 + isoline_params3.init_commands
                                 + legend_params3.init_commands
                                 + colmap_params3.init_commands;
      reset_params.reset_commands => plane_params.reset_commands
                                 + downsize_params.reset_commands
				 + extract_scalar_params.reset_commands
                                 + orthoslice_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands
                                 + downsize_params2.reset_commands
                                 + extract_scalar_params2.reset_commands
                                 + orthoslice_params2.reset_commands
                                 + isoline_params2.reset_commands
                                 + legend_params2.reset_commands
                                 + colmap_params2.reset_commands
                                 + downsize_params3.reset_commands
                                 + extract_scalar_params3.reset_commands
                                 + orthoslice_params3.reset_commands
                                 + isoline_params3.reset_commands
                                 + legend_params3.reset_commands
                                 + colmap_params3.reset_commands;
   };
   Modules {
      ilink obj2_in => <-.DataObject2.obj;
      ilink obj3_in => <-.DataObject3.obj;
      MAdownsize MAdownsize {
   	 fld_in =><-.fld_in;
   	 downsize_params =><-.<-.Params.downsize_params;
   	 params =><-.<-.Params.params;
      }; 
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAorthoslice MAorthoslice {
         orthoslice_params =><-.<-.Params.orthoslice_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAisoline MAisoline {
         isoline_params =><-.<-.Params.isoline_params;
         fld_in =><-.MAorthoslice.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAisoline.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      MAdownsize MAdownsize2 {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params2;
         params =><-.<-.Params.params;
      };
      MAextract_scalar MAextract_scalar2 {
         fld_in =><-.MAdownsize2.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params2;
      };
      MAorthoslice MAorthoslice2 {
         orthoslice_params =><-.<-.Params.orthoslice_params2;
         fld_in =><-.MAextract_scalar2.fld_out;
      };
      MAisoline MAisoline2 {
         isoline_params =><-.<-.Params.isoline_params2;
         fld_in =><-.MAorthoslice2.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet2 {
         ilink plane_params => <-.<-.Params.plane_params;
         fld_in => <-.MAisoline2.fld_out;
         ilink+nosave colmap_params=> <-.<-.Params.colmap_params;			//@QƐ̕ύXŝŌ^錾ύXĂB
         ilink+nosave legend_params=> <-.<-.Params.legend_params;			//@QƐ̕ύXŝŌ^錾ύXĂ
         obj_in =><-.obj2_in;
         MAcolmap{
            ilink plane_params => <-.plane_params;
            set_just_fit.active => (<-.colmap_params.fit && (<-.plane_params.colmap2 == 0));
            MAcolormapUI{
               ilink plane_params => <-.plane_params;
               shell.visible => (<-.colmap_params.vis && (<-.plane_params.colmap2 == 0));
               MAdmapEchoUI{
                  UIinstancer.Value => (<-.colmap_params.vis && (<-.<-.plane_params.colmap2 == 0));
               };
               MAchangeColorUI{
                  ilink plane_params => <-.plane_params;
                  UI{
                     ilink plane_params => <-.plane_params;
                     edit_colormap{
                        ilink plane_params => <-.plane_params;
                        UI{
                           ilink plane_params => <-.plane_params;
                           vis => switch((plane_params.colmap2 + 1), .colmap_params.edit, 0);
                        };
                     };
                  };
               };
            };
         };
         MAlegend{
            all_reset.active => legend_params.vis;
            LegendUIinstancer.Value => (<-.LegendUI.vis && (<-.<-.plane_params.colmap2 == 0));
         };
         GMOD.parse_v change_common_val {
            v_commands => switch((<-.<-.Params.plane_params.colmap2 + 1)
                                  , "$push \n"
                                   +"colmap_params => <-.<-.Params.colmap_params2;\n"
                                   +"legend_params => <-.<-.Params.legend_params2;\n"
                                   +"$pop \n"
                                  , "$push \n"
                                   +"colmap_params => <-.<-.Params.colmap_params;\n"
                                   +"legend_params => <-.<-.Params.legend_params;\n"
                                   +"$pop \n");
            trigger    => (<-.plane_params.colmap2 || <-.plane_params.plane2);
            relative   => <-.<-;
            on_inst    = 0;
            active     => <-.plane_params.plane2;
         };
         GMOD.parse_v null_common_val {
            v_commands => switch((<-.<-.Params.plane_params.plane2 == 0)
                                  , "colmap_params => <-.<-.Params.colmap_params2;\n"
                                   +"legend_params => <-.<-.Params.legend_params2;\n");
            trigger    => <-.plane_params.plane2;
            relative   => <-.<-;
            active     => <-.plane_params.plane2 == 0;
         };
      };
      MAdownsize MAdownsize3 {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params3;
         params =><-.<-.Params.params;
      };
      MAextract_scalar MAextract_scalar3 {
         fld_in =><-.MAdownsize3.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params3;
      };
      MAorthoslice MAorthoslice3 {
         orthoslice_params =><-.<-.Params.orthoslice_params3;
         fld_in =><-.MAextract_scalar3.fld_out;
      };
      MAisoline MAisoline3 {
         isoline_params =><-.<-.Params.isoline_params3;
         fld_in =><-.MAorthoslice3.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet3 {
         ilink plane_params => <-.<-.Params.plane_params;
         fld_in => <-.MAisoline3.fld_out;
         ilink+nosave colmap_params=> <-.<-.Params.colmap_params;			//@QƐ̕ύXŝŌ^錾ύXĂB
         ilink+nosave legend_params=> <-.<-.Params.legend_params;			//@QƐ̕ύXŝŌ^錾ύXĂB
         obj_in =><-.obj3_in;
         MAcolmap{
            ilink plane_params => <-.plane_params;
            set_just_fit.active => (<-.colmap_params.fit && (<-.plane_params.colmap3 == 0));
            MAcolormapUI{
               ilink plane_params => <-.plane_params;
               shell.visible => (<-.colmap_params.vis && (<-.plane_params.colmap3 == 0));
               MAdmapEchoUI{
                  UIinstancer.Value => (<-.colmap_params.vis && (<-.<-.plane_params.colmap3 == 0));
               };
               MAchangeColorUI{
                  ilink plane_params => <-.plane_params;
                  UI{
                     ilink plane_params => <-.plane_params;
                     edit_colormap{
                        ilink plane_params => <-.plane_params;
                        UI{
                           ilink plane_params => <-.plane_params;
                           vis => switch((plane_params.colmap3 + 1), .colmap_params.edit, 0);
                        };
                     };
                  };
               };
            };
         };
         MAlegend{
            all_reset.active => legend_params.vis;
            LegendUIinstancer.Value => (<-.LegendUI.vis && (<-.<-.plane_params.colmap3 == 0));
         };
         GMOD.parse_v change_common_val {
            v_commands => switch((<-.<-.Params.plane_params.colmap + 1)
                                  , "$push \n"
                                   +"colmap_params => <-.<-.Params.colmap_params3;\n"
                                   +"legend_params => <-.<-.Params.legend_params3;\n"
                                   +"$pop \n"
                                  , "$push \n"
                                   +"colmap_params => <-.<-.Params.colmap_params;\n"
                                   +"legend_params => <-.<-.Params.legend_params;\n"
                                   +"$pop \n");
            trigger    => (<-.plane_params.colmap || <-.plane_params.plane3);
            relative   => <-.<-;
            on_inst    = 0;
            active     => <-.plane_params.plane3;
         };
         GMOD.parse_v null_common_val {
            v_commands => switch((<-.<-.Params.plane_params.plane3 == 0)
                                  , "colmap_params => <-.<-.Params.colmap_params3;\n"
                                   +"legend_params => <-.<-.Params.legend_params3;\n");
            trigger    => <-.plane_params.plane3;
            relative   => <-.<-;
            active     => <-.plane_params.plane3 == 0;
         };
      };
      olink fld_out3    => MAisoline3.fld_out;
      olink legend_out3 => .MAcmapLegendSet3.legend_out;
      olink text_out3   => .MAisoline3.text_out;
      olink bounds_out3 => .MAisoline3.bounds_out;
      olink fld_out2    => MAisoline2.fld_out;
      olink legend_out2 => .MAcmapLegendSet2.legend_out;
      olink text_out2   => .MAisoline2.text_out;
      olink bounds_out2 => .MAisoline2.bounds_out;

      fld_out           => MAisoline.fld_out;
      olink legend_out  => .MAcmapLegendSet.legend_out;
      olink text_out    => .MAisoline.text_out;
      olink bounds_out  => .MAisoline.bounds_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + select_planeUI.height
               + MAplane2UI.height
               + 5;
      ilink plane_params   => <-.Params.plane_params;
      label_cmd+nosave plane_label{
         labels = {"MACONT_PLANE1","MACONT_PLANE2","MACONT_PLANE3"};
      };
      MAUIoptionMenu select_planeUI{
         y            => ((<-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height) + 10);
         parent       => <-.parent;
         cmdList      => <-.plane_label.cmd;
         selectedItem => <-.<-.Params.plane_params.select_plane;
         label        = "MACONT_SELECT_PLANE";
      };
      /*
      MAUIpanel MAplane_panelUI{
         y       => (<-.select_planeUI.y + <-.select_planeUI.height);
         width   => <-.MAmoduleCommonUI.panel.width;
         height  => <-.MAmaplegendUI.y + <-.MAmaplegendUI.height + 5;
         parent  => <-.parent;
         visible => <-.<-.Params.plane_params.select_plane == 0;
      };
      */
      macro MAplane1UI{
         ilink params       => <-.params;
         ilink plane_params => <-.plane_params;
         ilink parent       => <-.parent;
         ilink fld_in       => <-.fld_in;
         int height         => MAplane_panelUI.height;
         MAUIpanel MAplane_panelUI{
            y       => (<-.<-.select_planeUI.y + <-.<-.select_planeUI.height);
            width   => <-.<-.MAmoduleCommonUI.panel.width;
            height  => <-.MAmaplegendUI.y + <-.MAmaplegendUI.height + 5;
            parent  => <-.parent;
            visible => <-.plane_params.select_plane == 0;
         };
         MAUIframe MAplane_visUI{
            y      = 0;
            parent => <-.MAplane_panelUI;
         };
         MAUItoggle plane_show_toggle{
            parent => <-.MAplane_visUI;
            y      => ((parent.height - height) / 2);
            label  = "MAUI_DISPLAY";
            set    => <-.plane_params.plane1;
         };
         MAdownsizeUI MAdownsizeUI {
            y               => (<-.MAplane_visUI.y + <-.MAplane_visUI.height);
            parent          => <-.MAplane_panelUI;
            fld_in          => <-.fld_in;
            downsize_params => <-.<-.<-.Params.downsize_params;
         };
         MAextract_scalarUI MAextract_scalarUI {
            fld_in                => <-.<-.<-.Modules.MAextract_scalar.fld_in;
            parent                => <-.MAplane_panelUI;
            extract_scalar_params => <-.<-.<-.Params.extract_scalar_params;
            y                     => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
         };
         MAorthosliceUI MAorthosliceUI {
            fld_in            => <-.<-.<-.Modules.MAorthoslice.fld_in;
            parent            => <-.MAplane_panelUI;
            orthoslice_params => <-.<-.<-.Params.orthoslice_params;
            y                 => <-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
         };
         MAisolineUI MAisolineUI {
            fld_in         => <-.<-.<-.Modules.MAisoline.fld_in;
            parent         => <-.MAplane_panelUI;
            isoline_params => <-.<-.<-.Params.isoline_params;
            y              => <-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
         };
         MAmaplegendUI MAmaplegendUI {
            parent        => <-.MAplane_panelUI;
            colmap_params => <-.<-.<-.Params.colmap_params;
            legend_params => <-.<-.<-.Params.legend_params;
            y             => <-.MAisolineUI.y + <-.MAisolineUI.height;
            active        => <-.<-.<-.Params.isoline_params.color;
         };
      };
      macro MAplane2UI{
         ilink params       => <-.params;
         ilink plane_params => <-.plane_params;
         ilink parent       => <-.parent;
         ilink fld_in       => <-.fld_in;
         int height         => MAplane_panelUI.height;
         MAUIpanel MAplane_panelUI{
            y       => (<-.<-.select_planeUI.y + <-.<-.select_planeUI.height);
            width   => <-.<-.MAmoduleCommonUI.panel.width;
            height  => <-.MAmaplegendUI.y + <-.MAmaplegendUI.height + 5;
            parent  => <-.parent;
            visible => <-.plane_params.select_plane == 1;
         };
         MAUIframe MAplane_visUI{
            y      = 0;
            parent => <-.MAplane_panelUI;
         };
         MAUItoggle plane_show_toggle{
            parent => <-.MAplane_visUI;
            y      => ((parent.height - height) / 2);
            label  = "MAUI_DISPLAY";
            set    => <-.plane_params.plane2;
         };
         MAdownsizeUI MAdownsizeUI {
            y               => (<-.MAplane_visUI.y + <-.MAplane_visUI.height);
            parent          => <-.MAplane_panelUI;
            fld_in          => <-.fld_in;
            downsize_params => <-.<-.<-.Params.downsize_params2;
         };
         MAextract_scalarUI MAextract_scalarUI {
            fld_in                => <-.<-.<-.Modules.MAextract_scalar2.fld_in;
            parent                => <-.MAplane_panelUI;
            extract_scalar_params => <-.<-.<-.Params.extract_scalar_params2;
            y                     => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
         };
         MAorthosliceUI MAorthosliceUI {
            fld_in            => <-.<-.<-.Modules.MAorthoslice2.fld_in;
            parent            => <-.MAplane_panelUI;
            orthoslice_params => <-.<-.<-.Params.orthoslice_params2;
            orthoslice_params{
               axis = 1;
               reset_commands =
                    "orthoslice_params2.axis=1;"
                   +"orthoslice_params2.planeI=;"
                   +"orthoslice_params2.planeJ=orthoslice_params.def_planeJ;"
                   +"orthoslice_params2.planeK=;"
                   ;
            };
            y                 => <-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
         };

         MAisolineUI MAisolineUI {
            fld_in         => <-.<-.<-.Modules.MAisoline.fld_in;
            parent         => <-.MAplane_panelUI;
            isoline_params => <-.<-.<-.Params.isoline_params2;
            y              => <-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
         };
         MAmaplegendUI MAmaplegendUI {
            parent        => <-.MAplane_panelUI;
            colmap_params => <-.<-.<-.Params.colmap_params2;
            legend_params => <-.<-.<-.Params.legend_params2;
            y             => <-.MAisolineUI.y + <-.MAisolineUI.height;
            colmap_b.y             => ((<-.common_cmap_toggle.y + <-.common_cmap_toggle.height) + 5);
            maplegend_panel.height => ((<-.legend_b.y + <-.legend_b.height) + 5);
            active                 => common_cmap_toggle.set == 0;
            MAUItoggle common_cmap_toggle{
               y      => ((<-.label.y + <-.label.height) + 5);
               parent => <-.maplegend_panel;
               set    => <-.<-.plane_params.colmap2;
               label  = "MACOLMAP_COMMON_VAL";
            };
         };
      };
      macro MAplane3UI{
         ilink params       => <-.params;
         ilink plane_params => <-.plane_params;
         ilink parent       => <-.parent;
         ilink fld_in       => <-.fld_in;
         int height         => MAplane_panelUI.height;
         MAUIpanel MAplane_panelUI{
            y       => (<-.<-.select_planeUI.y + <-.<-.select_planeUI.height);
            width   => <-.<-.MAmoduleCommonUI.panel.width;
            height  => <-.MAmaplegendUI.y + <-.MAmaplegendUI.height + 5;
            parent  => <-.parent;
            visible => <-.plane_params.select_plane == 2;
         };
         MAUIframe MAplane_visUI{
            y      = 0;
            parent => <-.MAplane_panelUI;
         };
         MAUItoggle plane_show_toggle{
            parent => <-.MAplane_visUI;
            y      => ((parent.height - height) / 2);
            label  = "MAUI_DISPLAY";
            set    => <-.plane_params.plane3;
         };
         MAdownsizeUI MAdownsizeUI {
            y               => (<-.MAplane_visUI.y + <-.MAplane_visUI.height);
            parent          => <-.MAplane_panelUI;
            fld_in          => <-.fld_in;
            downsize_params => <-.<-.<-.Params.downsize_params3;
         };
         MAextract_scalarUI MAextract_scalarUI {
            fld_in                => <-.<-.<-.Modules.MAextract_scalar3.fld_in;
            parent                => <-.MAplane_panelUI;
            extract_scalar_params => <-.<-.<-.Params.extract_scalar_params3;
            y                     => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
         };
         MAorthosliceUI MAorthosliceUI {
            fld_in            => <-.<-.<-.Modules.MAorthoslice3.fld_in;
            parent            => <-.MAplane_panelUI;
            orthoslice_params => <-.<-.<-.Params.orthoslice_params3;
            orthoslice_params{
               axis = 0;
               reset_commands =
                    "orthoslice_params2.axis=0;"
                   +"orthoslice_params2.planeI=orthoslice_params.def_planeI;"
                   +"orthoslice_params2.planeJ=;"
                   +"orthoslice_params2.planeK=;"
                   ;
            };
            y                 => <-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
         };

         MAisolineUI MAisolineUI {
            fld_in         => <-.<-.<-.Modules.MAisoline.fld_in;
            parent         => <-.MAplane_panelUI;
            isoline_params => <-.<-.<-.Params.isoline_params3;
            y              => <-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
         };
         MAmaplegendUI MAmaplegendUI {
            parent        => <-.MAplane_panelUI;
            colmap_params => <-.<-.<-.Params.colmap_params3;
            legend_params => <-.<-.<-.Params.legend_params3;
            y             => <-.MAisolineUI.y + <-.MAisolineUI.height;
            colmap_b.y             => ((<-.common_cmap_toggle.y + <-.common_cmap_toggle.height) + 5);
            maplegend_panel.height => ((<-.legend_b.y + <-.legend_b.height) + 5);
            active                 => common_cmap_toggle.set == 0;
            MAUItoggle common_cmap_toggle{
               y      => ((<-.label.y + <-.label.height) + 5);
               parent => <-.maplegend_panel;
               set    => <-.<-.plane_params.colmap3;
               label  = "MACOLMAP_COMMON_VAL";
            };
         };
      };
   };
   string stitle1 = "MACONT_PLANE1";
   string stitle2 = "MACONT_PLANE2";
   string stitle3 = "MACONT_PLANE3";
   MAdataObject DataObject3{
      in             => <-.Modules.fld_out3;
      child_objs => {<-.Modules.legend_out3,
                     <-.Modules.text_out3,
                     <-.Modules.bounds_out3
                    };
      Obj.name+nres  => <-.<-.stitle3;
      Obj.xform_mode = GD_XFORM_MODE_PARENT;
      Obj.visible    => <-.<-.Params.plane_params.plane3;
   };
   MAdataObject DataObject2{
      in             => <-.Modules.fld_out2;
      child_objs => {<-.Modules.legend_out2,
                     <-.Modules.text_out2,
                     <-.Modules.bounds_out2
                    };
      Obj.name+nres  => <-.<-.stitle2;
      Obj.xform_mode = GD_XFORM_MODE_PARENT;
      Obj.visible    => <-.<-.Params.plane_params.plane2;
   };
   DataObject{
      child_objs => {<-.Modules.legend_out,
                     <-.Modules.text_out,
                     <-.Modules.bounds_out
                    };
      Obj.name+nres => <-.<-.stitle1;
      Obj.visible    => <-.<-.Params.plane_params.plane1;
   };
   DataObject.Props.jitter = 1; //workaround: OpenGL renderer
   MAgroupObject GroupObject{
      ilink params   => <-.Params.params;
      child_objs => {<-.DataObject.obj,<-.DataObject2.obj,<-.DataObject3.obj};
      Top.name => <-.<-.title;
      Top.xform_mode = GD_XFORM_MODE_PARENT;
      Top.visible    => <-.params.obj_vis;
   };
   obj_out => GroupObject.obj;
};
MAnetwork FLDIsoline2D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ISOLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ISOLINE_T";
   Params {
      params.help_name = "isolin2d";
      params.name = "isoline";
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
				 + extract_scalar_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
				 + extract_scalar_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      }; 
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAisoline MAisoline {
         isoline_params =><-.<-.Params.isoline_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAisoline.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAisoline.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink text_out   => .MAisoline.text_out;
      olink bounds_out => .MAisoline.bounds_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
	       + MAextract_scalarUI.height
               + MAisolineUI.height 
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
   	 parent => <-.parent;
   	 fld_in =><-.fld_in;
   	 downsize_params =><-.<-.Params.downsize_params;
   	 y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAisolineUI MAisolineUI {
         fld_in =><-.<-.Modules.MAisoline.fld_in;
         parent => <-.parent;
         isoline_params =><-.<-.Params.isoline_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAisolineUI.y + <-.MAisolineUI.height;
         active => <-.<-.Params.isoline_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.text_out,
                             <-.Modules.bounds_out
                            };
   DataObject.Props.jitter = 1; //workaround: OpenGL renderer
};
