/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/marker.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/marker.v#1 $
*/
MAnetwork FLDMarker
#ifdef MAVS_USE_USER_NAME
< user_name="ME_MARKER_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_MARKER_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "marker";
      params.name = "marker";
      MAdownsize_params downsize_params;
      MAmarker_params marker_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => downsize_params.init_commands
                                 + marker_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + marker_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAmarker+nosave MAmarker {
         marker_params => <-.<-.Params.marker_params;
         fld_in        => <-.MAdownsize.fld_out;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => MAmarker.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out          => .MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAmarker.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      olink legend_out => .MAcmapLegendSet.legend_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAmarkerUI.height 
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAmarkerUI MAmarkerUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         marker_params =><-.<-.Params.marker_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAmarkerUI.y + <-.MAmarkerUI.height;
      };
   };


/*  for MicroAVS5.0 cut_plane */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => {<-.Modules.legend_out,<-.Modules.MAcut_plane.plane_axis_obj};
      Modes.mode => {<-.<-.Params.marker_params.mode1,
                             <-.<-.Params.marker_params.mode2,
                             <-.<-.Params.marker_params.mode3,
                             <-.<-.Params.marker_params.mode4,
                             <-.<-.Params.marker_params.mode5
                            };
      Props.cull = "Back";
   };
/*  for MicroAVS5.0 cut_plane */
};
