/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/molorbit.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
MAnetwork FLDMolOrbital
#ifdef MAVS_USE_USER_NAME
< user_name="ME_MOL_ORBIT_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_MOL_ORBIT_T";
   Params {
      params.help_name = "molorbit";
      params.name = "molorbit";
      MAdownsize_params downsize_params;
      MAmol_orbit_params mol_orbit_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
                                 + mol_orbit_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + mol_orbit_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands
                                 + "reset=1;";
      int+nosave reset=0;
   };
   Modules {
      ilink fld_in => <-.fld_in;
      ilink obj_in => <-.DataObject.obj;
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAmol_orbit MAmol_orbit {
         fld_in =><-.MAdownsize.fld_out;
         mol_orbit_params =><-.<-.Params.mol_orbit_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAmol_orbit.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAmol_orbit.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;

      olink Nfld_out => MAmol_orbit.Nfld_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAmol_orbitUI.height
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAmol_orbitUI MAmol_orbitUI {
         parent => <-.parent;
         fld_in => <-.fld_in;
         mol_orbit_params =><-.<-.Params.mol_orbit_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAmol_orbitUI.y + <-.MAmol_orbitUI.height;
      };
   };
   MAdataObjectLite MAdataObjectLite {
      in => <-.Modules.Nfld_out;
      child_objs => {<-.Modules.legend_out};
      Obj.pickable = 0;
      Obj.xform_mode = "Parent";
      Modes.colors = "None";
      Obj.name => "NOOBJLIST LINE_MOL_ORBIT_NEGATIVE_OBJ";
   };
   DataObject.child_objs => { <-.MAdataObjectLite.obj };
   GMOD.parse_v  set_colormap {
      v_commands => "$push -usr\n"
                   +"colmap_params.color_size=2;"
                   +"colmap_params.min_h=0.17;"
                   +"colmap_params.min_s=1;"
                   +"colmap_params.min_v=1;"
                   +"colmap_params.max_h=0.5;"
                   +"colmap_params.max_s=1;"
                   +"colmap_params.max_v=1;"
                   +"$pop\n"
                  ;
      trigger => is_valid(<-.Params.reset);
      relative => <-.Params;
      on_inst = 1;
   };
};

FLDBounds3D FLDBounds3D_MolOrbital<NEvisible=0>
{
   title = "ME_BOUNDS_MOL_ORBIT_T";
};
FLDContour3D FLDContour3D_MolOrbital<NEvisible=0>
{
   title = "ME_CONTOUR_MOL_ORBIT_T";
};
FLDArContour3D FLDArContour3D_MolOrbital<NEvisible=0>
{
   title = "ME_ARCONTOUR_MOL_ORBIT_T";
};
FLDIsoline3D FLDIsoline3D_MolOrbital<NEvisible=0>
{
   title = "ME_ISOLINE_MOL_ORBIT_T";
};
FLDArIsoline3D FLDArIsoline3D_MolOrbital<NEvisible=0>
{
   title = "ME_ARISOLINE_MOL_ORBIT_T";
};
FLDIsosurf FLDIsosurf_MolOrbital<NEvisible=0>
{
   title = "ME_ISOSURF_MOL_ORBIT_T";
};
FLDIsovolume FLDIsovolume_MolOrbital<NEvisible=0>
{
   title = "ME_ISOVOL_MOL_ORBIT_T";
};
FLDProbe FLDProbe_MolOrbital<NEvisible=0>
{
   title = "ME_PROBE_MOL_ORBIT_T";
};
