/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/stream.v#1 $
*/
MAnetwork FLDStream1D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_STREAMLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_STREAMLINE_T";
   Params {
      params.help_name = "strm1d";
      params.name = "stream";
      MAcombine_vect2d_params combine_vect_params;
      MAdownsize_params downsize_params;
      MAstream_params stream_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands =>
           combine_vect_params.init_commands
         + downsize_params.init_commands
         + stream_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           combine_vect_params.reset_commands
         + downsize_params.reset_commands
         + stream_params.reset_commands
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };

   Modules {
      MAcombine_vect MAcombine_vect {
         params              => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in              => <-.fld_in;
      };
      MAdownsize MAdownsize {
         downsize_params => <-.<-.Params.downsize_params;
         params          => <-.<-.Params.params;
         fld_in          => <-.MAcombine_vect.fld_out;
      };
      MAstream MAstream {
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAcombine_vect.fld_out;
         fld_in2       => <-.fld_in;
         probe_in      => <-.MAdownsize.fld_out;
      };
      MAilluminated_lines MAilluminated_lines{
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAstream.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAstream.fld_out;
         legend_params => <-.<-.Params.legend_params;
         colmap_params => <-.<-.Params.colmap_params;
         obj_in        => <-.MAilluminated_lines.out_obj;
      };
      fld_out =;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink obj_out => .MAilluminated_lines.out_obj;
      MAsaveMVG.in => <-.MAstream.fld_out;
   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height 
               + MAcombine_vectUI.height
               + MAdownsizeUI.height
               + MAstreamUI.height
               + MAilluminatedUI.height
               + MAmaplegendUI.height
               + MAstream_map_compUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAstream_map_compUI MAstream_map_compUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         downsize_params => <-.<-.Params.downsize_params;
        y => <-.MAstream_map_compUI.y + <-.MAstream_map_compUI.height;
      };
      MAstreamUI MAstreamUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
         fld_in => <-.fld_in;
      };
      MAilluminatedUI MAilluminatedUI{
         parent        => <-.parent;
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y             => <-.MAstreamUI.y + <-.MAstreamUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent        => <-.parent;
         colmap_params => <-.<-.Params.colmap_params;
         legend_params => <-.<-.Params.legend_params;
         y             => <-.MAilluminatedUI.y + <-.MAilluminatedUI.height;
         active        => <-.<-.Params.stream_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.obj_out
   };
};

MAnetwork FLDStream2D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_STREAMLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_STREAMLINE_T";
   Params {
      params.help_name = "strm2d";
      params.name = "stream";
      MAcombine_vect2d_params combine_vect_params;
      MAfline_params fline_params;
      MAstream_params stream_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands =>
           combine_vect_params.init_commands
         + fline_params.init_commands
         + stream_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           combine_vect_params.reset_commands
         + fline_params.reset_commands
         + stream_params.reset_commands
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };

   Modules {
      MAcombine_vect MAcombine_vect {
         params =><-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
      };
      MAfline2d MAfline {
         params =><-.<-.Params.params;
         fline_params => <-.<-.Params.fline_params;
         fld_in => <-.fld_in;
      };
      MAstream MAstream {
         params =><-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in => <-.MAcombine_vect.fld_out;
         fld_in2 => <-.fld_in;
         probe_in => <-.MAfline.fld_out;
      };
      MAilluminated_lines MAilluminated_lines{
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAstream.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAstream.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in => <-.MAilluminated_lines.out_obj;
      };
      fld_out          =;
      olink line_out   => .MAfline.obj_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink obj_out    => .MAilluminated_lines.out_obj;
      MAsaveMVG.in     => <-.MAstream.fld_out;
   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height 
               + MAcombine_vectUI.height
               + MAflineUI.height
               + MAstreamUI.height
               + MAilluminatedUI.height
               + MAmaplegendUI.height
               + MAstream_map_compUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAstream_map_compUI MAstream_map_compUI {
         parent        => <-.parent;
         params        =><-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAfline2dUI MAflineUI {
         parent => <-.parent;
         fld_in => <-.<-.Modules.MAfline.fld_in;
         params => <-.<-.Params.params;
         fline_params => <-.<-.Params.fline_params;
         y      => <-.MAstream_map_compUI.y + <-.MAstream_map_compUI.height;
      };
      MAstreamUI MAstreamUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y      => <-.MAflineUI.y + <-.MAflineUI.height;
         fld_in => <-.fld_in;
      };
      MAilluminatedUI MAilluminatedUI{
         parent        => <-.parent;
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y             => <-.MAstreamUI.y + <-.MAstreamUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params => <-.<-.Params.colmap_params;
         legend_params => <-.<-.Params.legend_params;
         y             => <-.MAilluminatedUI.y + <-.MAilluminatedUI.height;
         active        => <-.<-.Params.stream_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.line_out, <-.Modules.legend_out,
                             <-.Modules.obj_out			//Lqǉ
   };
};

MAnetwork FLDStream3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_STREAMLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_STREAMLINE_T";
   Params {
      params.help_name = "strm3d";
      params.name = "stream";
      MAcombine_vect3d_params combine_vect_params;
      MAfplane_params fplane_params;
      MAstream_params stream_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands =>
           combine_vect_params.init_commands
         + fplane_params.init_commands
         + stream_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           combine_vect_params.reset_commands
         + fplane_params.reset_commands
         + stream_params.reset_commands
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };

   Modules {
      MAcombine_vect MAcombine_vect {
         params =><-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
      };
      MAfplane MAfplane {
         params =><-.<-.Params.params;
         fplane_params => <-.<-.Params.fplane_params;
         fld_in => <-.fld_in;
      };
      MAstream MAstream {
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAcombine_vect.fld_out;
         fld_in2       => <-.fld_in;
         probe_in      => <-.MAfplane.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAstream.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => .MAstream.fld_out;
      olink plane_out => .MAfplane.obj_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height 
               + MAcombine_vectUI.height
               + MAfplaneUI.height
               + MAstreamUI.height
               + MAmaplegendUI.height
               + MAstream_map_compUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAstream_map_compUI MAstream_map_compUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in => <-.fld_in;
         y      => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
      };
      MAfplaneUI MAfplaneUI {
         parent => <-.parent;
         fld_in => <-.<-.Modules.MAfplane.fld_in;
         params => <-.<-.Params.params;
         fplane_params => <-.<-.Params.fplane_params;
         y      => <-.MAstream_map_compUI.y + <-.MAstream_map_compUI.height;
      };
      MAstreamUI MAstreamUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y      => <-.MAfplaneUI.y + <-.MAfplaneUI.height;
         fld_in => <-.fld_in;
      };
      MAmaplegendUI MAmaplegendUI {
         parent        => <-.parent;
         colmap_params => <-.<-.Params.colmap_params;
         legend_params => <-.<-.Params.legend_params;
         y      => <-.MAstreamUI.y + <-.MAstreamUI.height;
         active => <-.<-.Params.stream_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.plane_out, <-.Modules.legend_out};
};
MAnetwork FLDArStream3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_STREAMLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_STREAMLINE_T";
   MAGDobject_templ-nosave+IPort2 &picked_obj;
   Params {
      params.help_name = "strm3d";
      params.name = "stream";
      MAcombine_vect3d_params combine_vect_params;
      MAnew_slice_plane_params new_slice_plane_params;
      MAstream_params stream_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands =>
           combine_vect_params.init_commands
         + new_slice_plane_params.init_commands
         + stream_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           combine_vect_params.reset_commands
         + new_slice_plane_params.reset_commands
         + stream_params.reset_commands
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };

   Modules {
      ilink pick_in =><-.picked_obj;
      MAcombine_vect MAcombine_vect {
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
      };
      MAnew_slice_plane MAnew_slice_plane {
         in_pick => <-.pick_in;
         new_slice_plane_params => <-.<-.Params.new_slice_plane_params;
         fld_in => <-.MAcombine_vect.fld_out;
      };
      MAstream MAstream {
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAcombine_vect.fld_out;
         fld_in2       => <-.fld_in;
         probe_in      => <-.MAnew_slice_plane.fld_out;
      };
      MAilluminated_lines MAilluminated_lines{
         params        => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in        => <-.MAstream.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAstream.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in => <-.MAilluminated_lines.out_obj;
      };
//      fld_out => .MAstream.fld_out;
      fld_out=;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink pick_obj_out => .MAnew_slice_plane.out_pick_obj;
      olink slice_obj_out => .MAnew_slice_plane.out_slice_obj;
      olink axis_obj_out => .MAnew_slice_plane.out_axis_obj;
      olink obj_out => .MAilluminated_lines.out_obj;
      MAsaveMVG.in => <-.MAstream.fld_out;
   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height 
               + MAcombine_vectUI.height
               + MAnew_slice_planeUI.height
               + MAstreamUI.height
               + MAilluminatedUI.height
               + MAmaplegendUI.height
               + MAstream_map_compUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y      => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAstream_map_compUI MAstream_map_compUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         fld_in => <-.fld_in;
         y      => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
      };
      MAnew_slice_planeUI MAnew_slice_planeUI {
         parent => <-.parent;
         fld_in => <-.<-.Modules.MAnew_slice_plane.fld_in;
         new_slice_plane_params => <-.<-.Params.new_slice_plane_params;
         y      => <-.MAstream_map_compUI.y + <-.MAstream_map_compUI.height;
      };
      MAstreamUI MAstreamUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y      => <-.MAnew_slice_planeUI.y + <-.MAnew_slice_planeUI.height;
         fld_in => <-.fld_in;
      };
      MAilluminatedUI MAilluminatedUI{
         parent => <-.parent;
         params => <-.<-.Params.params;
         stream_params => <-.<-.Params.stream_params;
         y => <-.MAstreamUI.y + <-.MAstreamUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params => <-.<-.Params.colmap_params;
         legend_params => <-.<-.Params.legend_params;
         y => <-.MAilluminatedUI.y + <-.MAilluminatedUI.height;
         active => <-.<-.Params.stream_params.color;
      };
   };

/*  for MicroAVS 6.0 lݒ */

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.new_slice_plane_params.dim1        = <-.env_params.streamline.dim1;\n"
                  +"Params.new_slice_plane_params.dim2        = <-.env_params.streamline.dim2;\n"
                  +"Params.new_slice_plane_params.x_vector.x  = <-.<-.env_params.streamline.x_vector.x;\n"
                  +"Params.new_slice_plane_params.x_vector.y  = <-.<-.env_params.streamline.x_vector.y;\n"
                  +"Params.new_slice_plane_params.x_vector.z  = <-.<-.env_params.streamline.x_vector.z;\n"
                  +"Params.new_slice_plane_params.y_vector.x  = <-.<-.env_params.streamline.y_vector.x;\n"
                  +"Params.new_slice_plane_params.y_vector.y  = <-.<-.env_params.streamline.y_vector.y;\n"
                  +"Params.new_slice_plane_params.y_vector.z  = <-.<-.env_params.streamline.y_vector.z;\n"
                  +"Params.new_slice_plane_params.z_vector.x  = <-.<-.env_params.streamline.z_vector.x;\n"
                  +"Params.new_slice_plane_params.z_vector.y  = <-.<-.env_params.streamline.z_vector.y;\n"
                  +"Params.new_slice_plane_params.z_vector.z  = <-.<-.env_params.streamline.z_vector.z;\n"
                  +switch(is_valid(<-.Params.env_params.streamline.center.x) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.x  = <-.<-.env_params.streamline.center.x;\n")
                  +switch(is_valid(<-.Params.env_params.streamline.center.y) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.y  = <-.<-.env_params.streamline.center.y;\n")
                  +switch(is_valid(<-.Params.env_params.streamline.center.z) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.z  = <-.<-.env_params.streamline.center.z;\n")
                  +"Params.new_slice_plane_params.vector_complete = 1;\n"
                  +"Params.new_slice_plane_params.vector_complete = 1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.streamline.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.streamline.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAstream.fld_in);
     on_inst    = 0;
   };
   string+nres local_colormap => MicroAVScontroller.Params.env_params.streamline.colormap;
   GMOD.parse_v set_rd_filename {
     v_commands    => "local_colormap = Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "local_colormap = Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.streamline.dim1       =" + Params.new_slice_plane_params.dim1 + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.dim2       =" + Params.new_slice_plane_params.dim2 + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.x_vector.x =" + Params.new_slice_plane_params.x_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.x_vector.y =" + Params.new_slice_plane_params.x_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.x_vector.z =" + Params.new_slice_plane_params.x_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.y_vector.x =" + Params.new_slice_plane_params.y_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.y_vector.y =" + Params.new_slice_plane_params.y_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.y_vector.z =" + Params.new_slice_plane_params.y_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.z_vector.x =" + Params.new_slice_plane_params.z_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.z_vector.y =" + Params.new_slice_plane_params.z_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.z_vector.z =" + Params.new_slice_plane_params.z_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.center.x   =" + Params.new_slice_plane_params.center.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.center.y   =" + Params.new_slice_plane_params.center.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.streamline.center.z   =" + Params.new_slice_plane_params.center.z + ";\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */


   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.pick_obj_out,
                             <-.Modules.slice_obj_out,
                             <-.Modules.axis_obj_out,
                             <-.Modules.obj_out
                            };
   //MAnew_slice_planeW[g߂̃p[^l̐ݒ
   Params.new_slice_plane_params.plane_style=1;
   Params.new_slice_plane_params.dim1=8;
   Params.new_slice_plane_params.dim2=8;

   //p[^Zbgl̐ݒ
   Params.new_slice_plane_params.reset_commands =
     "new_slice_plane_params{"
    +   "marker_scale = 1.0;"
    +   "specify_type = 0;"
    +   "plane_style = 1;" // 0  1ɕύX
    +   "plane_axis_vis = 1;"
    +   "rot_trans_reset = 1;"
    +   "all_nodes = 0;"
    +   "plane_or_mesh = 0;"
    +   "dim1_scale = 1.0;"
    +   "dim2_scale = 1.0;"
    +   "dim1 = 8;" // 2  8ɕύX
    +   "dim2 = 8;" // 2  8ɕύX
    +   "separate = 0;"
    +   "marker_vis = 1;"
    +   "pick_clear=1;"
    +   "marker_scale = 1.0;"
    +   "pressed_button = 0;"
    +   "selected = 0;"
    +   "pick_b1_status=0;"
    +   "pick_b2_status=0;"
    +   "pick_b3_status=0;"
    +   "x_rot_ui = 45.0;"
    +   "y_rot_ui = 45.0;"
    +   "z_rot_ui = 45.0;"
    +   "x_trans_ui = 1.0;"
    +   "y_trans_ui = 1.0;"
    +   "z_trans_ui = 1.0;"
    +   "x_rot_ui_local = 45.0;"
    +   "y_rot_ui_local = 45.0;"
    +   "z_rot_ui_local = 45.0;"
    +   "x_trans_ui_local = 1.0;"
    +   "y_trans_ui_local = 1.0;"
    +   "z_trans_ui_local = 1.0;"
    +   "axis_scale = 1.0;"
    +   "world_or_local = 0;"
    +"};"
    ;
};
