/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/vector.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/vector.v#1 $
*/
MAnetwork FLDVector1D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_VECTOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_VECTOR_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "vec1d";
      params.name = "vector";
      MAdownsize_params downsize_params;
      MAcombine_vect2d_params combine_vect_params;
      MAvector_params vector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands =>
           downsize_params.init_commands
         + combine_vect_params.init_commands
         + vector_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           downsize_params.reset_commands
         + combine_vect_params.reset_commands
         + vector_params.reset_commands
         + "\nvector_params.all_nodes=1;\n"	// always 1 for 1D/2D
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         downsize_params => <-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in => <-.fld_in;
      };
      MAcombine_vect MAcombine_vect {
         params =><-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.MAdownsize.fld_out;
      };
      MADVcomb_comp MADVcomb_comp {
         nd1 => <-.MAcombine_vect.fld_out;
         nd2 => <-.MAdownsize.fld_out;
         comp1 = {0};
         comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
      };
         MADVcombine_mesh_and_data+nosave MADVcomb_mesh_and_data {
         in_mesh => <-.MAcombine_vect.fld_out;
         in_nd => <-.MADVcomb_comp.out;
      };
      MAvector MAvector {
         params        => <-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         fld_in        => <-.MADVcomb_mesh_and_data.out;
         vector.in     => <-.fld_in;
         in_pick       => <-.in_pick;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAvector.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      olink legend_out => .MAcmapLegendSet.legend_out;

/*  for MicroAVS5.0  */
      olink vector_obj<NEportLevels={1,2}> => .MAvector.vector_out;
      olink text_obj<NEportLevels={1,2}> => .MAvector.text_out;
/*  for MicroAVS5.0  */

   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAcombine_vectUI.height
               + MAvectorUI.height
               + MAvector_map_compUI.height
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         downsize_params => <-.<-.Params.downsize_params;
         y => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAvector_map_compUI MAvector_map_compUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAvectorUI MAvectorUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAvector_map_compUI.y + <-.MAvector_map_compUI.height;
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.all_nodes_toggle.active;
            copy_on_change<weight=3>;
         };
#else
         all_nodes_toggle.active = 0;
#endif //MSDOS
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAvectorUI.y + <-.MAvectorUI.height;
         active => <-.<-.Params.vector_params.color;
      };
   };

/*  for MicroAVS5.0 cut_plane */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      Obj{
         &cut_plane_params => <-.cut_plane_params;
         xform+nres => in.xform;
      };
      child_objs => {<-.Modules.legend_out,
                     <-.Modules.vector_obj,  // for MicroAVS5.0
                     <-.Modules.text_obj,    // for MicroAVS5.0
                     <-.Modules.MAcut_plane.plane_axis_obj};   // for MicroAVS5.0
      Modes.mode => {<-.<-.Params.vector_params.mode1,
                             <-.<-.Params.vector_params.mode2,
                             <-.<-.Params.vector_params.mode3,
                             <-.<-.Params.vector_params.mode4,
                             <-.<-.Params.vector_params.mode5
                            };
   };
/*  for MicroAVS5.0 cut_plane */

};

FLDVector1D FLDVector2D {
   Params.params.help_name = "vec2d";
};

MAnetwork FLDVector3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_VECTOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_VECTOR_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "vec3d";
      params.name = "vector";
      MAdownsize_params downsize_params;
      MAcombine_vect3d_params combine_vect_params;
      MAorthoslice_params orthoslice_params;
      MAvector_params vector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands =>
           combine_vect_params.init_commands
         + downsize_params.init_commands
         + orthoslice_params.init_commands
         + vector_params.init_commands
         + legend_params.init_commands
         + colmap_params.init_commands;
      reset_params.reset_commands =>
           combine_vect_params.reset_commands
         + downsize_params.reset_commands
         + orthoslice_params.reset_commands
         + vector_params.reset_commands
         + legend_params.reset_commands
         + colmap_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         downsize_params => <-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in => <-.fld_in;
      };
      MAcombine_vect MAcombine_vect {
         params =><-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.MAdownsize.fld_out;
      };
      MADVcomb_comp MADVcomb_comp {
         nd1 => <-.MAcombine_vect.fld_out;
         nd2 => <-.MAdownsize.fld_out;
         comp1 = {0};
         comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
      };
         MADVcombine_mesh_and_data+nosave MADVcomb_mesh_and_data {
         in_mesh => <-.MAcombine_vect.fld_out;
         in_nd => <-.MADVcomb_comp.out;
      };
      MAorthoslice MAorthoslice {
         params =><-.<-.Params.params;
         orthoslice_params => <-.<-.Params.orthoslice_params;
         fld_in        => <-.MADVcomb_mesh_and_data.out;
      };
      MAvector MAvector {
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         fld_in        => <-.MADVcomb_mesh_and_data.out;
         slice_in => <-.MAorthoslice.fld_out;
         in_pick       => <-.in_pick;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAvector.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      olink legend_out => .MAcmapLegendSet.legend_out;

/*  for MicroAVS5.0  */
      olink vector_obj<NEportLevels={1,2}> => .MAvector.vector_out;
      olink text_obj<NEportLevels={1,2}> => .MAvector.text_out;
/*  for MicroAVS5.0  */

   };

   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAcombine_vectUI.height
               + MAdownsizeUI.height
               + MAorthosliceUI.height
               + MAvectorUI.height
               + MAmaplegendUI.height
               + MAvector_map_compUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         downsize_params => <-.<-.Params.downsize_params;
         y => <-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcombine_vectUI MAcombine_vectUI {
         parent => <-.parent;
         params => <-.<-.Params.params;
         combine_vect_params => <-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         y => <-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAvector_map_compUI MAvector_map_compUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAorthosliceUI MAorthosliceUI {
         fld_in =><-.<-.Modules.MAorthoslice.fld_in;
         parent => <-.parent;
         params =><-.<-.Params.params;
         orthoslice_params => <-.<-.Params.orthoslice_params;
         y => <-.MAvector_map_compUI.y + <-.MAvector_map_compUI.height;
      };
      MAvectorUI MAvectorUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAvectorUI.y + <-.MAvectorUI.height;
         active => <-.<-.Params.vector_params.color;
      };
   };
/*  for MicroAVS5.0 cut_plane */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      Obj{
         &cut_plane_params => <-.cut_plane_params;
         xform+nres => in.xform;
      };
      child_objs => {<-.Modules.legend_out,
                     <-.Modules.vector_obj,  // for MicroAVS5.0
                     <-.Modules.text_obj,    // for MicroAVS5.0
                     <-.Modules.MAcut_plane.plane_axis_obj};   // for MicroAVS5.0
      Modes.mode => {<-.<-.Params.vector_params.mode1,
                             <-.<-.Params.vector_params.mode2,
                             <-.<-.Params.vector_params.mode3,
                             <-.<-.Params.vector_params.mode4,
                             <-.<-.Params.vector_params.mode5
                            };
   };
/*  for MicroAVS5.0 cut_plane */

};

