/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/axis.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/axis.v#1 $
*/
//
// Axis Editor
//
MAparams MAaxis_editor_params {
   boolean color = 1;
   boolean axis_vis = 0;
   float x_offset = 0;
   float y_offset = 0;
   float scale = 1;
   DefaultXform rot_xform;
//   DefaultXform pos_xform {
//      xlate = { -4, -4, 0 };
//   };
   init_commands = "";
   reset_commands =
       "axis_editor_params.color=1;"
      +"axis_editor_params.axis_vis=0;"
      +"axis_editor_params.x_offset=0;"
      +"axis_editor_params.y_offset=0;"
      +"axis_editor_params.scale=1;"
//      +"axis_editor_params.pos_xform.xlate={-4,-4,0};"
      ;
};

MAmacroUI MAaxisEditorUI {
   MAviewer_common_params &viewer_params;
   MAaxis_editor_params &axis_editor_params;

   height => axis_editor_panel.height;
   MAUIframe axis_editor_panel {
      parent => <-.parent;
      y => <-.y;
      height = 240;
   };
   MAUIslider x_offset_slider {
      parent => <-.axis_editor_panel;
      value = 0.;
      x = 60;
      y = 150;
      width = 150;
#ifdef MSDOS
      height = 35;
#else
      height = 60;
#endif //MSDOS
      title = "MAV3AXIS_XPOS";
      min = -10.;
      max = 10.;
      decimalPoints = 1;
      value => <-.axis_editor_params.x_offset;
   };
   x_offset_slider y_offset_slider {
      title = "MAV3AXIS_YPOS";
      x = 0;
      width = 60;
      y = 15;
      height = 150;
      horizontal = 0;
      processingDirection = "up";
      value => <-.axis_editor_params.y_offset;
   };

   MAUIdial scale_dial {
      parent => <-.axis_editor_panel;
      value = 1.;
      title = "MAV3AXIS_SCALE";
      x = 60;
      y = 15;
      width = 150;
      height = 130;
      min = 0.1;
      max = 5.;
      decimalPoints = 1;
      value => <-.axis_editor_params.scale;
   };
   MAUItoggle color_toggle {
      parent => <-.axis_editor_panel;
      x = 20;
      y = 210;
      width = 70;
      height = 25;
      color.backgroundColor = "white";
      color.foregroundColor = MAVS_RED;
      label = "MAV3AXIS_COL";
      set => <-.axis_editor_params.color;
   };
   MAUItoggle axis_vis_toggle {
      parent => <-.axis_editor_panel;
      x => color_toggle.x + color_toggle.width + 30; 
      y => color_toggle.y;
      width = 100;
      label = "MAUI_DISPLAY";
      set => <-.axis_editor_params.axis_vis;
   };
};

MAeditor MAaxisEditor {
   title = "MAV3AXIS_TITLE";

   Params {
      params.name      = "axis";
      params.help_name = "geaxis";
      params.visible   = 0;
      MAaxis_editor_params axis_editor_params;
      axis_editor_params.axis_vis => viewer_params.axis;
      init_params.init_commands => axis_editor_params.init_commands;
      reset_params.reset_commands => axis_editor_params.reset_commands;
   };
   MAGDxform_edit+nosave get_top_xform {
      shell_vis => <-.Params.axis_editor_params.axis_vis;
      &xform => <-.viewer_params.top_xform;
      absolute = 1;
      &x_rot => <-.rot_edit.x_rot;
      &y_rot => <-.rot_edit.y_rot;
      &z_rot => <-.rot_edit.z_rot;
   };
   MAGDxform_edit+nosave rot_edit {
      ///never shell_vis => <-.Params.axis_editor_params.axis_vis;
      &xform => <-.Params.axis_editor_params.rot_xform;
      absolute = 1;
      scale => <-.Params.axis_editor_params.scale;
   };
   MAdefaultCamera3D+nosave Camera {
      objects => {MAaxisObj.all_axis_obj};
      back = 10000;
      float x => 4 - <-.Params.axis_editor_params.x_offset;
      float y => 4 - <-.Params.axis_editor_params.y_offset;
      from => {x, y, 12};
      at   => {x, y, 0};
   };
   macro+nosave MAaxisObj {
      ilink axis_editor_params => <-.Params.axis_editor_params;
      ilink xform_in => .axis_editor_params.rot_xform;
      link vis => .axis_editor_params.axis_vis;
      link color => !.axis_editor_params.color;
      link scale_in => .axis_editor_params.scale;
   
      macro axis_x {
         ilink colorx => <-.color;
         Mesh_Unif+Space3+Dim1 line_x<NEportLevels={0,1}> {
            nspace => 3;
            dims = {2};
            coordinates { values = {0.,0.,0.,1.,0.,0.}; };
         };
         MAdefaultObject line_x_obj<NEportLevels={0,2}> {
            input => <-.line_x;
            props => <-.axis_x_props;
         };
         Pyr set<NEportLevels={0,0}> {
            ncells = 1;
            node_connect_list = {4,2,1,3,0};
         };
         Mesh head_x<NEportLevels={0,1}> {
            int nnodes = 5;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  -0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,0.,0.5,0.,0.,0.,1.
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set};
            xform {
               mat = {
                  0.,0.,-0.3,0.,0.,0.3,0.,0.,0.3,0.,0.,0.,0.,0.,0.,1.
               };
               xlate = {1.,0.,0.};
            };
         };
         MAdefaultObject head_x_obj<NEportLevels={0,2}> {
            input => <-.head_x;
            props => <-.axis_x_props;
            xform => input.xform;
         };
         DefaultProps axis_x_props {
            col<NEportLevels={1,0}> => {1,<-.colorx,<-.colorx};
            inherit = 0;
         };
         MAdefaultObject label_x_obj<NEportLevels={0,2}> {
            input => <-.label_x;
            props => <-.axis_x_props;
         };
         Text_NoXform label_x {
            str = "X";
            nspace = 3;
            position = {1.1,-0.3,0.3};
            stroke = 1;
         };
      };
      macro axis_y {
         ilink colory => <-.color;
         Mesh_Unif+Space3+Dim1 line_y<NEportLevels={0,1}> {
            nspace => 3;
            dims = {2};
            coordinates { values = {0.,0.,0.,0., 1.,0.}; };
         };
         Pyr set {
            ncells = 1;
            node_connect_list = {4,2,1,3,0};
         };
         Mesh head_y<NEportLevels={0,1}> {
            int nnodes = 5;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  -0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,0.,0.5,0.,0.,0.,1.
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set};
            xform {
               mat = {
                  0.3,0.,0.,0.,0.,0.,-0.3,0.,0.,0.3,0.,0.,0.,0.,0.,1.
               };
               xlate = {0.,1.,0.};
            };
         };
         MAdefaultObject line_y_obj<NEportLevels={0,2}> {
            input => <-.line_y;
            props => <-.axis_y_props;
         };
         MAdefaultObject head_y_obj<NEportLevels={0,2}> {
            input => <-.head_y;
            props => <-.axis_y_props;
            xform => input.xform;
         };
         DefaultProps axis_y_props {
            col<NEportLevels={1,0}> => {<-.colory,1,<-.colory};
            inherit = 0;
         };
         MAdefaultObject label_y_obj<NEportLevels={0,2}> {
            input => <-.label_y;
            props => <-.axis_y_props;
         };
         Text_NoXform label_y {
            str = "Y";
            nspace = 3;
            position = {-0.3,1.1,0.3};
            stroke = 1;
         };
      };
      macro axis_z {
         ilink colorz => <-.color;
         Mesh_Unif+Space3+Dim1 line_z<NEportLevels={0,1}> {
            nspace => 3;
            dims = {2};
            coordinates { values = {0.,0.,0.,0., 0.,1.}; };
         };
         Pyr set {
            ncells = 1;
            node_connect_list = {4,2,1,3,0};
         };
         Mesh head_z<NEportLevels={0,1}> {
            int nnodes = 5;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  -0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,0.,0.5,0.,0.,0.,1.
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set};
            xform {
               mat = {
                  0.3,0.,0.,0.,0.,0.3,0.,0.,0.,0.,0.3,0.,0.,0.,0.,1.
               };
               xlate = {0.,0.,1.};
            };
         };
         MAdefaultObject line_z_obj<NEportLevels={0,2}> {
            input => <-.line_z;
            props => <-.axis_z_props;
         };
         MAdefaultObject head_z_obj<NEportLevels={0,2}> {
            input => <-.head_z;
            props => <-.axis_z_props;
            xform => input.xform;
         };
         DefaultProps axis_z_props {
            col<NEportLevels={1,0}> => {<-.colorz,<-.colorz,1};
            inherit = 0;
         };
         MAdefaultObject label_z_obj<NEportLevels={0,2}> {
            input => <-.label_z;
            props => <-.axis_z_props;
         };
         Text_NoXform label_z {
            str = "Z";
            nspace = 3;
            position = {-0.3,0.3,1.1};
            stroke = 1;
         };
      };
      DefaultModes axis_modes {
         normals = 1;
      };
      DefaultProps axis_props {
         line_width => <-.scale_in;
      };
      MAdefaultObject all_axis_obj<NEportLevels={0,2}> {
         objects => {
            <-.axis_x.line_x_obj, <-.axis_y.line_y_obj, <-.axis_z.line_z_obj,
            <-.axis_x.head_x_obj, <-.axis_y.head_y_obj, <-.axis_z.head_z_obj,
            <-.axis_x.label_x_obj, <-.axis_y.label_y_obj, <-.axis_z.label_z_obj
         };
         props => <-.axis_props;
         modes => <-.axis_modes;
         visible => <-.vis;
         pickable = 0;
         xform => xform_in;
      };
   };

   GMOD.copy_on_change set_UI_vis {
      input => switch(<-.Params.axis_editor_params.axis_vis, 1); 
      output => <-.UI.visible;
      on_inst = 0;
   };
   UI {
      //visible => <-.viewer_params.axis;
      MAaxisEditorUI AxisEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         axis_editor_params => <-.<-.Params.axis_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + AxisEditorUI.height + 5;
   };
   olink axis_camera => Camera;
};
