/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/label.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/label.v#1 $
*/
//
// Label Editor
//
// MAlabelObject to GD/templ.v moved

MAparams MAlabel_editor_params {
   boolean palette_vis = 1;
   string+nosave FontTable[] => str_array("MAVLAB_FONTS",";");
   string+nosave SampleFontTable[] => str_array("MAVLAB_SAMPLEFONTS",";");
   string+nosave sample_font => SampleFontTable[.font_index];
   MAlabelObject Label5 { state = 1;
      &FontTable => <-.FontTable;
      obj.name => "NOOBJLIST "+name_of(<-.<-);
   };
   Label5 Label10;
   Label5 Label9;
   Label5 Label8;
   Label5 Label7;
   Label5 Label6;
   Label5 Label4;
   Label5 Label3;
   Label5 Label2;
   Label5 Label1;
   MAlabelObject &Labels[] => {Label1, Label2, Label3, Label4, Label5,
                               Label6, Label7, Label8, Label9, Label10};
   omlink labels => Labels.obj;
   boolean+nosave reset;
   int+nosave     current_label = 0;
   float+nosave red => Labels[current_label].red;
   float+nosave green => Labels[current_label].green;
   float+nosave blue => Labels[current_label].blue;
   int+nosave height => Labels[current_label].height;
   string+nosave label => Labels[current_label].label;
   float+nosave x_pos => Labels[current_label].x_pos;
   float+nosave y_pos => Labels[current_label].y_pos;
   boolean+nosave front => Labels[current_label].front;
   boolean+nosave state => Labels[current_label].state;
   int+nosave font_index => Labels[current_label].font_index;
   int+nosave style => Labels[current_label].style;

   init_commands => "";
   reset_commands =
       "label_editor_params.current_label=0;"
      +"label_editor_params.reset=1;"
      +"label_editor_params.palette_vis=1;"
      ;
};

MAmacroUI MAlabelEditorUI {
   MAviewer_common_params &viewer_params;
   MAlabel_editor_params &label_editor_params;

   boolean active = 0;
   int current_label => .label_editor_params.current_label;

   height => label_editor_panel.height;
   MAUIframe label_editor_panel {
      parent => <-.parent;
      y => <-.y;
      width = 480;
#ifdef MSDOS
      height = 310;
#else
      height = 355;
#endif //MSDOS
   };
   GMOD.copy_on_change set_active {
      input => <-.label_editor_params.state;
      output => <-.active;
#ifdef MSDOS
      copy_on_change<weight=3>;
#endif //MSDOS
   };
   MAUIOptionMenuLabel Select {
      parent => <-.label_editor_panel;
      options => {
         "MAVLAB" + " 1",
         "MAVLAB" + " 2",
         "MAVLAB" + " 3",
         "MAVLAB" + " 4",
         "MAVLAB" + " 5",
         "MAVLAB" + " 6",
         "MAVLAB" + " 7",
         "MAVLAB" + " 8",
         "MAVLAB" + " 9",
         "MAVLAB" + "10"
      };
      selectedItem => <-.label_editor_params.current_label;
      label = "MAVLAB_SEL";
      x = 5;
      y = 10;
#ifdef MSDOS
      width = 225;
#else
      width = 225;
#endif //MSDOS
      width2 => width/2+5;
      height = 30;
   };
   MAUIOptionMenuLabel LabelFont {
      parent => <-.label_editor_panel;
      options => <-.label_editor_params.FontTable;
      x = 10;
      y => <-.Select.y + <-.Select.height;
#ifdef MSDOS
      width = 220;
#else
      width = 225;
#endif //MSDOS
      height = 30;
      active => <-.active;
      selectedItem => <-.label_editor_params.font_index;
      label = "MAVLAB_FONT";
   };
   MAUIOptionMenuLabel LabelStyle {
      parent => <-.label_editor_panel;
      options => {
         "MAVLAB_NORMAL", "MAVLAB_BOLD", "MAVLAB_ITALIC", "MAVLAB_BOLDITLIC"
      };
      x = 10;
      y => <-.LabelFont.y + <-.LabelFont.height;
#ifdef MSDOS
      width = 220;
#else
      width = 225;
#endif //MSDOS
      height = 30;
      active => <-.active;
      selectedItem => <-.label_editor_params.style;
      label = "MAVLAB_STYLE";
   };
   MAcolorEditorUI LabelColorEditorUI {
      MAlabel_editor_params &label_editor_params => <-.label_editor_params;
      parent => <-.label_editor_panel;
      x = 240;
      y = 10;
      active => <-.active;
      label = "MAVLAB_COL";
      red   => <-.label_editor_params.red;
      green => <-.label_editor_params.green;
      blue  => <-.label_editor_params.blue;
      palette_vis  => <-.label_editor_params.palette_vis;
   };
   MAUItoggle Visible {
      parent => <-.parent;
      set => <-.label_editor_params.state;
      label = "MAUI_DISPLAY";
      x = 250;
      y = 15;
      width = 100;
   };
   MAUItoggle FrontBack {
      parent => <-.parent;
      set => <-.label_editor_params.front;
      label = "MAVLAB_FRONT";
      x = 365;
      y = 15;
      width = 100;
      visible => <-.viewer_params.viewer3d;
      active => <-.active;
   };
   MAUIslider HoriSlider {
      parent => <-.label_editor_panel;
      x = 250;
      y => <-.LabelColorEditorUI.y + <-.LabelColorEditorUI.height + 10;
      width = 210;
#ifdef MSDOS
      //height = 35;
#else
      height = 60;
#endif //MSDOS
      title = "MAUI_YOKO";
      min = -1;
      max =  1;
      value => <-.label_editor_params.x_pos;
      active => <-.active;
   };
   HoriSlider VertSlider {
#ifdef MSDOS
      y = 260;
#else
      y => <-.HoriSlider.y + <-.HoriSlider.height;
#endif //MSDOS
      title = "MAUI_TATE";
      value => <-.label_editor_params.y_pos;
   };
   MAUIlabel Prompt {
      parent => <-.label_editor_panel;
      x = 10;
      y => <-.LabelStyle.y + <-.LabelStyle.height + 5;
      width = 160;
      height = 25;
      alignment = "left";
      label = "MAVLAB_PROMPT";
   };
   MAUIbutton ClearButton {
      parent => <-.label_editor_panel;
      x => <-.Prompt.x + <-.Prompt.width + 5;
      y => <-.Prompt.y - 5;
      width = 43;
      height = 30;
      label = "";
      labelPixmap.filename = MAVS_ICON_PATH+"clear.x";
      labelPixmap.fileType = "avs_image";
   };
   MAUItext Text {
      parent => <-.label_editor_panel;
      x = 10;
      y => <-.ClearButton.y + <-.ClearButton.height;
      width = 205;
      active => <-.active;
      text => <-.label_editor_params.label;
// 3.0 New
      columns+nres => 205/(UIdata.UIfonts[0].lineHeight+1);
      height = 40;
      multiLine = 1;
// 3.0 New end
   };
   GMOD.copy_on_change ClearText {
      trigger => <-.ClearButton.do;
      input = "";
      output => <-.Text.text;
      on_inst = 0;
   };
   MAUIslider HeightSlider {
      parent => <-.label_editor_panel;
      x = 10;
      y => <-.Text.y + <-.Text.height+5;
      width = 210;
#ifdef MSDOS
      //height = 35;
#else
      height = 60;
#endif //MSDOS
      title = "MAUI_SCALE";
      min = 1;
      max = 72;
      value => <-.label_editor_params.height;
      mode = "integer";
      decimalPoints = 0;
      active => <-.active;
   };
   MAUIframe SampleFrame {
      parent => <-.label_editor_panel;
      x = 10;
#ifdef MSDOS
      y = 220;
      height = 80;
#else
      y => <-.HeightSlider.y + <-.HeightSlider.height + 10;
      height = 100;
#endif //MSDOS
      width = 210;
   };
   MAUIpanel SamplePanel {
      parent => <-.SampleFrame;
      x = 0;
      y = 0;
      width =>parent.clientWidth;
      height =>parent.clientHeight;
      color.backgroundColor = "black";
   };
   MAUIlabel SampleLabel {
      parent => <-.SamplePanel;
      width =>parent.clientWidth;
      height =>parent.clientHeight;
      //label => <-.label_editor_params.label;
      label = "MAVLAB_SAMPLE";
      x = 0;
#ifdef MSDOS
      y => (72 - <-.label_editor_params.height * 0.7) / 2;
#else
      y = 0;
#endif //MSDOS
      fontAttributes {
         family => <-.<-.label_editor_params.sample_font;
         height => max_array({1, <-.<-.label_editor_params.height * 0.7});
         weight => switch(<-.<-.label_editor_params.style+1,
                          "medium","bold","medium","bold");
         slant => switch(<-.<-.label_editor_params.style+1,
                          "regular","regular","oblique","oblique");
      };
      color.foregroundColor = "white";
      color.backgroundColor = "black";
   };
};

MAeditor MAlabelEditor {
   title = "MAVLAB_TITLE";
   int current_label => Params.label_editor_params.current_label;

   Params {
      params.name = "label";
      params.help_name => switch(viewer_params.viewer3d+1,
                          "imlabel","gelabel");
      MAlabel_editor_params label_editor_params {
      };
      init_params.init_commands => label_editor_params.init_commands;
      reset_params.reset_commands => label_editor_params.reset_commands;
      GMOD.parse_v reset_labels {
         on_inst = 0;
         trigger => <-.label_editor_params.reset;
         relative => <-.label_editor_params;
         v_commands =
 "$push -usr\n"
+"!Labels[0]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};"
+"!Labels[1]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};"
+"!Labels[2]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};"
+"!Labels[3]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};"
+"!Labels[4]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"!Labels[5]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"!Labels[6]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"!Labels[7]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"!Labels[8]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"!Labels[9]{red=1;green=1;blue=1;height=20;"
+"label=\"\";x_pos=0;y_pos=0;front=1;state=1;"
+"font_index=0;style=0;};\n"
+"$pop\n";
};
   };

   UI {
      visible => <-.viewer_params.label_vis;
      parent.width = 480;
      MAlabelEditorUI LabelEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         label_editor_params => <-.<-.Params.label_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + LabelEditorUI.height + 5;
   };
   MAdefaultObject GroupObj {
      objects => <-.Params.label_editor_params.labels;
      name = "NOOBJLIST All Labels";
   };
   olink label_objs => GroupObj;
};
