/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/props.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/props.v#1 $
*/
//
// Props Editor
//
MAparams MAprops_editor_params {
   boolean inherit = 1;
   boolean props_list = 0;
   boolean+nosave reset;
   boolean spec_color_editor = 0;
   boolean palette_vis = 1;
   float red          = GD_DEFAULT_RED;
   float green        = GD_DEFAULT_GREEN;
   float blue         = GD_DEFAULT_BLUE;
//   float ambient      = GD_DEFAULT_AMBIENT;
//   float diffuse      = GD_DEFAULT_DIFFUSE;
//   float specular     = GD_DEFAULT_SPECULAR;
//   float gloss        = GD_DEFAULT_SPEC_EXP;
//   float transparency = GD_DEFAULT_TRANS;
   float ambient;
   float diffuse;
   float specular;
   float gloss;
   float spec_red     = GD_DEFAULT_RED;
   float spec_green   = GD_DEFAULT_GREEN;
   float spec_blue    = GD_DEFAULT_BLUE;
   float transparency;
   init_commands = "";
   reset_commands =
       "props_editor_params.palette_vis=1;\n"
      +"props_editor_params.reset=1;\n"
      +"props_editor_params.props_list=0;"
      +"props_editor_params.spec_color_editor=0;"
      ;
};

MAmacroUI MApropsEditorUI {
   MAviewer_common_params &viewer_params;
   MAprops_editor_params &props_editor_params;

   MAUItoggle InheritToggle {
      parent => <-.parent;
      x = 255;
      y = 15;
      width = 100;
      &set => <-.props_editor_params.inherit;
      label = "MAV3PROPS_INHERIT";
   };
//#ifdef MICROAVS_V2_1
//   InheritToggle PropsListToggle {
//      x => <-.InheritToggle.x + 115;
//      &set => <-.props_editor_params.props_list;
//      label => "MAV3PROPS_LIST"+" ...";
//   };
//#endif //MICROAVS_V2_1

   height => props_editor_panel.height;
   MAUIframe props_editor_panel {
      parent => <-.parent;
      y => <-.y;
      width = 480;
#ifdef MSDOS
      height = 248;
#else
      height = 304;
#endif //MSDOS
   };
   MAcolorEditorUI ColorEditorUI {
      MAprops_editor_params &props_editor_params => <-.props_editor_params;
      parent => <-.props_editor_panel;
      red => props_editor_params.red;
      green => props_editor_params.green;
      blue => props_editor_params.blue;
      palette_vis => props_editor_params.palette_vis;
      y = 5;
   };
   MAUIbutton SpecColorEditorButton {
      parent => <-.props_editor_panel;
      x = 10;
#ifdef MSDOS
      y = 210;
#else
      y => <-.height - .height - 15;
#endif //MSDOS
      width = 210;
      height = 24;
      active => (<-.props_editor_params.specular > 0.0);
      label => "MAV3PROPS_SPEC_COL"+" ...";
      &do => <-.props_editor_params.spec_color_editor;
   };
   GMOD.instancer SpecColorEditorUIinstancer {
      Group => <-.SpecColorEditorUI;
      Value => <-.props_editor_params.spec_color_editor;
   };
   MAcolorEditorUI SpecColorEditorUI<instanced=0> {
      MAprops_editor_params &props_editor_params => <-.props_editor_params;
      MAUIcloseDialog SpecColorPanel {
         title = "MAV3PROPS_SPEC_COL";
         visible => <-.props_editor_params.spec_color_editor;
         width = 240;
#ifdef MSDOS
         height = 270;
#else
         height = 280;
#endif //MSDOS
      };
      parent => .SpecColorPanel;
      red => props_editor_params.spec_red;
      green => props_editor_params.spec_green;
      blue => props_editor_params.spec_blue;
      y = 5;
   };
   macro MAmaterialEditorUI {
      MAprops_editor_params &props_editor_params => <-.props_editor_params;
      ilink parent => <-.props_editor_panel;
      MAUIframe props_panel {
         parent => <-.parent;
         x = 232;
         y = -2;
         width = 240;
         height => parent.height;
      };
      MAUIslider am_slider {
         parent => <-.props_panel;
         title = "MAV3PROPS_AMBIENT";
         x = 10;
         width => .parent.clientWidth - 20;
#ifdef MSDOS
         y = 5;
         height = 40;
#else
         y = 0;
         height = 60;
#endif //MSDOS
         min = 0;
         max = 1;
         value => <-.props_editor_params.ambient;
         immediateMode = 0;
         decimalPoints = 2;
      };
      am_slider dif_slider {
         title = "MAV3PROPS_DIFFUSE";
#ifdef MSDOS
         y => 5 + am_slider.y + am_slider.height;
#else
         y => am_slider.y + am_slider.height;
#endif //MSDOS
         value => <-.props_editor_params.diffuse;
      };
      am_slider spe_slider {
         title = "MAV3PROPS_SPEC";
#ifdef MSDOS
         y => 5 + dif_slider.y + dif_slider.height;
#else
         y => dif_slider.y + dif_slider.height;
#endif //MSDOS
         value => <-.props_editor_params.specular;
      };
      am_slider spe_exp_slider {
         title = "MAV3PROPS_SPEC_EXP";
#ifdef MSDOS
         y => 5 + spe_slider.y + spe_exp_slider.height;
#else
         y => spe_slider.y + spe_exp_slider.height;
#endif //MSDOS
         min = 1;
         max = 100;
         value => <-.props_editor_params.gloss;
         decimalPoints = 0;
      };
      am_slider trans_slider {
         title = "MAV3PROPS_TRANS";
#ifdef MSDOS
         y => 5 + spe_exp_slider.y + spe_exp_slider.height;
#else
         y => spe_exp_slider.y + spe_exp_slider.height;
#endif //MSDOS
         value => <-.props_editor_params.transparency;
         min = 0.003;
      };
   };
};

MAeditor MApropsEditor {
   title = "MAV3PROPS_TITLE";
   MAGDobject_templ+IPort2 &obj_in { GDprops_templ+OPort2 &props; };

   Params {
      params.name = "props";
      params.help_name = "geprops";
      MAprops_editor_params props_editor_params;
      init_params.init_commands => props_editor_params.init_commands;
      reset_params.reset_commands => props_editor_params.reset_commands;
   };

   MAGDprops_edit PropsEditor {
      props      => <-.obj_in.props;
      shell_vis  => <-.Params.viewer_params.props_vis;
      red        => <-.Params.props_editor_params.red;
      green      => <-.Params.props_editor_params.green;
      blue       => <-.Params.props_editor_params.blue;
      ambient    => <-.Params.props_editor_params.ambient;
      diffuse    => <-.Params.props_editor_params.diffuse;
      specular   => <-.Params.props_editor_params.specular;
      spec_red   => <-.Params.props_editor_params.spec_red;
      spec_green => <-.Params.props_editor_params.spec_green;
      spec_blue  => <-.Params.props_editor_params.spec_blue;
      spec_exp   => <-.Params.props_editor_params.gloss;
      trans      => <-.Params.props_editor_params.transparency;
      reset      => <-.Params.props_editor_params.reset;
      inherit    => <-.Params.props_editor_params.inherit;
   };

//
//  W[CX^XMAGDprops_edit܂obj_inɒlZbgA
//  WXgݒ肳lNAB
//

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.props_editor_params.ambient      = <-.env_params.properties.ambient;\n"
                  +"Params.props_editor_params.diffuse      = <-.env_params.properties.diffuse;\n"
                  +"Params.props_editor_params.specular     = <-.env_params.properties.specular;\n"
                  +"Params.props_editor_params.gloss        = <-.env_params.properties.spec_exp;\n"
                  +"Params.props_editor_params.transparency = <-.env_params.properties.trans;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => switch(.active, is_valid(<-.obj_in));
     on_inst    = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"Params.env_params.properties.ambient  = MicroAVS.MAviewer.MAviewer3Editors.PropsEditor.Params.props_editor_params.ambient;\n"
                     +"Params.env_params.properties.diffuse  = MicroAVS.MAviewer.MAviewer3Editors.PropsEditor.Params.props_editor_params.diffuse;\n"
                     +"Params.env_params.properties.specular = MicroAVS.MAviewer.MAviewer3Editors.PropsEditor.Params.props_editor_params.specular;\n"
                     +"Params.env_params.properties.spec_exp = MicroAVS.MAviewer.MAviewer3Editors.PropsEditor.Params.props_editor_params.gloss;\n"
                     +"Params.env_params.properties.trans    = MicroAVS.MAviewer.MAviewer3Editors.PropsEditor.Params.props_editor_params.transparency;\n"
                     +"$pop\n"
                     +"$push\n"
                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#else
   GMOD.parse_v set_init_params;
   GMOD.parse_v get_init_params;
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

   UI {
      visible => <-.viewer_params.props_vis;
      parent.width = 480; // special
      MApropsEditorUI PropsEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         props_editor_params => <-.<-.Params.props_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + PropsEditorUI.height + 5;
   };
};
