/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/track.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/track.v#1 $
*/
//
// Track Editor
// no parameters
//
macro MAtrackEditor {
   MAGDview_templ+IPort2 &view_in;
   ilink camera_in;
   ilink obj_in;
   link track_rv => .view_in.render_view;
   link trans_mode;

   string start_events[4] = {
   "<Btn1Down>"  , "Shift<Btn1Down>"  , "<Btn3Down>"  , "Shift<Btn3Down>"   };
   string run_events[4] = {
   "<Btn1Motion>", "Shift<Btn1Motion>", "<Btn3Motion>", "Shift<Btn3Motion>" };
   string stop_events[4] = {
   "<Btn1Up>"    , "Shift<Btn1Up>"    , "<Btn3Up>"    , "Shift<Btn3Up>"     };

   UItwoPoint InterRotate {
      view+IPort2 => track_rv;
      startEvent => start_events[0];
      runEvent => run_events[0];
      stopEvent => stop_events[0];
   };
   MAGDtrack_edit TrackRotate {
      view+IPort2 => view_in;
      camera+IPort2 => camera_in;
      obj+IPort2 => obj_in;
      x => InterRotate.x;
      y => InterRotate.y;
      event => InterRotate.state;
      time => InterRotate.time;
      mode = 0;
      rot_mode = 0; //> TrackAll.rot_mode;
      space = 0; //> TrackAll.space;
      trans_mode => <-.trans_mode;
   };
   UItwoPoint InterScale {
      view+IPort2 => track_rv;
      startEvent => start_events[1];
      runEvent => run_events[1];
      stopEvent => stop_events[1];
   };
   MAGDtrack_edit TrackScale {
      view+IPort2 => view_in;
      camera+IPort2 => camera_in;
      obj+IPort2 => obj_in;
      x => InterScale.x;
      y => InterScale.y;
      event => InterScale.state;
      time => InterScale.time;
      mode = 1;
      scale_mode = 0; //> TrackAll.scale_mode;
      space = 0; //> TrackAll.space;
      trans_mode => <-.trans_mode;
   };
   UItwoPoint InterXlate_XY {
      view+IPort2 => track_rv;
      startEvent => start_events[2];
      runEvent => run_events[2];
      stopEvent => stop_events[2];
   };
   MAGDtrack_edit TrackXlate_XY {
      view+IPort2 => view_in;
      camera+IPort2 => camera_in;
      obj+IPort2 => obj_in;
      x => InterXlate_XY.x;
      y => InterXlate_XY.y;
      event => InterXlate_XY.state;
      time => InterXlate_XY.time;
      mode = 2;
      xlate_mode = 0; //> TrackAll.xlate_mode;
      space = 0; //> TrackAll.space;
      trans_mode => <-.trans_mode;
   };
   UItwoPoint InterXlate_Z {
      view+IPort2 => track_rv;
      startEvent => start_events[3];
      runEvent => run_events[3];
      stopEvent => stop_events[3];
   };
   MAGDtrack_edit TrackXlate_Z {
      view+IPort2 => view_in;
      camera+IPort2 => camera_in;
      obj+IPort2 => obj_in;
      x => InterXlate_Z.x;
      y => InterXlate_Z.y;
      event => InterXlate_Z.state;
      time => InterXlate_Z.time;
      mode = 3;
      xlate_mode = 0;
      space = 0;
   };
};
