/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/unitvec.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source$
*/
//
// Unit Vector Editor
//
MAparams MAunitvector_editor_params {
    float   x_pos = 3.0;
    float   y_pos = -4.0;
    float   z_pos = 0.0;
    float   red = 1.0;
    float   green = 1.0;
    float   blue = 1.0;
    boolean+nosave reset;

    init_commands => "";
    reset_commands =
       "unitvector_editor_params{"
      +"x_pos=3.0;y_pos=-4.0;z_pos=0.0;"
      +"red=1.0;green=1.0;blue=1.0;"
      +"reset = 1;"
      +"};"
      ; 
};

MAmacroUI MAunitvectorEditorUI {
   MAunitvector_editor_params &unitvector_editor_params;
   
   height => unitvector_editor_panel.height;
   MAUIframe unitvector_editor_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.yslider.height + <-.yslider.y + 15;
      width => parent.clientWidth - 2;
   };
   MAUItoggle unit_vis_toggle {
      parent => <-.unitvector_editor_panel;
      x = 5;
      y = 3;
      width = 100;
      label = "MAUI_DISPLAY";
      set => <-.params.visible;
   };
   MAUIlabel color_label {
      parent => <-.unitvector_editor_panel;
      x = 5;
      y => <-.unit_vis_toggle.y + <-.unit_vis_toggle.height + 15;
      width = 110;
      label = "MAUNIT_LABEL_COLOR";
      alignment = "left";
   }; 
   MAcolorEditorUI MAcolorEditor {
      parent => <-.unitvector_editor_panel;
      visible = 1;
      y => <-.color_label.y + <-.color_label.height + 5;
      palette_vis = 1;
      red => <-.unitvector_editor_params.red;
      green => <-.unitvector_editor_params.green;
      blue => <-.unitvector_editor_params.blue;
   };
   MAUIlabel move_label {
      parent => <-.unitvector_editor_panel;
      x = 5;
      y => <-.MAcolorEditor.y + <-.MAcolorEditor.height + 5;
      width = 110;
      label = "MAUNIT_LABEL_MOVE";
      alignment = "left";
   }; 
   MAUIslider xslider {
      parent => <-.unitvector_editor_panel;
      x = 5;
      y => <-.move_label.y + <-.move_label.height + 10;
      width => parent.clientWidth - 2 * x;
      min = -5.0;
      max = 5.0;
      title = "MAUNIT_LABEL_X";
      value => <-.unitvector_editor_params.x_pos;
   };
   MAUIslider yslider {
      parent => <-.unitvector_editor_panel;
      x = 5;
      y => <-.xslider.y + <-.xslider.height + 10;
      width => parent.clientWidth - 2 * x;
      min = -5.0;
      max = 5.0;
      title = "MAUNIT_LABEL_Y";
      value => <-.unitvector_editor_params.y_pos;
   };
};

MAeditor MAunitvectorEditor {
   title = "MAUNIT_TITLE";
 
   Params {
      params.name      = "unit";
      params.help_name = "unit";
      params.visible   = 0; // 0 for instancer
      MAunitvector_editor_params unitvector_editor_params {
  
      };
      init_params.init_commands => unitvector_editor_params.init_commands;
      reset_params.reset_commands => unitvector_editor_params.reset_commands;
      GMOD.parse_v reset_unit {
         on_inst = 0;
         trigger => <-.unitvector_editor_params.reset;
         relative => <-.unitvector_editor_params;
         v_commands ="";
      };
   };
   Mesh_Unif Line {
               nspace = 2;
               ndim = 1;
               points = {0.,0.,1.,0.};
               nnodes = 4;
               dims = {4};
               coordinates.values = {0.0, 0.1, 0.0, 0.0, 1.0, 0.0, 1.0, 0.1};
   };
   MAdataObjectLite Obj {
      in => <-.Line;
      Obj.name => "NOOBJLIST LINE_UNIT_OBJ";
      Obj.pickable = 0;
   };
   DefaultCamera2D camera {
      objects => {<-.GroupObject.obj};
      from => { -<-.Params.unitvector_editor_params.x_pos,
                -<-.Params.unitvector_editor_params.y_pos,
                -<-.Params.unitvector_editor_params.z_pos+1.0};
      at   => { -<-.Params.unitvector_editor_params.x_pos,
                -<-.Params.unitvector_editor_params.y_pos,
                -<-.Params.unitvector_editor_params.z_pos};
   };
   GMOD.parse_v set_unit {
         on_inst = 0;
         trigger => <-.viewer_params.unit_vis;
         relative => <-.<-.<-.<-;
         v_commands =>
              "$push\n"
            + switch(<-.viewer_params.unit_vis+1,
              "$del_obj_ref MAview.Cameras MAviewerEditors.UnitVectorEditor.camera\n",
              "$del_obj_ref MAview.Cameras MAviewerEditors.UnitVectorEditor.camera\n"
             + "$link MAview.Cameras MAviewerEditors.UnitVectorEditor.camera\n")
            + "$pop\n";
   };
   GMOD.copy_on_change set_visible {
         input   => switch(<-.Params.params.visible, 1);
         output  => <-.viewer_params.unit_vis;
         on_inst = 0;
   };
   DefaultProps TextProps {
      int height => 16;
      font => "-*-"+"times"+"-"
                   +"medium-r"+"-*-*-"+height+"-*-*-*-*-*-*-*";
   };
   macro strZeroObj {
         ilink props => <-.TextProps;
         Text_NoXform strZero {
         str = "0";
         nspace = 2;
         position[.nspace] = {-0.1,0.1};
         stroke = 0;
         StrokeTextAttribs {
           font_type = 0;
           style = 0;
           plane = 0;
           orient = 0;
           space_mode = 1;
           spacing = 0.0;
           height = 0.7;
           expansion = 0.7;
         };
      };
      MAdefaultObject DefaultObject {
         input => <-.strZero;
         name => "NOOBJLIST Zeroobj";
         pickable = 0;
         props => <-.props;
      };
   };
   MAGDxform_edit get_scale {
      xform => <-.viewer_params.top_xform;
      absolute = 1;
      shell_vis = 1;
   };
   float unit_val => 1.0 / get_scale.scale;
   string str_val[] => str_array(str_format("%.1E", unit_val), "E");
   macro strMaxObj {
       ilink props => <-.TextProps;
       Text_NoXform strMax {
         str => <-.<-.str_val[0];
         nspace = 2;
         position[.nspace] = {0.7,0.1};
         stroke = 0;
         StrokeTextAttribs {
           font_type = 0;
           style = 0;
           plane = 0;
           orient = 0;
           space_mode = 1;
           spacing = 0.0;
           height = 0.7;
           expansion = 0.7;
         };
      };
      MAdefaultObject DefaultObject {
         input => <-.strMax;
         name => "NOOBJLIST Maxobj";
         pickable = 0;
         props => <-.props;
      };
   };
   macro strEObj {
       ilink props => <-.TextProps;
       Text_NoXform strE {
         str => "E" + <-.<-.str_val[1];
         nspace = 2;
         position[.nspace] = {0.0,-0.5};
         stroke = 0;
         StrokeTextAttribs {
           font_type = 0;
           style = 0;
           plane = 0;
           orient = 0;
           space_mode = 1;
           spacing = 0.0;
           height = 0.4;
           expansion = 0.8;
         };
      };
      MAdefaultObject DefaultObject {
         input => <-.strE;
         name => "NOOBJLIST Eobj";
         pickable = 0;
         props => <-.props;
      }; 
   };
   MAgroupObject GroupObject {
      child_objs => { <-.Obj.obj,
                      <-.strZeroObj.DefaultObject,
                      <-.strEObj.DefaultObject,
                      <-.strMaxObj.DefaultObject};
      Props.col[3] => {<-.<-.Params.unitvector_editor_params.red, 
                       <-.<-.Params.unitvector_editor_params.green,
                       <-.<-.Params.unitvector_editor_params.blue };
      Top.name => "NOOBJLIST Group UnitVector";
      Top.pickable = 0;
   };
   UI {
        parent.width = 245;
        parent.height => <-.height + 65;
        mod_panel.visible = ;
        EditorCommonUI.panel.width => parent.clientWidth;
        MAunitvectorEditorUI UnitVectorEditorUI {
           parent => <-.parent;
           unitvector_editor_params => <-.<-.Params.unitvector_editor_params;
           params => <-.params;
           y => EditorCommonUI.y + EditorCommonUI.height;
        };
        height => EditorCommonUI.height + UnitVectorEditorUI.height;
        GMOD.copy_on_change set_UI_vis {
           input => switch(<-.visible, 1); 
           output => <-.mod_panel.visible;
           on_inst = 1;
        };
    };
};
