/*
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/unix.v#1 $
*/
//
// This is UI, but GD Kit used!!!
//
// fontDialog for Unix, but it is internal used
//
// NOTES:
// Why UIlabel does NOT support font (font list like X Window System)subobject?
// Because TextString object it needs font (font list like X Window System).
// then we must use View.
//
// Take Care:
//	MAcolorEditorUI and MAlabelObject in MAGD library.
//
MAUIfontDialog MAGDfontDialogUnix<NEvisible=1> {

   macro+nosave _fontDialog {
      boolean visible => <-.visible;
      string &font_list[] => <-.font_list;
      string font = "fixed";
      float red = 1.0;
      float green = 1.0;
      float blue = 1.0;

      MAUIokCancelDialog FontDialog {
         visible => <-.visible;
         width = 550;
         height = 450;
      };
   
      MAUIlabel selectFontLabel {
         parent  => <-.FontDialog;
         x = 0;
         y = 0;
         label = "MAVLAB_FONT";
         width = 100;
      };
      
      MAUIlist fontList {
         parent  => <-.FontDialog;
         strings => <-.font_list;
         x = 0;
         y => <-.selectFontLabel.y + <-.selectFontLabel.height;
         height+nres => (7 * UIdata.UIfonts[0].lineHeight );
         width = 550;
         selectedItem = 0;
         selectedText => <-.font;
      };
      MAUIlabel currentFontLabel {
         parent  => <-.FontDialog;
         x = 0;
         y => <-.fontList.y + <-.fontList.height + 10;
         width => <-.fontList.width;
         label => <-.fontList.selectedText;
      };
      
      MAcolorEditorUI colorEditor {
         parent  => <-.FontDialog;
         x = 20;
         y => <-.currentFontLabel.y + <-.currentFontLabel.height + 5;
         //index = 47;
         red => <-.red;
         green => <-.green;
         blue => <-.blue;
      };
      
      UIrenderView sampleRenderView {
         parent  => <-.FontDialog;
         x = 275;
         y => <-.currentFontLabel.y + <-.currentFontLabel.height + 60;
         width = 250;
         height = 160;
         color.backgroundColor = "black";
      };
      
      MAlabelObject sampleLabelObj {
         label = "MAVLAB_SAMPLE";
         font_list => <-.fontList.selectedText;
         front = 0; // for 2D
         state = 1; // visible
         x_pos = -0.5;
         red => <-.colorEditor.red;
         green => <-.colorEditor.green;
         blue => <-.colorEditor.blue;
      };
      DefaultXform CameraXform { xlate = { 0, 0, -12}; };
      DefaultCamera2D Camera2D {
         objects => { <-.sampleLabelObj.obj };
         xform => <-.CameraXform;
      };
      BestVirtPal VirtPal;
      
      DefaultView sampleView {
         virtpal => <-.VirtPal;
         renderer = 0;
         handle => <-.sampleRenderView.handle;
         cameras => { <-.Camera2D };
      };
   
      boolean ok      => FontDialog.ok;
      boolean cancel  => FontDialog.cancel;

      GMOD.parse_v copy_values {
         on_inst = 0;
         //trigger => .active;
         active => <-.visible;
         relative => <-.<-;
         v_commands => "$push\n"
                      +"red=<-.red;"
                      +"green=<-.green;"
                      +"blue=<-.blue;"
                      +"font=<-.font;"
                      +"$pop\n";
      };
      GMOD.parse_v set_values {
         on_inst = 0;
         trigger => <-.ok;
         relative => <-.<-.<-;
         v_commands => "$push -usr\n"
                      +"red=_fontDialog.red;"
                      +"green=_fontDialog.green;"
                      +"blue=_fontDialog.blue;"
                      +"font=_fontDialog.font;"
                      +"$pop\n";
      };
   };
};
