/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/view.v#1 $
*/
//
// View Editor
//
MAparams MAview_editor_params {
   //int     renderer = 1;	// OpenGL Renderer
   int     renderer<val_state=4> = Templates.CONFIG.gd_default_renderer+0;
   boolean timer    = 0;
   float+nosave fps =;
   boolean+nosave refresh;
   init_commands    = "";
   reset_commands   =
       "view_editor_params.renderer=Templates.CONFIG.gd_default_renderer;"
      +"view_editor_params.timer=0;"
      +"viewer_params.stereo_on=0;"
      +"viewer_params.stereo_balance=1;"
      +"viewer_params.stereo_offset=1;";
};

MAmacroUI MAviewEditorUI {
   MAviewer_common_params &viewer_params;
   MAview_editor_params &view_editor_params;

   height => view_editor_panel.height;
   MAUIframe view_editor_panel {
      parent => <-.parent;
      y => <-.y;
#ifdef MSDOS
      height => 240 + 60 * <-.viewer_params.viewer3d;
#else
      height => 240 + 160 * <-.viewer_params.viewer3d;
#endif //MSDOS
   };
   MAUIframe renderer_frame {
      parent => <-.view_editor_panel;
      x = 5;
      y = 10;
      width = 220;
#ifdef MSDOS
      height => 60 * <-.viewer_params.viewer3d;
#else
      height => 160 * <-.viewer_params.viewer3d;
      visible => <-.viewer_params.viewer3d;
#endif //MSDOS
   };
   MAUIlabel software_renderer_only_label {
      parent => <-.renderer_frame;
      visible => Templates.CONFIG.gd_gl_disabled;
      x = 5;
      y = 8;
      height = 100;
      alignment = "left";
      color.foregroundColor = MAVS_BLUE;
      label => "MAVVIEW_SW_ONLY";
   };
   MAUIlabel renderer_label {
      parent => <-.renderer_frame;
      string labels[] => { "MAVVIEW_RENDERERS",
#ifdef MSDOS
                           "MAVVIEW_VOLUME_RENDERING"
#else
                           "MAVVIEW_VOLREN_MSG1" + "\n"
                          +"MAVVIEW_VOLREN_MSG2" + "\n"
                          +"MAVVIEW_VOLREN_MSG3" + "\n"
#endif //MSDOS
                          };
      label => labels[viewer_params.volume_rendering];
      x = 5;
      y = 8;
      string alis[] => { "center", "left" };
      alignment => alis[viewer_params.volume_rendering];
      string colors[] = { "black", MAVS_BLUE };
      color.foregroundColor => colors[viewer_params.volume_rendering];
      width => renderer_frame.clientWidth - 5;
      int heights[] => { 24, 100 };
      height => heights[viewer_params.volume_rendering];
   };
#ifdef MSDOS
   MAUIOptionMenuLabel renderer_rb {
      visible => (viewer_params.volume_rendering == 0)
                * Templates.CONFIG.gd_gl_active;
      parent => <-.renderer_frame;
      // on PC, UIoptionMenu can NOT understand UIoption's active
      options => { "MAVVIEW_COMMON", "MAVVIEW_OPENGL" };
      x = 10;
      y => <-.renderer_label.y + <-.renderer_label.height + 1;
      width = 200;
      selectedItem => <-.view_editor_params.renderer;
      optionLabel = 0;
   };
#else
   UIoption SW_renderer  { active => 1;
      label = "MAVVIEW_COMMON"; set = 1; };
   UIoption OGL_renderer { active => Templates.CONFIG.gd_gl_active;
      label = "MAVVIEW_OPENGL"; };
   UIoption XGL_renderer { active => Templates.CONFIG.gd_xgl_active;
      label = "MAVVIEW_XGL"; };
   UIoption PEX_renderer { active => Templates.CONFIG.gd_pex_active;
      label = "MAVVIEW_PEX"; };
   UIoption XIL_renderer { active => Templates.CONFIG.gd_xil_active
                                   * !<-.viewer_params.viewer3d; // 2D only
      label = "MAVVIEW_XIL"; };
   MAUIradioBox renderer_rb {
      visible => (viewer_params.volume_rendering == 0);
      parent => <-.renderer_frame;
      x = 10;
      y = 35;
      width = 200;
      cmdList => {<-.SW_renderer,
                  <-.OGL_renderer,
                  <-.XGL_renderer,
                  <-.PEX_renderer,
                  <-.XIL_renderer};
      selectedItem => <-.view_editor_params.renderer;
   };
#endif //MSDOS

   MAUIframe size_frame {
      parent => <-.view_editor_panel;
      x = 5;
      y => renderer_frame.y + renderer_frame.height + 5;
      width => renderer_frame.width;
      height = 80;
   };
   MAUIlabel width_label {
      parent => <-.size_frame;
      x = 0;
      y = 15;
      width = 100;
      label = "MAUI_WIDTH";
   };
   MAUIfield width_size {
      parent => <-.size_frame;
      x = 100;
      y = 10;
      width = 100;
      mode = "integer";
      min = 1;
      max   => viewer_params.full_render_width;
      value => viewer_params.render_width;
   };
   width_label height_label {
      y = 45;
      label = "MAUI_HEIGHT";
   };
   width_size height_size {
      y = 40;
      max   => viewer_params.full_render_height;
      value => viewer_params.render_height;
   };
   MAUIframe timer_frame {
      parent => <-.view_editor_panel;
      x = 5;
      y => size_frame.y + size_frame.height + 5;
      width => size_frame.width;
      height = 100;
   };
   MAUItoggle timer_toggle {
      parent => <-.timer_frame;
      label = "MAVVIEW_TIMER";
      x = 10;
      y = 10;
      width = 100;
      height = 20;
      set => <-.view_editor_params.timer;
   };
   MAUItext fps_label { // Modifed
      parent => <-.timer_frame;
      visible => <-.timer_toggle.set;
      x = 8;
      y => <-.timer_toggle.y + <-.timer_toggle.height + 5;
      width = 200;
      height = 45;
      outputOnly = 1;
      updateMode = 0;
      multiLine = 1;
      text => switch(is_valid(<-.view_editor_params.fps) + 1,
                     " ",
                     " "
                   + "MAVVIEW_TIMER_MSG1"
                   + str_format(" %.2f ", <-.view_editor_params.fps)
                   + "MAVVIEW_TIMER_MSG2"
               );
      color.foregroundColor = MAVS_BLUE;
      //color.backgroundColor = "black";
   };
/* version 5.1 ADD_START --------------------------------------*/

   MAUIframe stereo_frame {
      parent => <-.view_editor_panel;
      x = 5;
      y => <-.timer_frame.y + <-.timer_frame.height + 5;
      width => timer_frame.width;
#ifdef MSDOS
      height => 140;
#else
      height => 220;
#endif
   };
   MAUIlabel stereo_label {
      parent => <-.stereo_frame;
      label ="MAVVIEW_STEREO";
      x = 5;
      y = 8;
      height = 20;
      alignment = "center";
   };
   MAUItoggle stereo_toggle {
      parent => <-.stereo_frame;
      label = "MAVVIEW_STEREO_ON";
      x = 10;
      y => stereo_label.y + stereo_label.height + 5;
      width = 100;
      height = 20;
      active => <-.viewer_params.stereo_enable;
      set => <-.viewer_params.stereo_on;
   };
   MAUIslider stereo_barance_slider {
      title = "MAVVIEW_STEREO_BALANCE";
      parent => <-.stereo_frame;
      x => ((<-.stereo_frame.clientWidth - .width) / 2);
      y => <-.stereo_toggle.y + <-.stereo_toggle.height + 5;
      width => <-.stereo_frame.clientWidth - 20;
      active => <-.stereo_toggle.set;
      value => <-.viewer_params.stereo_balance;
      min = -2;
      max =  2;
   };
   MAUIslider stereo_separation_offset_slider {
      title = "MAVVIEW_STEREO_OFFSET";
      parent => <-.stereo_frame;
      x => <-.stereo_barance_slider.x;
      y => <-.stereo_barance_slider.y + <-.stereo_barance_slider.height + 5;
      width => <-.stereo_barance_slider.width;
      active => <-.stereo_toggle.set;
      value => <-.viewer_params.stereo_offset;
      min = -2;
      max =  4;
   };
   MAUIbutton refresh_b {
      parent => <-.view_editor_panel;
      label = "MAVVIEW_REFRESH";
      x = 5;
      y => <-.stereo_frame.y + <-.stereo_frame.height + 10;
      width => renderer_frame.width;
      height = 25;
      do => <-.view_editor_params.refresh;
   };
   MAUIbutton+nosave updata_b {
      do = 0;
      parent => <-.view_editor_panel;
      label => "MAVVIEW_MATRIX_UPDATE";
      x => (((<-.view_editor_panel.clientWidth / 2) - .width) / 2);
      y => refresh_b.y + refresh_b.height + 5;
      width => <-.view_editor_panel.clientWidth/2 - 10;
      height = 25;
   };
   MAUIbutton+nosave default_b{
      do = 0;
      parent => <-.view_editor_panel;
      label => "MAVVIEW_MATRIX_PANEL";
      x => ((((<-.view_editor_panel.clientWidth / 2) - .width) / 2)
         + (<-.view_editor_panel.clientWidth / 2));
      y => <-.updata_b.y;
      width => <-.view_editor_panel.clientWidth/2 - 10;
      height => <-.update;
   };

   GMOD.parse_v set_view_editor_panel_size {
      on_inst    = 0;
      trigger+nres    => <-.parent.visible;
      active     = 1;
      relative   => <-.view_editor_panel;
      v_commands => "height => "
                  + "( <-.renderer_frame.height"           /* `惂[hĨt[ */
                  + "+ <-.size_frame.height"               /* ̂̕\̑傫̃t[ */
                  + "+ <-.timer_frame.height"              /* ̃t[ */
                  + "+ <-.stereo_frame.height"             /* XeI\̃t[ */
                  + "+ <-.refresh_b.height"                /* tbV{^ */
                  + "+ <-.updata_b.height"                 /* ݒXV^ݒpl̃{^ */
                  + "+ 50)* <-.viewer_params.viewer3d;\n";
   };

/*---------------------------------------  version 5.1 ADD_END */
};

MAeditor MAviewEditor {
   title = "MAVVIEW_TITLE";
   MAGDview_templ &view_in<NEportLevels={2,1}>;

   Params {
      MAGDview_templ &view_in<NEportLevels={2,1}> => <-.view_in;
      MAview_editor_params view_editor_params;
      params.name = "view";
      params.help_name => switch(viewer_params.viewer3d+1, "imwin","gewin");
      init_params.init_commands => view_editor_params.init_commands;
      reset_params.reset_commands =>
                "viewer_params.render_width=300;"
              + "viewer_params.render_height=300;"	// Not good here?
              + "view_in.fps=;"				// Not good here?
              + view_editor_params.reset_commands
              ;
      view_editor_params.fps => view_in.fps;
   };
   MAGDview_edit+nosave ViewEditor {
      view      => <-.view_in;
      shell_vis => <-.Params.viewer_params.view_vis;
      renderer  => <-.Params.view_editor_params.renderer;
      timer     => <-.Params.view_editor_params.timer;
      refresh   => <-.Params.view_editor_params.refresh;
   };
   UI {
      visible => <-.viewer_params.view_vis;
      mod_panel {
         x = 15;
         y = 66;
      };
      MAviewEditorUI ViewEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         view_editor_params => <-.<-.Params.view_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
         view_editor_panel {
            height = 380;
         };
         timer_frame+nosave timer_frame {
            height = 110;
         };
      };
      height => EditorCommonUI.height + ViewEditorUI.height + 5;
   };
};

/*  for MicroAVS5.0 cut_plane  */
MAeditor MAcutEditor {
   title = "MAV3CUT_TITILE";
   ilink obj_in;
   MAcut_plane_params &cut_plane_params;
   Params {
      params.name = "view";
      params.help_name = "cutview";
   };
   UI {
      visible => <-.viewer_params.cut_vis;
      mod_panel {
         x = 15;
         y = 66;
      };
      MAmacroUI MAcut_panelUI{
         ilink viewer_params => <-.viewer_params;
         int+nosave y        => <-.EditorCommonUI.y + <-.EditorCommonUI.height + 5;
         height              => .cut_editor_panel.height;
         parent              => <-.parent;
         MAUIframe cut_editor_panel {
            parent => <-.parent;
            y      => <-.y;
            height => <-.set_plane.y + <-.set_plane.height + 5;
         };
         MAUItoggle cut_button{
            parent => <-.cut_editor_panel;
            label = "MAV3CUT_ON";
            x = 10;
            y = 5;
            width = 100;
            active => <-.<-.visible;
            set => <-.<-.<-.cut_plane_params.cut_on;
         };
         MAUItoggle above_button{
            parent => <-.cut_editor_panel;
            label = "MAV3CUT_ABOVE";
            x = 10;
            y => <-.cut_button.y + <-.cut_button.height;
            width => <-.cut_editor_panel.clientWidth;
            active => <-.cut_button.set;
            set => <-.<-.<-.cut_plane_params.above;
         };


         label_cmd label_cmd {
            labels = {"MAV3CUT_PLANE1", "MAV3CUT_PLANE2"};
            cmd[];
         };
         UIoptionMenu+nosave set_plane {
            parent       => <-.cut_editor_panel;
            x            => ((parent.clientWidth - width) / 2);
            y            => ((<-.above_button.y + <-.above_button.height) + 10);
            cmdList      => <-.label_cmd.cmd;
            selectedItem => <-.viewer_params.cut_plane_item;
            active => <-.cut_button.set;
            label  => "MAV3CUT_SET_PLANE";
         };

      };


      MAnew_slice_planeUI new_slice_planeUI1{
         ilink viewer_params    => <-.viewer_params;
         y                      => <-.MAcut_panelUI.y + <-.MAcut_panelUI.height + 5;
         parent                 => <-.parent;
         new_slice_plane_params => <-.<-.cut_plane_params.new_slice_plane_params1;
         new_slice_plane_panel{
            visible => (<-.viewer_params.cut_plane_item == 0)
                       * <-.<-.MAcut_panelUI.cut_button.set;
         };
         MAUIlabel+nosave plane_label {
            parent => <-.new_slice_plane_panel;
            label  => <-.<-.MAcut_panelUI.label_cmd.labels[<-.<-.MAcut_panelUI.set_plane.selectedItem]
                     + " " +"MAV3CUT_SETTING";
            x      => (.parent.clientWidth - .width)/2;
            y      = 10;
            width  = 150;
         };
         common{
            frame{
               y => ((<-.<-.plane_label.y + <-.<-.plane_label.height) + 4);
            };
         };
      };
      new_slice_planeUI1 new_slice_planeUI2{
         new_slice_plane_params => <-.<-.cut_plane_params.new_slice_plane_params2;
         new_slice_plane_panel{
            visible => (<-.viewer_params.cut_plane_item == 1)
                       * <-.<-.MAcut_panelUI.cut_button.set;
         };
      };
      height => EditorCommonUI.height 
              + MAcut_panelUI.height
              + new_slice_planeUI1.height * (new_slice_planeUI1.new_slice_plane_panel.visible == 1)
              + new_slice_planeUI2.height * (new_slice_planeUI2.new_slice_plane_panel.visible == 1)
              + 15;
   };
};

/*  for MicroAVS7.0 Scalar2Texture  */
MAeditor MAs2tEditor {
   title = "MAV3S2T_TITLE";
   ilink obj_in;
   ilink viewer_params;
   Params {
      params.name = "view";
      params.help_name = "s2t";
      reset_params.reset_commands =>
              s2t_params.reset_commands
              ;
      MAs2t_params+nres &s2t_params => <-.viewer_params.s2t_params;
//      MAs2t_params s2t_params{
//         s2t_on       => <-.env_params.scalar2texture.s2t_on;
//         texture_size => <-.env_params.scalar2texture.texture_size;
//      };
   };

/*  for MicroAVS 7.0 lݒ 2003.07.28*/
#ifdef MICROAVS_DEV_KIT
   /* CX^XɏlZbg */
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  + switch( (is_valid(Params.env_params.scalar2texture.s2t_on) + 1)
                            ,"\n"
                            ,"Params.s2t_params.s2t_on = MicroAVScontroller.Params.env_params.scalar2texture.s2t_on;\n")
                  + switch( (is_valid(Params.env_params.scalar2texture.texture_size) + 1)
                            ,"\n"
                            ,"Params.s2t_params.texture_size = MicroAVScontroller.Params.env_params.scalar2texture.texture_size;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative+nres => <-;
     on_inst    = 1;
   };
   /* <ݒ̍XV>sɏlWXgɓo^ */
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"Params.env_params.scalar2texture.s2t_on       = MicroAVS.MAviewer.viewer_params.s2t_params.s2t_on;\n"
                     +"Params.env_params.scalar2texture.texture_size = MicroAVS.MAviewer.viewer_params.s2t_params.texture_size;\n"
                     +"$pop\n"
                     +"$push\n"
                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };

#else
   GMOD.parse_v set_init_params;
   GMOD.parse_v get_init_params;
#endif // end of MICROAVS_DEV_KIT
/*  End  MicroAVS 7.0 lݒ 2003.07.28*/
   UI {
      ilink s2t_params => <-.Params.s2t_params;
      visible => viewer_params.s2t_vis;
      height => EditorCommonUI.height + MAs2t_panelUI.height;
      mod_panel {
         x = 15;
         y = 66;
      };
      MAmacroUI MAs2t_panelUI{
         ilink s2t_params => <-.s2t_params;
         int+nosave y        => <-.EditorCommonUI.y + <-.EditorCommonUI.height + 5;
         height              => .s2t_editor_panel.height;
         parent              => <-.parent;
         MAUIframe s2t_editor_panel {
            parent => <-.parent;
            y      => <-.y;
            height => <-.texture_size_field.y + <-.texture_size_field.height + 10;
         };
         MAUIradioBoxLabel s2t_change_button {
            labels => { "MAV3S2T_SHADING", "MAV3S2T_TEXTURE"};
            title  = "MAV3S2T_CONT";
            parent => <-.s2t_editor_panel;
            x      = 5;
            y      = 5;
            selectedItem => <-.s2t_params.s2t_on;
         };
         MicroAVS.MAUIFieldLabel+nosave texture_size_field {
            parent => <-.s2t_editor_panel;
            y      => <-.s2t_change_button.y + <-.s2t_change_button.height;
            width  = 200;
            mode   = 1;
            active => <-.s2t_change_button.selectedItem == 1;
            value  => <-.s2t_params.texture_size;
            label  = "MAV3S2T_TEXTURE_SIZE";
            UIlabel.width => <-.width /1.5;
            UIfield.x     => <-.UIlabel.x + <-.UIlabel.width + 8;
         };
      };
   };
};

