/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/xform.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/xform.v#1 $
*/
//
// Transform Editor
//
MAparams MAtransform_editor_params {
   boolean+nosave reset;
   boolean normalize   =;
   boolean center      =;
   boolean absolute    = 0;
   double  x_rot       = 0.0;
   double  y_rot       = 0.0;
   double  z_rot       = 0.0;
   double  scale       = 1.0;
   double  x_trans     = 0.0;
   double  y_trans     = 0.0;
   double  z_trans     = 0.0;
   double  x_cent      = 0.0;
   double  y_cent      = 0.0;
   double  z_cent      = 0.0;
   double  rotate_val  = 45.0;
   double  zoom_val    = 1.1;
   double  move_val    = 0.5;
   double  cent_val    = 0.5;
   int     rd_ok       =;
   int     wt_ok       =;
   string  rd_filename =;
   string  wt_filename =;
   init_commands = "";
   reset_commands =
       "transform_editor_params.reset=1;"
      //+"transform_editor_params.normalize=1;"
      +"transform_editor_params.center=1;"
      +"transform_editor_params.absolute=0;"
      +"transform_editor_params.x_rot=0;"
      +"transform_editor_params.y_rot=0;"
      +"transform_editor_params.z_rot=0;"
      +"transform_editor_params.scale=0;"
      +"transform_editor_params.x_trans=0;"
      +"transform_editor_params.y_trans=0;"
      +"transform_editor_params.z_trans=0;"
      +"transform_editor_params.x_cent=0;"
      +"transform_editor_params.y_cent=0;"
      +"transform_editor_params.z_cent=0;"
      +"transform_editor_params.rotate_val=45.0;"
      +"transform_editor_params.move_val=0.5;"
      +"transform_editor_params.cent_val=0.5;"
      +"transform_editor_params.zoom_val=1.1;"
      +"transform_editor_params.rd_filename=;"
      +"transform_editor_params.wt_filename=;"
      ;
};

MAmacroUI MAtransformEditorUI {
   MAviewer_common_params &viewer_params;
   MAtransform_editor_params &transform_editor_params;

   height => transform_editor_panel.height;
   MAUIframe transform_editor_panel {
      parent => <-.parent;
      y => <-.y;
      width = 453;
      height => switch(<-.viewer_params.viewer3d+1, 240, 320);
   };
   MAUIbutton Normalize {
      parent => <-.transform_editor_panel;
      label = "MAVXFORM_NORM";
      &do => <-.transform_editor_params.normalize;
      x = 10;
      y = 10;
      width = 100;
      height = 24;
   };
   Normalize Center {
      label = "MAVXFORM_CENTER";
      &do => <-.transform_editor_params.center;
      x => <-.Normalize.x + <-.Normalize.width + 5;
   };

   MAUIOptionMenuLabel RelAbs {
      parent => <-.transform_editor_panel;
      options => { "MAVXFORM_REL", "MAVXFORM_ABS" };
      x = 230;
      y = 10;
      width = 220;
      height = 30;
      &selectedItem => <-.transform_editor_params.absolute;
      optionLabel = 0;
      label = "";
   };

   GMOD.instancer AbsoluteUIinstancer {
      Group => <-.AbsoluteUI;
      Value => <-.transform_editor_params.absolute;
   };
   macro AbsoluteUI<instanced=0> {
      ilink parent => <-.transform_editor_panel;
      ilink transform_editor_params => <-.transform_editor_params;
      ilink viewer_params => <-.viewer_params;
      MAUIframe Frame {
         parent => <-.parent;
         x = 5;
         y = 50;
         width = 440;
         height => switch(<-.viewer_params.viewer3d+1, 185, 265);
      };
      MAUIfield2 MoveValueX {
         parent => <-.Frame;
         x = 90;
         y = 10;
         allwidth = 120;
         min = -1000000.0;
         max =  1000000.0;
         value => <-.transform_editor_params.x_trans;
         decimalPoints = 6;
         title => "X " + "MAUI_TRANS";
         MAUIlabel+nonotify Label {
            parent => <-.parent;
            x => <-.x - (.width + 5);
            y => <-.y + 5;
            width = 85;
            label => <-.title;
            alignment = "right";
            visible => <-.visible;
         };
      };
      MoveValueX MoveValueY {
         y => MoveValueX.y + 35;
         value => <-.transform_editor_params.y_trans;
         title => "Y " + "MAUI_TRANS";
      };
      MoveValueX CentValueX {
         x => MoveValueX.x + MoveValueX.width + 110;
         value => <-.transform_editor_params.x_cent;
         title => "MAUI_CENT" + " X";
      };
      CentValueX CentValueY {
         y => CentValueX.y + 35;
         value => <-.transform_editor_params.y_cent;
         title => "MAUI_CENT" + " Y";
      };
      CentValueY CentValueZ {
         visible => viewer_params.viewer3d;
         y => CentValueY.y + 35;
         value => <-.transform_editor_params.z_cent;
         title => "MAUI_CENT" + " Z";
      };
      MoveValueX ZoomValue {
         y => MoveValueY.y + 35 + viewer_params.viewer3d * 35;
         min = 0.000001;
         max = 1000000.0;
         value => <-.transform_editor_params.scale;
         title = "MAUI_ZOOM";
      };
      MoveValueX RotateValueZ {
         y => ZoomValue.y + 35 + viewer_params.viewer3d * 35 * 2;
         min = -180.0;
         max =  180.0;
         value => <-.transform_editor_params.z_rot;
         title => "Z " + "MAUI_ROTA";
      };
      MoveValueX MoveValueZ {
         y => MoveValueY.y + 35;
         value => <-.transform_editor_params.z_trans;
         visible => viewer_params.viewer3d;
         title => "Z " + "MAUI_TRANS";
      };
      RotateValueZ RotateValueX {
         y => ZoomValue.y + 35;
         value => <-.transform_editor_params.x_rot;
         visible => viewer_params.viewer3d;
         title => "X " + "MAUI_ROTA";
      };
      RotateValueX RotateValueY {
         y => RotateValueX.y + 35;
         value => <-.transform_editor_params.y_rot;
         title => "Y " + "MAUI_ROTA";
      };
   };
   GMOD.instancer RelativeUIinstancer {
      Group => <-.RelativeUI;
      Value => !<-.transform_editor_params.absolute;
   };
   macro RelativeUI<instanced=0> {
      ilink parent => <-.transform_editor_panel;
      ilink transform_editor_params => <-.transform_editor_params;
      ilink viewer_params => <-.viewer_params;
      olink height => ZoomUI.height + MoveUI.height + Rotate3DUI.height;
      macro MoveUI {
         ilink parent => <-.parent;
         ilink transform_editor_params => <-.transform_editor_params;
         ilink viewer_params => <-.viewer_params;
         int x =  5;
         int y = 50;
         olink height => MoveFrame.height;
         MAUIframe MoveFrame {
            parent => <-.parent;
            x => <-.x;
            y => <-.y;
            width = 220;
            height = 130;
         };
         MAUIbutton Xminus {
            parent => <-.MoveFrame;
            x = 30;
            y = 45;
            width = 48;
            height = 40;
            label => "-X " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "galeft.x";
            labelPixmap.fileType = "avs_image";
            toolTip.enable = "always";
         };
         Xminus Yplus {
            x = 80; y = 5;
            label => "+Y " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "gaup.x";
         };
         Xminus Xplus {
            x = 130;
            label => "+X " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "garight.x";
         };
         Xminus Yminus {
            x = 80; y = 85;
            label => "-Y " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "gadown.x";
         };
         Xminus Zminus {
            x = 80; height = 20;
            label => "-Z " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "gaback.x";
            visible => <-.viewer_params.viewer3d;
         };
         Zminus Zplus {
            y = 65;
            label => "+Z " + "MAUI_TRANS";
            labelPixmap.filename = MAVS_ICON_PATH + "gafront.x";
            visible => <-.viewer_params.viewer3d;
         };
         MAUIlabel MoveLabel {
            parent => <-.MoveFrame;
            x = 0;
            y = 20;
            width = 65;
            height = 25;
            label = "MAUI_TRANSLATE";
         };
         MAUIfield2 MoveValue {
            parent => <-.MoveFrame;
            x = 155;
            y = 10;
            allwidth = 55;
            min = 0.0;
            max = ;
            decimalPoints = 2;
            value => <-.transform_editor_params.move_val;
         };
         GMOD.parse_v IncrX {
            trigger => <-.Xplus.do;
            v_commands = "x_trans = move_val;\n";
            relative => <-.transform_editor_params;
            on_inst = 0;
         };
         IncrX DecrX {
            trigger => <-.Xminus.do;
            v_commands = "x_trans = -move_val;\n";
         };
         IncrX IncrY {
            trigger => <-.Yplus.do;
            v_commands = "y_trans = move_val;\n";
         };
         IncrY DecrY {
            trigger => <-.Yminus.do;
            v_commands = "y_trans = -move_val;\n";
         };
         IncrX IncrZ {
            trigger => <-.Zplus.do;
            v_commands = "z_trans = move_val;\n";
         };
         IncrZ DecrZ {
            trigger => <-.Zminus.do;
            v_commands = "z_trans = -move_val;\n";
         };
      };
      macro ZoomUI {
         ilink parent => <-.parent;
         ilink transform_editor_params => <-.transform_editor_params;
         ilink viewer_params => <-.viewer_params;
         olink height => ZoomFrame.height;
         MAUIframe ZoomFrame {
            parent => <-.parent;
            x = 5;
            y = 180;
            width = 220;
            height = 53;
         };
         MAUIbutton ZoomOut {
            parent => <-.ZoomFrame;
            x = 55;
            y = 5;
            width = 48;
            height = 40;
            label = "MAUI_ZOOMOUT";
            labelPixmap.filename = MAVS_ICON_PATH + "gsmall.x";
            labelPixmap.fileType = "avs_image";
            toolTip.enable = "always";
         };
         GMOD.parse_v Incr {
            trigger => <-.ZoomIn.do;
            v_commands = "scale = zoom_val;\n";
            relative => <-.transform_editor_params;
            on_inst = 0;
         };
         Incr Decr {
            trigger => <-.ZoomOut.do;
            v_commands = "scale = 1.0 / zoom_val;\n";
         };
         ZoomOut ZoomIn {
            x = 105;
            label = "MAUI_ZOOMIN";
            labelPixmap.filename = MAVS_ICON_PATH + "gbig.x";
         };
         MAUIlabel ZoomLabel {
            parent => <-.ZoomFrame;
            x = 0;
            y = 20;
            width = 50;
            height = 25;
            label = "MAUI_ZOOM";
         };
         MAUIfield2 ZoomValue {
            parent => <-.ZoomFrame;
            x = 155;
            y = 10;
            allwidth = 55;
            min = 0.000001;
            max = 100.0;
            value => <-.transform_editor_params.zoom_val;
            decimalPoints = 2;
         };
      };
      MoveUI CenterUI {
         x = 225;
         Xminus.labelPixmap.filename = MAVS_ICON_PATH + "gcleft.x";
         Xplus.labelPixmap.filename  = MAVS_ICON_PATH + "gcright.x";
         Yminus.labelPixmap.filename = MAVS_ICON_PATH + "gcdown.x";
         Yplus.labelPixmap.filename  = MAVS_ICON_PATH + "gcup.x";
         Zminus.labelPixmap.filename = MAVS_ICON_PATH + "gcback.x";
         Zplus.labelPixmap.filename  = MAVS_ICON_PATH + "gcfront.x";
         Xminus.label => "-X " + "MAUI_CENT" + "MAUI_TRANS";
         Xplus.label  => "+X " + "MAUI_CENT" + "MAUI_TRANS";
         Yminus.label => "-Y " + "MAUI_CENT" + "MAUI_TRANS";
         Yplus.label  => "+Y " + "MAUI_CENT" + "MAUI_TRANS";
         Zminus.label => "-Z " + "MAUI_CENT" + "MAUI_TRANS";
         Zplus.label  => "+Z " + "MAUI_CENT" + "MAUI_TRANS";
         MoveLabel.label = "MAUI_CENT";
         IncrX.v_commands = "x_cent= cent_val;\n";
         DecrX.v_commands = "x_cent=-cent_val;\n";
         IncrY.v_commands = "y_cent= cent_val;\n";
         DecrY.v_commands = "y_cent=-cent_val;\n";
         IncrZ.v_commands = "z_cent= cent_val;\n";
         DecrZ.v_commands = "z_cent=-cent_val;\n";
      };
      GMOD.instancer Rotate2DUIinstancer {
         Group => <-.Rotate2DUI;
         Value => !<-.viewer_params.viewer3d;
      };
      macro Rotate2DUI<instanced=0> {
         ilink parent => <-.parent;
         ilink transform_editor_params => <-.transform_editor_params;
         ilink viewer_params => <-.viewer_params;
         olink height => RotateFrame.height;
         MAUIframe RotateFrame {
            parent => <-.parent;
            x = 225;
            y = 180;
            width = 220;
            height = 53;
         };
         MAUIbutton Zplus {
            parent => <-.RotateFrame;
            x = 55;
            y = 5;
            width = 48;
            height = 40;
            label => "+Z " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "im_rot_2.x";
            labelPixmap.fileType = "avs_image";
            toolTip.enable = "always";
         };
         Zplus Zminus {
            x = 105;
            label => "-Z " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "im_rot_1.x";
         };
         MAUIlabel RotateLabel {
            parent => <-.RotateFrame;
            x = 0;
            y = 20;
            width = 50;
            height = 25;
            label = "MAUI_ROTA";
         };
         MAUIfield2 RotateValue {
            parent => <-.RotateFrame;
            x = 155;
            y = 10;
            allwidth = 55;
            value => <-.transform_editor_params.rotate_val;
            min = 0.0;
            max = 360.0;
            decimalPoints = 2;
         };
         GMOD.parse_v IncrX {
            trigger => <-.Zplus.do;
            v_commands = "z_rot = rotate_val;\n";
            relative => <-.transform_editor_params;
            on_inst = 0;
         };
         IncrX DecrX {
            trigger => <-.Zminus.do;
            v_commands = "z_rot = -rotate_val;\n";
         };
      };
      GMOD.instancer Rotate3DUIinstancer {
         Group => <-.Rotate3DUI;
         Value => <-.viewer_params.viewer3d;
      };
      macro Rotate3DUI<instanced=0> {
         ilink parent => <-.parent;
         ilink transform_editor_params => <-.transform_editor_params;
         ilink viewer_params => <-.viewer_params;
         olink height => RotateFrame.height;
         MAUIframe RotateFrame {
            parent => <-.parent;
            x = 225;
            y = 180;
            width = 220;
            height = 130;
         };
         MAUIbutton Xminus {
            parent => <-.RotateFrame;
            x = 30;
            y = 25;
            width = 48;
            height = 40;
            label => "-X " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "grotx2.x";
            labelPixmap.fileType = "avs_image";
            toolTip.enable = "always";
         };
         Xminus Yminus {
            x = 80; y = 45;
            label => "-Y " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "groty2.x";
         };
         Xminus Zplus {
            x = 55; y = 85;
            label => "+Z " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "grotz2.x";
         };
         Xminus Xplus {
            x = 130;
            label => "+X " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "grotx1.x";
         };
         Xplus Yplus {
            x = 80; y = 5;
            label => "+Y " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "groty1.x";
         };
         Xplus Zminus {
            x = 105; y = 85;
            label => "-Z " + "MAUI_ROTA";
            labelPixmap.filename = MAVS_ICON_PATH + "grotz1.x";
         };
         MAUIlabel RotateLabel {
            parent => <-.RotateFrame;
            x = 0;
            y = 100;
            width = 50;
            height = 25;
            label = "MAUI_ROTA";
         };
         MAUIfield2 RotateValue {
            parent => <-.RotateFrame;
            x = 155;
            y = 90;
            allwidth = 55;
            value => <-.transform_editor_params.rotate_val;
            min = 0.0;
            max = 360.0;
            decimalPoints = 2;
         };
         GMOD.parse_v IncrX {
            trigger => <-.Xplus.do;
            v_commands = "x_rot = rotate_val;\n";
            relative => <-.transform_editor_params;
            on_inst = 0;
         };
         IncrX DecrX {
            trigger => <-.Xminus.do;
            v_commands = "x_rot = -rotate_val;\n";
         };
         IncrX IncrY {
            trigger => <-.Yplus.do;
            v_commands = "y_rot = rotate_val;\n";
         };
         IncrY DecrY {
            trigger => <-.Yminus.do;
            v_commands = "y_rot = -rotate_val;\n";
         };
         IncrX IncrZ {
            trigger => <-.Zplus.do;
            v_commands = "z_rot = rotate_val;\n";
         };
         IncrZ DecrZ {
            trigger => <-.Zminus.do;
            v_commands = "z_rot = -rotate_val;\n";
         };
      };
   };
};

MAeditor MAtransformEditor {
   title = "MAVXFORM_TITLE";
   MAGDcamera_templ+IPort2 &camera_in;
   MAGDobject_templ+IPort2 &obj_in { MAGDxform_templ+OPort2 &xform; };

   Params {
      params.name = "transform";
      params.help_name => switch(viewer_params.viewer3d+1,
                          "imxform","gexform");
      MAtransform_editor_params transform_editor_params;
      init_params.init_commands => transform_editor_params.init_commands;
      reset_params.reset_commands
         => transform_editor_params.reset_commands
           +switch(viewer_params.viewer3d+1,
            "transform_editor_params.normalize=1;"
           +"transform_editor_params.center=1;", ""
            );
   };

   MAGDobj_edit+nosave obj_edit {
      shell_vis  => <-.Params.viewer_params.transform_vis;
      camera     => <-.camera_in;
      object     => <-.obj_in;
      reset      => <-.Params.transform_editor_params.reset;
      normalize  => <-.Params.transform_editor_params.normalize;
      center     => <-.Params.transform_editor_params.center;
   };
//
// GDxform_edit_update bugs!!!; workaround!!!! begin
   DefaultXform+nosave dummy_xform<NEvisible=0>;
   MAGDxform_edit+nosave dummy <NEvisible=0> {
      shell_vis = 1; xform => <-.dummy_xform;
      upd_func-notify_val+notify_inst; // only instanced
   };
// GDxform_edit_update bugs!!!; workaround!!!! end
//
   MAGDxform_edit+nosave xform_editor {
      shell_vis  => <-.Params.viewer_params.transform_vis;
      xform+nres => <-.obj_in.xform;
      absolute   => <-.Params.transform_editor_params.absolute; 
      scale      => <-.Params.transform_editor_params.scale; 
      x_rot      => <-.Params.transform_editor_params.x_rot; 
      y_rot      => <-.Params.transform_editor_params.y_rot; 
      z_rot      => <-.Params.transform_editor_params.z_rot; 
      x_trans    => <-.Params.transform_editor_params.x_trans; 
      y_trans    => <-.Params.transform_editor_params.y_trans; 
      z_trans    => <-.Params.transform_editor_params.z_trans; 
      x_cent     => <-.Params.transform_editor_params.x_cent; 
      y_cent     => <-.Params.transform_editor_params.y_cent; 
      z_cent     => <-.Params.transform_editor_params.z_cent; 
      reset      => <-.Params.transform_editor_params.reset;
   };

   UI {
      visible => <-.viewer_params.transform_vis;
      parent.width = 460; // special
      EditorCommonUI.resetHelpButtons.reset_button.x = 338;
      EditorCommonUI.resetHelpButtons.help_button.x  = 416;
      EditorCommonUI.resetHelpButtons.panel.width    = 453;
      MAtransformEditorUI TransformEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         transform_editor_params => <-.<-.Params.transform_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + TransformEditorUI.height + 5;
   };

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.transform_editor_params.rd_filename = <-.env_params.angle.view_xform;\n"
                  +"Params.transform_editor_params.rd_ok       = 1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     active	=> (strlen(<-.Params.env_params.angle.view_xform) != 0);
     relative   => <-;
     trigger    => switch(.active, is_valid(<-.obj_in));
     on_inst    = 0;
   };
   GMOD.parse_v set_rd_filename {
     v_commands    => "Params.env_params.angle.view_xform = MicroAVS.MAviewer.MAviewerEditors.TransformEditor.Params.transform_editor_params.rd_filename;\n";
     trigger+nres  => Params.transform_editor_params.rd_ok;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "Params.env_params.angle.view_xform = MicroAVS.MAviewer.MAviewerEditors.TransformEditor.Params.transform_editor_params.wt_filename;\n";
     trigger+nres  => Params.transform_editor_params.wt_ok;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "Control.SetenvParams.setenv_params.Go =  1;\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

};
