/*
	"$Id: //depot/express/fcs70/v/MicroAVS/UI/contains.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/UI/contains.v#1 $
*/
//
// MicroAVS Containers
//
UI.UIpanel+nosave MAUIpanel {
   x     = 0;
   y     =; // for Auto
   width = 230;
};
UI.UIframe+nosave MAUIframe {
#ifdef MSDOS
   x               = 0;
#else
   x               = 2;
#endif //MSDOS
   y               =; // for Auto
   width           = 230 + 4; // 4 for frame
   height          = 50;
   shadowType      = "shadow_in";
   shadowThickness = 2;
};
UI.UImod_panel+nosave MAUImod_panel {
   option {
      int width   => <-.width;
      int height  => <-.height;
      string icon => <-.icon;
   };
   string icon;
};
//
// shell+
// supports window styles and system menu controls
//
UI.UIshell MAUIshell {
   UIdecorContainer+IPort2+read *parent;
#ifdef MSDOS
   update+notify_inst = "MAUIshellUpdate"; // override
#else
   omethod+notify_val+notify_inst
      update2 <lang="cxx",interruptable=0>
         (handle.widget+read+req,
          windowExStyle+read+opt,
          windowStyle+read+opt,
          sysMenuMode+read+opt)
      = "MAUIshellUpdate";
   fontAttributes.family = "times";
   fontAttributes.height = 14;
#endif //MSDOS

   int &windowExStyle =;
      // supports:
      // WS_EX_DLGMODALFRAME;

   int &windowStyle =;
      // supports:
      // WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|DS_MODALFRAME|WS_MINIMIZEBOX etc..
      // $include is high cost!!! See %DevStudio%/VC/include/winuser.h

   int &sysMenuMode =;
      // supports:
      // Restore   : 0x001 - Enabled
      // Move      : 0x002 - Enabled
      // Size      : 0x004 - Enabled
      // Minimize  : 0x008 - Enabled
      // Maximize  : 0x010 - Enabled
      // separator1: 0x020 - Enabled
      // Close     : 0x040 - Enabled
      // separator2: 0x080 - Enabled
      // AppSwitch : 0x100 - Enabled

   boolean &dragAcceptFiles = 0;
   string+write+nonotify dropFiles[];
   int dropFiles_update = 0;
};

#define BAR_SIZE	18
//
// MAUIscrolledWindow
//
// UIscrolledWindow critical PROBLEMS for MicroAVS.
// 1) it does NOT show scrollbars, when instanced on PC
// 2) it does NOT correct, when resize and virtual size changed
//
UIgeom+UIdecorGeom+UIvirtualGeom+UIcore+UIconnection+nosave
MAUIscrolledWindow<NEportLevels={0,1}> {
   UIconnection+IPort2 *parent {
      canHaveChildren = 1;
      int+write clientWidth;
      int+write clientHeight;
   };
   visible          = 1;
   x                = 0;
   y                = 0;
   width            = 220;
   height           = 220;
   clientWidth      = 220;
   clientHeight     = 220;
   virtualWidth     = 300;
   virtualHeight    = 300;

   shellParent      = 0;
   canHaveChildren<NEvisible=0> = 1;

   UIevents  events<NEvisible=0>;
   boolean   groupToParent<val_state=4>;
   UIcursorT &cursor<NEvisible=1>;

   int resizeMode   = 0; // no implementation
   int scrollBars   = 1;

   int+read offsetX = 0; // New feature
   int+read offsetY = 0; // New feature// NOTES: nagative value
   int+read v_increment => clientHeight / 10;
   int+read h_increment => clientWidth / 10;

   int deltaH            => virtual_panel.clientHeight - .clientHeight;
   int deltaW            => virtual_panel.clientWidth  - .clientWidth;
   boolean v_On          => deltaH * scrollBars > 0;
   boolean h_On          => deltaW * scrollBars > 0;
   int v_scrollbarSize   => max_array({0, deltaH + BAR_SIZE * h_On});
   int h_scrollbarSize   => max_array({0, deltaW + BAR_SIZE * v_On});
   boolean v_scrollbarOn => v_scrollbarSize * scrollBars > 0;
   boolean h_scrollbarOn => h_scrollbarSize * scrollBars > 0;

   GMOD.copy_on_change set_v_home_pos {
      input   => switch(v_scrollbarOn+1, 0);
      output  => v_scroll_slider.value;
      on_inst = 0;
   };
   set_v_home_pos set_h_home_pos {
      input   => switch(h_scrollbarOn+1, 0);
      output  => h_scroll_slider.value;
   };
#ifndef MSDOS
   // on Unix, slider bugs
   GMOD.copy_on_change set_v_vis {
      trigger => v_scrollbarOn;
      input   => 0;
      output  => v_scroll_slider.showValue;
      on_inst = 0;
      copy_on_change<weight=3>;
   };
   set_v_vis set_h_vis {
      trigger => h_scrollbarOn;
      output  => h_scroll_slider.showValue;
   };
#endif //!MSDOS
   UIslider v_scroll_slider {
      parent                => <-.parent;
      visible               => <-.v_scrollbarOn;
      value                 => <-.offsetY;
      title                 => "";
      x                     => <-.x + <-.clientWidth - .width;
      y                     => <-.y;
      width                 = BAR_SIZE;
      height                => <-.clientHeight;
      min                   =>
                       -1 * (<-.v_scrollbarSize + BAR_SIZE * h_scrollbarOn);
      max                   = 0;
      mode                  = "integer";
#ifdef MSDOS
#else
      showValue             = 0;
#endif //MSDOS
      decimalPoints         = 0;
      immediateMode         = 1;
      horizontal            = 0;
      processingDirection   = "up";
#ifdef OLDER_V4
      color.foregroundColor = "#008800";
      color.backgroundColor = "#008800";
#else
      color.foregroundColor = "#DDDDDD";
      color.backgroundColor = "#DDDDDD";
#endif /*OLDER_V4*/
      increment             => <-.v_increment;
   };
   UIslider h_scroll_slider {
      parent                => <-.parent;
      visible               => <-.h_scrollbarOn;
      value                 => <-.offsetX;
      title                 => "";
      x                     => <-.x;
      y                     => <-.y + <-.clientHeight - .height;
      width                 => <-.clientWidth - BAR_SIZE * v_scrollbarOn;
      height                = BAR_SIZE;
      min                   = 0;
      max                   => <-.h_scrollbarSize + BAR_SIZE * v_scrollbarOn;
      mode                  = "integer";
#ifdef MSDOS
#else
      showValue             = 0;
#endif //MSDOS
      decimalPoints         = 0;
      immediateMode         = 1;
#ifdef OLDER_V4
      color.foregroundColor = "#008800";
      color.backgroundColor = "#008800";
#else
      color.foregroundColor = "#DDDDDD";
      color.backgroundColor = "#DDDDDD";
#endif /*OLDER_V4*/
      increment             => <-.h_increment;
   };
   UIpanel viewport_panel {
      parent                => <-.parent;
      visible               => <-.visible;
      x                     => <-.x;
      y                     => <-.y;
      width                 => <-.width;
      height                => <-.height;
      clientWidth           => <-.clientWidth;
      clientHeight          => <-.clientHeight;
      active                => <-.active;
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
   };
   UIpanel virtual_panel {
      parent                => <-.viewport_panel;
      x                     => -1 * <-.h_scroll_slider.value;
      y                     => <-.v_scroll_slider.value;
      width                 => <-.virtualWidth;
      height                => <-.virtualHeight;
      pixmap.filename       => <-.<-.pixmap.filename;
      pixmap.fileType       => <-.<-.pixmap.fileType;
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
      &cxxhandle            => <-.cxxhandle;
      &handle               => <-.handle;
      &motif_resources      => <-.motif_resources;
      &window_resources     => <-.window_resources;
      &layout               => <-.layout;
      &canHaveChildren      => <-.canHaveChildren;
      &shellParent          => <-.shellParent;
      &events               => <-.events;
      &groupToParent        => <-.groupToParent;
   };
};
#undef BAR_SIZE

UIrenderView+OPort MAUIrenderView {
   width	= 200;
   height	= 200;

   /* promote handle to output port for easy connections to DDview */
   handle+OPort2 <NEvisible=1>;

   boolean+read CopyToClipboard	= 0;
   boolean+read CopyRegion	= 0;

#ifdef MSDOS
   // on Unix, not supported yet
   method+notify_val update<NEvisible=0,interruptable=0,lang="cxx"> = 
					"MAUIrendViewUpdate";
   method+notify_inst inst<NEvisible=0,interruptable=0,lang="cxx"> = 
					"MAUIrendViewInstance";
#endif //MSDOS
};
