/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/arcont3d.v#1 $
*/
MAnetwork UCDArContour3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ARCONTOUR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ARCONTOUR_T";
   MAGDobject_templ-nosave+IPort2 &picked_obj;
   Params {
      params.help_name = "arcont3d";
      params.name = "arcont3d";
      MAextract_scalar_params extract_scalar_params;
      MAnew_slice_plane_params new_slice_plane_params;
      MAcontour_params contour_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + new_slice_plane_params.init_commands
                                 + contour_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + new_slice_plane_params.reset_commands
                                 + contour_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      ilink pick_in =><-.picked_obj;
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAnew_slice_plane MAnew_slice_plane {
         in_pick =><-.pick_in;
         new_slice_plane_params =><-.<-.Params.new_slice_plane_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcontour MAcontour {
         contour_params =><-.<-.Params.contour_params;
         fld_in =><-.MAnew_slice_plane.fld_out;
      };
      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAcontour.fld_out;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out             => MAscalar2texture.fld_out;
      olink legend_out    => .MAcmapLegendSet.legend_out;
      olink texture_out   => .MAscalar2texture.Dmap2Image.out;
      olink pick_obj_out  => .MAnew_slice_plane.out_pick_obj;
      olink slice_obj_out => .MAnew_slice_plane.out_slice_obj;
      olink axis_obj_out  => .MAnew_slice_plane.out_axis_obj;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAnew_slice_planeUI.height
               + MAextract_scalarUI.height
               + MAcontourUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAnew_slice_planeUI MAnew_slice_planeUI {
         fld_in =><-.<-.Modules.MAnew_slice_plane.fld_in;
         parent => <-.parent;
         new_slice_plane_params =><-.<-.Params.new_slice_plane_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAcontourUI MAcontourUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_out;
         parent => <-.parent;
         contour_params =><-.<-.Params.contour_params;
         y =><-.MAnew_slice_planeUI.y + <-.MAnew_slice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAcontourUI.y + <-.MAcontourUI.height;
      };
   };

/*  for MicroAVS 6.0 lݒ */
// 

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.new_slice_plane_params.x_vector.x  = <-.<-.env_params.ar_contour.x_vector.x;\n"
                  +"Params.new_slice_plane_params.x_vector.y  = <-.<-.env_params.ar_contour.x_vector.y;\n"
                  +"Params.new_slice_plane_params.x_vector.z  = <-.<-.env_params.ar_contour.x_vector.z;\n"
                  +"Params.new_slice_plane_params.y_vector.x  = <-.<-.env_params.ar_contour.y_vector.x;\n"
                  +"Params.new_slice_plane_params.y_vector.y  = <-.<-.env_params.ar_contour.y_vector.y;\n"
                  +"Params.new_slice_plane_params.y_vector.z  = <-.<-.env_params.ar_contour.y_vector.z;\n"
                  +"Params.new_slice_plane_params.z_vector.x  = <-.<-.env_params.ar_contour.z_vector.x;\n"
                  +"Params.new_slice_plane_params.z_vector.y  = <-.<-.env_params.ar_contour.z_vector.y;\n"
                  +"Params.new_slice_plane_params.z_vector.z  = <-.<-.env_params.ar_contour.z_vector.z;\n"
                  +switch(is_valid(<-.Params.env_params.ar_contour.center.x) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.x  = <-.<-.env_params.ar_contour.center.x;\n")
                  +switch(is_valid(<-.Params.env_params.ar_contour.center.y) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.y  = <-.<-.env_params.ar_contour.center.y;\n")
                  +switch(is_valid(<-.Params.env_params.ar_contour.center.z) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.z  = <-.<-.env_params.ar_contour.center.z;\n")
                  +"Params.new_slice_plane_params.vector_complete = 1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.ar_contour.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.ar_contour.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAcontour.fld_in);
//     active     = 0;
     on_inst    = 0;
   };
   string+nres local_colormap => MicroAVScontroller.Params.env_params.ar_contour.colormap;
   GMOD.parse_v set_rd_filename {
     v_commands    => "local_colormap = Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "local_colormap = Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.x_vector.x =" + Params.new_slice_plane_params.x_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.x_vector.y =" + Params.new_slice_plane_params.x_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.x_vector.z =" + Params.new_slice_plane_params.x_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.y_vector.x =" + Params.new_slice_plane_params.y_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.y_vector.y =" + Params.new_slice_plane_params.y_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.y_vector.z =" + Params.new_slice_plane_params.y_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.z_vector.x =" + Params.new_slice_plane_params.z_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.z_vector.y =" + Params.new_slice_plane_params.z_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.z_vector.z =" + Params.new_slice_plane_params.z_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.center.x   =" + Params.new_slice_plane_params.center.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.center.y   =" + Params.new_slice_plane_params.center.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.ar_contour.center.z   =" + Params.new_slice_plane_params.center.z + ";\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAcontour.fld_out;
      child_objs => {<-.Modules.legend_out,
                             <-.Modules.pick_obj_out,
                             <-.Modules.slice_obj_out,
                             <-.Modules.axis_obj_out
                    };
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};
