/*
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/celfac.v#1 $
*/
MAnetwork UCDCellExtface
#ifdef MAVS_USE_USER_NAME
< user_name="ME_CELLEXTFACE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_CELLEXTFACE_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "celface";
      params.name = "celface";
      MAextract_cell_component_params extract_cell_component_params;
      MAcell_faces_params cell_faces_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => extract_cell_component_params.init_commands
                                 + cell_faces_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_cell_component_params.reset_commands
                                 + cell_faces_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_cell_component MAextract_cell_component {
         fld_in =><-.fld_in;
         /* v7.0 Rev.C add trigger value and redefinition metnod */
         extract_cell_component {
            int+notify trigger => .comp;
            method+notify_val+notify_inst upd_extr_cell_comp<status=1> = "DVextr_cell_comp_update";
         };
         extract_cell_component_params =><-.<-.Params.extract_cell_component_params;
      };
      MADVextract_mesh extract_mesh {
         in =><-.MAextract_cell_component.fld_out;
      };
      MAcell_faces MAcell_faces {
         fld_in =><-.extract_mesh.out;
         cell_faces_params =><-.<-.Params.cell_faces_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAcell_faces.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAcell_faces.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      olink legend_out => .MAcmapLegendSet.legend_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_cell_compUI.height
               + MAcell_facesUI.height
               + MAmaplegendUI.height
               + 5;
      MAextract_cell_compUI MAextract_cell_compUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         extract_cell_component_params =><-.<-.Params.extract_cell_component_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcell_facesUI MAcell_facesUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         cell_faces_params =><-.<-.Params.cell_faces_params;
         y => <-.MAextract_cell_compUI.y + <-.MAextract_cell_compUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y => <-.MAcell_facesUI.y + <-.MAcell_facesUI.height;
         active => <-.<-.Params.cell_faces_params.color;
      };
   };

/*  for MicroAVS5.0 cut_plane */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => {<-.Modules.legend_out, <-.Modules.MAcut_plane.plane_axis_obj};
      Modes.normals = "None";
   };
/*  for MicroAVS5.0 cut_plane */
};
