/*
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/celvect.v#1 $
*/
MAnetwork UCDCellVector2D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_CELL_VECTOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_CELL_VECTOR_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "celvec2d";
      params.name = "celvec2d";
      MAcombine_vect2d_params combine_vect_params;
      MAcelvector_params vector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => combine_vect_params.init_commands
                                 + vector_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + vector_params.reset_commands
                                 + "\nvector_params.all_nodes=1;\n" // always 1
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MADVcell_centers cell_centers {
         /* 7.0 Rev.C  Redefine so we get notified when cell data changes. */
         Mesh+Cell_Data_Opt+Iparam &in {
            nnodes+req;
            xform+nonotify;
         } => <-.fld_in;
         omethod+notify_inst+notify_val  upd_func<status=1> = "DVcell_centres_update";
      };
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in =><-.cell_centers.out;
      };
     MADVcomb_comp MADVcomb_comp {
         nd1 => <-.MAcombine_vect.fld_out;
         nd2 => <-.cell_centers.out;
         comp1 = {0};
         comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
      };
         MADVcombine_mesh_and_data+nosave MADVcomb_mesh_and_data {
         in_mesh => <-.MAcombine_vect.fld_out;
         in_nd => <-.MADVcomb_comp.out;
      };
      MAcelvector MAcelvector {
         vector_params => <-.<-.Params.vector_params;
         fld_in        => <-.MADVcomb_mesh_and_data.out;
         vector.in     => <-.fld_in;
         in_pick       => <-.in_pick;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => MAcelvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => .Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAcelvector.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      olink legend_out => .MAcmapLegendSet.legend_out;
/*  for MicroAVS5.0  */
      olink vector_obj<NEportLevels={1,2}> => .MAcelvector.vector_out;
      olink text_obj<NEportLevels={1,2}> => .MAcelvector.text_out;
/*  for MicroAVS5.0  */

   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_cell_vectUI.height 
               + MAcelvectorUI.height 
               + MAcelvector_map_compUI.height
               + MAmaplegendUI.height
               + 5;
      MAcombine_cell_vectUI MAcombine_cell_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcelvector_map_compUI MAcelvector_map_compUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAcombine_cell_vectUI.y + <-.MAcombine_cell_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAcelvectorUI MAcelvectorUI {
         parent => <-.parent;
         vector_params =><-.<-.Params.vector_params;
         y => <-.MAcelvector_map_compUI.y + <-.MAcelvector_map_compUI.height;
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.all_nodes_toggle.active;
            copy_on_change<weight=3>;
         };
#else
         all_nodes_toggle.active = 0;
#endif //MSDOS
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAcelvectorUI.y + <-.MAcelvectorUI.height;
         active => <-.<-.Params.vector_params.color;
      };
   };
/*  for MicroAVS5.0 cut_plane */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => {<-.Modules.legend_out,
                     <-.Modules.vector_obj,  // for MicroAVS5.0
                     <-.Modules.text_obj,    // for MicroAVS5.0
                     <-.Modules.MAcut_plane.plane_axis_obj};   // for MicroAVS5.0
   };
/*  for MicroAVS5.0 cut_plane */

};
MAnetwork UCDCellVector3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_CELL_VECTOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_CELL_VECTOR_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "celvec3d";
      params.name = "celvec3d";
      MAcombine_vect3d_params combine_vect_params;
      MAcel_slice_plane_params cel_slice_plane_params;
      MAcelvector_params vector_params;
      // Too bad, but i have no time!
      cel_slice_plane_params.all_nodes => vector_params.all_nodes;
      // Too bad, but i have no time! end
      cel_slice_plane_params.def_dim1 = 8;
      cel_slice_plane_params.def_dim2 = 8;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => combine_vect_params.init_commands
                                 + cel_slice_plane_params.init_commands
                                 + vector_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + cel_slice_plane_params.reset_commands
                                 + vector_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MADVcell_centers cell_centers {
         /* 7.0 Rev.C  Redefine so we get notified when cell data changes. */
         Mesh+Cell_Data_Opt+Iparam &in {
            nnodes+req;
            xform+nonotify;
         } => <-.fld_in;
         omethod+notify_inst+notify_val  upd_func<status=1> = "DVcell_centres_update";

      };
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in =><-.cell_centers.out;
      };
     MADVcomb_comp MADVcomb_comp {
         nd1 => <-.MAcombine_vect.fld_out;
         nd2 => <-.cell_centers.out;
         comp1 = {0};
         comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
      };
         MADVcombine_mesh_and_data+nosave MADVcomb_mesh_and_data {
         in_mesh => <-.MAcombine_vect.fld_out;
         in_nd => <-.MADVcomb_comp.out;
      };

      MADVcomb_comp MADVcomb_comp_slice {
         nd1 => <-.MAcel_slice_plane.fld_out;
         nd2 => <-.MAcel_slice_plane.cell_centers.out;
         comp1 = {0};
         comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
      };
      MADVcombine_mesh_and_data MADVcomb_mesh_and_data_slice {
         in_mesh => <-.MAcel_slice_plane.fld_out;
         in_nd => <-.MADVcomb_comp_slice.out;
      };
      MAcel_slice_plane MAcel_slice_plane {
         cel_slice_plane_params =><-.<-.Params.cel_slice_plane_params;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in => <-.fld_in;
         // for BUG MVI-0053
         DataObject.Obj.xform => input.xform;
         // for BUG MVI-0053 end
      };
      MAcelvector MAcelvector {
         vector_params => <-.<-.Params.vector_params;
         slice_in      => <-.MADVcomb_mesh_and_data_slice.out;
         fld_in        => <-.MADVcomb_mesh_and_data.out;
         in_pick       => <-.in_pick;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => MAcelvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAcelvector.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

   /*  for MicroAVS5.0 cut_plane */

      olink legend_out => MAcmapLegendSet.legend_out;
      olink plane_out => MAcel_slice_plane.obj_out;

/*  for MicroAVS5.0  */
      olink vector_obj<NEportLevels={1,2}> => .MAcelvector.vector_out;
      olink text_obj<NEportLevels={1,2}> => .MAcelvector.text_out;
/*  for MicroAVS5.0  */

   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_cell_vectUI.height 
               + MAcel_slice_planeUI.height 
               + MAcelvectorUI.height 
               + MAcelvector_map_compUI.height
               + MAmaplegendUI.height
               + 5;
      MAcombine_cell_vectUI MAcombine_cell_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcelvector_map_compUI MAcelvector_map_compUI {
         parent => <-.parent;
         params =><-.<-.Params.params;
         vector_params => <-.<-.Params.vector_params;
         y => <-.MAcombine_cell_vectUI.y + <-.MAcombine_cell_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAcel_slice_planeUI MAcel_slice_planeUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         cel_slice_plane_params =><-.<-.Params.cel_slice_plane_params;
         y => <-.MAcelvector_map_compUI.y + <-.MAcelvector_map_compUI.height;
      };
      MAcelvectorUI MAcelvectorUI {
         parent => <-.parent;
         vector_params =><-.<-.Params.vector_params;
         y =><-.MAcel_slice_planeUI.y + <-.MAcel_slice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAcelvectorUI.y + <-.MAcelvectorUI.height;
         active => <-.<-.Params.vector_params.color;
      };
   };

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => {<-.Modules.legend_out,
                     <-.Modules.plane_out,
                     <-.Modules.vector_obj,  // for MicroAVS5.0
                     <-.Modules.text_obj,    // for MicroAVS5.0
                     <-.Modules.MAcut_plane.plane_axis_obj};   // for MicroAVS5.0
   };
/*  for MicroAVS5.0 cut_plane */

};
