/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/contor.v#1 $
*/
MAnetwork UCDContour3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_CONTOUR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_CONTOUR_T";
   Params {
      params.help_name = "cont3d";
      params.name = "contour";
      MAextract_scalar_params extract_scalar_params;
      MAslice_plane_params slice_plane_params;
      MAcontour_params contour_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      /* p[^[̏ƃZbg s2t̓ZbgȂ*/
      init_params.init_commands => extract_scalar_params.init_commands
                                 + slice_plane_params.init_commands
                                 + contour_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + slice_plane_params.reset_commands
                                 + contour_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAslice_plane MAslice_plane {
         slice_plane_params =><-.<-.Params.slice_plane_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcontour MAcontour {
         contour_params =><-.<-.Params.contour_params;
         fld_in =><-.MAslice_plane.fld_out;
      };
      MAscalar2texture MAscalar2texture{
         s2t_params => <-.<-.Params.s2t_params;
         fld_in     => <-.MAcontour.fld_out;
         in_dmap    => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out           => MAscalar2texture.fld_out;
      olink legend_out => MAcmapLegendSet.legend_out;
      olink plane_out => MAslice_plane.obj_out;
      olink texture_out => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAslice_planeUI.height
               + MAcontourUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAslice_planeUI MAslice_planeUI {
         fld_in =><-.<-.Modules.MAslice_plane.fld_in;
         parent => <-.parent;
         slice_plane_params =><-.<-.Params.slice_plane_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAcontourUI MAcontourUI {
         fld_in =><-.<-.Modules.MAcontour.fld_in;
         parent => <-.parent;
         contour_params =><-.<-.Params.contour_params;
         y =><-.MAslice_planeUI.y + <-.MAslice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAcontourUI.y + <-.MAcontourUI.height;
      };
   };
   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      child_objs => {<-.Modules.legend_out,
                             <-.Modules.plane_out};
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};
MAnetwork UCDContour2D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_CONTOUR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_CONTOUR_T";
   Params {
      params.help_name = "cont2d";
      params.name = "contour";
      MAextract_scalar_params extract_scalar_params;
      MAcontour_params contour_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + contour_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + contour_params.reset_commands
                                 + s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAcontour MAcontour {
         contour_params =><-.<-.Params.contour_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAscalar2texture MAscalar2texture{
         s2t_params => <-.<-.Params.s2t_params;
         colmap_params => <-.<-.Params.colmap_params;
         fld_in     => <-.MAcontour.fld_out;
         in_dmap    => <-.<-.DataObject.Datamap;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out           => MAscalar2texture.fld_out;
      olink legend_out  => .MAcmapLegendSet.legend_out;
      olink texture_out => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAcontourUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAcontourUI MAcontourUI {
         fld_in =><-.<-.Modules.MAcontour.fld_in;
         parent => <-.parent;
         contour_params =><-.<-.Params.contour_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAcontourUI.y + <-.MAcontourUI.height;
      };
   };
   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAcontour.fld_out;
      MinMax.input => <-.def_fld;
      child_objs => {<-.Modules.legend_out};
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};
