/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Ucd/extedge.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/extedge.v#1 $
*/
MAnetwork UCDExtedge2D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_EXTEDGE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_EXTEDGE_T";
   Params {
      params.help_name = "exted2d";
      params.name = "extedg2d";
      MAextract_scalar_params extract_scalar_params;
      MAext_edges_params ext_edges_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + ext_edges_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + ext_edges_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_scalar MAextract_scalar {
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         fld_in =><-.fld_in;
      };
      MAext_edges MAext_edges {
         ext_edges_params =><-.<-.Params.ext_edges_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAext_edges.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAext_edges.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height 
               + MAext_edgesUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAext_edgesUI MAext_edgesUI {
         parent => <-.parent;
         ext_edges_params =><-.<-.Params.ext_edges_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAext_edgesUI.y + <-.MAext_edgesUI.height;
         active => <-.<-.Params.ext_edges_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out};
};
UCDExtedge2D UCDExtedge3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_EXTEDGE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_EXTEDGE_T";
   Params.params.name = "extedg3d";
};
