/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Ucd/isolin.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/isolin.v#1 $
*/
MAnetwork UCDIsoline3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ISOLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ISOLINE_T";
   Params {
      params.help_name = "isolin3d";
      params.name = "isoline";
      MAextract_scalar_params extract_scalar_params;
      MAslice_plane_params slice_plane_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + slice_plane_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + slice_plane_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAslice_plane MAslice_plane {
         slice_plane_params =><-.<-.Params.slice_plane_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAisoline MAisoline {
         isoline_params =><-.<-.Params.isoline_params;
         fld_in =><-.MAslice_plane.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => MAisoline.fld_in;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAisoline.fld_out;
      olink legend_out => MAcmapLegendSet.legend_out;
      olink plane_out  => MAslice_plane.obj_out;
      olink text_out   => MAisoline.text_out;
      olink bounds_out => MAisoline.bounds_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAslice_planeUI.height
               + MAisolineUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAslice_planeUI MAslice_planeUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         slice_plane_params =><-.<-.Params.slice_plane_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAisolineUI MAisolineUI {
         fld_in =><-.<-.Modules.MAisoline.fld_in;
         parent => <-.parent;
         isoline_params =><-.<-.Params.isoline_params;
         y =><-.MAslice_planeUI.y + <-.MAslice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAisolineUI.y + <-.MAisolineUI.height;
         active => <-.<-.Params.isoline_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.plane_out,
                             <-.Modules.text_out,
                             <-.Modules.bounds_out
                            };
};
MAnetwork UCDIsoline2D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ISOLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ISOLINE_T";
   Params {
      params.help_name = "isolin2d";
      params.name = "isoline";
      MAextract_scalar_params extract_scalar_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAisoline MAisoline {
         isoline_params =><-.<-.Params.isoline_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => MAisoline.fld_in;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAisoline.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink text_out => MAisoline.text_out;
      olink bounds_out => MAisoline.bounds_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAisolineUI.height 
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAisolineUI MAisolineUI {
         fld_in =><-.<-.Modules.MAisoline.fld_in;
         parent => <-.parent;
         isoline_params =><-.<-.Params.isoline_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAisolineUI.y + <-.MAisolineUI.height;
         active => <-.<-.Params.isoline_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.text_out,
                             <-.Modules.bounds_out
                            };
};
