/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/offset.v#1 $
*/
MAnetwork UCDOffset2D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_OFFSET_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_OFFSET_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "offset2d";
      params.name = "offset2d";
      MAcombine_vect2d_params combine_vect_params;
      MAoffset_params offset_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => combine_vect_params.init_commands
                                 + offset_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + offset_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in => <-.MAcut_plane.out_fld;
      };

   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.fld_in;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
         cut1{
             CutParam{
                component[] => init_array(<-.in_field.nnode_data,0,(<-.in_field.nnode_data -1));
             };
         };
         cut2{
             CutParam{
                component[] => init_array(<-.in_field.nnode_data,0,(<-.in_field.nnode_data -1));
             };
         };
      };

      MAoffset MAoffset {
         offset_params =><-.<-.Params.offset_params;
         fld_in        => <-.MAcombine_vect.fld_out;
         fld_in2       => <-.MAcut_plane.out_fld;
      };

      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;

   /*  for MicroAVS5.0 cut_plane */

      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAoffset.fld_out;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out           => MAscalar2texture.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink texture_out => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_vectUI.height 
               + MAoffsetUI.height 
               + MAmaplegendUI.height
               + MAoffset_map_compUI.height
               + 5;
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
      MAcombine_vectUI MAcombine_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAoffset_map_compUI MAoffset_map_compUI{
         parent => <-.parent;
        offset_params => <-.<-.Params.offset_params;
         y => <-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
         fld_in => <-.fld_in;
      };
      MAoffsetUI MAoffsetUI {
         parent => <-.parent;
         offset_params =><-.<-.Params.offset_params;
         y =><-.MAoffset_map_compUI.y + <-.MAoffset_map_compUI.height;
         fld_in => <-.fld_in;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAoffsetUI.y + <-.MAoffsetUI.height;
         active => <-.<-.Params.offset_params.color;
      };
   };
   // for facet rendering 97.9.30 by sugino
   DataObject.Modes.normals = "None";
   //

  /*  for MicroAVS5.0 cut_plane */

   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink+nres def_fld    => <-.Modules.MAoffset.fld_out;
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      child_objs => {<-.Modules.legend_out,<-.Modules.MAcut_plane.plane_axis_obj};
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         &cut_plane_params => <-.cut_plane_params;
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };

  /*  for MicroAVS5.0 cut_plane */


};
UCDOffset2D UCDOffset3D {
   title = "ME_OFFSET_T";
   Params {
      params.help_name = "offset3d";
      params.name = "offset3d";
      MAcombine_vect3d_params combine_vect_params;
   };
};
