/*
	"$Id: //depot/express/fcs70/v/MicroAVS/common.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/common.v#1 $
*/
//
// MicroAVS common Templates
//
flibrary+buffered+global MAcommonTemplates <compile_subs=0, NEvisible=0>
{
   //////////////////////////////////////////////////////////////////////////
   // Parameter Templates of Modules and Editors
   //////////////////////////////////////////////////////////////////////////
   group+Port MAparams {
      string+nosave init_commands  = "";
      string+nosave reset_commands = "";
   };
//@p[^̕ۑɎgpp[^Q
//
   group MAenv_params{
      group background {
         float back_col[3];
      };
      group camera {
         int   perspective;
         float fov;
         int   depth_cue;
         float depth_front;
         float depth_back;
      };
      group properties {
         float ambient;
         float diffuse;
         float specular;
         float spec_exp;
         float trans;
      };
      group ar_contour {
         group x_vector {
            float x;
            float y;
            float z;
         };
         group y_vector {
            float x;
            float y;
            float z;
         };
         group z_vector {
            float x;
            float y;
            float z;
         };
         group center {
            float x;
            float y;
            float z;
         };
         string colormap;
      };
      group iso_surface {
      	 float  level;
         string colormap;
      };
      group streamline {
         int   dim1;
         int   dim2;
         group x_vector {
            float x;
            float y;
            float z;
         };
         group y_vector {
            float x;
            float y;
            float z;
         };
         group z_vector {
            float x;
            float y;
            float z;
         };
         group center {
            float x;
            float y;
            float z;
         };
         string colormap;
      };
      group particl {
         int   dim1;
         int   dim2;
         group x_vector {
            float x;
            float y;
            float z;
         };
         group y_vector {
            float x;
            float y;
            float z;
         };
         group z_vector {
            float x;
            float y;
            float z;
         };
         group center {
            float x;
            float y;
            float z;
         };
         int    tracer;
         string colormap;
      };
      group volume_render {
         int   border;
         float low_min;
         float low_max;
         float high_min;
         float high_max;
      };
      group surf_plot {
         float  scale;
         float  offset;
         string colormap;
      };
      group angle {
         string view_xform;
      };
      group angle {
         string view_xform;
      };
      group scalar2texture {
         int s2t_on;
         int texture_size;
      };
   };

   MAparams MAcommon_params {
      boolean        visible;
      boolean+nosave reset;
      boolean        help;
      string+nosave  title;
      //string+nosave  icon; //no longer
      string+nosave  name; //== icon filename
      string+nosave  help_name;
      init_commands  = "";
      reset_commands = "";
   };
   //////////////////////////////////////////////////////////////////////////
   // UI macro Templates of Modules and Editors
   //////////////////////////////////////////////////////////////////////////
   macro MAmacroUI {
      ilink parent;
      int y;
      int height;
      MAcommon_params &params;
   };
   MAmacroUI MAcommonUI {
      MAcommon_params &params;
      height => resetHelpButtons.height;
      link panel => resetHelpButtons.panel; // Compatibility
      MAUIresetHelpButtons resetHelpButtons {
         parent => <-.parent;
         y => <-.y;
         reset => <-.params.reset;
         help  => <-.params.help;
      };
   };
   macro MAmacro<hconnect=2, export_all=0, NEopenable=MAVS_OPENABLE> {
      string title => name_of(<-);
      macro Params {
         MAcommon_params params;
         GMOD.parse_v init_params {
            mode = 1;
            string init_commands = "";
            v_commands => "Scheduler.percent_done=20;Scheduler.disable=1;\n"
                         + <-.params.init_commands
                         +"Scheduler.percent_done=60;\n"
                         + init_commands
                         +"init_params.active=0;\n"
                         +"Scheduler.disable=0;\n"
                         +"Scheduler.percent_done=100;\n";
            relative => <-;
            on_inst = 1;
            active = 0; // not supported yet
         };
         GMOD.parse_v reset_params {
            ////mode = 1;
            sync = 1;
            string reset_commands = "";
            trigger => <-.params.reset;
            v_commands => "$push\n"
                         +"Scheduler.percent_done=20;Scheduler.disable=1;\n"
                         +"$pop\n"
                         +"$push -usr\n"
                         + <-.params.reset_commands
                         +"$pop\n"
                         +"Scheduler.percent_done=60;\n"
                         +"$push -usr\n"
                         + reset_commands
                         +"$pop\n"
                         +"$push\n"
                         +"Scheduler.disable=0;\n"
                         +"Scheduler.percent_done=100;\n"
                         +"$pop\n"
                        ;
            relative => <-;
            on_inst = 0;
         };
         MAenv_params+nres &env_params => MicroAVScontroller.Params.env_params;
      };
      GMOD.instancer Instancer {
         Group => <-.UI;
         Value => <-.UI.visible;
      };
      macro UI<instanced=0, locked=0> {
         string help_path = "method";
         MAcommon_params &params => <-.Params.params;
         ilink visible => .params.visible;
         link parent<NEportLevels=1>;
         int height;
         MAmime HelpViewer {
            trigger => <-.params.help;
            stFilename => MAVS_HELP_PATH+"/"+help_path+"/"+params.help_name+".htm";
         };
      };
   };
};
