/*
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/rdtempl.v#1 $
*/
//
// MicroAVS reader Templates
//
#ifdef OLD
#ifdef MSDOS
#define MA_FILE_SEP	"\\"
#else
#define MA_FILE_SEP	"/"
#endif //MSDOS
#endif //OLD
//
// Reader Template
//
macro MAreader_templ<NEopenable=MAVS_OPENABLE> {
#ifdef MICROAVS_DEV_KIT
   MAdataObj+nres &dataObj<NEvisible=0> => <-.dataObj;
#else
   MAdataObj dataObj<NEvisible=0>;
#endif //MICROAVS_DEV_KIT
   string title = "";
#ifdef OLD
   string fnames<NEvisible=0>[] => str_array(Params.filename, MA_FILE_SEP);
   string nos<NEvisible=0>[] => str_array(name_of(<-), "#");
   string no<NEvisible=0> => switch((array_size(nos) > 1)+1, "",
                        " #"+nos[array_size(nos)-1]);
   string name<NEvisible=0> => fnames[array_size(fnames)-1] + no;
#else
   string nos<NEvisible=0>[] => str_array(name_of(<-), "#");
   string no<NEvisible=0> => switch((array_size(nos) > 1)+1, "",
                        " #"+nos[array_size(nos)-1]);
   string name<NEvisible=0> => Params.basename + no;
#endif //OLD

   // MicroAVS2.0 for Compatibility begin
   string filename <NEvisible=1, export=3> =;
   boolean portable<NEvisible=0, export=0> = 1;
   boolean swap    <NEvisible=0, export=0> = 0;
   boolean flip    <NEvisible=0, export=0> = 0;
   link mod_panel  <NEvisible=0, export=0> => UI.mod_panel;
   // MicroAVS2.0 for Compatibility end

   group Params<NEportLevels={0,1}, export_all=2> {
      string+nosave filename<export=0>      => <-.filename;
      boolean+nosave portable<export=0>     => <-.portable;
      boolean+nosave swap<export=0>         => <-.swap;
      boolean+nosave flip<export=0>         => <-.flip;
      int+nosave format<export=0>           =;
      string+nosave info<export=0>          =;
      int+nosave one_obj<export=0>          = 1;
      string+nosave names<export=0>[]       =;
      string+nosave ok_filename<export=0>   =;
      string+nosave basename<export=0>      =;
      int+nosave data_type_detail<export=0> = 0;
      boolean+nosave reset<export=0>        =;
      //boolean+nosave reset_active<export=0> = 1;
      boolean+nosave reset_active<export=0> => is_valid(reader.filename);
      string+nosave reset_commands<export=0>="";
      boolean+nosave help<export=0>         =;
      string+nosave help_name<export=0>     ="default";
   };
   GMOD.parse_v reset_params {
      sync = 1;
      string reset_commands = "";
      trigger => <-.Params.reset;
      v_commands => "$push\n"
                   +"Scheduler.percent_done=30;Scheduler.disable=1;\n"
                   +"$pop\n"
                   +"$push -usr\n"
                   + <-.Params.reset_commands
                   +"$pop\n"
                   +"$push -usr\n"
                   + reset_commands
                   +"$pop\n"
                   +"$push\n"
                   +"Scheduler.disable=0;\n"
                   +"Scheduler.percent_done=100;\n"
                   +"$pop\n"
                  ;
      relative => <-;
      on_inst = 0;
   };
   MAmime HelpViewer {
      trigger => <-.Params.help;
      stFilename => MAVS_HELP_PATH+"/dataio/"+Params.help_name+".htm";
   };
   MAfilename_to_type filename_to_type {
      filename      => <-.Params.filename;
      modules       => dataObj.read_module;
      executables   => dataObj.read_executable;
      file_suffixes => dataObj.read_file_suffix;
      data_types    => dataObj.read_data_type;
      comments      => dataObj.read_comment;
      helps         => dataObj.read_help;
      require       = MAVS_REREAD; // for re-read
      ok_filename   => <-.Params.ok_filename;
      basename      => <-.Params.basename;
#ifdef MICROAVS_DEV_KIT
      old_one       => <-.Params.data_type_detail;
#endif //MICROAVS_DEV_KIT
   };
   module+nosave reader {
      string filename   => <-.Params.ok_filename;
      string data_type  => <-.filename_to_type.data_type;
      string module     => <-.filename_to_type.module;
      string executable => <-.filename_to_type.executable;
      group out;
      int done          =;
#ifndef MICROAVS_DEV_KIT
      done => <-.Params.data_type_detail;
#endif //!MICROAVS_DEV_KIT
      int err_no;
   };
#ifdef MICROAVS_DEV_KIT
   GMOD.copy_on_change set_err_no {
      input => <-.filename_to_type.err_no;
      output+nres => MicroAVScontroller.Params.params.err_no;
      on_inst = 0;
   };
   set_err_no set_err_no2 { input => <-.reader.err_no; };
   // version 4.0
   MAcontrolMRU dataMRU {
      file_section  = "Recent Data File List";
      read_filename => <-.filename_to_type.ok_filename;
      MRU+nres      => MicroAVScontroller.Params.params.dataMRU;
   };
#endif //MICROAVS_DEV_KIT
   macro+nosave UI {
      ilink Params => <-.Params;
      ilink dataObj => <-.dataObj;
      link+nres searchPattern => dataObj.read_searchPattern;
      string title  => <-.title;
      string data_type_label =>
         " "+"MAFT_CUR_DATA_TYPE" + ":\n"
        +"   " + switch(Params.data_type_detail+1,
                  "", // undefined
                  "MAFT_GEOM",
                  "MAFT_IMAGE",
                  "MAFT_MVGEO",
                  "MAFT_FS1D2S",
                  "MAFT_FS1D3S",
                  "MAFT_FS1D3SBU",
                  "MAFT_FV1D2S",
                  "MAFT_FV1D3S",
                  "MAFT_FV1D3SBU",
                  "MAFT_FS2D",
                  "MAFT_FV2D",
                  "MAFT_FS3D",
                  "MAFT_FS3DBU",
                  "MAFT_FV3D",
                  "MAFT_FV3DBU",
                  "MAFT_US2D",
                  "MAFT_US3D",
                  "MAFT_UV2D",
                  "MAFT_UV3D",
                  "MAFT_FS1D",
                  "MAFT_FV1D",
                  "MAFT_US1D",
                  "MAFT_UV1D",
                  "MAFT_FS1D3SSU",
                  "MAFT_FV1D3SSU",
                  "MAFT_FS3DSU",
                  "MAFT_FV3DSU",
                  "MAFT_U_S1D",
                  "MAFT_U_S2D",
                  "MAFT_U_S3D",
                  "MAFT_U_V1D",
                  "MAFT_U_V2D",
                  "MAFT_U_V3D",
                  "MAFT_USS1D",
                  "MAFT_USS2D",
                  "MAFT_USS3D",
                  "MAFT_USV1D",
                  "MAFT_USV2D",
                  "MAFT_USV3D",
                  "MAFT_UVS1D",
                  "MAFT_UVS2D",
                  "MAFT_UVS3D",
                  "MAFT_UVV1D",
                  "MAFT_UVV2D",
                  "MAFT_UVV3D",
                  "MAFT_PDB",
                  "MAFT_CUBE_DENSITY",
                  "MAFT_CUBE_ORBITAL",
                  "MAFT_LOG",
                  "MAFT_LWO",
                  "MAFT_MGF",
                  ""
      );
      string titleS =;
      GMOD.copy_on_change set_title { // for Unix Version bug
         input => <-.title;
         output => <-.titleS;
         on_inst = 1;
      };
      int+nres height => 266 + UIdata.UIfonts[0].lineHeight * 3;
      MAUImod_panel mod_panel {
         title => " " + <-.titleS + " " + "MAMREAD_DATA_LABEL";
         width+nres => parent.clientWidth;
         height => <-.height;
      };
      MAUIresetHelpButtons ResetHelpButtons {
         parent => <-.mod_panel;
         y = 0;
         reset => <-.Params.reset;
         help  => <-.Params.help;
         reset_active => <-.Params.reset_active;
      };
      MAUItext DataTypeFrame {
         parent => <-.mod_panel;
         x = 0;
         y => <-.ResetHelpButtons.y + <-.ResetHelpButtons.height + 5;
         width => .parent.clientWidth - 18;
         height+nres => UIdata.UIfonts[0].lineHeight * .rows;
         rows = 3;
         //visible => .parent.visible;
         color.foregroundColor = MAVS_BLUE;
         multiLine = 1;
         outputOnly = 1;
         text => <-.data_type_label;
         updateMode = 0;
      };
      MAUIFileSelector fileSelector {
         parent => <-.mod_panel;
         x = 0;
         y => <-.DataTypeFrame.y + <-.DataTypeFrame.height + 5;
         width => parent.clientWidth - 18;
         title => <-.mod_panel.title;
         // MicroAVS2.0 for Compatibility begin
         //file => <-.Params.filename;
         file => <-.<-.filename;
         // MicroAVS2.0 for Compatibility end
         Title.label => "MAMREAD_DATA_TITLE";
         Title.fontAttributes.height = 14;
         fileFB.current_directory => MAVS_READ_DATA_PATH;
         fileFB.all_types = "";
#ifdef MSDOS
         fileFB.searchPattern => <-.<-.searchPattern;
#else
         fileFB.searchPattern => MAVS_DATA_PATH+"*.*";
#endif //MSDOS
         fileFB.field_types => <-.<-.field_types;
         fileFB.ucd_types   => <-.<-.ucd_types;
         fileFB.image_types => <-.<-.image_types;
         fileFB.geom_types  => <-.<-.geom_types;
         fileFB.geom_types_name  => <-.<-.geom_types_name;
      };
      int y => fileSelector.y + fileSelector.height;
      string field_types = "";
      string ucd_types = "";
      string image_types = "";
      string geom_types = "";
      string geom_types_name = "";
   };
};
//
// Multi-Time Reader Template
//
MAreader_templ MAmtreader_templ {
   Params {
      int store_all<export=0>   = 0;
      int+nosave nsteps         = 0;  // ==total
      int stepno                = 1;  // ==current_step
      string+nosave time_string = ""; // ==step_title
      int+nosave play           =;
      int cycle                 = 0;// 0:one_time/1:continuous/2:bounce
      int start                 = 1;
      int end                   =;
      int timestep_reset        =;
      int set_step_range        = 1;
      float x_pos               = 0;
      float y_pos               = 0;
      boolean front             = 1;
      boolean front_back_vis<NEvisible=0> = 1;
      boolean state             = 1;
      boolean underline         = 0;
      float red                 = 1;
      float green               = 1;
      float blue                = 1;
#ifdef MSDOS
      string font = "-*-FixedSys-medium-r-*-*-14-*-*-*-*-*-*-*";
#else
      string font = "-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*";
#endif //MSDOS
// null/min/max data begin
      group field_params {
         boolean+nosave value_changed     = 0;
         boolean        each              = 0; // 0:all/1:each
         boolean        all_null_flag     = 0;
         boolean        all_min_flag      = 0;
         boolean        all_max_flag      = 0;
         prim           all_null_value    = 0.0;
         prim           all_min_value     =;
         prim           all_max_value     =;
         prim+nosave    def_all_null_value =;
         prim+nosave    def_all_min_value =;
         prim+nosave    def_all_max_value =;
         int+nosave     ncomp             =;
         group each_values[ncomp] {
            boolean     null_flag     = 0;
            boolean     min_flag      = 0;
            boolean     max_flag      = 0;
            prim        null_value    = 0.0;
            prim        min_value     =;
            prim        max_value     =;
            prim+nosave def_null_value =;
            prim+nosave def_min_value =;
            prim+nosave def_max_value =;
         };

/*  for MicroAVS5.0 crop/downsize  start  */
         int         crop_imin    = 0;
         int         crop_jmin    = 0;
         int         crop_kmin    = 0;
         int         crop_imax    = 0;
         int         crop_jmax    = 0;
         int         crop_kmax    = 0;
         float       downsize_i;
         float       downsize_j;
         float       downsize_k;
         int+nosave  end_i        = 0;
         int+nosave  end_j        = 0;
         int+nosave  end_k        = 0;
         int         crop_dwn_on  = 0;
         int         crop_dwn_set = 0;
         int         exec         = 0;
/*  for MicroAVS5.0 crop/downsize  end  */

      };
// null/min/max data end
   };

   Params.reset_active => is_valid(reader.filename);
   reset_params.reset_commands
      = "Params{"
/* MicroAVS V4.0 begin */
      + "stepno=1;"
/* MicroAVS V4.0 end */
      + "store_all=0;"
      + "x_pos=0;y_pos=0;front=1;state=1;"
      + "red=1;green=1;blue=1;underline=0;"
#ifdef MSDOS
      + "font=\"-*-FixedSys-medium-r-*-*-14-*-*-*-*-*-*-*\";"
#else
      + "font=\"-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*\";"
#endif //MSDOS
      + "field_params{"
      +  "each=0;"
      +  "all_null_flag=0;"
      +  "all_null_value=0;"
      +  "all_min_flag=0;"
      +  "all_max_flag=0;"
      +  switch(is_valid(Params.field_params.def_all_min_value)+1,
                "all_min_value=;",
                "all_min_value=def_all_min_value;")
      +  switch(is_valid(Params.field_params.def_all_max_value)+1,
                "all_max_value=;",
                "all_max_value=def_all_max_value;")
      +  "each_values[ncomp]{"
      +   "null_flag=0;min_flag=0;max_flag=0;"
      +   "null_value=0.0;"
      +   "};"
      +  switch(1+(Params.nsteps>1), "",
             "each_values.min_value=each_values.def_min_value;"
            +"each_values.max_value=each_values.def_max_value;")
      +  "};"
      + "};"
      ;
   UI {
      ilink in_field => <-.reader.out;
      int+nres height0 => 215 + UIdata.UIfonts[0].lineHeight;
      int height => height0
                 + (<-.Params.nsteps > 1) * MAUItimeStepControl.height
                 + dataRangeUI.height;
      GMOD.instancer MAUItimeStepControlInstancer {
         Value => <-.Params.nsteps > 1;
         Group => <-.MAUItimeStepControl;
      };
      int y2 = 0;
      macro MAUItimeStepControl<instanced=0> {
         ilink parent => <-.mod_panel;
         ilink Params => <-.Params;
         int y => <-.y2;
         int height => frame.height;
         MAUIframe frame {
            parent => <-.parent;
            x = 0;
            y => <-.y;
            width = 235;
            height = 220;
         };
         MAUIlabel current_step_label {
            parent => <-.frame;
            x = 5;
            y = 10;
            width = 100;
            //height => 25;
            height+nres => UIdata.UIfonts[0].lineHeight +15;
            alignment = "right";
            label => "MATD_STEPNO";
         };
         MAUIspinField current_stepno {
            parent => <-.frame;
            x => <-.current_step_label.x + <-.current_step_label.width + 5;
            y => <-.current_step_label.y;
            decimalPoints = 0;
            mode = "integer";
            height+nres => UIdata.UIfonts[0].lineHeight +15;
            min => <-.Params.start;
            max => <-.Params.end;
            value => <-.Params.stepno;
            fontAttributes.height = 16;
         };
         MAUIlabel total_steps_label {
            parent => <-.frame;
            x => <-.current_stepno.x + <-.current_stepno.all_width;
            y => <-.current_step_label.y;
            width = 100;
            height => <-.current_step_label.height;
            fontAttributes.height = 16;
            label => " / " + <-.Params.nsteps;
            alignment = "left";
         };
         MAUIlabel start_label{
            parent => <-.frame;
            x      = 5;
            y      => <-.current_step_label.y + <-.current_step_label.height + 5;
            width  => <-.current_step_label.width;
            height => <-.current_step_label.height;
            alignment = "right";
            label  => "MATD_START_LABEL";
         };
         MAUIfield start_step {
            parent    => <-.frame;
            x         => <-.current_stepno.x;
            y         => <-.start_label.y;
            width     => <-.current_stepno.width;
            height    => <-.start_label.height;
            mode      = "integer";
            min       = 1;
            max       => <-.Params.nsteps;
            value     => <-.Params.start;
            decimalPoints = 0;
            fontAttributes.height = 16;
         };
         MAUIlabel end_label{
            parent => <-.frame;
            x      = 5;
            y      => <-.start_label.y + <-.start_label.height + 5;
            width  => <-.current_step_label.width;
            height => <-.start_label.height;
            alignment = "right";
            label  => "MATD_END_LABEL";
         };
         MAUIfield end_step {
            parent    => <-.frame;
            x         => <-.start_step.x;
            y         => <-.end_label.y;
            width     => <-.current_stepno.width;
            height    => <-.end_label.height;
            mode      = "integer";
            min       => <-.Params.start;
            max       => <-.Params.nsteps;
            value     => <-.Params.end;
            decimalPoints = 0;
            fontAttributes.height = 16;
         };
         MAUIbutton reset_step {
            parent => <-.frame;
            x      => ((<-.frame.width - width) / 2);
            y      => <-.end_label.y + <-.end_label.height + 10;
            label => "MATD_RESET_STEP";
            do     => <-.Params.timestep_reset;
         };
         MAUIbutton start {
            parent => <-.frame;
            x = 10;
            y = 35;
            y => <-.reset_step.y + <-.reset_step.height + 10;
            width = 33;
            height = 33;
            labelPixmap.filename => MAVS_ICON_PATH+"rstart.x";
            labelPixmap.fileType = "avs_image";
            GMOD.parse_v set_start {
               on_inst    = 0;
               active     => <-.do;
               trigger    => <-.do;
               relative   => <-.<-.Params;
               v_commands = "$push -usr\nstepno=start;$pop\n";
            };
            label => "MATD_START";
         };
         MAUIbutton stop {
            parent => <-.frame;
            x => <-.start.x + <-.start.width + 2;
            y => <-.start.y;
            width = 33;
            height = 33;
            boolean do => <-.Params.play <+> 1;
            labelPixmap.filename => MAVS_ICON_PATH+"rstop.x";
            labelPixmap.fileType = "avs_image";
            label => "MATD_STOP";
         };
         MAUIbutton one_time {
            parent => <-.frame;
            x => <-.stop.x + <-.stop.width + 2;
            y => <-.start.y;
            width = 33;
            height = 33;
            labelPixmap.filename => MAVS_ICON_PATH+"roneway.x";
            labelPixmap.fileType = "avs_image";
            GMOD.parse_v choice_one_time {
               on_inst    = 0;
               active     => <-.do;
               trigger    => <-.do;
               relative   => <-.<-.Params;
               v_commands = "$push -usr\ncycle=0;play=1;$pop\n";
            };
            label => "MATD_ONETIME";
         };
         MAUIbutton cycle {
            parent => <-.frame;
            x => <-.one_time.x + <-.one_time.width + 2;
            y => <-.start.y;
            width = 33;
            height = 33;
            labelPixmap.filename => MAVS_ICON_PATH+"rcycle.x";
            labelPixmap.fileType = "avs_image";
            GMOD.parse_v choice_continuous {
               on_inst    = 0;
               trigger    => <-.do;
               active     => <-.do;
               relative   => <-.<-.Params;
               v_commands = "$push -usr\ncycle=1;play=1;$pop\n";
            };
            label => "MATD_CYCLE";
         };
         MAUIbutton bounce {
            parent => <-.frame;
            x => <-.cycle.x + <-.cycle.width + 2;
            y => <-.start.y;
            width = 33;
            height = 33;
            labelPixmap.filename => MAVS_ICON_PATH+"rbounce.x";
            labelPixmap.fileType = "avs_image";
            GMOD.parse_v choice_bounce {
               on_inst    = 0;
               trigger    => <-.do;
               active     => <-.do;
               relative   => <-.<-.Params;
               v_commands = "$push -usr\ncycle=2;play=1;$pop\n";
            };
            label => "MATD_BOUNCE";
         };
         MAUIbutton end {
            parent => <-.frame;
            x => <-.bounce.x + <-.bounce.width + 2;
            y => <-.start.y;
            width = 33;
            height = 33;
            labelPixmap.filename => MAVS_ICON_PATH+"rend.x";
            labelPixmap.fileType = "avs_image";
            GMOD.parse_v set_end {
               on_inst    = 0;
               active     => <-.do;
               trigger    => <-.do;
               relative   => <-.<-.Params;
               v_commands = "$push -usr\nstepno=end;$pop\n";
            };
            label => "MATD_END";
         };
         MAUItoggle label_onoff {
            parent => <-.frame;
            x = 10;
            y => <-.start.y + <-.start.height + 10;
            width = 100;
            set   => <-.Params.state;
            label => "MATD_COMMENT";
         };
         MAUIbutton font {
            parent => <-.frame;
            x => <-.label_onoff.x + <-.label_onoff.width;
            y => <-.start.y + <-.start.height + 10;
            width = 50;
            active => <-.Params.state;
            label => "MAUI_FONT";
         };
         MAUIbutton move {
            parent => <-.frame;
            x => <-.font.x + <-.font.width + 5;
            y => <-.start.y + <-.start.height + 10;
            width = 50;
            active => <-.Params.state;
            label => "MAUI_TRANS";
         };
#ifdef MSDOS
         MAUIfontDialog font_dialog
#else
         // On Unix, we need to show a sample with GD(view).
         // UIlabel does NOT support font(like X font list).
         MAGDfontDialogUnix font_dialog
#endif //MSDOS
         {
            parent    => <-.frame;
            visible   => <-.font.do;
            red       => <-.Params.red;
            green     => <-.Params.green;
            blue      => <-.Params.blue;
            underline => <-.Params.underline;
            font      => <-.Params.font;
         };
         GMOD.instancer move_dialog_instancer {
            Group => <-.move_dialog;
            Value => <-.move.do;
         };
         MAUIlabelMoveDialog move_dialog<instanced=0> {
            parent    => <-.frame;
            visible   => <-.move.do;
            front     => <-.Params.front;
            xpos      => <-.Params.x_pos;
            ypos      => <-.Params.y_pos;
         };
      };
// null/min/max data begin
      macro dataRangeUI {
         ilink parent => <-.mod_panel;
         ilink field_params => <-.Params.field_params;
         ilink in_field => <-.in_field;
         int y => <-.y2 + (<-.Params.nsteps > 1)
                          * MAUItimeStepControl.height;
         int height => change_panel.y + change_panel.height + 5;
         boolean active => is_valid(field_params.ncomp);

         MADVnode_data_labels node_data_label {
            in => <-.in_field;
            GMOD.copy_on_change set_ncomp {
               input => <-.ncomp;
               output => <-.<-.field_params.ncomp;
               on_inst = 0;
            };
         };
         MAUIframe data_panel {
            parent => <-.parent;
            x = 0;
            y => <-.y;
            width+nres => parent.clientWidth - 20;
            height => <-.height;
         };
         MAUIradioBoxLabel allorEachRadioBox {
            parent => <-.data_panel;
            title = "MAREAD_DATA_RANGE_LABEL";
            labels = {"MAREAD_ALL_DATA_LABEL", "MAREAD_EACH_DATA_LABEL"};
            selectedItem => <-.field_params.each;
            active => <-.active;
         };
         MAUIframe change_panel {
            parent => <-.data_panel;
            x = 5;
            y => <-.allorEachRadioBox.y + <-.allorEachRadioBox.height;
            width => parent.clientWidth - 10;
            height =>
               switch((allorEachRadioBox.selectedItem + 1),
                  <-.allEditorButton.y + <-.allEditorButton.height,
                  <-.eachEditorButtons[field_params.ncomp-1].y
                + <-.eachEditorButtons[field_params.ncomp-1].height) + 10;
         };
         MAUIlabel data_label {
            parent => <-.change_panel;
            x = 5;
            y = 5;
            label => <-.allorEachRadioBox.selectedString;
            active => <-.active;
         };
         MAUIbutton allEditorButton {
            parent => <-.change_panel;
            x = 5;
            y => <-.data_label.y + data_label.height;
            width => parent.clientWidth - 10;
            height = 25;
            active => <-.active;
            visible => !<-.allorEachRadioBox.selectedItem;
            label => <-.allorEachRadioBox.selectedString;
            do = 0;
         };
         GMOD.copy_on_change flip {
            on_inst = 0;
            input   => !<-.allorEachRadioBox.selectedItem
                      * <-.allEditorButton.do;
            output  => <-.allEditor.visible;
         };
         MAUInullMinMaxValEditor allEditor {
            title        => <-.allorEachRadioBox.selectedString;
            visible      = 0;
            null_enabled => <-.field_params.all_null_flag;
            min_enabled  => <-.field_params.all_min_flag;
            max_enabled  => <-.field_params.all_max_flag;
            null_value   => <-.field_params.all_null_value;
            min_value    => <-.field_params.all_min_value;
            max_value    => <-.field_params.all_max_value;
         };
         GMOD.copy_on_change flop {
            on_inst = 0;
            input   => <-.allorEachRadioBox.selectedItem;
            output  => <-.eachEditorButtons_vis;
         };
         boolean eachEditorButtons_vis = 1;
         MAUIbutton eachEditorButtons[field_params.ncomp] {
            int id  => index_of(eachEditorButtons);
            parent  => <-.change_panel;
            active  => <-.active;
            visible => <-.allorEachRadioBox.selectedItem;
            label   => <-.node_data_label.labels[id];
            x       = 5;
            y       => <-.data_label.y + <-.data_label.height + .height * id;
            width   => parent.clientWidth - 10;
            height  = 25;
            do      = 0;
         };
         MAUInullMinMaxValEditor eachEditors[field_params.ncomp] {
            int id       => index_of(eachEditors);
            title        => <-.node_data_label.labels[id];
            null_enabled => <-.field_params.each_values[id].null_flag;
            min_enabled  => <-.field_params.each_values[id].min_flag;
            max_enabled  => <-.field_params.each_values[id].max_flag;
            null_value   => <-.field_params.each_values[id].null_value;
            min_value    => <-.field_params.each_values[id].min_value;
            max_value    => <-.field_params.each_values[id].max_value;
            GMOD.copy_on_change set_vis {
               input => <-.<-.eachEditorButtons[id].do
                      * <-.<-.eachEditorButtons_vis;
               output => <-.visible;
               on_inst = 0;
            };
         };
      };
// null/min/max data end
   };
   GMOD.loop+nosave Loop {
      run+nosave       => <-.Params.play;
      start_val+nosave => <-.Params.start;
      end_val+nosave   => <-.Params.end;
      count+nosave     => <-.Params.stepno;
      incr+nosave      = 1;
      cycle+nosave     => <-.Params.cycle;
      done+nosave;
   };
   GMOD.parse_v+nosave set_timestep_range {
      v_commands =>  "$push -usr\n"
                    +"start = 1;\n"
                    +"end   = nsteps;\n"
                    +"\n$pop\n";
      relative   => <-.Params;
      trigger    => <-.Params.timestep_reset;
      on_inst    = 0;
      active     = 1;
   };
   GMOD.parse_v+nosave init_timestep_range {
      v_commands =>  "$push -usr\n"
                    +"Params.start = 1;\n"
                    +"Params.end   = nsteps;\n"
                    +"$pop\n"
                    +"$push\n"
                    +"Params.set_step_range = 0;\n"
                    +"$pop\n";
      relative   => <-;
      trigger    => is_valid(<-.reader.nsteps);
      on_inst    =  0;
      active     => <-.Params.set_step_range;
   };
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v auto_connect_label_obj {
      on_inst = 0;
      trigger => <-.Params.nsteps > 1;
      //active => is_valid(<-.<-.MAviewer)&&trigger;
      active => trigger;
      v_commands => "$push -usr\n"
                    +switch(<-.Params.state+1,
                            "$del_obj_ref <-.MAviewer.objs_in label_obj",
                            "$push\n"
                           +"$del_obj_ref <-.MAviewer.objs_in label_obj\n"
                           +"$pop\n"
                           +"$link <-.MAviewer.objs_in label_obj"
                     )
                    +"\n$pop\n"
                    ;
      relative => <-.<-;
   };
#endif //MICROAVS_DEV_KIT
   MAlabelObject labelObject {
      obj.name   => "NOOBJLIST "+name_of(<-.<-);
      red        => <-.Params.red;
      green      => <-.Params.green;
      blue       => <-.Params.blue;
      label      => <-.Params.time_string;
      x_pos      => <-.Params.x_pos;
      y_pos      => <-.Params.y_pos;
      front      => <-.Params.front;
      state      => <-.Params.state;
      font_list  => <-.Params.font;
      underline  => <-.Params.underline;
   };
   olink label_obj<export_all=2> => labelObject.obj;
// null/min/max data begin
   reader { out+Mesh+Node_Data; };
   macro SetNullMinMaxValues {
      ilink in_field => <-.reader.out;
      ilink field_params => <-.Params.field_params;
      int ncomp => field_params.ncomp;

      MAset_param set_all_null {
         trigger   => is_valid(.in_value);
         in_value  => min_array(in_field.node_data.null_value);
         def_value => <-.field_params.def_all_null_value;
         value     => <-.field_params.all_null_value;
      };
      MAset_param set_all_min {
         trigger   => is_valid(.in_value);
         in_value  => min_array(in_field.node_data.min);
         def_value => <-.field_params.def_all_min_value;
         value     => <-.field_params.all_min_value;
      };
      MAset_param set_all_max {
         trigger   => is_valid(.in_value);
         in_value  => max_array(in_field.node_data.max);
         def_value => <-.field_params.def_all_max_value;
         value     => <-.field_params.all_max_value;
      };
      MAset_param set_each_null[ncomp] {
         int id    => index_of(set_each_null);
         trigger   => is_valid(.in_value);
         in_value  => in_field.node_data[id].null_value;
         def_value => <-.field_params.each_values[id].def_null_value;
         value     => <-.field_params.each_values[id].null_value;
      };
      MAset_param set_each_min[ncomp] {
         int id    => index_of(set_each_min);
         trigger   => is_valid(.in_value);
         in_value  => in_field.node_data[id].min;
         def_value => <-.field_params.each_values[id].def_min_value;
         value     => <-.field_params.each_values[id].min_value;
      };
      MAset_param set_each_max[ncomp] {
         int id    => index_of(set_each_max);
         trigger   => is_valid(.in_value);
         in_value  => in_field.node_data[id].max;
         def_value => <-.field_params.each_values[id].def_max_value;
         value     => <-.field_params.each_values[id].max_value;
      };
      Node_Data Node_DataWithValues<NEportLevels={0,1}> {
         ilink in_field => <-.in_field;
         ilink field_params => <-.field_params;
         nnodes => in_field.nnodes;
         nnode_data => in_field.nnode_data;
         node_data[nnode_data] {
            ilink in_field => <-.in_field;
            nvals      => in_field.node_data[index_of(node_data)].nvals;
            veclen     => in_field.node_data[index_of(node_data)].veclen;
            id         => in_field.node_data[index_of(node_data)].id;
            values     => in_field.node_data[index_of(node_data)].values;
            null_flag  =>
switch(field_params.each+1,
 field_params.all_null_flag,
 field_params.each_values[index_of(node_data)].null_flag);
            null_value =>
switch(field_params.each+1,
 set_all_null.value,
 set_each_null[index_of(node_data)].value);

// NOTES: min2/max2 are min/max value without null_value
 prim min2<NEvisible=0>
    => min_array(in_field.node_data[index_of(node_data)].values,
                 null_flag, null_value);
 prim max2<NEvisible=0>
    => max_array(in_field.node_data[index_of(node_data)].values,
                 null_flag, null_value);
            min        =>
switch(field_params.each+1,
 switch(field_params.all_min_flag+1,
 min2,
 set_all_min.value)
 ,
 switch(field_params.each_values[index_of(node_data)].min_flag+1,
 min2,
 set_each_min[index_of(node_data)].value)
);
            max        =>
switch(field_params.each+1,
 switch(field_params.all_max_flag+1,
 max2,
 set_all_max.value)
 ,
 switch(field_params.each_values[index_of(node_data)].max_flag+1,
 max2,
 set_each_max[index_of(node_data)].value)
);
            min_vec    => in_field.node_data[index_of(node_data)].min_vec;
            max_vec    => in_field.node_data[index_of(node_data)].max_vec;
            labels     => in_field.node_data[index_of(node_data)].labels;
            units      => in_field.node_data[index_of(node_data)].units;
         };
      };
      MADVcombine_mesh_and_data DVcomb_mesh_and_data {
         in_mesh => <-.in_field;
         in_nd => <-.Node_DataWithValues;
      };
      olink out<export_all=2> => DVcomb_mesh_and_data.out;
   };
   olink field<export_all=2> => SetNullMinMaxValues.out;
// null/min/max data end
};
