/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/readers.v#1 $
*/
//
// MicroAVS Readers
//
flibrary+buffered+global+sort readers <compile_subs=0>
{
   $include MicroAVS/rdtempl.v
//
// MVGEO Reader
//
   MAreader_templ MAmvgeoReader {
      title => "MAFT_MVG_NAME";
      Params.reset_active = 0;
      Params.help_name    = "rdmvg";
      UI {
         searchPattern   = "*.mvg;";
         geom_types_name => <-.title;
         geom_types      = "*.mvg;";
      };
      reader+MAmvgeo_reader {
      };
      MAdataObject dataObject {
         ilink reader => <-.reader;
         in        => <-.reader.out;
         Obj.name  => <-.<-.name;
         Obj.xform => in.xform;
         Datamap {
            ! DatamapValue[0] {
               &v2 => reader.min_h;
               &v3 => reader.min_s;
               &v4 => reader.min_v;
            };
            ! DatamapValue[1] {
               &v2 => reader.max_h;
               &v3 => reader.max_s;
               &v4 => reader.max_v;
            };
            ! DataRange[0] {
               selectValues => reader.select_values;
               &size => reader.color_size;
               &UIMinValue => reader.min_col_val;
               &UIMaxValue => reader.max_col_val;
            };
         };
      };
      olink obj<export_all=2> => dataObject.obj;
   };
//
// Geometry Params
//
   group MAgeom_params{
     int cad_option = 0;
     int render_q   = 10;
     int render_m   = 1;
     int seg        = 25;
     int text       = 0;
     int color      = 1;
     int+nosave def_render_q   = 10;
     int+nosave def_render_m   = 1;
     int+nosave def_seg        = 25;
     int+nosave def_text       = 0;
     int+nosave def_color      = 1;
   };
//
// Geometry Reader
//
   MAreader_templ MAgeomReader {
      title => "MAFT_GEOM_NAME";
      Params.reset_active = 0;
      Params.help_name    = "rdgeom";
      MAgeom_params geom_params;
      filename_to_type{
         options => <-.geom_params;
      };
      UI {
         searchPattern => dataObj.read_GsearchPattern;
         geom_types    => dataObj.read_GsearchPattern;
         MAgeom_params &geom_params => <-.geom_params;
         height+nres => ((266 + (UIdata.UIfonts[0].lineHeight * 3)) + option.height);
         macro option{
            MAgeom_params &geom_params => <-.geom_params;
            ilink parent => <-.mod_panel;
            int x        => <-.fileSelector.x;
            int y        => ((<-.fileSelector.y + <-.fileSelector.height) + 5);
            int width    => (parent.clientWidth - 18);
            int height   => reload_button.y + reload_button.height + 15;
            int visible  => geom_params.cad_option;
            string filename => <-.Params.filename;
            MAUIpanel panel{
               x       => <-.x;
               y       => <-.y;
               width   => <-.width;
               height  => <-.height;
               parent  => <-.parent;
               visible => <-.visible;
            };
            MAUIlabel option_title{
               x      = 0;
               y      = 10;
               width  => parent.clientWidth;
               label  = "ME_3D_CAD_OPTION";
               parent => <-.panel;
            };
            MAUItoggle color_toggle{
               y      => <-.option_title.y + <-.option_title.height;
               label  = "ME_3D_CAD_COL";
               set    => <-.geom_params.color;
               parent => <-.panel;
            };
            macro Render_Method{
               ilink geom_params => <-.geom_params;
               ilink parent => <-.panel;
               int y        => <-.color_toggle.y + <-.color_toggle.height + 5;
               int height   => frame.height;
               MAUIframe frame{
                  y      => <-.y;
                  width  => parent.clientWidth - 5;
                  height => <-.UIradioBox.y + <-.UIradioBox.height + 10;
                  parent => <-.parent;
               };
               string render[2] = {"ME_WIRE_FRAME","ME_TESSELLATE"};
               MAUIradioBoxLabel UIradioBox{
                  x      = 5;
                  y      = 5;
                  width  => parent.clientWidth;
                  parent => <-.frame;
                  labels => <-.render;
                  title  = "ME_RENDER_METHOD";
                  selectedItem => <-.geom_params.render_m;
               };
            };
            macro Render_Quality{
               ilink geom_params => <-.geom_params;
               ilink parent => <-.panel;
               int y        => <-.Render_Method.y + <-.Render_Method.height;
               int height   => frame.height;
               MAUIframe frame{
                  y      => <-.y;
                  width  => parent.clientWidth - 5;
                  height => <-.UIslider.y + <-.UIslider.height + 10;
                  parent => <-.parent;
               };
               MAUIslider UIslider{
                  x      = 5;
                  y      = 5;
                  width  => (<-.parent.clientWidth - 20);
                  min    = 2;
                  max    = 50;
                  mode   = "integer";
                  parent => <-.frame;
                  title  = "ME_RENDER_QUALITY";
                  value  => <-.geom_params.render_q;
               };
            };
            macro Max_Seg{
               ilink geom_params => <-.geom_params;
               ilink parent => <-.panel;
               int y        => <-.Render_Quality.y + <-.Render_Quality.height;
               int height   => frame.height;
               MAUIframe frame{
                  y      => <-.y;
                  width  => parent.clientWidth - 5;
                  height => <-.UIslider.y + <-.UIslider.height + 10;
                  parent => <-.parent;
               };
               MAUIslider UIslider{
                  x      = 5;
                  y      = 5;
                  width  => (<-.parent.clientWidth - 20);
                  min    = 2;
                  max    = 100;
                  mode   = "integer";
                  parent => <-.frame;
                  title  = "ME_MAX_CURVE_SEGMENTS";
                  value  => <-.geom_params.seg;
               };
            };
            macro Screen_Text{
               ilink geom_params => <-.geom_params;
               ilink parent => <-.panel;
               int y        => <-.Max_Seg.y + <-.Max_Seg.height;
               int height   => frame.height;
               MAUIframe frame{
                  y      => <-.y;
                  width  => parent.clientWidth - 5;
                  height => <-.UIradioBox.y + <-.UIradioBox.height + 10;
                  parent => <-.parent;
               };
               string render[2] = {"ME_BOX","ME_STROKE"};
               MAUIradioBoxLabel UIradioBox{
                  x      = 5;
                  y      = 5;
                  parent => <-.frame;
                  labels => <-.render;
                  title  = "ME_SCREEN_TEXT";
                  selectedItem => <-.geom_params.text;
               };
            };
            MAUIbutton reset_button {
               y       => <-.Screen_Text.y + <-.Screen_Text.height + 10;
               width   = 60;
               parent  => <-.panel;
               label   = "MAUI_RESET";
            };
            MAUIbutton reload_button {
               x       => <-.reset_button.x + reset_button.width + 5;
               y       => <-.reset_button.y;
               width   => parent.clientWidth - <-.reset_button.width - 15;
               parent  => <-.panel;
               label   => "MARFLD_RELOAD";
               do      = 0;
            };
            GMOD.parse_v+nosave reset {
               v_commands => "$push -usr\n"
                           + "render_q = def_render_q;\n"
                           + "render_m = def_render_m;\n"
                           + "seg      = def_seg;\n"
                           + "text     = def_text;\n"
                           + "color    = def_color;\n"
                           + "$pop\n";
               trigger    => <-.reset_button.do;
               on_inst    = 0;
               relative   => <-.geom_params;
            };
            GMOD.parse_v+nosave set_reload{
               v_commands = "active = 1;\n";
               active     => (strlen(<-.filename) != 0);
               on_inst    =  1;
               relative   => <-.reload;
            };
            GMOD.parse_v+nosave reload{
               v_commands = "$push -usr\n"
                           +"filename = Params.filename;\n"
                           +"$pop\n";
               trigger    => <-.reload_button.do;
               active     = 0;
               on_inst    =  0;
               relative   => <-;
            };
         };
      };
      reader+MAgeom_reader {
      };

      MADVextract_mesh extract_mesh{
         in => <-.reader.out;
      };
      link fld_switch<NEportLevels=1> => switch((geom_params.color + 1),extract_mesh.out,reader.out);

/*  for MicroAVS5.0 cut_plane */
      ilink+nres in_pick<export=1> => <-.MAviewer.picked_obj;
      MAcut_plane_params cut_plane_params;
      MAcut_plane MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.fld_switch;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.cut_plane_params;
      };
//      olink plane_axis_obj => MAcut_plane.plane_axis_obj.obj;
      MAdataObject dataObject {
         MAcut_plane_params &cut_plane_params => <-.cut_plane_params;
         DefaultXform+OPort Xform;
         in                    => <-.MAcut_plane.out_fld;
         child_objs            => {<-.MAcut_plane.plane_axis_obj};
         Obj.name              => <-.<-.name;
         Obj.xform             => <-.Xform;
         &Obj.cut_plane_params => <-.cut_plane_params;
         Datamap { ! DataRange[0] { selectValues = 0; }; };
      };

/*  for MicroAVS5.0 cut_plane */

      macro dataObjects {
         imlink in_fields => reader.fields;
         imlink in_names  => reader.names;
         MAdataObject dos[array_size(in_fields)] {
            DefaultXform+OPort Xform;
            in+nres       => <-.in_fields[index_of(dos)];
            Obj.name+nres => <-.<-.in_names[index_of(dos)];
            Obj.xform     => <-.Xform;
            Datamap { ! DataRange[0] { selectValues = 0; }; };
         };
         MAgroupObject groupObject {
            child_objs => <-.dos.obj;
            Top.name   => <-.<-.<-.name;
            Datamap { ! DataRange[0] { selectValues = 0; }; };
         };
         olink obj => groupObject.obj;
      };
      olink obj<NEcolor0=16711680, export_all=2>
         => switch(reader.one_obj + 1, dataObjects.obj, dataObject.obj);
   };
//
// Image Reader
//
   MAreader_templ MAimageReader {
      title => "MAFT_IMAGE_NAME";
      // MicroAVS2.0 for Compativility begin
      flip<NEvisible=1, export=3> = 0;
      // MicroAVS2.0 for Compativility end
      Params.reset_commands = "flip=0;";
      Params.help_name      = "rdimage";

      reader+MAimage_reader {
         flip => <-.Params.flip;
      };
#ifdef MICROAVS_DEV_KIT
      MAplugin_filter Plugin_Filter {
         dll_name+nres  => MicroAVScontroller.Params.params.plugin_name;
         in+nres        => <-.reader.out;
         go+nres        => MicroAVScontroller.Params.params.plugin_selected;
      };
      GMOD.parse_v set_output {
         v_commands =>
              "$push -usr\n"
            + switch(Plugin_Filter.go+1, 
                     "dataObject.in => <-.reader.out;", 
                     "dataObject.in => <-.Plugin_Filter.out;")
            + "\n$pop\n"
			+"$push\n"
			+"$del_obj_ref <-.dataObject.obj <-.obj\n"
            +"$pop\n"
            +"$link <-.dataObject.obj <-.obj"
			+"\n$pop\n";
         active = 1;
         trigger => <-.Plugin_Filter.done;
         relative => <-;
         on_inst = 0;
      };
#endif //MICROAVS_DEV_KIT
      UI {
         searchPattern => dataObj.read_IsearchPattern;
         image_types   => dataObj.read_IsearchPattern;
         MAUIframe panel {
            parent => <-.mod_panel;
            x      = 0;
            y      => <-.y;
            width  = 235;
            height = 40;
         };
         MAUItoggle flip_toggle {
            parent => <-.panel;
            label  =  "Flip Image"; // Later
            y      => 4;
            width  => .parent.width;
            set    => <-.Params.flip;
         };
      };
      MAdataObject2D dataObject {
         DefaultXform+OPort Xform;
         in        => <-.reader.out;
         Obj.name  => <-.<-.name
                     + str_format(" [%d X %d]",
                               reader.out.dims[0], reader.out.dims[1]);
         Obj.xform => <-.Xform;
      };
      olink field<export_all=2> => reader.out;
      olink obj<export_all=2>   => dataObject.obj;
   };

//
// Field Reader with Muti time steps
//
   MAmtreader_templ MAfieldReader {
      title => "MAFT_FIELD_NAME";

      // MicroAVS2.0 for Compativility begin
      portable<NEvisible=1, export=3> = 1;
      swap    <NEvisible=1, export=3> = 0;
      // MicroAVS2.0 for Compativility end

      Params.reset_commands     = "portable=1;swap=0;";
      Params.help_name          = "rdfield";

      reader+MAfield_reader {
         portable    => <-.Params.portable;
         swap        => switch(.portable+1, <-.Params.swap, 0);
         flip        => <-.Params.flip;
         stepno      => <-.Params.stepno;
         nsteps      => <-.Params.nsteps;
         time_string => <-.Params.time_string;
/*  for MicroAVS5.0 crop/downsize  start  */
         min0        => <-.Params.field_params.crop_imin;
         min1        => <-.Params.field_params.crop_jmin;
         min2        => <-.Params.field_params.crop_kmin;
         max0        => <-.Params.field_params.crop_imax;
         max1        => <-.Params.field_params.crop_jmax;
         max2        => <-.Params.field_params.crop_kmax;
         factor0     => <-.Params.field_params.downsize_i;
         factor1     => <-.Params.field_params.downsize_j;
         factor2     => <-.Params.field_params.downsize_k;
         end0        => <-.Params.field_params.end_i;
         end1        => <-.Params.field_params.end_j;
         end2        => <-.Params.field_params.end_k;
         check       => <-.Params.field_params.crop_dwn_on;
         set         => <-.Params.field_params.crop_dwn_set;
         exec        => <-.Params.field_params.exec;
/*  for MicroAVS5.0 crop/downsize  end  */
         &out;
         store_all   => <-.Params.store_all;
      };
#ifdef MICROAVS_DEV_KIT
      MAplugin_filter Plugin_Filter {
         dll_name+nres  => MicroAVScontroller.Params.params.plugin_name;
         in+nres        => <-.reader.out;
         go+nres        => MicroAVScontroller.Params.params.plugin_selected;
      };
      GMOD.parse_v set_output {
         v_commands =>
              "$push -usr\n"
            + switch(Plugin_Filter.go+1, 
                     "SetNullMinMaxValues.in_field=> <-.reader.out;", 
                     "SetNullMinMaxValues.in_field=> <-.Plugin_Filter.out;")
            + "\n$pop\n";
         active = 1;
         trigger => <-.Plugin_Filter.done;
         relative => <-;
         on_inst = 0;
      };
#endif //MICROAVS_DEV_KIT
      UI {
         searchPattern => dataObj.read_FsearchPattern;
         field_types   => dataObj.read_FsearchPattern;
         MAUIframe portable_panel {
            parent => <-.mod_panel;
            x      = 0;
            y      => <-.y;
            width  = 235;
            height = 60;
         };
         MAUItoggle portable_toggle {
            parent  => <-.portable_panel;
            label   = "Portable (XDR)";
            y       = 5;
            width   => .parent.width;
            set     => <-.Params.portable;
         };
         MAUItoggle swap_toggle {
            parent  => <-.portable_panel;
            label   = "Swap Bytes";
            set     = 0;
            x       = 20;
            y       => <-.portable_toggle.height+<-.portable_toggle.y+4;
            width   => .parent.width;
            active  => !<-.Params.portable;
            set     => <-.Params.swap;
         };
         height0 = 275;
         height0 = 300;
         y2      => portable_panel.y + portable_panel.height;

/*  for MicroAVS downsize/crop_UI  */

         macro crop_dwnUI {
            ilink parent       => <-.mod_panel;
            ilink Params       => <-.Params;
            ilink in_field     => <-.in_field;
            int y              => <-.dataRangeUI.y + <-.dataRangeUI.height;
            int height         => crop_dwn_panel.height +15;
            string filename    => <-.Params.filename;
            int exec           => <-.Params.field_params.exec;
            int+nosave crop_dwn_on  => <-.Params.field_params.crop_dwn_on;
            int+nosave crop_dwn_set => <-.Params.field_params.crop_dwn_set;
            MAUIframe crop_dwn_panel {
               parent => <-.parent;
               x      = 0;
               y      => <-.y;
               width  => .parent.clientWidth - 18;
               height => <-.reload_button.y + <-.reload_button.height + 10;
            };
            MAUItoggle crop_dwn_toggle {
               parent    => <-.crop_dwn_panel;
               x         = 5;
               y         = 10;
               width     = 200;
               height    = 25;
               alignment = "center";
               label     => "MARFLD_CROP_DOWNSIZE";
               set       => <-.Params.field_params.crop_dwn_on;
            };
            MAUIbutton crop_button {
               parent => <-.crop_dwn_panel;
               x      => (<-.crop_dwn_panel.width - width) / 2;
               y      => <-.crop_dwn_toggle.y + <-.crop_dwn_toggle.height + 5;
               label  => "MARFLD_SET_CROP";
               active => crop_dwn_toggle.set;
               do     = 0;
            };
            MAUIbutton dwonsize_button {
               parent => <-.crop_dwn_panel;
               x      => (<-.crop_dwn_panel.width - width) / 2;
               y      => <-.crop_button.y + <-.crop_button.height + 5;
               label  => "MARFLD_SET_DOWNSIZE";
               do     = 0;
               active => crop_dwn_toggle.set;
            };
            GMOD.parse_v reload{
               v_commands = "$push -usr\n"
                           +" exec = 1;\n"
                           +"$pop\n"
                           +"$push -usr\n"
                           +"filename = Params.filename;\n"
                           +"$pop\n";
               trigger    => <-.reload_button.do;
               on_inst    = 0;
               relative   => <-;
            };

    /*  ߂ɓǂݍ񂾃f[^̏ۑ|Zbgp̒l */
            group oparams{
               int+nosave crop_imin;
               int+nosave crop_jmin;
               int+nosave crop_kmin;
               int+nosave crop_imax;
               int+nosave crop_jmax;
               int+nosave crop_kmax;
               float+nosave downsize_i;
               float+nosave downsize_j;
               float+nosave downsize_k;
               int+nosave crop_dwn_on;
               int+nosave crop_dwn_set;
            };
            GMOD.parse_v set_oparams{
               v_commands = "$push -usr\n"
                           + "oparams.crop_imin    = Params.field_params.crop_imin;\n"
                           + "oparams.crop_jmin    = Params.field_params.crop_jmin;\n"
                           + "oparams.crop_kmin    = Params.field_params.crop_kmin;\n"
                           + "oparams.crop_imax    = Params.field_params.crop_imax;\n"
                           + "oparams.crop_jmax    = Params.field_params.crop_jmax;\n"
                           + "oparams.crop_kmax    = Params.field_params.crop_kmax;\n"
                           + "oparams.downsize_i   = Params.field_params.downsize_i;\n"
                           + "oparams.downsize_j   = Params.field_params.downsize_j;\n"
                           + "oparams.downsize_k   = Params.field_params.downsize_k;\n"
                           + "oparams.crop_dwn_on  = Params.field_params.crop_dwn_on;\n"
                           + "oparams.crop_dwn_set = Params.field_params.crop_dwn_set;\n"
                           + "$pop\n"
                           + "$push -usr\n"
                           + "set_oparams.active = 0;\n"
                           + "$pop\n";
               trigger  => is_valid(in_field);
               on_inst  = 0;
               relative => <-;
            };

            MAUIbutton reset_button {
               parent => <-.crop_dwn_panel;
               x      => (<-.crop_dwn_panel.width
                          - <-.reload_button.width
                          - .width -10) / 2;
               y      => <-.dwonsize_button.y + <-.dwonsize_button.height + 15;
               width  = 70;
               label  => "MAUI_RESET";
               do     = 0;
               active => crop_dwn_toggle.set;
            };
            MAUIbutton reload_button {
               parent  => <-.crop_dwn_panel;
               x       => <-.reset_button.x
                          + <-.reset_button.width + 10;
               y       => <-.reset_button.y;
               width   = 140;
               label   => "MARFLD_RELOAD";
               do      = 0;
               active => crop_dwn_toggle.set;
            };
            GMOD.parse_v reset_oparams{
               v_commands = "$push -usr\n"
                           + "crop.crop_imin.value      = oparams.crop_imin;\n"
                           + "crop.crop_jmin.value      = oparams.crop_jmin;\n"
                           + "crop.crop_kmin.value      = oparams.crop_kmin;\n"
                           + "crop.crop_imax.value      = oparams.crop_imax;\n"
                           + "crop.crop_jmax.value      = oparams.crop_jmax;\n"
                           + "crop.crop_kmax.value      = oparams.crop_kmax;\n"
                           + "downsize.downsize_i.value = oparams.downsize_i;\n"
                           + "downsize.downsize_j.value = oparams.downsize_j;\n"
                           + "downsize.downsize_k.value = oparams.downsize_k;\n"
                           + "crop_dwn_set              = oparams.crop_dwn_set;\n"
                           + "$pop\n";
               trigger  => <-.reset_button.do;
               on_inst  = 0;
               relative => <-;
            };


    /*  crop̒lݒ肵Ă_CAO */
            macro crop{
               ilink parent            => <-.crop_dwn_panel;
               ilink field_params      => <-.Params.field_params;
               ilink crop_on           => <-.crop_button.do;
               ilink oparams           => <-.oparams;
               int+nosave crop_dwn_on  => <-.Params.field_params.crop_dwn_on;
               MAUIcloseDialog crop_dialog{
                  x       = 44;
                  y       = 44;
                  height  => <-.k_panel.y + <-.k_panel.height + 80;
                  visible => <-.crop_on;
                  title = "MARFLD_SET_CROP";
               };

               MAUIframe i_panel {
                  parent  => <-.crop_dialog;
                  x       => (<-.crop_dialog.clientWidth - width) / 2;
                  y       = 10;
                  width   => (<-.crop_dialog.clientWidth - 10);
                  height  => <-.crop_imax.y + <-.crop_imax.height + 10;
                  visible => <-.crop_on;
               };
               MAUIlabel i_label {
                  parent    => <-.i_panel;
                  x         => (<-.i_panel.clientWidth - width) / 2;
                  y         = 10;
                  width     => (<-.i_panel.clientWidth - 10);
                  visible   => <-.crop_on;
                  alignment = "center";
                  label     => "MARFLD_SET_I";
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_imin {
                  title   => "MARFLD_SET_MIN";
                  parent  => <-.i_panel;
                  x+nres  => (<-.i_panel.clientWidth - .width ) / 2;
                  y+nres  => <-.i_label.y + <-.i_label.height;
                  min     = 0;
                  max     => <-.field_params.end_i - 1;
                  value   => <-.field_params.crop_imin;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_imax {
                  title   => "MARFLD_SET_MAX";
                  parent  => <-.i_panel;
                  x+nres  => <-.crop_imin.x;
                  y+nres  => <-.crop_imin.y + <-.crop_imin.height + 5;
                  min     = 0;
                  max     => <-.field_params.end_i - 1;
                  value   => <-.field_params.crop_imax;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIframe j_panel {
                  parent  => <-.crop_dialog;
                  x       => (<-.crop_dialog.clientWidth - width) / 2;
                  y       => <-.i_panel.y + <-.i_panel.height;
                  width   => (<-.crop_dialog.clientWidth - 10);
                  height  => <-.crop_jmax.y + <-.crop_jmax.height + 10;
                  visible => <-.crop_on;
               };
               MAUIlabel j_label {
                  parent    => <-.j_panel;
                  x         => (<-.j_panel.clientWidth - width) / 2;
                  y         = 10;
                  width     => (<-.j_panel.clientWidth - 10);
                  visible   => <-.crop_on;
                  alignment = "center";
                  label     => "MARFLD_SET_J";
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_jmin {
                  title   => "MARFLD_SET_MIN";
                  parent  => <-.j_panel;
                  x+nres  => (<-.j_panel.clientWidth - .width ) / 2;
                  y+nres  => <-.j_label.y + <-.j_label.height;
                  min     = 0;
                  max     => <-.field_params.end_j - 1;
                  value   => <-.field_params.crop_jmin;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_jmax {
                  title   => "MARFLD_SET_MAX";
                  parent  => <-.j_panel;
                  x+nres  => <-.crop_jmin.x;
                  y+nres  => <-.crop_jmin.y + <-.crop_jmin.height + 5;
                  min     = 0;
                  max     => <-.field_params.end_j - 1;
                  value   => <-.field_params.crop_jmax;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIframe k_panel {
                  parent  => <-.crop_dialog;
                  x       => (<-.crop_dialog.clientWidth - width) / 2;
                  y       => <-.j_panel.y + <-.j_panel.height;
                  width   => (<-.crop_dialog.clientWidth - 10);
                  height  => <-.crop_kmax.y + <-.crop_kmax.height + 10;
                  visible => <-.crop_on;
               };
               MAUIlabel k_label {
                  parent    => <-.k_panel;
                  x         => (<-.k_panel.clientWidth - width) / 2;
                  y         = 10;
                  width     => (<-.k_panel.clientWidth - 10);
                  visible   => <-.crop_on;
                  alignment = "center";
                  label     => "MARFLD_SET_K";
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_kmin {
                  title   => "MARFLD_SET_MIN";
                  parent  => <-.k_panel;
                  x+nres  => (<-.k_panel.clientWidth - .width ) / 2;
                  y+nres  => <-.k_label.y + <-.k_label.height;
                  min     = 0;
                  max     => <-.field_params.end_k - 1;
                  value   => <-.field_params.crop_kmin;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIslider crop_kmax {
                  title   => "MARFLD_SET_MAX";
                  parent  => <-.k_panel;
                  x+nres  => <-.crop_kmin.x;
                  y+nres  => <-.crop_kmin.y + <-.crop_kmin.height + 5;
                  min     = 0;
                  max     => <-.field_params.end_k - 1;
                  value   => <-.field_params.crop_kmax;
                  mode    = "integer";
                  visible => <-.crop_on;
                  active    => <-.crop_dwn_on;
               };
            };

    /*  downsize̒lݒ肵Ă_CAO */
            macro downsize{
               ilink parent       => <-.crop_dwn_panel;
               ilink field_params => <-.Params.field_params;
               ilink downsize_on  => <-.dwonsize_button.do;
               int+nosave crop_dwn_on => <-.Params.field_params.crop_dwn_on;
               MAUIcloseDialog downsize_dialog{
                  x       = 44;
                  y       = 84;
                  height  => <-.downsize_panel.height + <-.downsize_panel.y + 80;
                  visible => <-.downsize_on;
                  title = "MARFLD_SET_DOWNSIZE";
               };
               MAUIframe downsize_panel {
                  parent  => <-.downsize_dialog;
                  x       => (<-.downsize_dialog.clientWidth - width) / 2;
                  y       = 10;
                  width   => (<-.downsize_dialog.clientWidth - 10);
                  height  => <-.downsize_k.y + <-.downsize_k.height + 15;
                  visible => <-.downsize_on;
               };
               MAUIslider2 downsize_i {
                  title   => "MARFLD_SET_I";
                  parent  => <-.downsize_panel;
                  x+nres  => (<-.downsize_panel.width - .width ) / 2;
                  y+nres  = 20;
                  min     = 1.0;
                  max     = 12.0;
                  value   => <-.field_params.downsize_i;
                  mode    = "real";
                  visible => <-.downsize_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIslider2 downsize_j {
                  title   => "MARFLD_SET_J";
                  parent  => <-.downsize_panel;
                  x+nres  => (<-.downsize_panel.width - .width ) / 2;
                  y+nres  => <-.downsize_i.y + <-.downsize_i.height + 5;
                  min     = 1.0;
                  max     = 12.0;
                  value   => <-.field_params.downsize_j;
                  mode    = "real";
                  visible => <-.downsize_on;
                  active    => <-.crop_dwn_on;
               };
               MAUIslider2 downsize_k {
                  title   => "MARFLD_SET_K";
                  parent  => <-.downsize_panel;
                  x+nres  => (<-.downsize_panel.width - .width ) / 2;
                  y+nres  => <-.downsize_j.y + <-.downsize_j.height + 5;
                  min     = 1.0;
                  max     = 12.0;
                  value   => <-.field_params.downsize_k;
                  mode    = "real";
                  visible => <-.downsize_on;
                  active    => <-.crop_dwn_on;
               };
            };
         };

         height => ((height0
                   + ((<-.Params.nsteps > 1) * MAUItimeStepControl.height))
                   + dataRangeUI.height
                   + crop_dwnUI.height
                   );

/*  for MicroAVS downsize/crop_UI  */

      };
/*
 * cropdownsizeݒ肵AvۑꍇAf[^̍ēǍ݂̃gK[ɎgB
 * Avǂݍ܂ꂽ̂ݎs邽߁Aactive̒lƂĂPKvicrop_dwn_setjB
 * field.cǂāAf[^ēǍ݂Ƃm点tOɒlZbgi2001.11.20j
 *
*/
      GMOD.parse_v reload_update{
         v_commands = "$push -usr\n"
                     + "Params.field_params.crop_dwn_set = 1;\n"
                     + "$pop\n";
         on_inst  =  0;
         trigger  => <-.Params.field_params.exec;
         active   =  1;
         relative => <-;
      };

      GMOD.parse_v set_reload{
         v_commands = "$push -usr\n"
                     + "Params.field_params.exec = 1;\n"
                     + "$pop\n"
                     +"$push -usr\n"
                     +"filename = Params.filename;\n"
                     +"$pop\n";
         on_inst  =  0;
         trigger  => <-.reader.done;
         active   => ((<-.Params.field_params.crop_dwn_on == 1) && (Params.field_params.crop_dwn_set == 1));
         relative => <-;
      };
   };

//
// Ucd Reader with Muti time steps
//
   MAmtreader_templ MAucdReader {
      title => "MAFT_UCD_NAME";
      Params {
         string+nosave cycle_type = "";
         int+nosave new_format    = 0;
      };
      Params.help_name    = "rducd";
      reader+MAucd_reader {
         current_step => <-.Params.stepno;
         total        => <-.Params.nsteps;
         step_title   => <-.Params.time_string;
         cycle_type   => <-.Params.cycle_type;
         new_format   => <-.Params.new_format;
         store_all    => <-.Params.store_all;
      };
#ifdef MICROAVS_DEV_KIT
      MAplugin_filter Plugin_Filter {
         dll_name+nres  => MicroAVScontroller.Params.params.plugin_name;
         in+nres        => <-.reader.out;
         go+nres        => MicroAVScontroller.Params.params.plugin_selected;
      };
      GMOD.parse_v set_output {
         v_commands =>
              "$push -usr\n"
            + switch(Plugin_Filter.go+1, 
                     "SetNullMinMaxValues.in_field=> <-.reader.out;", 
                     "SetNullMinMaxValues.in_field=> <-.Plugin_Filter.out;")
            + "\n$pop\n";
         active = 1;
         trigger => <-.Plugin_Filter.done;
         relative => <-;
         on_inst = 0;
      };
#endif //MICROAVS_DEV_KIT
      UI {
         searchPattern => dataObj.read_UsearchPattern;
         ucd_types     => dataObj.read_UsearchPattern;
         y2            => y;
      };
   };

//
// CUBE Data Reader
//
   MAmtreader_templ MAcubeReader {
      title => "MAFT_CUBE_NAME";

      Params.reset_commands     = "";
      Params.help_name          = "rdcube";
      UI {
         searchPattern   = "*.cube;";
         geom_types_name => <-.title;
         geom_types      = "*.cube;";
         y2              => y;
      };
      reader+MAcube_reader {
      };
      olink field<export_all=2> => reader.out;
   };

//
//Protein data bank reader
//
   MAreader_templ MApdbReader {
      title => "MAFT_PDB_NAME";

      Params.reset_commands     =  "Params.sphere=4;"
                                  +"Params.sphere_min=1;"
                                  +"Params.sphere_max=20;"
                                  +"Params.cylinder=3;"
                                  +"Params.cylinder_min=1;"
                                  +"Params.cylinder_max=20;"
                                  +"Params.cpk=0;"
                                  +"Params.jitter=50;"
                                  +"Params.jitter_min=0;"
                                  +"Params.jitter_max=100;"
                                  +"Params.text_vis=0;"
                                  +"Params.num_text_vis=1;"
                                  +"Params.font_size=10;"
                                  +"Params.font_min=1;"
                                  +"Params.font_max=100;"
                                  +"Params.elem_edit=0;"
                                  +"Params.rad_type=0;"
                                  +"Params.factor=0.25;"
                                  +"Params.cpk_rad_type=0;"
                                  +"Params.cpk_factor=0.7;"
                                  ;
      Params.help_name          = "rdpdb";
      Params {
         int sphere_min = 1;
         int sphere_max = 20;
         int sphere = 4;
         int cylinder_min = 1;
         int cylinder_max = 20;
         int cylinder = 3;
         int cpk = 0;
         int jitter = 50;
         int jitter_min = 0;
         int jitter_max = 100;
         boolean text_vis = 0;
         boolean num_text_vis = 1;
         int font_size = 10;
         int font_min = 1;
         int font_max = 100;
         int+nosave elem_edit = 0;
         boolean+nosave elem_edit_active = 1;
         int rad_type = 0;	//0:VDW/1:Ion/2:user-defined/3:constant
         float factor = 0.25;
         int cpk_rad_type = 0;	//0:VDW/1:Ion/2:user-defined
         float cpk_factor = 0.7;
      };
      UI {
         searchPattern   = "*.pdb;";
         geom_types_name => <-.title;
         geom_types      = "*.pdb;";
#ifdef MSDOS
         height => y + font_slider.y + font_slider.height + 15;
#else
         height => 229 + font_slider.y + font_slider.height + 15;
#endif //MSDOS
         MAUIframe option_panel {
            parent => <-.mod_panel;
            x      = 0;
            y      => <-.y;
            width  = 235;
            height => <-.font_slider.y + <-.font_slider.height + 15;
         };
         MAUIradioBoxLabel radiobox_label {
            title = "MAPDB_RADIO";
            parent => <-.option_panel;
            x = 5;
            y = 5;
            labels => {"MAPDB_BALSTICK", "MAPDB_CPK"};
            &selectedItem => <-.Params.cpk;
         };
         MAUIradioBoxLabel radiobox_radius[2] {
            title = "MAPDB_RADIO_RADIUS";
            parent => <-.option_panel;
            x = 5;
            y => <-.radiobox_label.y + <-.radiobox_label.height;
            labels => 
               {"MAPDB_VDW", "MAPDB_ION", "MAPDB_USER", "MAPDB_RAD_UNIFORM"};
         };
         !radiobox_radius[0] {
            visible => !<-.Params.cpk;
            &selectedItem => <-.Params.rad_type;
         };
         !radiobox_radius[1] {
            visible => <-.Params.cpk;
            !RBcmdList[3] { active => 0; };
            &selectedItem => <-.Params.cpk_rad_type;
         };
         MAUIslider radius_factor_slider {
            title => "MAPDB_RADIUS_FACTOR";
            parent => <-.option_panel;
            y+nres => <-.radiobox_radius[0].y + <-.radiobox_radius[0].height + 5;
            min = 0.0;
            max = 1.0;
            value => switch(<-.Params.cpk+1,
                            <-.Params.factor, <-.Params.cpk_factor);
            decimalPoints = 2;
            active => <-.Params.rad_type != 3;
         };
         MAUIbutton maeledit_button {
            parent => <-.option_panel;
            y => <-.radius_factor_slider.y + <-.radius_factor_slider.height + 5;
            label => "MAELEDIT_VIZ";
            do => <-.Params.elem_edit;
#ifdef MICROAVS_DEV_KIT
            active => <-.Params.elem_edit_active;
#else
            active = 0; // only MicroAVS supported
#endif //MICROAVS_DEV_KIT
         };
         MAUIslider2 sphere_slider {
            parent => <-.option_panel;
            x = 5;
            y => <-.maeledit_button.y + <-.maeledit_button.height + 15;
            min => <-.Params.sphere_min;
            max => <-.Params.sphere_max;
            value => <-.Params.sphere;
            mode = 1;
            decimalPoints = 0;
            precision_oonly = 1;
            title = "MAPDB_SPHERE";
            //valEditor.UI.min_field.min=0;
         };
         MAUIslider2 cylinder_slider {
            parent => <-.option_panel;
            x = 5;
            y+nres => <-.sphere_slider.y + <-.sphere_slider.height + 5;
            min => <-.Params.cylinder_min;
            max => <-.Params.cylinder_max;
            value => <-.Params.cylinder;
            mode = 1;
            decimalPoints = 0;
            precision_oonly = 1;
            title = "MAPDB_CYLINDER";
            //valEditor.UI.min_field.min=0;
            active => !<-.Params.cpk;
         };
         MAUItoggle text_toggle {
            parent => <-.option_panel;
            y =><-.cylinder_slider.y + <-.cylinder_slider.height + 5;
            width => parent.clientWidth / 2;
            set => <-.Params.text_vis;
            label = "MAPDB_TEXT_VIS";
         };
         MAUItoggle num_text_toggle {
            parent => <-.option_panel;
            x => <-.text_toggle.x + <-.text_toggle.width;
            y => <-.text_toggle.y;
            width => <-.text_toggle.width;
            set => <-.Params.num_text_vis;
            label = "MAPDB_NUM_TEXT_VIS";
            active => <-.Params.text_vis;
         };
         MAUIslider2 text_jitter_slider {
            parent => <-.option_panel;
            x = 5;
            y => <-.text_toggle.y + <-.text_toggle.height + 5;
            min => <-.Params.jitter_min;
            max => <-.Params.jitter_max;
            value => <-.Params.jitter;
            mode = 1;
            decimalPoints = 0;
            precision_oonly = 1;
            title = "MAPDB_JITTER";
            valEditor.UI.min_field.min=0;
            active => <-.Params.text_vis;
         };
         MAUIslider2 font_slider {
            parent => <-.option_panel;
            x = 5;
            y+nres => <-.text_jitter_slider.y + <-.text_jitter_slider.height + 10;
            min => <-.Params.font_min;
            max => <-.Params.font_max;
            mode = 1;
            decimalPoints = 0;
            value => <-.Params.font_size;
            mode = 1;
            precision_oonly = 1;
            title = "MAPDB_FONT_SIZE";
            valEditor.UI.min_field.min=0;
            active => <-.Params.text_vis;
         };
      };
#ifdef MICROAVS_DEV_KIT
      MAcontrol_process exec_elem_editor {
         commands =>
             "MAeledit" + " "
            //+"$XP_PATH<0>/runtime/atom.tab" + " "
            +<-.reader.atom_table_file + " "
            +"MA_LOCALE" + " "
            +"\""+"MicroAVS."+name_of(<-.<-)
            +"{Params.elem_edit_active=0;};" +"\"\n"
            + " "
            +"\""+"MicroAVS."+name_of(<-.<-)
            +"{reader.filename=<-.filename;};" +"\"\n"
            + " "
            +"\""+"MicroAVS."+name_of(<-.<-)
            +"{Params.elem_edit_active=1;};" +"\"\n"
            ;
         mode => <-.Params.elem_edit;
         hProcess<NEvisible=1>;
      };
#endif // MICROAVS_DEV_KIT
      reader+MApdb_reader {
         cpk => <-.Params.cpk;
         rad_type => switch(cpk+1, <-.Params.rad_type, <-.Params.cpk_rad_type);
         factor => switch(cpk+1, <-.Params.factor, <-.Params.cpk_factor);
         num_flag => <-.Params.num_text_vis;
      };
      MAdataObject dataObject_Sticks {
         in => <-.reader.Sticks;
         Obj.name = "NOOBJLIST Group Stick PDB";
         Obj.xform => in.xform;
         Datamap { ! DataRange[0] { selectValues = 0; }; };
         Props.subdiv => <-.<-.Params.cylinder;
         Props.dir_pt_size = 2;
         Props.inherit = 0;
         Props.col[3] = {1, 1, 1};
         Modes.mode[5] =>
            {0, switch((<-.<-.Params.cylinder != 2)+1, 1, 3), 0, 0, 0};
      };
      MAdataObject dataObject_TextField {
         in        => <-.reader.TextField;
         Obj.name = "NOOBJLIST Group Text PDB";
         Obj.xform => in.xform;
         Datamap { ! DataRange[0] { selectValues = 0; }; };
         Props.jitter => <-.<-.Params.jitter;
         Props.font => "-adobe-times-bold-r-*-*-" + <-.<-.Params.font_size + "-*-*-*-*-*-*-*";
      };
      MAdataObject dataObject_Ball {
         in        => <-.reader.Balls;
         Obj.name  => <-.<-.name;
         Obj.xform => in.xform;
         Datamap { ! DataRange[0] { selectValues = 0; }; };
         Props.subdiv => <-.<-.Params.sphere;
         child_objs+nosave =>
         switch(<-.Params.text_vis * 2 + (!<-.Params.cpk),
            { <-.dataObject_Sticks.obj },
            { <-.dataObject_TextField.obj },
            { <-.dataObject_Sticks.obj, <-.dataObject_TextField.obj }
         );
      };
      olink obj => dataObject_Ball.obj;
   };

//
//Gaussian data reader
//
   MApdbReader MAlogReader {
      title => "MAFT_LOG_NAME";
      Params.help_name          = "rdlog";
      UI {
         searchPattern   = "*.log;";
         geom_types_name => <-.title;
         geom_types      = "*.log;";
         radiobox_label.labels    => {"MALOG_BALSTICK", "MALOG_CPK"};
         radiobox_label.title     = "MALOG_RADIO";
         sphere_slider.title      = "MALOG_SPHERE";
         cylinder_slider.title    = "MALOG_CYLINDER";
         text_toggle.label        = "MALOG_TEXT_VIS";
         text_jitter_slider.title = "MALOG_JITTER";
         font_slider.title        = "MALOG_FONT_SIZE";
      };
      reader+MAlog_reader {
      };
      dataObject_Sticks.Obj.name = "NOOBJLIST Group Stick LOG";
      dataObject_TextField.Obj.name = "NOOBJLIST Group Text LOG";
   };

//
//LightWave3D data reader
//
   MAreader_templ MAlwoReader {
      title => "MAFT_LWO_NAME";

      Params.reset_active = 0;
      Params.help_name    = "rdlwo";
      UI {
         searchPattern   = "*.lwo;";
         geom_types_name => <-.title;
         geom_types      = "*.lwo;";
      };
      reader+MAlwo_reader {
      };
      macro dataObjects {
         imlink in_fields => reader.fields;
         MAdataObject dos[array_size(in_fields)] {
            DefaultXform+OPort Xform;
            in+nres   => <-.in_fields[index_of(dos)];
            Obj.name  = "NOOBJLIST Group LightWave3D";
            Obj.xform => <-.Xform;
            Datamap { ! DataRange[0] { selectValues = 0; }; };
         };
         MAgroupObject groupObject {
            child_objs => <-.dos.obj;
            Top.name   => <-.<-.<-.name;
            Datamap { ! DataRange[0] { selectValues = 0; }; };
         };
         olink obj => groupObject.obj;
      };
      olink obj => dataObjects.obj;
   };

//
//MicroAVS Geometory ASCII Format
//

   MAmtreader_templ MAmgfReader {
      title => "MAFT_MGF_NAME";

      Params.help_name = "rdmgf";
      UI<locked=0> {
         -dataRangeUI;
         group dataRangeUI {
            int height = 0;
         };
         searchPattern   = "*.mgf;";
         geom_types_name => <-.title;
         geom_types      = "*.mgf;";
         y2              => y;
      };
      reader+MAmgf_reader<locked=0> {
         total => <-.Params.nsteps;
         current_step => <-.Params.stepno;
         step_title => <-.Params.time_string;
         Top.name =  "NOOBJLIST MicroAVS Geometory ASCII file";
         Top.altobj => <-.<-.groupObject.AltObject.obj;
      };
      init_timestep_range{
         trigger    => is_valid(<-.reader.total);
      };
      MAgroupObject groupObject<locked=0> {
         child_objs => <-.reader.Top;
         Top.name   => <-.<-.name;
         Datamap { ! DataRange[0] { selectValues = 0; }; };
      };
      olink obj => groupObject.obj;
      field<NEvisible=0, export=0>;
   };
};
