/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/acpkg.v#1 $
*/	

/* this Read_Geom is a duplicate of the version in modules.v */

macro Read_Geom {
    
    macro read_geom_ui {
        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select read geom control panel.";
            parent<NEportLevels={4,0}>;
        };

        UIfileSB file_browser {
            parent => <-.panel;
            title = "Read GEOM Filename";
            visible => <-.panel.visible;
            searchPattern = "$XP_PATH<0>/data/geom/*.geo";
        };

        olink filename => file_browser.filename;
    };

    ACread_geom ACread_geom {
        array_flag = 0;
        filename => read_geom_ui.filename;
    };

    DataObject DataObject {
        in => ACread_geom.out_field;
        Obj {
                xform_mode = 1; /* GD_XFORM_MODE_PARENT */
                name <NEportLevels={3,0}> => <-.<-.ACread_geom.name;
        };
    };

    olink field => ACread_geom.out_field;
    olink geom =>  DataObject.obj;
};

macro Read_Geoms {
   
    macro read_geom_ui {
        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select read geom control panel.";
            parent<NEportLevels={4,0}>;
        };

        UIfileSB file_browser {
            parent => <-.panel;
            title = "Read GEOM Filename";
            visible => <-.panel.visible;
            searchPattern = "$XP_PATH<0>/data/geom/*.geo";
        };

        olink filename => file_browser.filename;
    };

    ACread_geom ACread_geom {
        array_flag = 1;
        filename => read_geom_ui.filename;
    };

    DataObjects DataObjects {
        in_fields => ACread_geom.out_fields;
        dos {
                Obj {
                        xform_mode = 1; /* GD_XFORM_MODE_PARENT */
                        name => ( (<-.<-.<-.ACread_geom.name + ".obj") +
                                  index_of(<-.<-.dos) );
                };
        };
    };

    GroupObject GroupObject {
        child_objs => DataObjects.dos.obj;
        Top {
                name => <-.<-.ACread_geom.name + ".Top";
        };
    };

    olink field => ACread_geom.out_fields;
    olink geom =>  GroupObject.obj;
};

macro Read_Image {
    
    macro read_image_ui {
	UImod_panel panel {
	    title = "Read IMAGE";
	    message = "Select read image control panel.";
	    parent<NEportLevels={4,0}>;
	    x = 0;
	    y = 0;
	    width = 200;
	    height = 200;
	};
	
	UIfileSB file_browser {
	    parent => panel;
	    x = 0;
	    y = 100;
	    title = "Read IMAGE Filename";
	    visible => panel.visible;
	    searchPattern = "$XP_PATH<0>/data/image/*.x";
	};

	olink filename => file_browser.filename;
    };
    DVread_image DVread_image {
	filename => read_image_ui.filename;
	out {
	    xform.rspace = 2;
        };
    };

    DataObject DataObject {
	in => DVread_image.out;
    };

    olink  field=> DVread_image.out;
    olink image => DataObject.obj;
};
macro Read_Field {

    macro read_field_ui {
	UImod_panel panel {
	    parent<NEportLevels={4,0}>;
	    title = "Read Field";
	    message = "Select read field control panel.";
	    x = 0;
	    y = 0;
	    width = 200;
	    height = 200;
	};
	
	UItoggle vector_toggle {
		parent => panel;
		label = "Vector Data";
		&set+IPort2 => avs2fld.vector;
	};

	UIfileSB file_browser {
	    parent => panel;
	    x = 0;
	    y = 100;
	    title = "Read Field Filename";
	    visible => panel.visible;
	    searchPattern = "$XP_PATH<0>/data/field/*.fld";
	};

	olink filename => file_browser.filename;
    };
    
    read_field read_field {
	Read_Field_Browser => read_field_ui.filename;
    };
    ACavs_to_fld avs2fld {
	in => read_field.o_Field_Output;
    };

    olink field => avs2fld.out;
};
macro Read_UCD {
    
    macro read_ucd_ui {
	UImod_panel panel {
	    parent<NEportLevels={4,0}>;
	    title = "Read UCD";
	    message = "Select read ucd control panel.";
	    width = 200;
	    height = 200;
	    x = 0;
	    y = 0;
	};
	
	UIfileSB file_browser {
	    parent => panel;
	    x = 0;
	    y = 100;
	    title = "Read UCD Filename";
	    visible => panel.visible;
	    searchPattern = "$XP_PATH<0>/data/ucd/*.inp";
	};

	olink filename => file_browser.filename;
    };
    
    read_ucd read_ucd {
	read_file => read_ucd_ui.filename;
    };

     ACucd_to_fld ucd2fld {
	in => read_ucd.o_tet_output;
    };

    olink field => ucd2fld.out;
};
