//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/acutil.v#1 $
//	
//
// Utilities for AVS5 compatibility kit
// This file is loaded before compat.v, from templ.v.
// It is the libfile for the AC_UTIL library.

$declare_type avsmod group
$declare_type avsfield ptr
$declare_type avsucd ptr
$declare_type avsgeom ptr
$declare_type avscmap ptr
$declare_type avsudata ptr

// Note: all the cxxmethods below are generated directly into express.cxx
// and express.h because their code is included directly here.
library MenuItems <out_src_file="menu_gen.cxx",
                   out_hdr_file="menu_gen.h",
                   hdr_code=<"
    /* these functions are defined in the AC Kit */
    /* See avs_cli.c:ACread_avs5_v_command, for the corresponding
       V commands */
    int ACread_avs5_file (char *filename, char *func_name, int script_mode);
    int MODLIBread(char *filename, int sync_mode);
    void *_AVSattach_module(char *name, char *ex_name, char *host_name, int macro);
">> {
   group read_avs5_net {
      string+read+req filename;
      cxxmethod+notify_val update = <"
      return ACread_avs5_file(filename, "read_avs5_net", 0);
">;
   };
   group read_avs5_script {
      string+read+req filename;
      cxxmethod+notify_val update = <"
      return ACread_avs5_file(filename, "read_avs5_script", 1);
">;
   };
   group read_mod_lib {
      string+read+req filename;
      cxxmethod+notify_val update = <"
	return MODLIBread(filename, 1);
">;
   };
   group read_module {
      string+read+req filename;
      cxxmethod+notify_val update = <"
	return _AVSattach_module(NULL, filename, NULL, 0) != 0;
">;
   };
   group read_remote_module {
      string+read+req filename;
      string+read+req hostname;
      cxxmethod+notify_val update = <"
	return _AVSattach_module(NULL, filename, hostname, 0) != 0;
">;
   };
};

library+buffered Utilities {
   group dmap_to_cmap {
      DMAP.DatamapTempl+read+notify+req &dmap_in<NEportLevels={2,0}>;
      // If provided, the cmap_in just gets passed through to the output.
      avscmap+read+notify cmap_in<NEportLevels={2,0}>;
      int+read+notify free_flag;
      avscmap+write+nonotify cmap_out<NEportLevels={0,2}>;
      method+notify_val update = "ACconvert_dmap_to_avs_cmap";
      method+notify_del destroy = "ACfree_cmap";
   };
   macro Color_editor {
      // This is just a placeholder; the rest of these objects will be
      // added in in compat2.v for the specific modules we know to need
      // them.  Unfortunately this can't be done here because this file
      // can't depend on VIEW without (we believe) creating circular
      // dependency loops.
      int width;
      int height;
      int y;
      link parent<NEportLevels={2,1}>; // connect to UI parent obj
      avscmap &out;
   };
   macro ACfile_sel_box {
      link parent<NEportLevels={2,1}>; // connect to UI parent obj
      string title;		// displayed on toggle button
      int y;			// this is an input parameter
      int width = 250;		// XXX: should be ui_text_width(...)
      int height => UItoggle.height; // this is an output parameter
      string message;
      Controls.UItoggle UItoggle {
	 label => "Pop up " + <-.title + " dialog box";
	 parent => <-.parent;
	 y => <-.y;
	 width => <-.width;
         message => <-.message;
      };
      StandardDialogs.UIfileDialog UIfileDialog {
	 parent => <-.parent;
	 filename => <-.filename;
	 searchPattern => <-.searchPattern;
	 visible => <-.UItoggle.set;
         message => <-.message;
      };
      string filename<NEportLevels={2,0}>;
      string searchPattern;
   };
   macro ACtext_typein_with_title {
     link parent<NEportLevels={2,1}>;
     string title<NEportLevels={1,1}>;
     string text<NEportLevels={2,1}>;
     string message<NEportLevels={1,1}>;
     int y = 0;
     int width = 250;
     int height => label.height + 4 + textW.height + 4;
     Controls.UIlabel label {
       parent => <-.parent;
       label => <-.title;
       y => <-.y;
       width => <-.width;
       message => <-.message;
     };
     Controls.UItext textW {
       parent => <-.parent;
       y => <-.y + <-.label.height + 4;
       // height = 60;
       width => <-.width;
       text => <-.text;
       message => <-.message;
     };
   };
   group paths {
      string Path;
      string LibPath;		// this is synthetic, not a standard AVS path
      string NetworkDirectory;
      string DataDirectory;
      string VendorLogo;
      // Run this method to set up the path variables above
      method+notify_inst inst = "ACstore_path_vars";
   };
};
