/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/contour2.v#1 $
*/

APPS.MultiWindowApp contour2<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "contour2 shows the use of classes to control the AGContour functionality. Note the use of the AGContourViewport.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {AGDataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   Contouring.AGContourLegend AGContourLegend<NEx=220,NEy=363> {
      contour => <-.AGContour;
      geometry = {4,-5};
      labelHeight = 3;
      title = "Temperature\nLevels";
   };
   Contouring.AGContour AGContour<NEx=220,NEy=275> {
      field => <-.orthoslice.out_fld;
      classValues<NEportLevels={2,0}> => <-.Classes;
      contourType = "datamappedisolines";
      isoLineLabelDistance = 50;
      isoLineLabelHeight = 3.5;
      isoLineLabelAngleInterval = {-45,45};
      majorIsoLineWidth = 0.5;
      majorIsoLineFrequency = 1;
      minClass = 0;
   };
   MODS.Readers.Read_Field Read_Field<NEx=495,NEy=121> {
      read_field_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/field/wind.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=550,NEy=187> {
      in_field => <-.Read_Field.field;
   };
   Basic.AGText AGText<NEx=220,NEy=407> {
      geometry = {-0.25,6};
      height = 6;
      text = {"IsoLines of Temperature Distribution"};
   };
   Contouring.AGContourWorld AGContourWorld<NEx=429,NEy=308> {
      children => {
         <-.AGContour,<-.AGXAxis,<-.AGYAxis,<-.AGXTicklines,<-.AGYTicklines
      };
      majorTickWidth = 0.25;
   };
   float Classes<NEportLevels=1,NEx=220,NEy=165>[] = {
      -15,-10,0,10,20,25,30,32,34,36,38,40
   };
   Axes.AGXAxis AGXAxis<NEx=220,NEy=77> {
      text = "X Position";
   };
   Axes.AGYAxis AGYAxis<NEx=220,NEy=110> {
      text = "Y Position";
   };
   Axes.AGXTicklines AGXTicklines<NEx=220,NEy=11> {
      priority = -1;
   };
   Axes.AGYTicklines AGYTicklines<NEx=220,NEy=44> {
      priority = -1;
   };
   Contouring.AGContourViewport AGContourViewport<NEx=429,NEy=440> {
      children => {<-.AGContourWorld,
                   <-.AGContourLegend,
                   <-.AGText};
   };
   Basic.AGDataObject AGDataObject<NEx=605,NEy=495> {
      in => <-.AGContourViewport;
      DefaultMinMax {
         input => <-.<-.orthoslice.out_fld;
      };
   };
   Contouring.AGContour AGContour#1<NEx=616,NEy=22>;
   float ChangeClasses<NEportLevels=1,NEx=55,NEy=242>[] = {
      0,30,35,36,37,38,39,40};
};
