/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/logex2.v#1 $
*/

APPS.MultiWindowApp logex2<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=200.,NEy=20.> {
      demo_text = "logex2 shows the use of log axes using the AG kit. To switch on the log axis functionality you use the scaleTypeX and scaleTypeY parameters of the required AGGraphWorld module. Using these it is possible to select a linear, log10 or power scaling.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {AGDataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   double ratios<NEx=11,NEy=11>[] = {1e-06,0.05,0.1,
0.2,0.5,1};
   float ratios2<NEx=11,NEy=44>[] => ((2 * ratios) * (2 * ratios));
   int numValues<NEx=11,NEy=77> = 200;
   float x<NEportLevels={0,1},NEx=11,NEy=110>[] => pow(10,init_array(numValues,-1,1));
   float x2<NEx=11,NEy=143>[] => (x * x);
   float x3<NEx=11,NEy=176>[] => ((1 - x2) * (1 - x2));
   float y0<NEx=165,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[0] * x2))) / sqrt((x3 + (ratios2[0] * x2))));
   float y1<NEx=330,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[1] * x2))) / sqrt((x3 + (ratios2[1] * x2))));
   float y2<NEx=495,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[2] * x2))) / sqrt((x3 + (ratios2[2] * x2))));
   float y3<NEx=660,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[3] * x2))) / sqrt((x3 + (ratios2[3] * x2))));
   float y4<NEx=836,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[4] * x2))) / sqrt((x3 + (ratios2[4] * x2))));
   float y5<NEx=1001,NEy=77,NEportLevels={0,1}>[] => (sqrt((1 + (ratios2[5] * x2))) / sqrt((x3 + (ratios2[5] * x2))));
   Basic.AGDataObject AGDataObject<NEx=484,NEy=484> {
      in => <-.AGGraphViewport;
   };
   Graphing.AGGraphViewport AGGraphViewport<NEx=341,NEy=418> {
      children => {<-.AGGraphWorld,<-.AGGraphLegend};
      geometry = {-3,-3,3,4};
   };
   Graphing.AGGraphWorld AGGraphWorld<NEx=187,NEy=352> {
      children => {
         <-.AGXAxis,<-.AGYAxis,<-.AGXTicklines,<-.AGYTicklines,<-.AGGraph0,
         <-.AGGraph1,<-.AGGraph2,<-.AGGraph3,<-.AGGraph4,<-.AGGraph5
      };
      scaleTypeX = "log10";
      scaleTypeY = "log10";
      minorTickCount = 1;
      niceLimits = 0;
      textFont = "sw:Roman-Simplex";
      textHeight = 3.5;
      limitsY = {0.01,50};
   };
   Axes.AGXAxis AGXAxis<NEx=11,NEy=242> {
      text = "Applied frequency / Undamped natural frequency";
   };
   Axes.AGYAxis AGYAxis<NEx=11,NEy=308,NEwidth=176,NEheight=220> {
      text = "Transmissibility factor";
      labelPowerFactor = 0;
   };
   Axes.AGXTicklines AGXTicklines<NEx=11,NEy=275>;
   Axes.AGYTicklines AGYTicklines<NEx=11,NEy=341>;
   AGGraph AGGraph0<NEx=209,NEy=154> {
      legendText => ("\r2140 = " + ratios[0]);
      valuesX => <-.x;
      valuesY => <-.y0;
      priority = 1;
   };
   AGGraph AGGraph1<NEx=374,NEy=154> {
      legendText => ("\r2140 = " + ratios[1]);
      valuesX => <-.x;
      valuesY => <-.y1;
      priority = 2;
   };
   AGGraph AGGraph2<NEx=539,NEy=154> {
      legendText => ("\r2140 = " + ratios[2]);
      valuesX => <-.x;
      valuesY => <-.y2;
      priority = 3;
   };
   AGGraph AGGraph3<NEx=704,NEy=154> {
      legendText => ("\r2140 = " + ratios[3]);
      valuesX => <-.x;
      valuesY => <-.y3;
      priority = 4;
   };
   AGGraph AGGraph4<NEx=880,NEy=154> {
      legendText => ("\r2140 = " + ratios[4]);
      valuesX => <-.x;
      valuesY => <-.y4;
      priority = 5;
   };
   AGGraph AGGraph5<NEx=1045,NEy=154> {
      legendText => ("\r2140 = " + ratios[5]);
      valuesX => <-.x;
      valuesY => <-.y5;
      priority = 6;
   };
   Graphing.AGGraphLegend AGGraphLegend<NEx=341,NEy=319> {
      graphs => {
         <-.AGGraph0,<-.AGGraph1,<-.AGGraph2,<-.AGGraph3,<-.AGGraph4,
         <-.AGGraph5
      };
      geometry = {-4,-4};
      title = "Damping Ratio";
   };
};
