/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/piechart.v#1 $
*/

APPS.MultiWindowApp PieChart<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "PieChart shows how the AG kit is used to create pie chart visualizations. AGPieChart can be connected directly into an AGViewportObj to correctly render it in a standard viewer.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {AGViewportObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   Basic.AGViewportObj AGViewportObj<NEx=297.,NEy=275.> {
      viewport<NEx=11.,NEy=44.> {
         children => {<-.<-.AGPieChart,
            <-.<-.PieTitle};
         frameWidth<NEdisplayMode="open"> = 0.;
      };
   };
   AGText PieTitle<NEx=187.,NEy=154.> {
      text = {"Car Sales \nSomewhere"};
      geometry = {0.,5.5};
      font = "Helvetica";
      height = 5.;
      multiLineSpacingFactor = -0.200000003;
   };
   Graphing.AGPieChart AGPieChart<NEx=451.,NEy=154.> {
      values => <-.Car_Sales;
      labelHeight = 4.;
      labelJustification = "center";
      labelStrings<NEportLevels={2,0}> => <-.Car_Names;
      labelSuffix<NEportLevels={0,0}> = " $";
      priority = 0;
      explodeOffset<NEdisplayMode="open">;
      labelFont = "Helvetica";
   };
   string Car_Names<NEportLevels=1,NEx=308.,NEy=33.>[] = {
      "Volvo","Saab","Ford","VW","BMW","Fiat","Seat"
   };
   float Car_Sales<NEportLevels=1,NEx=308.,NEy=77.>[] = {
      123.,111.,237.,-550.,221.,154.,44.};
};
