/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/polar.v#1 $
*/

APPS.MultiWindowApp polar<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "polar demonstrates the use of a polar axis system using the AG kit. Note the use of the AGPolarGraphWorld module that is used together with the AGPolarTAxis and AGPolarRAxis modules.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {AGGraphViewportObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   AGPolarRTicklines AGPolarRTicklines {
      majorStepR<NEdisplayMode="open"> = 200.;
   };
   AGPolarTAxis AGPolarTAxis {
      majorTickColor<NEdisplayMode="open"> = "yellow";
      labelColor<NEdisplayMode="open"> = "yellow";
      textColor<NEdisplayMode="open"> = "yellow";
   };
   AGPolarRAxis AGPolarRAxis {
      majorTickColor<NEdisplayMode="open"> = "cyan";
      labelColor<NEdisplayMode="open"> = "cyan";
      textColor<NEdisplayMode="open"> = "cyan";
   };
   AGGraphViewportObj AGGraphViewportObj<NEx=297.,NEy=286.> {
      graphViewport {
         children => {<-.<-.AGPolarGraphWorld,<-.<-.AGGraphLegend};
         frameWidth<NEdisplayMode="open"> = 0.;
      };
   };
   AGPolarGraphWorld AGPolarGraphWorld {
      children => {
         <-.AGPolarTAxis,<-.AGPolarRTicklines,<-.AGPolarRAxis,<-.Spiralup,
         <-.AGPolarTTicklines,<-.Spiraldown
      };
      minorTickCount<NEdisplayMode="open"> = 1;
      textFont = "sw:helvetica";
   };
   AGPolarGraph Spiralup {
      valuesR<NEdisplayMode="open"> => init_array(100,0,1000);
   };
   AGPolarTTicklines AGPolarTTicklines;
   AGGraphLegend AGGraphLegend {
      graphs => {<-.Spiralup,<-.Spiraldown};
      geometry<NEdisplayMode="open"> = {5.1,-5.};
      fillColor<NEdisplayMode="open"> = "steelblue";
   };
   AGPolarGraph Spiraldown {
      valuesR<NEdisplayMode="open"> => init_array(100,1000,0);
      graphType<NEdisplayMode="open"> = "scatter";
   };
};
