/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/sliceFld.v#1 $
*/

APPS.MultiWindowApp sliceFld<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This is a more involved example that combines the functionality of the AG kit with some standard AVS/Express macros, notably Read_Field and orthoslice. An orthoslice module is used to slice the volume into a 2D plane and then a further orthoslice module is used to slice this plane into a 1D field that can be plotted with the AG kit.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Readers.Read_Field Read_Field<NEx=198,NEy=22> {
      read_field_ui {
         file_browser {
	    filename = "$XP_PATH<0>/data/field/hydrogen.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=198,NEy=121> {
      in_field => <-.Read_Field.field;
   };
   MODS.Mappers.orthoslice orthoslice#1<NEx=418,NEy=121> {
      in_field => <-.orthoslice.out_fld;
   };
   Contouring.AGContourObj AGContourObj<NEx=253,NEy=308> {
      inField => <-.orthoslice.out_fld;
      combineContourWorldInput {
         input2 => {<-.<-.AGXAxis,<-.<-.AGYAxis,<-.<-.AGLine};
      };
   };
   Axes.AGXAxis AGXAxis<NEx=242,NEy=220>;
   Axes.AGYAxis AGYAxis<NEx=242,NEy=253>;
   Basic.AGLine AGLine<NEx=33,NEy=297> {
      geometry => <-.extract_coordinate_array.coord;
      color = "red";
      width = 1;
   };
   FLD_MAP.Array_Extractors.extract_coordinate_array extract_coordinate_array<NEx=33,NEy=220> {
      in => <-.orthoslice#1.out_fld;
      coord<NEportLevels={0,2}>;
      comp = {1,2};
   };
   Graphing.AGGraphFieldObj AGGraphFieldObj<NEx=440,NEy=297> {
      in_field => {<-.orthoslice#1.out_fld};
      extract_data_array = {};
      graphs = {};
   };

   GDM.Uviewer2D Uviewer2D<NEx=429.,NEy=440.> {
      Scene {
         Top {
	    child_objs => {AGContourObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
      GDM.Uscene2D Scene#1 {
         Top {
	    child_objs<NEportLevels={4,1}> => {AGGraphFieldObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View,<-.Scene#1.View.View};
      };
   };
};
