/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/mgraph3.v#1 $
*/

APPS.MultiWindowApp MultiGraph3<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "MultiGraph3 shows how you can use the standard Read_Text_Columns in AVS/Express to provide data for the AG kit modules. A macro, GeneralGraph has been used which consists of low level AG kit modules.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Text_Columns Read_Text_Columns {
      param {
         columns = {
            {name="column_0",type=4,use=1,null_value=0.},
            {name="column_1",type=4,use=1,null_value=0.},
            {name="column_2",type=4,use=1,null_value=0.}};
         ncol = 3;
         filename = "$XP_PATH<0>/data/graph/growth.dat";
      };
      DVtable_read_init {
         out[0];
      };
      read_table_ui {
         file_browser {
            searchPattern = "$XP_PATH<0>/data/graph/*.dat";
         };
      };
   };
   AGHLM.extract_column extract_column<NEx=95.,NEy=103.> {
      DVtable_xyz_create {
         field_xyz[3] = {
            {
               values=>Read_Text_Columns.DVtable_read.out[0].values,,
               null_flag=>Read_Text_Columns.DVtable_read.out[0].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[0].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[0].labels
            },
            {
               values=>Read_Text_Columns.DVtable_read.out[1].values,
               null_flag=>Read_Text_Columns.DVtable_read.out[1].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[1].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[1].labels
            },
            {
               values=>Read_Text_Columns.DVtable_read.out[2].values,
               null_flag=>Read_Text_Columns.DVtable_read.out[2].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[2].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[2].labels
            }};
         columns => <-.<-.Read_Text_Columns.table;
         ncol = 3;
         xyz_names[3] = {"column_0","column_1","column_2"};
         xyz_select {
            xyz_set = {1,0,0};
            xyz_axis = {0,0,0};
         };
         reset = 0;
         names[3] = {"column_0","column_1","column_2"};
      };
      comp = 0;
   };
   AGHLM.extract_column extract_column#1<NEx=426.,NEy=103.> {
      DVtable_xyz_create {
         field_xyz[3] = {
            {
               values=>Read_Text_Columns.DVtable_read.out[0].values,
               null_flag=>Read_Text_Columns.DVtable_read.out[0].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[0].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[0].labels
            },
            {
               values=>Read_Text_Columns.DVtable_read.out[1].values,,
               null_flag=>Read_Text_Columns.DVtable_read.out[1].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[1].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[1].labels
            },
            {
               values=>Read_Text_Columns.DVtable_read.out[2].values,
               null_flag=>Read_Text_Columns.DVtable_read.out[2].null_flag,
               null_value=>Read_Text_Columns.DVtable_read.out[2].null_value,,,
               name=>Read_Text_Columns.DVtable_read.out[2].labels
            }};
         columns => <-.<-.Read_Text_Columns.table;
         ncol = 3;
         xyz_names[3] = {"column_0","column_1","column_2"};
         xyz_select {
            xyz_set = {1,0,0};
            xyz_axis = {0,0,0};
         };
         reset = 0;
         names[3] = {"column_0","column_1","column_2"};
      };
      UIradioBoxLabel {
         label_cmd {
            cmd[] = {,
               {
                  set=1,
               },};
         };
      };
      comp = 1;
   };
   AGHLM.General_Graph General_Graph<NEx=251.,NEy=181.> {
      Graph#1 {
         GraphUI {
            graphtype {
               label_cmd {
                  cmd = {
                     ,,,
                     {
                        set=1,
                     },,,,
                  };
               };
            };
            color = {
               ,,
               {
                  set=0
               },,,
               {
                  set=1
               },,,,,
            };
         };
         Gparams {
            Graph_params1 {
               graphtype = 3;
               line_color = 5;
            };
         };
      };
      ValuesY1 => <-.extract_column.out;
      ValuesY2 => <-.extract_column#1.out;
      Graph#2 {
         UIframe<instanced=0>;
      };
      Graph#3 {
         UIframe<instanced=0>;
      };
      Graph#4 {
         UIframe<instanced=0>;
      };
      Graph#5 {
         UIframe<instanced=0>;
      };
   };

   GDM.Uviewer2D Uviewer2D {
      Scene {
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 310;
                        defaultHeight = 325;
                        defaultX = 55;
                        defaultY = 385;
                     };
                  };
               };
            };
         };
         Top {
            child_objs => {
               <-.<-.<-.General_Graph.GraphViewport.obj};
         };
      };
   };
};

