/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/xy.v#1 $
*/

APPS.MultiWindowApp XYGraph<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "XYGraph demostrates the use of the Graph macro. This is a higher level AG kit macro that allows XY plots to be created very easily.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.GraphViewport.obj};
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 299;
                        defaultY = 244;
                     };
                  };
               };
            };
            View {
               trigger = 1;
            };
         };
      };
   };

   float X<NEportLevels={1,1}>[] = {0.1,1.,2.,3.,4.,5.,6.};
   float Y<NEportLevels={1,1}>[] = {0.1,3.,2.,3.,7.,5.,2.};

   AGHLM.Graph Graph {
      AGGraph {
         valuesX => <-.<-.X;
         valuesY => <-.<-.Y;
      };
      GraphUI<instanced=0>;
   };
   AGHLM.GraphLegend GraphLegend {
      AGGraphLegend {
         graphs => {<-.<-.Graph.output};
      };
      LegendUI<instanced=0>;
   };
   AGHLM.GraphViewport GraphViewport {
      AGGraphViewportObj {
         graphViewport {
            children => {
               <-.<-.<-.GraphWorld.out, <-.<-.<-.GraphLegend.obj};
         };
      };
      GraphViewport_UI<instanced=0>;
   };
   AGHLM.GraphWorld GraphWorld {
      AGCombineGraphWorldInput {
         input1 => {<-.<-.Graph.output};
         input2 => <-.<-.XYAxis.mlink;
      };
   };
   AGHLM.XYAxis XYAxis {
      XAxis<instanced=0>;
      Graph_in => <-.Graph.output;
   };
};
