/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/xy2.v#1 $
*/

APPS.MultiWindowApp Two_XYGraphs<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows how 2 Graph macros can be combined into one visualization with different axes for each series plotted in an XY plot. Note the use of 2 GraphWorld macros and a single GraphViewport macro.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=350.,NEy=480.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.GraphViewport.obj};
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 199;
                        defaultY = 380;
                     };
                  };
               };
            };
            View {
               trigger = 1;
            };
         };
      };
   };

   float X<NEportLevels={1,1}>[] = {0.1,1.,2.,3.,4.,5.,6.};
   float Y<NEportLevels={1,1}>[] = {0.1,3.,2.,3.,7.,5.,2.};

   AGHLM.Graph Graph {
      AGGraph {
         valuesX => <-.<-.X;
         valuesY => <-.<-.Y;
      };
      GraphUI<instanced=0>;
   };
   AGHLM.GraphLegend GraphLegend<NEx=374.,NEy=209.> {
      AGGraphLegend {
         graphs => {<-.<-.Graph.output,
                    <-.<-.Graph#1.output};
      };
      LegendUI<instanced=0>;
   };
   AGHLM.GraphViewport GraphViewport<NEx=350.,NEy=390.> {
      AGGraphViewportObj {
         graphViewport {
            children => {
               <-.<-.<-.GraphWorld.out,
               <-.<-.<-.GraphWorld#1.out,
               <-.<-.<-.GraphLegend.obj};
         };
      };
      GraphViewport_UI<instanced=0>;
   };
   AGHLM.GraphWorld GraphWorld {
      AGCombineGraphWorldInput {
         input1 => {<-.<-.Graph.output};
         input2 => <-.<-.XYAxis.mlink;
      };
   };
   AGHLM.XYAxis XYAxis<NEx=121.,NEy=209.> {
      XAxis<instanced=0>;
      Graph_in => <-.Graph.output;
   };

   float Y#1<NEportLevels={1,1}>[] = {5.,3.,4.,5.,7.,3.,1.};

   AGHLM.Graph Graph#1 {
      AGGraph {
         valuesY => <-.<-.Y#1;
      };
      GraphUI<instanced=0> {
         color = {
            ,,
            {
               set=0,,
            },
            {
               set=1,,,
            },,,,,
         };
      };
      Graph_params {
         graphtype = 4;
         line_color = 3;
      };
   };
   AGHLM.XYAxis XYAxis#1 {
      XAxis<instanced=0>;
      Axis {
         selectedItem = 1;
      };
      color1 = {
         {
            set=0,,
         },,,,,
         {
            set=1,,,
         },,,
      };
      color2 = {
         {
            set=0,,
         },,,
         {
            set=1,,,
         },,,,,
      };
      color3 = {
         {
            set=0,,
         },,,
         {
            set=1,,,
         },,,,,
      };
      Graph_in => <-.Graph#1.output;
      X_Axis_params {
         Axle_on_off = 0;
         X_Tickline_on_off = 0;
      };
      Y_Axis_params {
         Y_Axis_text = "Reverse Y axis text";
         X_Axis_pos = 7.5;
         Steps_for_Major = 1;
         reverse_text = 1;
         Axle_color = 5;
         Label_color = 3;
         Text_color = 3;
         Y_Tickline_on_off = 0;
      };
   };
   AGHLM.GraphWorld GraphWorld#1 {
      AGCombineGraphWorldInput {
         input1 => {<-.<-.Graph#1.output};
         input2 => <-.<-.XYAxis#1.mlink;
      };
   };
};
