/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/anim.v#1 $
*/

flibrary+buffered+sort ANIM <
   disabled => Templates.CONFIG.anim_kit_disabled,
   build_dir="animator",
   build_cmd="$(MAKE)",
#ifdef MSDOS
   link_files="-lanim -lcxxut -lgdsw -lgd -lmutil $(AVILIBS) -lz",
#else
   link_files="-lanim -lcxxut -lgd -lmutil -lgdsw -lgdif -lfld -lz",
#endif
   out_src_file="anim_omx.cxx",
   out_hdr_file="anim_omx.hxx",
   use_src_file=0,
   needs_edit_lic="GD">
{
   module AnimControl<
      need_objs = "ANIM.StringInterpolator ANIM.ScalarInterpolator ANIM.ArrayInterpolator ANIM.TransformMatrixInterpolator",
      cxx_class="AnimatorClass",
      cxx_hdr_files="avs/animator/animator.h",
      cxx_members="private:  UtPtrList <AnimObjBase> animObjBase;  OMobj_id interpGrpId; OMobj_id countId; OMobj_id interpolatorId; char interpName[128]; int intpType; int firstFind;"> 
   {
      int currentFrame<export=2> = 0;
      float frameTimes<export=2>[];
      float frameDelta<export=2> = 1.;
      float currentTime<export=2> = 0.;
      float newTime<export=2> = 0.;
      float scaleBeginTime<export=2> = 1.0;
      float scaleEndTime<export=2> = 3.;
      float scaleValue<export=2> = 2.0;
      string scaleInterpolatorName<export=2> = "";
      int scaleAll<export=2> = 1.;
      int scaleTimes<export=2> = 1.;
      int scaleValues<export=2> = 1.;
      float framesPerSec<export=2,NEportLevels={0,2}> = 24.;
      int addFrameBtn<export=2,NEportLevels={2,0}> = 0;
      int clearFramesBtn<export=2,NEportLevels={2,0}> = 0;
      int deleteFrameBtn<export=2,NEportLevels={2,0}> = 0;
      int moveFrameBtn<export=2,NEportLevels={2,0}> = 0;
      int completeFramesBtn<export=2,NEportLevels={2,0}> = 0;
      int copyFrameBtn<export=2,NEportLevels={2,0}> = 0;
      int scaleFramesBtn<export=2,NEportLevels={2,0}> = 0;
      int reInitBtn<export=2,NEportLevels={2,0}> = 0;
      int reScanBtn<export=2,NEportLevels={2,0}> = 0;
      int upd_seq<export=2>;
      int interpEditorOkBtn<export=2,NEportLevels={2,0}> = 0;
      int interpEditorApplyBtn<export=2,NEportLevels={2,0}> = 0;
      string interpolatorList<export=2,NEportLevels={0,0}>[];
      int interpolatorListIndex<export=2>;
      string interpNameStr<export=2> = "";
      int timeListIndex<export=2>;
      float interpTimes<export=2>[];
      int   quatOrEuler<export=2>;
      int   interpType<export=2>;
      float fScalar<export=2>;
      int   iScalar<export=2>;
      float fValue1<export=2>;
      float fValue2<export=2>;
      float fValue3<export=2>;
      int   iValue1<export=2>;
      int   iValue2<export=2>;
      int   iValue3<export=2>;
      float matValue1<export=2>;
      float matValue2<export=2>;
      float matValue3<export=2>;
      float matValue4<export=2>;
      float matValue5<export=2>;
      float matValue6<export=2>;
      int   fFrame1Visible<export=2> = 0;
      int   fFrame2Visible<export=2> = 0;
      int   fFrame3Visible<export=2> = 0;
      int   iFrame1Visible<export=2> = 0;
      int   iFrame2Visible<export=2> = 0;
      int   interpEditorVisible<export=2> = 0;
      int   valuesType<export=2>;
      cxxmethod+notify_inst onInstance();
      cxxmethod deleteEditorDialog(
         currentTime+read+write+notify,
         clearFrameBtn+read+notify+req,
         deleteFrameBtn+read+notify+req,
         moveFrameBtn+read+notify+req
      );
      cxxmethod interpUIValuesChanged(
         interpEditorOkBtn+read+notify,
         interpEditorApplyBtn+read+notify
      );
      cxxmethod interpolatorSelected <weight=2>(
         interpolatorListIndex+read+notify,
         completeFramesBtn+read+notify+req
      );
      cxxmethod timeSelected<weight=3> (
	 interpolatorListIndex+read+notify,
	 timeListIndex+read+notify
      );
      cxxmethod+req addFrame <weight=1>(
	 addFrameBtn+read+notify,
	 upd_seq+read+notify,
         currentTime+read+write+notify,
	 frameDelta+read,
         currentFrame+read+write+req,
	 frameTimes+write
      );
      cxxmethod+req deleteFrame<weight=1>(
         deleteFrameBtn+read+notify+req,
	 currentTime+read+write+req
      );
      cxxmethod+req clearFrames<weight=1>(
	 clearFramesBtn+read+notify+req,
         currentFrame+write,
         currentTime+write,
	 frameTimes+write
      );
      cxxmethod+req moveFrame <weight=1>(
         moveFrameBtn+read+notify+req,
	 newTime+read+req,
         currentFrame+read+write+req,
         currentTime+read+write,
         frameTimes+write
      );
      cxxmethod completeFrames <weight=1> (
	 completeFramesBtn+read+notify+req,
         currentFrame+read+write+req,
	 frameDelta+read,
         currentTime+read+write,
	 frameTimes+write
      );
      cxxmethod copyFrame <weight=1> (
         copyFrameBtn+read+notify+req,
         currentFrame+read+write+req,
	 frameDelta+read,
         currentTime+read+write,
	 frameTimes+write
      );
      cxxmethod scaleFrames <weight=1> (
         scaleFramesBtn+read+notify+req,
         scaleBeginTime+read+write,
         scaleEndTime+read+write,
         scaleValue+read,
         scaleAll+read,
         frameTimes+write
      );
      cxxmethod clearADB();
      cxxmethod reInitADB(
         reInitBtn+read+notify+req
      );
      cxxmethod reScan(
         reScanBtn+read+notify+req
      );
      cxxmethod update();
      cxxmethod deleteObject();
      cxxmethod updateFrames();
      cxxmethod updateInterpolators();
      cxxmethod+notify_deinst deleteNotify();
      float count = 0.0;
      group InterpolatorGroup;
   };


   module ArrayInterpolator<
      cxx_class="InterpolatorClass",
      cxx_hdr_files="avs/animator/interp.h">
   {
      float loopCount<NEportLevels={2,0}> = 0.;
      float keysArray<NEportLevels={2,0}>[];
      prim valuesArray<NEportLevels={2,0}>[];
      prim resultArray<NEportLevels={0,2}>[];
      enum interpType<export=2> {
         choices => {"Linear","Cubic","Quintic","Sinusoidal"};
      } = "Linear";
      cxxmethod LUpdate(
         interpType+read+req,
	 loopCount+read+notify+req,
	 keysArray+read+req,
	 valuesArray+read+req,
	 resultArray+write
      );
   };

   module TransformMatrixInterpolator<
      cxx_class="InterpolatorClass",
      cxx_hdr_files="avs/animator/interp.h">
   {
      float loopCount<NEportLevels={2,0}> = 0.;
      float keysArray<NEportLevels={2,0}>[];
      float valuesArray<NEportLevels={2,0}>[];
      float resultArray<NEportLevels={0,2}>[];
      int quatOrEuler <export=2,NEportLevels={2,0}>= 0;
      enum interpType<export=2> {
         choices => {"Linear","Cubic","Quintic","Sinusoidal"};
      } = "Linear";
      int reverseDirection <export=2,NEportLevels={2,0}>= 0;
      cxxmethod LUpdate(
         interpType+read+req,
         reverseDirection+read+write+req,
	 loopCount+read+notify+req,
	 keysArray+read+req,
	 valuesArray+read+req,
         quatOrEuler+read+req,
	 resultArray+write
      );
   };

   module ScalarInterpolator<
      cxx_class="InterpolatorClass",
      cxx_hdr_files="avs/animator/interp.h">
   {
      float loopCount<export=2,NEportLevels={2,0}>;
      float keysArray<export=2>[0];
      prim valuesArray<export=2,NEportLevels={0,0}>[0];
      enum interpType<export=2> {
         choices => {"Linear","Cubic","Quintic","Sinusoidal"};
      } = "Linear";
      prim result<export=2,NEportLevels={0,2}>;
      cxxmethod LUpdate(
         interpType+read+req,
	 loopCount+read+notify+req,
	 keysArray+read+req,
	 valuesArray+read+req,
	 result+write
      );

   };

   module StringInterpolator<export=1> {
      float loopCount<export=2,NEportLevels={2,0}>;
      float keysArray<export=2>[];
      string valuesArray<export=2,NEportLevels={0,0}>[];
      string result<NEportLevels={0,2}>;
      cxxmethod LUpdate(
         interpType+read+notify+req,
	 loopCount+read+notify+req,
	 keysArray+read+notify+req,
	 valuesArray+read+notify+req,
	 result+write
      );
   };

   module ImageCap<
      cxx_class="ImageCap",
      cxx_hdr_files="avs/animator/ImageCap.h",
      export=0>
   {
      int LMode<NEportLevels={2,0}> = 0;
      int LCaptureMode<NEportLevels={2,0}> = 1;
      int LClear<NEportLevels={2,0}> = 0;
      int LRecord<NEportLevels={2,0}> = 0;
      int LDelete<NEportLevels={2,0}> = 0;

      // 0 = AVI (Windows only), 1 = MPEG-1
      int LMovieMode<NEportLevels={2,0}> = 1;
      // MPEG Variable Bitrate flag
      // 0 = constant bitrate, 1 = variable bitrate
      int LMovieVariableRate<NEportLevels={2,0}> = 0;
      // MPEG target bitrate in bits per second when in CBR mode.
      // 0 for default setting which varies depending on MPEG-1
      // vs. MPEG-2.  The old default was 1,152,000.
      int LMovieBitRate<NEportLevels={2,0}> = 0;
      // MPEG Quantization Level when in VBR mode.  0 gets
      // default setting, otherwise use 2-31.
      int LMovieQuality<NEportLevels={2,0}> = 0;
      // MPEG VBV buffer.  0 for default setting, otherwise
      // in multiples of 16 kbit.  MPEG-1 default is 23,
      // MPEG-2 default is 112.  VBV = Video Buffering Verifier.
      int LMovieBuffer<NEportLevels={2,0}> = 0;

      // 0 is uncompressed, 1 is compressed.
      int AVImode<NEportLevels={2,0}> = 0;
      // The four-character-code for specifying a VFW compression codec
      // to compress the AVI file.  Windows only.
      // Some examples ...
      // "I420" = Intel 4:2:0 Video
      // "HFYU" = Huffyuv v2.1.1
      // "DIVX" = DivX
      string AVIfourcc<NEportLevels={2,0}>;
      // trigger the choose codec method
      int AVItrigger<NEportLevels={2,0}>;

      // movie trigger
      int LGenMovie<NEportLevels={2,0}> = 0;

      int LCurrentImage<NEportLevels={2,2}> = 0;
      int LTotalImages<NEportLevels={0,2}> = 0;
      int LFlipFrameBuffer<NEportLevels={2,0}> = 1;
      float LTotalSize<NEportLevels={0,2}>;
      string LAnimOutFile<NEportLevels={2,0}>;
      // Overwrite output file without warning?
      // 0 == warn if overwrite,
      // 1 == overwrite without warning
      int LAnimOutOverwrite<NEportLevels={2,0}> = 0;
      string LAnimTempDir<NEportLevels={2,0}>;

      GD.GDview_ref_templ+notify &LGDView<NEportLevels={2,0},export=0>;
      Mesh_Unif+Dim2+Space2+Node_Data+Vector4+nosave+notify &LInputFrameBuffer<NEportLevels={2,0},export=0>;
      Mesh_Unif+Dim2+Space2+Node_Data+Vector4+nosave LFrameBuffer<NEportLevels={0,2},export=0>;

      int LPBDelay<NEportLevels={2,0}> = 0;
      int LRunForward<NEportLevels={2,0}> = 0;
      int LRunBack<NEportLevels={2,0}> = 0;
      int LCycleType<NEportLevels={2,0}> = 0;
      int LLoopCount<NEportLevels={2,0}> = 0;
      int LTimerStep<NEportLevels={2,0}> = 0;
      int LTimerActive<NEportLevels={2,0}> = 0;
      int LTimerFrameStep<NEportLevels={2,0}> = 1;
      int LTimerFrameVal<NEportLevels={2,0}> = 0;

      cxxmethod+notify_deinst ChooseCodec<status=1> (
            AVItrigger+read+notify+req,
            AVImode+read+req,
            AVIfourcc+write
      );

      cxxmethod LUpdate<status=1> (
            LMode+read+notify+req,
            LCaptureMode+read+notify+req,
            LClear+read+notify+req,
            LRecord+read+notify+req,
            LDelete+read+notify+req,
            LMovieMode+read+notify+req,
            LMovieVariableRate+read,
            LMovieBitRate+read,
            LMovieQuality+read,
            LMovieBuffer+read,
            AVImode+read,
            AVIfourcc+read,
            LGenMovie+read+notify+req,
            LCurrentImage+read+notify+req,
	    LTotalImages+write,
            LTotalSize+write,
            LAnimOutFile+read+notify+req,
            LAnimOutOverwrite+read,
	    LGDView+read+notify,
            LFrameBuffer+write,
	    LInputFrameBuffer+read+notify+req,
	    LRunForward+read+notify,
	    LRunBack+read+notify,
	    LCycleType+read+notify,
	    LLoopCount+write,
	    LPBDelay+read+notify,
	    LTimerStep+read+notify,
	    LTimerActive+read+notify,
	    LTimerFrameStep+read+notify,
	    LTimerFrameVal+read+notify
      );
   };

   module GeomCap<
      cxx_class="GeomCap",
      cxx_hdr_files="avs/animator/GeomCap.h",
      cxx_members="OMobj_id m_oldViewId;",
      cxx_members_constr="m_oldViewId(OMnull_obj)",
      export=0>
   {
      int CMode<NEportLevels={2,0}> = 0;
      int CCaptureMode<NEportLevels={2,0}> = 1;
      int CClear<NEportLevels={2,0}> = 0;
      int CRecord<NEportLevels={2,0}> = 0;
      int CDelete<NEportLevels={2,0}> = 0;
      int CCurrentFrame<NEportLevels={2,2}> = 0;
      int CTotalFrames<NEportLevels={0,2}> = 0;
      string CAnimOutFile<NEportLevels={2,0}>;

      GD.GDview_ref_templ+notify &CGDView<NEportLevels={3,0},export=0>;

      int LPBDelay<NEportLevels={2,2}> = 0;
      int LRunForward<NEportLevels={2,0}> = 0;
      int LRunBack<NEportLevels={2,0}> = 0;
      int LCycleType<NEportLevels={2,0}> = 0;
      int LLoopCount<NEportLevels={2,0}> = 0;
      int LTimerStep<NEportLevels={2,0}> = 0;
      int LTimerActive<NEportLevels={2,0}> = 0;
      int LTimerFrameStep<NEportLevels={2,0}> = 1;
      int LTimerFrameVal<NEportLevels={2,0}> = 0;

      cxxmethod CUpdate<status=1> (
            CMode+read+notify+req,
            CCaptureMode+read+notify+req,
            CClear+read+notify+req,
            CRecord+read+notify+req,
            CDelete+read+notify+req,
            CCurrentFrame+read+notify+req,
	    CTotalFrames+write,
            CAnimOutFile+read+notify+req,
	    CGDView+read+notify,
	    LRunForward+read+notify,
	    LRunBack+read+notify,
	    LCycleType+read+notify,
	    LLoopCount+write,
	    LPBDelay+read+notify,
	    LTimerStep+read+notify,
	    LTimerActive+read+notify,
	    LTimerFrameStep+read+notify,
	    LTimerFrameVal+read+notify
      );
   };

   module GeomRep<
      cxx_class="GeomCap",
      cxx_hdr_files="fld/Xfld.h avs/animator/GeomCap.h",
      cxx_members="OMobj_id m_oldViewId;",
      cxx_members_constr="m_oldViewId(OMnull_obj)",
      export=0>
   {
      int CCurrentFrame<NEportLevels={2,2}> = 0;
      int CTotalFrames<NEportLevels={0,2}> = 0;
      string CAnimInFile<NEportLevels={2,0}>;

      GD.GDview_ref_templ+notify &CGDView<NEportLevels={3,0},export=0>;

      int LPBDelay<NEportLevels={2,2}> = 0;
      int LRunForward<NEportLevels={2,0}> = 0;
      int LRunBack<NEportLevels={2,0}> = 0;
      int LCycleType<NEportLevels={2,0}> = 0;
      int LLoopCount<NEportLevels={2,0}> = 0;
      int LTimerStep<NEportLevels={2,0}> = 0;
      int LTimerActive<NEportLevels={2,0}> = 0;
      int LTimerFrameStep<NEportLevels={2,0}> = 1;
      int LTimerFrameVal<NEportLevels={2,0}> = 0;
      int CFullCache<NEportLevels={2,0}> = 0;
      int CReplayMode<NEportLevels={2,0}> = 1;

      cxxmethod+notify_inst ConInstance();
      cxxmethod CUpdate<status=1> (
            CCurrentFrame+read+write+notify+req,
            CTotalFrames+write,
            CAnimInFile+read+notify+req,
            CGDView+read+notify,
            LRunForward+read+notify,
            LRunBack+read+notify,
            LCycleType+read+notify,
            LLoopCount+write,
            LPBDelay+read+notify,
            LTimerStep+read+notify,
            LTimerActive+read+notify,
            LTimerFrameStep+read+notify,
            LTimerFrameVal+read+notify,
            CFullCache+read+notify,
            CReplayMode+read+write+notify+req
      );
   };

   module GeomSave_templ<
      cxx_class="GeomSave",
      cxx_class_args="*this",
      cxx_hdr_files="avs/animator/GeomSave.h"> {
        GD.GDview_ref_templ &SGDView<NEportLevels={2,0},export=0>;
        string SFilename;
        int    SFormat;
        int    SFrameNo;
        boolean overwrite = 0;  // If true skip overwrite check

        cxxmethod SGFAUpdate<status=1> (
            SFilename+read+notify+req,
            SFormat+read+notify+req,
            SFrameNo+read+notify+req,
            overwrite+read+nonotify+opt
        );

	data_method GSinit_animation;
	data_method GSend_animation;
	data_method GSabort_animation;
	data_method GSwrite_geometry_list;
	data_method GSwrite_geometry;
	data_method GSwrite_cache;
	data_method GSwrite_xform_list;
	data_method GSwrite_xform;
	data_method GSwrite_props_list;
	data_method GSwrite_props;
	data_method GSwrite_modes_list;
	data_method GSwrite_modes;
	data_method GSwrite_texture_list;
	data_method GSwrite_texture;
	data_method GSwrite_txtrxform_list;
	data_method GSwrite_txtrxform;
	data_method GSwrite_view;
	data_method GSwrite_camera_list;
	data_method GSwrite_camera;
	data_method GSwrite_frame_list;
	data_method GSwrite_frame;
	data_method GSwrite_object;
	data_method GSend_object;
	data_method GSend_frame;
   };

   GeomSave_templ GeomSave_GFA<cxx_hdr_files="avs/animator/gfaFile.h"> {
	GSinit_animation = "GFAinit_animation";
	GSend_animation  = "GFAend_animation";
	GSabort_animation = "GFAabort_animation";
	GSwrite_geometry_list = "GFAwrite_geometry_list";
	GSwrite_geometry      = "GFAwrite_geometry";
	GSwrite_cache        = "GFAwrite_cache";
	GSwrite_xform_list   = "GFAwrite_xform_list";
	GSwrite_xform        = "GFAwrite_xform";
	GSwrite_props_list   = "GFAwrite_props_list";
	GSwrite_props        = "GFAwrite_props";
	GSwrite_modes_list   = "GFAwrite_modes_list";
	GSwrite_modes        = "GFAwrite_modes";
	GSwrite_texture_list = "GFAwrite_texture_list";
	GSwrite_texture        = "GFAwrite_texture";
	GSwrite_txtrxform_list = "GFAwrite_txtrxform_list";
	GSwrite_txtrxform      = "GFAwrite_txtrxform";
	GSwrite_camera_list    = "GFAwrite_camera_list";
	GSwrite_camera         = "GFAwrite_camera";
	GSwrite_frame_list     = "GFAwrite_frame_list";
	GSwrite_frame          = "GFAwrite_frame";
	GSwrite_object         = "GFAwrite_object";
   };
};


