/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/au.v#1 $
*/


// Make this be a "global config" parameter that users can switch...
#define AU_UI_VIS Templates.CONFIG.au_show_ui

#define STATUS_HEIGHT 34
#define TOOL_HEIGHT 34

flibrary AU <dictionary="au.dct"> {

flibrary AUI<NEvisible=0> {
   /*
    * Define base hconn objects for widget's and containers
    */
   GMOD.hconnect _hconn_widget {
      direction = 0;
      offer_name = "<-.parent";
      offer = "widget";
      skip_levels = 1;
   };
   _hconn_widget _hconn_container {
      accept_name = "<-";
      accept = "widget";
   };
   /*
    * Define base hconn objects for option's and option lists
    */
   GMOD.hconnect _hconn_cmd {
      direction = 1;
      offer_name = "<-";
      offer = "list (cmd)";
      skip_levels = 1;
   };
   _hconn_cmd _hconn_option {
      offer = "list (option)";
   };
   _hconn_cmd _hconn_cmd_list {
      accept_name = "<-.cmdList";
      offer = "list (cmd_list)";
      accept = "list (cmd)";
   };
   _hconn_cmd_list _hconn_option_list {
      offer = "list (option_list)";
      accept = "list (option)";
   };
   UIpanel _AU_panel<hconnect=2,export=2,export_subs=1> {
      AUI._hconn_container hconn_widget<instanced=2,
	     hdr_code="int AUdefault_shell_create (OMobj_id);"> {
	 offer<export=3> = "widget (panel)";
	 offer_name = "<-.parent";
	 hconn_inst<weight=-1>;
	 default_func = "AUdefault_shell_create";
      };
      x<export=2> = 0;
      y<export=2> = 0;
      width<export=2> => parent.clientWidth;
      height<export=2> => parent.clientHeight;
      // By default, need to set this to 0 cause UI can't deal with
      // cmd's being added to lists with 1 in "radio-list" mode.
      visible = 0;
      /*
       * If we create a default window, we want to have a place to 
       * store the X and Y of the window.  The shell's X and Y are
       * connected here.  The shell is not saved (UIdefault_shell_attach
       * sets the nosave attribute), but we do want to save some of
       * the information.
       */
      int defaultX;
      int defaultY;
      int defaultWidth = 512;
      int defaultHeight = 512;
      int defaultIconic = 0;
      string title;
   };
};

flibrary+global Widgets<NEeditable=1> {
   UIoptionMenu30 AUoptionMenu {
      AUI._hconn_widget hconn_widget;
   };
   UIpanel AUtoolbar {
      x = ;
      y = ;
      AUI._hconn_cmd_list hconn_list<instanced=0> {
         offer = "";
	 accept = "toolbar";
      };
      library templ { // this template is used to create the buttons 
	 UIbutton button {
	    width = 27;
	    height = 27;
	    &labelPixmap;
	 };
      };
      int tool_dir;
      int pad, list_pad;
      int tip_placement;
      group+nosave buttons<locked=0>;
      group &cmdList[] {
	 string+nonotify label;
	 group+opt &cmdList[] {
	    string+nonotify label;
	 };
      };
      omethod+notify_inst tool_update<weight=0,interruptable=0>(
				      cmdList+notify+read,
				      tool_dir+notify+read,
				      pad+notify+read,list_pad+notify+read,
				      tip_placement+notify+read)
				      = "AUtoolbar_update";
   };
   UIoptionList AUoptionToolList<hconnect=2> {
      /*
       * We want to run when new guys are added or when the "set" member
       * changes, not this other junk
       */
      cmdList {
	 message+nonotify;
	 accelerator+nonotify;
	 do+nonotify;
	 active+nonotify;
      };
      AUI._hconn_option_list hconn_list {
   	 accept = "toolbar";
	 offer = "toolbar";
      };
      radioBehavior = 1;
      int selectedItem;
      omethod+notify_inst+notify+read update<interruptable=0> 
				= "AUoption_list_update";
   };
   UIcmdList AUmenuList {
      AUI._hconn_option_list hconn_list {
   	 accept = "";
	 offer = "list (menubar)";
      };
   };
   UIcmd AUfileMenuCmd {
      AUI._hconn_option_list hconn_list {
   	 accept = "";
	 offer = "list (file_menu)";
      };
   };
   UIoption AUfileMenuOption {
      AUI._hconn_option_list hconn_list {
   	 accept = "";
	 offer = "list (file_menu)";
      };
   };
   UIoption AUoptionTool {
      int option_tool; // flag to indicate that this is a separate option
      int tool_order;  // priority integer indicating order in toolbar
      int tool_space;
      GMOD.parse_v run_on_do {
	 on_inst = 0;
	 trigger => <-.do;
	 relative => <-;
	 v_commands = "set = !set;";
      };
      AUI._hconn_option hconn_list {
	 offer = "toolbar";
      };
      pixmap.fileType = "avs_image";
   };
   UIcmd AUcmdTool {
      int tool_order;  // order in tool list 
      int tool_space;
      AUI._hconn_option hconn_list {
	 offer = "toolbar";
      };
      pixmap.fileType = "avs_image";
   };
};

flibrary+global Containers<NEeditable=1> {
   macro AUpanel<export=1> {
      macro UI<hconnect=2,NEvisible=AU_UI_VIS,NEx=0,NEy=0,
		ui_global_class=1> {
	 AUI._AU_panel panel;
	 UIoption option<hconnect=2,export=2,
			 export_subs=1,NEopened="export_list"> {
	    AUI._hconn_option hconn_list {
	       offer<export=3> = "list (option panel)";
	       hconn_inst<weight=-1>;
	       skip_levels = 3;//should never add itself to someone at same level
	    };
	    set => <-.panel.visible;
	    label => name_of(<-.<-.<-,1);
	 };
      };
   };
   macro AUpanel_inst<export=1> {
      macro UI<hconnect=2,NEvisible=AU_UI_VIS,NEx=0,NEy=0,
		ui_global_class=1> {
	 GMOD.instancer instancer {
	    Group => <-.<-.IUI;
	    Value => IUI.panel.visible;
	    active = 2;
	 };
	 UIoption option<hconnect=2,export=2,
			 export_subs=1,NEopened="export_list"> {
	    AU.AUI._hconn_option hconn_list {
	       offer<export=3> = "list (option panel)";
	       hconn_inst<weight=-1>;
	       //should never add itself to someone at same level
	       skip_levels = 3;
	    };
	    set => <-.<-.IUI.panel.visible;
	    label => name_of(<-.<-.<-,1);
	 };

      };
      macro IUI<instanced=0,hconnect=2,ui_global_class=1> {
	 AU.AUI._AU_panel panel;
      };
   };
   AUpanel_inst AUstack_inst {
      UI {
	 option {
	    hconn_list {
	       offer = "list (option stack)";
	       skip_levels = 3;
	    };
	 };
      };
      IUI {
	 panel {
	    hconn_widget {
	       accept = "";
	       offer = "widget (stack)";
	       skip_levels = 3;
	    };
	 };
#ifdef MSDOS
	 UIradioList optionList<hconnect=2> {
            int height = 0;
            int y = 0;
#else
	 UIoptionMenu optionList<hconnect=2> {
	    y = 0;
#endif
	    radioBehavior = 1;
	    label => name_of(<-.<-.<-,1);
	    AU.AUI._hconn_option_list hconn_list;
	 };
	 UIframe frame<hconnect=2> {
	    AU.AUI._hconn_container hconn_widget<instanced=0> {
	       offer = ;
	       /* Only accept panels and stacks here */
	       accept = "widget (panel stack)";
	    };
	    parent => <-.panel;
	    x = 5;
	    y => <-.optionList.y + <-.optionList.height + 5;
	    width => <-.panel.clientWidth - 10;
	    height => <-.panel.clientHeight - y - 5;
	 };
      };
   };
   AUstack_inst AUoptionMenuStack {
      IUI {
#ifdef MSDOS
      	optionList+UIoptionMenu {

            // The following line fixes PR 6244.  The optionList is a merge
            // of UIradioList and UIoptionMenu.  The "notify_inst" attribute
            // on the optionList's update method, required by UIoptionMenu,
            // was not preserved during the merge, so we add it again.
            //update+notify_inst;

            // Need to make sure that it stays an omethod.  CFS PR 21096.
            omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = "UIoptionMenuUpdate";
#else
	 optionList {
#endif
	    optionLabel = 1;
	    width = 250;
	    label => name_of(<-.<-.<-,1);
	    x => (panel.width - width) / 2;
	    y = 5;
	    parent => <-.panel;
#ifdef MSDOS
	    hconn_list {
		offer = ;
	    };
#else
	    hconn_list {
	       offer = ;
	    };
#endif
	 };
      };
   };
   AUstack_inst AUoptionListStack;
};

flibrary+global Macros<NEeditable=1> {
   macro AUstatus_bar<export=1> {
      UIcontainer &parent<NEportLevels={2,1}>;
      int+IPort2 x;
      int+IPort2 y;
      int+OPort2 height = STATUS_HEIGHT;
      int+OPort2 width => parent.width;
      UIframe UIframe {
	 x => <-.x + 5;
	 y => <-.y;
	 parent => <-.parent;
	 width 	=> <-.width - 10;
	 height = <-.height;
	 shadowType = "shadow_etched_in";
	 shadowThickness = 2;
      };
      UIlabel ModuleName {
	 x		= 0;
	 y		= 0;
	 label 		=> Scheduler.current_mod;
	 height 	=> UIframe.clientHeight;
	 width 		=> <-.width / 3;
	 parent		=> <-.UIframe;
	 alignment 	= 0;
	 update<status=0>;
      };
      UIpanel Basin {
	 x 		=> (ModuleName.x + ModuleName.width);
	 y 		= 3;
	 width 		=> UIframe.width - ModuleName.width
				 - StopGo.StopGo.width;
//				 - OnOffStatus.OnOffStatus.width;
	 height 	=> <-.UIframe.clientHeight - 6;
	 color {
#ifdef MSDOS
	    backgroundColor = "light red";
#else
	    backgroundColor = "red";
#endif
	 };
	 parent 	=> <-.UIframe;
      };
      UIpanel ChangeBar {
	 x 		= 0;
	 y 		= 0;
	 width 	=> ((Basin.clientWidth * (Scheduler.percent_done+1)) / 100.0);
	 height 	=> <-.Basin.clientHeight;
	 color {
#ifdef MSDOS
	    backgroundColor = "light green";
#else
	    backgroundColor = "green";
#endif
	 };
	 parent 	=> <-.Basin;
	 update<status=0>;
      };
      macro StopGo {
	 UIcontainer &parent<NEportLevels={2,1}> => <-.UIframe;
	 UIbutton StopGo {
	    UImake_dyn_wind UImake_dyn_wind {
	       in_handle => <-.handle;
	    };
	    x => <-.<-.Basin.x + <-.<-.Basin.width;
//	    y => (UIframe.height - height) / 2 - 2;
	    y = 0;
	    width = 38;
	    height = 18;
	    parent => <-.parent;
	    label => switch(StopGoInd+1,"Interrupt execution",
					"Enable execution");
	    labelPixmap {
	       filename => StopGoIcons[StopGoInd];
	       fileType = "avs_image";
	    };
	    update<status=0>;
	 };
	 GMOD.parse_v ParseStopGo {
	    v_commands = "StopGoAccum = StopGoAccum + 1;Disabler=StopGoInd;";
	    trigger => <-.StopGo.do;
	    on_inst = 0;
	    relative => <-.<-;
	    parse_v_relative<interruptable=0,status=0>;
	 };
	 string StopGoIcons[2] = {
	    "$XP_PATH<0>/v/vizxp/icons/go.x",
	    "$XP_PATH<0>/v/vizxp/icons/stop.x"
	 };
	 int Disabler => Scheduler.interrupt;
	 int StopGoInd => (StopGoAccum % 2);
	 int StopGoAccum = 0;
      };
      macro OnOffStatus {
	 UIcontainer &parent<NEportLevels={2,1}> => <-.UIframe;
	 UIbutton OnOffStatus {
	    UImake_dyn_wind UImake_dyn_wind {
	       in_handle => <-.handle;
	    };
//	    x => StopGo.StopGo.x + StopGo.StopGo.width - 2;
//	    y => (UIframe.height - height) / 2 - 2;
	    x => StopGo.StopGo.x;
	    y => StopGo.StopGo.height - 4;
	    width = 38;
	    height = 18;
	    parent => <-.parent;
	    label => switch(OnOffInd+1,"Disable status", "Enable status");
	    labelPixmap {
	       filename => OnOffIcons[OnOffInd];
	       fileType = "avs_image";
	    };
	    update<status=0>;
	 };
	 string OnOffIcons[2] = {
	    "$XP_PATH<0>/v/vizxp/icons/go.x",
	    "$XP_PATH<0>/v/vizxp/icons/stop.x"
	 };
	 GMOD.parse_v ParseOnOff {
	    v_commands = "OnOffInd = !OnOffInd;";
	    trigger => <-.OnOffStatus.do;
	    on_inst = 0;
	    relative => <-.<-;
	    parse_v_relative<interruptable=0,status=0>;
	 };
	 int OnOffInd => !(Scheduler.status_check);
      };
   };
};
flibrary+global Applications<NEeditable=1> {
   macro AUshell {
      macro UI<hconnect=2,NEvisible=AU_UI_VIS,ui_global_class=1,
		NEx=0,NEy=0,export_subs=1> {
	 UIshell shell {
	    title => name_of(<-.<-.<-,1);
	    width	=> UIdata.UIdisplays[0].width / 4;
	    height	=> UIdata.UIdisplays[0].height * 5 / 6;
	    menu => <-.menu;
	 };
	 AU.AUpanel panel<hconnect=2> {
	    UI {
	       panel<NEportLevels={0,3}> {
		  visible = 1;
		  hconn_widget<instanced=0> {
		     accept = "widget (shell stack panel)";
		     offer = ;
		  };
		  parent<NEportLevels={4,0}> => <-.<-.<-.shell;
	       };
	       option.hconn_list.offer =;
	    };
	 };
	 UIcmdList menu<hconnect=2> {
	    AU.AUI._hconn_cmd_list hconn_list<instanced=0> {
	       accept = "list (option_list cmd_list shell menubar)";
	    };
	    cmdList => {File};
	 };
	 macro exit_dialog {
	    GMOD.exit_process ExitProcess {
	       do_exit => ExitDialog.ok;
	       status = 0;
	    };
	    UIquestionDialog ExitDialog {
	       title    =  "AU_EXIT_TITLE";
	       message  =  "AU_EXIT_DLG_MSG";
	       visible  => Exit.do;
	       isModal  =  1;
	       update<status=0>;
	    };
	    UIcmd Exit<NEportLevels={0,2}> {
	       label 	= "AU_EXIT_MENU";
	       message 	= "AU_EXIT_MSG";
	    };
	 };
	 UIcmdList File<hconnect=2> {
	    AU.AUI._hconn_cmd_list hconn_list<instanced=0> {
	       accept = "list (file_menu)";
	    };
	    cmdList => {exit_dialog.Exit};
	    label = "AU_FILE_MENU";
	 };
      };
   };
   AUshell AUappl {
      UI {
	 AU.AUtoolbar toolbar<hconnect=2> {
	    y = 5;
	    height = TOOL_HEIGHT;
	    hconn_list<instanced=0> {
	       accept = "toolbar";
	       offer =;
	    };
	    parent => <-.shell;
	 };
	 panel.UI.panel {
	    y => toolbar.height;
	    height => parent.clientHeight - status_bar.height - 
		      toolbar.height;
	 };
	 AU.AUstatus_bar status_bar {
	    x = 0;
	    // Don't wipe out this connection when restoring
	    // a minimized app.  CFS PR 25930.
	    y => <-.shell.clientHeight <+> (- STATUS_HEIGHT);
	    parent => <-.shell;
	 };
      };
   };
   AUappl SingleWindowBase {
      UI {
	 shell {
	    width => ((Windows.IUI.panel.width<+>panel.UI.panel.width) <+> 20);
   /* This pad value compensates for menu height and shell height... should
      be accessible in UI global object? */
#ifdef MSDOS
#define SHELL_PAD 85
#else
#define SHELL_PAD 65
#endif
	    height => (((Windows.IUI.panel.height <+> toolbar.height) <+> 
			SHELL_PAD) <+> InfoBar.height);
	    statusString = "Pick objects with <ctrl>+left mouse button";
	 };
	 panel {
	    UI {
	       panel {
		  hconn_widget {
		     accept = ;
		  };
		  y => 0;
		  width => 320;
		  // Don't wipe out this connection when restoring
		  // a minimized app.  CFS PRs 9833, 10002.
		  height => parent.clientHeight <+> (-status_bar.height);
	       };
	    };
	 };
	 status_bar {
	    width => <-.panel.UI.panel.width;
	 };
	 toolbar {
	    x => <-.panel.UI.panel.width + 10;
	    y => 5;
	    tip_placement = 0; // north
	 };
	 AU.AUstack_inst Windows<hconnect=2> {
	    IUI {
	       optionList<NEportLevels={0,3}> {
		  hconn_list {
		     accept = "list (graphics)";
		  };
		  label = "AU_WINDOWS_MENU";
	       };
	       panel {
		  parent => <-.<-.<-.shell;
		  hconn_widget<instanced=0> {
		     accept = "widget (graphics)";
		     offer = ;
		  };
		  x => <-.<-.<-.panel.UI.panel.width + 10;
		  y => toolbar.y + toolbar.height + 5;
		  width => 506;
		  height => 506;
		  visible => 1;
	       };
	       frame<instanced=0> {
		  visible = 0;
		  hconn_widget {
		     accept = ;
		  };
	       };
	    };
	    UI {
	       option {
		  hconn_list.offer = ;
	       };
	    };
	 };
	 UIpanel InfoBar<hconnect=2> {
	    parent => <-.shell;
	    x => <-.panel.UI.panel.width + 10;
	    y => <-.panel.UI.panel.height;
	    width => Windows.IUI.panel.width;
	    height => status_bar.height;
	    AU.AUI._hconn_container hconn_widget<instanced=0> {
	       offer = ;
	       accept = "widget (info)";
	    };
	 };

	 AU.AUoptionListStack Editors<hconnect=2,ui_global_class=1> {
	    UI.option.hconn_list.offer = ;
	    IUI {
	       optionList<list_class="Modules",NEportLevels={0,3}> {
		  hconn_list {
		     offer =;
		     accept = "list (stack panel !graphics !info)";
		  };
		  label = "AU_EDITORS_MENU";
	       };
	       panel {
		  hconn_widget {
		     offer = ;
		  };
		  visible = 1;
		  parent<NEportLevels={4,0}> => <-.<-.<-.panel.UI.panel;
	       };
	       frame<widget_class="widget",NEportLevels={0,3}> {
		  hconn_widget {
		     accept = "widget (stack panel !graphics)";
		  };
	       };
	    };
	 };
	 menu {
	    cmdList => {File, Editors.IUI.optionList, Windows.IUI.optionList};
	 };
      };
   };
   SingleWindowBase SingleWindowApp {
      UI {
	 AU.AUoptionMenuStack Modules<hconnect=2,
				      ui_global_class=1> {
	    IUI {
	       panel.parent<NEportLevels={4,0}>;

	       // makes the Modules editor visible by default (5543)
	       panel.visible = 1;

	       optionList<list_class="Modules"> {
		  hconn_list {
		     accept = "list (module)";
		  };
	       };
	       frame {
		  hconn_widget<instanced=0> {
		     accept = "";
		  };
	       };
	       UIscrolledWindow mod_panel<widget_class="widget",hconnect=2>{
		  x = 0;
		  y = 0;
		  AU.AUI._hconn_container hconn_widget<instanced=0> {
		     accept = "widget (module)";
		  };
		  parent => frame;
		  scrollBars	=  2;
		  width	=> frame.clientWidth;
		  height	=> frame.clientHeight;
		  virtualWidth => .width * 5;
		  virtualHeight=> .height * 5;
	       };
	    };
	    UI {
	       option {
		  label = "AU_MODULES_MENU";
		  message = "AU_EDIT_MOD_MSG";
	          hconn_list.order = 0;
	       };
	    };
	 };
	 /*
	  * The Editors panel should no longer get the "modules" objects
	  */
	 Editors {
	    IUI {
	       optionList<list_class=""> {
		  hconn_list.accept = 
			   "list (stack panel !module !graphics !info)";
	          label = "AU_EDITORS_MENU";
	       };
	       frame<widget_class=""> {
		  y = 0;
		  hconn_widget.accept = 
			   "widget (stack panel !module !graphics)";
	       };
	    };
	 };
      };
   };
   AUappl MultiWindowApp {
      UI {
	 shell {
	    x = 5;
	    y = 5;
	    width => 364;
	    statusString = "Pick objects with <ctrl>+left mouse button";
	 };
	 panel {
	    UI {
	       panel {
		  hconn_widget {
		     accept = ;
		  };
		  x => toolbar.width + 3;
		  y => 0;
		  width => parent.clientWidth - 36;
		  height => parent.clientHeight - 2 * STATUS_HEIGHT - 2;
	       };
	    };
	 };
	 toolbar {
	    x = 4;
	    y = 4;
	    height = ;
	    tool_dir = 1; // vertical
	    tip_placement = 2; // east
	 };
	 AU.AUoptionMenuStack Modules<hconnect=2,ui_global_class=1> {
	    IUI {
	       panel.parent<NEportLevels={4,0}>;

	       // makes the Modules editor visible by default (5543)
	       panel.visible = 1;

	       optionList<list_class="Modules"> {
		  hconn_list {
		     accept = "list (module)";
		  };
	       };
	       frame {
		  hconn_widget<instanced=0> {
		     accept = "";
		  };
	       };
	       UIscrolledWindow mod_panel<widget_class="widget",hconnect=2>{
		  AU.AUI._hconn_container hconn_widget<instanced=0> {
		     accept = "widget (module)";
		  };
		  parent => frame;
		  scrollBars	=  2;
		  width	=> frame.clientWidth;
		  height	=> frame.clientHeight;
		  virtualWidth => .width * 5;
		  virtualHeight=> .height * 5;
	       };
	    };
	    UI {
	       option {
		  label = "AU_MODULES_MENU";
		  message = "AU_EDIT_MOD_MSG";
		  hconn_list.order = 0;
	       };
	    };
	 };
	 UIpanel InfoBar<hconnect=2> {
	    parent => <-.shell;
	    x = 5;
	    y => (<-.shell.clientHeight - (status_bar.height * 2)) - 2;
	    width => shell.clientWidth - 10;
	    height => status_bar.height;
	    AU.AUI._hconn_container hconn_widget<instanced=0> {
	       offer = ;
	       accept = "widget (info)";
	    };
	 };
	 AU.AUoptionListStack Editors<hconnect=2> {
	    UI {
	       option.hconn_list.offer = ;
	    };
	    IUI {
	       optionList {
		  hconn_list {
		     offer = ;
		     accept = "list (stack panel !module !graphics !info)";
		  };
		  label = "AU_EDITORS_MENU";
	       };
	       panel {
		  visible = 1;
		  hconn_widget {
		     offer = ;
		  };
		  parent<NEportLevels={4,0}> => <-.<-.<-.panel.UI.panel;
	       };
	       frame<NEportLevels={0,3}> {
		  y = 0;
		  hconn_widget {
		     accept = "widget (stack panel !module !graphics)";
		  };
	       };
	    };
	 };
	 menu {
	    cmdList => {File, Editors.IUI.optionList};
	 };
      };
   };
};
};

#undef STATUS_HEIGHT
#undef TOOL_HEIGHT
