//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/cgen.v#2 $
//	
flibrary CGEN <c_hdr_files="<avs/fld.h>",compile_subs=0> {
group CGEN_prim {
	atts CGEN_int_type<
    		cgen_c_begin="   int  $VAR_NAME;", 
		cgen_f_begin="      INTEGER  $VAR_NAME", 
    		cgen_c_get=
<"   /* Get $VAR_NAME's value */ 
   if (OMget_name_int_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), &$VAR_NAME) != 1) 
      $VAR_NAME = 0;">,
    		cgen_f_get=
<"C    Get $VAR_NAME's value 
      IF (OMFget_name_int_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_NAME) .NE. 1) 
     .   $VAR_NAME = 0">,
    		cgen_c_set=
<"   /* Set $VAR_NAME's value */  
   OMset_name_int_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), $VAR_NAME);">,
    		cgen_f_set=
<"C     Set $VAR_NAME's value
      if (OMFset_name_int_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_NAME) .NE.1 )
     .      PRINT*,'Error setting $VAR_NAME' ">
		>;
	int+CGEN_int_type CGEN_int;
	short+CGEN_int_type CGEN_short;
	char+CGEN_int_type CGEN_char;
	byte+CGEN_int_type CGEN_byte;
	-CGEN_int_type; /* need to get rid of this to prevent match screwups */
	atts CGEN_long_type<
    		cgen_c_begin="   xp_long  $VAR_NAME;",   		
    		cgen_f_begin="      XP_LONG_INT  $VAR_NAME", 
    		cgen_c_get=
<"   /* Get $VAR_NAME's value */
   if (OMget_name_long_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), &$VAR_NAME) != 1)
      $VAR_NAME = 0.0;">,
    		cgen_f_get=
<"C   Get $VAR_NAME's value
      IF (OMFget_name_long_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_NAME) .NE. 1)
     .   $VAR_NAME = 0.0">,
    		cgen_c_set=<"   /* Set $VAR_NAME's value */
   OMset_name_long_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), $VAR_NAME);">,
    		cgen_f_set=
<"C   Set $VAR_NAME's value 
      IF (OMFset_name_long_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'), 
     .   $VAR_NAME) .NE. 1) PRINT*,'Error setting $VAR_NAME' ">
		>;
	long+CGEN_long_type CGEN_long;
	-CGEN_long_type; /* need to get rid of this to prevent match screwups */
	atts CGEN_real_type<
    		cgen_c_begin="   double  $VAR_NAME;", 
    		cgen_f_begin="      DOUBLE PRECISION  $VAR_NAME", 
    		cgen_c_get=
<"   /* Get $VAR_NAME's value */
   if (OMget_name_real_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), &$VAR_NAME) != 1)
      $VAR_NAME = 0.0;">,
    		cgen_f_get=
<"C   Get $VAR_NAME's value
      IF (OMFget_name_real8_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_NAME) .NE. 1)
     .   $VAR_NAME = 0.0">,
    		cgen_c_set=<"   /* Set $VAR_NAME's value */
   OMset_name_real_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), $VAR_NAME);">,
    		cgen_f_set=
<"C   Set $VAR_NAME's value 
      IF (OMFset_name_real8_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'), 
     .   $VAR_NAME) .NE. 1) PRINT*,'Error setting $VAR_NAME' ">
		>;
	float+CGEN_real_type CGEN_float;
	double+CGEN_real_type CGEN_double;
	-CGEN_real_type;
	string CGEN_string<
    		cgen_c_begin="   char  *$VAR_NAME = NULL;", 
    		cgen_f_begin="      CHARACTER*32 $VAR_NAME", 
    		cgen_c_get=
<"   /* Get $VAR_NAME's value */
   if (OMget_name_str_val($MOD_ID, OMstr_to_name("$OBJ_NAME"), &$VAR_NAME, 0) != 1)
      $VAR_NAME = NULL;">,
    		cgen_f_get=
<"C   Get $VAR_NAME's value
      IF (OMFget_name_str_val($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_NAME, LEN($VAR_NAME)) .NE. 1)
     .       PRINT*,'Error setting $VAR_NAME' ">,
    		cgen_c_set="   /* Set $VAR_NAME's value */
   OMset_name_str_val($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $VAR_NAME);",
    		cgen_f_set=
<"C   Set $VAR_NAME's value
      IF (OMFset_name_str_val($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $VAR_NAME) .NE. 1)
     .        PRINT*,'Error setting $VAR_NAME'">,
		cgen_c_get_end="   if ($VAR_NAME)
      free($VAR_NAME);"
		>;
};

group CGEN_array {
        // define a template that can be used for all arrays 
	atts CGEN_arr<
		cgen_c_begin=
<"   xp_long  $VAR_NAME_size = 0;
   $VAR_DTYPE *$VAR_NAME = NULL; ">, 
#ifdef WORDLENGTH_64
		cgen_f_begin=
<"      XP_LONG_INT $VAR_NAME_size
      INTEGER $VAR_NAME_type
      INTEGER*8 $VAR_NAME, $VAR_NAME_offset
      $VAR_DTYPE $VAR_NAME_base(1)">, 
#else
		cgen_f_begin=
<"      XP_LONG_INT  $VAR_NAME_size
      INTEGER $VAR_NAME_type
      INTEGER $VAR_NAME, $VAR_NAME_offset
      $VAR_DTYPE $VAR_NAME_base(1)">, 
#endif
		cgen_c_get=
<"   $VAR_NAME = ($VAR_DTYPE *)OMret_name_array_ptr($MOD_ID, OMstr_to_name("$OBJ_NAME"), $VAR_GET_ARRAY_MODE,
			&$VAR_NAME_size, NULL);">,
		cgen_f_get=
<"      $VAR_NAME = OMFret_name_array_ptr($MOD_ID,
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_GET_ARRAY_MODE, $VAR_NAME_size, $VAR_NAME_type)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME,
     .   $VAR_NAME_base,$VAR_TYPE_ID)">,
		cgen_c_get_end=
<"   if ($VAR_NAME != NULL) 
      ARRfree($VAR_NAME);">,
		cgen_f_get_end=
<"      CALL ARRFfree($VAR_NAME)">,
		cgen_c_set=
<"   /*
    *   set number of elements in array: 
    *   $VAR_NAME_size = ...
    *   allocate array $VAR_NAME:
    */
   $VAR_NAME = ($VAR_DTYPE *)ARRalloc(NULL, $VAR_TYPE_ID, $VAR_NAME_size, NULL);
   /*
    *  fill in array $VAR_NAME
    */
   OMset_name_array($MOD_ID, OMstr_to_name("$OBJ_NAME"), $VAR_TYPE_ID, (void *)$VAR_NAME, 
                    $VAR_NAME_size, OM_SET_ARRAY_FREE);
   /*
    * alternatively, if the dimensions of $VAR_NAME array are set at this point 
    * you can use this call that allocates memory:
    * $VAR_NAME = ($VAR_DTYPE *)OMret_name_array_ptr($MOD_ID,
    *   	   	OMstr_to_name("$OBJ_NAME"), OM_GET_ARRAY_RW,
    *			&$VAR_NAME_size, NULL);
    */">,
		cgen_f_set=
<"C  set number of elements in array: 
C    allocate array $VAR_NAME:
C     $VAR_NAME_size = ...
      $VAR_NAME = ARRFalloc(0, $VAR_TYPE_ID, $VAR_NAME_size, 0)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME,
     .   $VAR_NAME_base,$VAR_TYPE_ID) 
C   fill in array $VAR_NAME here and than set array
      IF (OMFset_name_array($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $VAR_TYPE_ID, $VAR_NAME_base(1+$VAR_NAME_offset), 
     .   $VAR_NAME_size, OM_SET_ARRAY_FREE) .NE. 1)
     .       PRINT*,'Error setting $VAR_NAME'
C
C   Alternatively, if the dimensions of $VAR_NAME array are set 
C   at this point you can use this call that allocates memory for you:
C      $VAR_NAME = OMFret_name_array_ptr($MOD_ID,
C     .   OMFstr_to_name('$OBJ_NAME'),
C     .    OM_GET_ARRAY_RW, $VAR_NAME_size, $VAR_TYPE_ID)
C      
">,
		cgen_c_get_set=<"yes">,
		cgen_f_get_set=<"yes">,
		cgen_cxx_begin= 
<"   xp_long $VAR_NAME_size;
   $VAR_DTYPE *$VAR_NAME_arr;
">,
       cgen_cxx_end= 
<"   $VAR_NAME_arr = ($VAR_DTYPE *)$VAR_NAME.ret_array_ptr($VAR_GET_ARRAY_MODE,&$VAR_NAME_size);
   if ($VAR_NAME_arr) {
      /* Your code to set $VAR_NAME_arr goes here */
      ARRfree($VAR_NAME_arr);
   }
">
		>;
	int+CGEN_arr CGEN_int_arr[];
	short+CGEN_arr CGEN_short_arr[];
	char+CGEN_arr CGEN_char_arr[];
	byte+CGEN_arr CGEN_byte_arr[];
	float+CGEN_arr CGEN_float_arr[];
	double+CGEN_arr CGEN_double_arr[];
	long+CGEN_arr CGEN_long_arr[];
	-CGEN_arr;

	string CGEN_string_arr<
		cgen_c_begin="   char  **$VAR_NAME = NULL;
   OMobj_id $VAR_ID;
   xp_long  $VAR_NAME_size = 0, $VAR_NAME_count;",

		cgen_f_begin="      CHARACTER*32  $VAR_NAME
      XP_LONG_INT  $VAR_NAME_size, $VAR_NAME_count
      INTEGER	$VAR_ID(OIDSIZ)",

		cgen_c_get=
<"   /* Get string array $VAR_NAME */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name("$OBJ_NAME"), $MODE);

   /* Get the number of strings */
   if (OMget_array_size($VAR_ID, &$VAR_NAME_size) != 1 || $VAR_NAME_size == 0)
      $VAR_NAME = NULL;
   else 
      $VAR_NAME = (char **)malloc($VAR_NAME_size * sizeof(char *));
   for ($VAR_NAME_count = 0; $VAR_NAME_count < $VAR_NAME_size; $VAR_NAME_count++) {
      if (OMget_str_array_val($VAR_ID, $VAR_NAME_count, 
			      &($VAR_NAME[$VAR_NAME_count]), 0) != 1)
	 $VAR_NAME[$VAR_NAME_count] = NULL;
   }
">,
		cgen_f_get=
<"C  Get string array $VAR_NAME
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .       PRINT*,'Error finding $VAR_NAME variable ' 
C  Get number of strings
      IF (OMFget_array_size($VAR_ID, $VAR_NAME_size) .NE.1)
     .    $VAR_NAME_size = 0
C  Now get all the strings by setting $VAR_NAME_count to
C  value from 0 to $VAR_NAME_size-1
      $VAR_NAME_count = 0
      IF (OMFget_str_array_val($VAR_ID, $VAR_NAME_count, 
     .     $VAR_NAME, LEN($VAR_NAME)) .NE. 1)
     .         PRINT*,'Error getting $VAR_NAME array value'   
">,
		cgen_c_set=
<"   /* Set $VAR_NAME array */ 
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name("$OBJ_NAME"), OM_OBJ_RW);
   OMset_array_size($VAR_ID, $VAR_NAME_size); /* Set the number of strings */
   for ($VAR_NAME_count = 0; $VAR_NAME_count < $VAR_NAME_size;  $VAR_NAME_count++) {
      OMset_str_array_val($VAR_ID, $VAR_NAME_count, $VAR_NAME[$VAR_NAME_count]);
   }
">,   
		cgen_f_set=
<"C   Set $VAR_NAME array 
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$OBJ_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error finding $VAR_NAME' 
C  Set array size to something
      $VAR_NAME_size = 1
      IF (OMFset_array_size($VAR_ID, $VAR_NAME_size)
     .    .NE. 1)
     .       PRINT*,'Error setting $VAR_NAME  size'
C  Now set all the strings by setting $VAR_NAME_count to
C  value from 0 to $VAR_NAME_size-1 and setting $VAR_NAME itself, of cause
      $VAR_NAME_count = 0
      $VAR_NAME = 'my string'
      IF (OMFset_str_array_val($VAR_ID, $VAR_NAME_count, 
     .   $VAR_NAME) .NE. 1)
     .       PRINT*,'Error setting $VAR_NAME array size' 
">,   
		cgen_c_get_end=
<"   if ($VAR_NAME != NULL) {
      for ($VAR_NAME_count = 0; $VAR_NAME_count < $VAR_NAME_size; $VAR_NAME_count++) {
         if ($VAR_NAME[$VAR_NAME_count] != NULL)
            free((char *)$VAR_NAME[$VAR_NAME_count]);
      }
      free((char *)$VAR_NAME);
   }"> 
		>[];

};

//
// All groups will match this guy.  We need it for polymorphic objects that
// will match more than one group.  Here we declare globals that will match
// all objects to avoid duplicating the definition of the variable in each
// guy.
group CGEN_group {
   group CGEN_group <
     cgen_c_begin ="   OMobj_id $VAR_ID;",
     cgen_f_begin ="      INTEGER $VAR_ID(OIDSIZ)"
     >;
};

group CGEN_mesh {
   atts CGEN_cxx_mesh_points <
   cgen_cxx_begin = 
<"
   // $VAR_NAME.ndim (int) 
   // $VAR_NAME.dims (xp_long []) 
   xp_long *$VAR_NAME_dims = (xp_long *)$VAR_NAME.dims.ret_array_ptr($VAR_GET_ARRAY_MODE);
   // $VAR_NAME.nspace (int) 
   // $VAR_NAME.npoints (int)
   // $VAR_NAME.points (float [])
   float *$VAR_NAME_points = (float *)$VAR_NAME.points.ret_array_ptr($VAR_GET_ARRAY_MODE);
">,
   cgen_cxx_end = 
<"
   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);
   if ($VAR_NAME_points)
      ARRfree($VAR_NAME_points);
">
>;
	Mesh_Unif+CGEN_cxx_mesh_points CGEN_Mesh_Unif<
		cgen_c_begin="   int $VAR_NAME_ndim, $VAR_NAME_nspace;
   xp_long $VAR_NAME_points_size, *$VAR_NAME_dims;		
   float *$VAR_NAME_points;",

#ifdef WORDLENGTH_64
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_dims_base(1)
      INTEGER $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_pnt_sz
      INTEGER*8 $VAR_NAME_offset, $VAR_NAME_points, $VAR_NAME_dims
      REAL $VAR_NAME_pnt_base(1)
">,
#else
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_dims_base(1)
      INTEGER $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_pnt_sz
      INTEGER $VAR_NAME_offset, $VAR_NAME_points, $VAR_NAME_dims
      REAL $VAR_NAME_pnt_base(1)
">,
#endif

		cgen_c_get=<"   /* Get $VAR_NAME uniform mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name("$VAR_NAME"), $MODE);

   /* Get mesh dims array */
   FLDget_dims ($VAR_ID, &$VAR_NAME_dims, &$VAR_NAME_ndim);

   /* Get mesh nspace */
   FLDget_nspace ($VAR_ID, &$VAR_NAME_nspace);

   /* Get mesh extents */
   FLDget_points ($VAR_ID, &$VAR_NAME_points, &$VAR_NAME_points_size, 
                  OM_GET_ARRAY_RD);">,

		cgen_f_get=<"C   Get $VAR_NAME mesh
C   Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .       PRINT*,'Error finding $VAR_NAME' 
C   Get mesh dims array
      IF (FLDFget_dims($VAR_ID, $VAR_NAME_dims, $VAR_NAME_ndim)
     .      .NE. 1) THEN
            PRINT*,'Error getting ndims'
            RETURN
      ENDIF
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)
C   Get mesh nspace
      IF (FLDFget_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .       PRINT*,'Error getting nspace'
C   Get mesh extents
      IF (FLDFget_points ($VAR_ID, $VAR_NAME_points, 
     .   $VAR_NAME_pnt_sz, OM_GET_ARRAY_RD) .NE. 1)
     .        PRINT*,'Error getting points'     
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_points,
     .   $VAR_NAME_pnt_base,DTYPE_FLOAT)
">,

		cgen_c_set=<"    /* Set $VAR_NAME uniform mesh */

   /*  Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name("$VAR_NAME"), $MODE);

   /* Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3 */
   FLDset_ndim ($VAR_ID, $VAR_NAME_ndim);

   /* Set mesh dims array */
   $VAR_NAME_dims = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 
                           $VAR_NAME_ndim, NULL);

   /*** fill in dims array with your values ***/

   FLDset_dims ($VAR_ID, $VAR_NAME_dims);
   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);

   /* Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3 */
   FLDset_nspace ($VAR_ID, $VAR_NAME_nspace);

   /* Set mesh extents */
   $VAR_NAME_points_size = 2*$VAR_NAME_nspace;
   $VAR_NAME_points = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
                               $VAR_NAME_points_size, NULL);

   /*** fill in points array with values for 2 points: low left and high right corners of the mesh ***/

   FLDset_points ($VAR_ID, $VAR_NAME_points, $VAR_NAME_points_size, 
                  OM_SET_ARRAY_FREE);">,

		cgen_f_set=<"C   Set $VAR_NAME mesh
C  Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .       PRINT*,'Error finding $VAR_NAME'
C  Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3
      $VAR_NAME_ndim = 2
      IF (FLDFset_ndim ($VAR_ID, $VAR_NAME_ndim) .NE. 1)
     .       PRINT*,'Error setting ndim'
C  Set mesh dims array
      $VAR_NAME_dims = ARRFalloc(0,DTYPE_LONG,$VAR_NAME_ndim,0)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)      
      IF (FLDFset_dims ($VAR_ID, 
     .   $VAR_NAME_dims_base(1+$VAR_NAME_offset)) .NE. 1)
     .       PRINT*,'Error setting dims'
C  Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3
      $VAR_NAME_nspace = 2 
      IF (FLDFset_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .       PRINT*,'Error setting nspace'
C  Set mesh extents by filling in points array with values for 2 points: 
C  low left and high right corners of the mesh
      $VAR_NAME_pnt_sz = 2*$VAR_NAME_nspace
      $VAR_NAME_points = ARRFalloc(0,DTYPE_FLOAT,$VAR_NAME_pnt_sz,0)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_points,
     .   $VAR_NAME_pnt_base,DTYPE_FLOAT) 
      IF (FLDFset_points ($VAR_ID, 
     .   $VAR_NAME_pnt_base(1+$VAR_NAME_offset), 
     .   $VAR_NAME_pnt_sz, OM_SET_ARRAY_FREE) .NE. 1)
     .       PRINT*,'Error setting points'
">,

		cgen_c_get_end="   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);
   if ($VAR_NAME_points)
      ARRfree($VAR_NAME_points);",

		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_dims)
      CALL ARRFfree($VAR_NAME_points)"
		>;

	Mesh_Rect+CGEN_cxx_mesh_points CGEN_Mesh_Rect<
		cgen_c_begin="   int $VAR_NAME_ndim, $VAR_NAME_nspace;
   xp_long $VAR_NAME_points_size, *$VAR_NAME_dims;		
   float *$VAR_NAME_points;",
#ifdef WORDLENGTH_64
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_nspace
	  XP_LONG_INT $VAR_NAME_pnt_sz
      INTEGER $VAR_NAME_dims_base(1)
      INTEGER*8 $VAR_NAME_offset, $VAR_NAME_points, $VAR_NAME_dims
      REAL $VAR_NAME_pnt_base(1)
">,
#else
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_nspace
	  XP_LONG_INT $VAR_NAME_pnt_sz
      INTEGER $VAR_NAME_dims_base(1)
      INTEGER $VAR_NAME_offset, $VAR_NAME_points, $VAR_NAME_dims
      REAL $VAR_NAME_pnt_base(1)
">,
#endif
		cgen_c_get="   /* Get rectilinear mesh $VAR_NAME */
   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get mesh dims array */
   FLDget_dims ($VAR_ID, &$VAR_NAME_dims, &$VAR_NAME_ndim);

   /* Get mesh nspace */
   FLDget_nspace ($VAR_ID, &$VAR_NAME_nspace);

   /* Get mesh extents */
   FLDget_points ($VAR_ID, &$VAR_NAME_points, &$VAR_NAME_points_size, 
                  OM_GET_ARRAY_RD);",

		cgen_f_get=<"C   Get $VAR_NAME mesh
C   Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error finding mesh'   
C   Get mesh dims array
      IF (FLDFget_dims($VAR_ID, $VAR_NAME_dims, $VAR_NAME_ndim)
     .   .NE. 1)  THEN
         PRINT*,'Error getting dims'
         RETURN
      ENDIF

      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)
C   Get mesh nspace
      IF (FLDFget_nspace ($VAR_ID, $VAR_NAME_nspace)
     .   .NE. 1)  PRINT*,'Error getting nspace'
C   Get mesh extents
      IF (FLDFget_points ($VAR_ID, $VAR_NAME_points, 
     .      $VAR_NAME_pnt_sz, OM_GET_ARRAY_RD)
     .   .NE. 1)  PRINT*,'Error getting points'
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_points,
     .   $VAR_NAME_pnt_base,DTYPE_FLOAT)
">,

		cgen_c_set="   /* Set $VAR_NAME rectilinear mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3 */
   FLDset_ndim ($VAR_ID, $VAR_NAME_ndim);

   /* Set mesh dims array */
   $VAR_NAME_dims = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 
                           $VAR_NAME_ndim, NULL);

   /*** Fill in dims array with your values ***/

   FLDset_dims ($VAR_ID, $VAR_NAME_dims);
   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);

   /* Set mesh nspace $VAR_NAME_nspace can be 1,2 or 3 */
   FLDset_nspace ($VAR_ID, $VAR_NAME_nspace);

   /* Set mesh extents */
   /* Now, that nspace and dims are set, just get pointer to points array */
   FLDget_points ($VAR_ID, &$VAR_NAME_points, &$VAR_NAME_points_size, 
                  OM_GET_ARRAY_RW);

   /*** Fill in points array with points on the boundary of rectilinear mesh ***/
   ",

		cgen_f_set=<"C   Set $VAR_NAME mesh
C  Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE .1)
     .      PRINT*,'Error finding mesh'
C  Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3
      $VAR_NAME_ndim = 2
      IF (FLDFset_ndim ($VAR_ID, $VAR_NAME_ndim). NE. 1)
     .      PRINT*,'Error setting ndim'
C  Set mesh dims array
      $VAR_NAME_dims = ARRFalloc(0,DTYPE_LONG,$VAR_NAME_ndim,0)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)      
      IF (FLDFset_dims ($VAR_ID, 
     .   $VAR_NAME_dims_base(1+$VAR_NAME_offset)) .NE. 1)
     .       PRINT*,'Error setting ndim' 
      CALL ARRFfree($VAR_NAME_dims)      
C  Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3
      $VAR_NAME_nspace = 2 
      IF (FLDFset_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .       PRINT*,'Error setting nspace'
C  Now, that nspace and dims are set, just get pointer to points array
      IF (FLDFget_points ($VAR_ID, $VAR_NAME_points, 
     .   $VAR_NAME_pnt_sz, OM_GET_ARRAY_RW) .NE.1)
     .       PRINT*,'Error setting points'
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_points,
     .   $VAR_NAME_pnt_base,DTYPE_FLOAT)
C  Fill in $VAR_NAME_pnt_base array with points 
C  on the boundary of rectilinear mesh
C  starting with $VAR_NAME_pnt_base(1+$VAR_NAME_offset)
">,

		cgen_c_get_end="   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);
   if ($VAR_NAME_points)
      ARRfree($VAR_NAME_points);",

		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_dims)
      CALL ARRFfree($VAR_NAME_points)",

		cgen_c_set_end="   if ($VAR_NAME_points)
      ARRfree($VAR_NAME_points);",

		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_points)"
		>;

	-CGEN_cxx_mesh_points;

	Mesh_Struct CGEN_Mesh_Struct<
		cgen_cxx_begin = "
   // $VAR_NAME.ndim (int) 
   // $VAR_NAME.dims (int []) 
   xp_long *$VAR_NAME_dims = (xp_long *)$VAR_NAME.dims.ret_array_ptr($VAR_GET_ARRAY_MODE);
   // $VAR_NAME.nspace (int) 
   // $VAR_NAME.nnodes (int)
   // $VAR_NAME.coordinates.values (float [])
   float *$VAR_NAME_coordinates = (float *)$VAR_NAME.coordinates.values.ret_array_ptr($VAR_GET_ARRAY_MODE);
",
		cgen_cxx_end = "
   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);
   if ($VAR_NAME_coordinates)
      ARRfree($VAR_NAME_coordinates);
",
		cgen_c_begin="   int $VAR_NAME_ndim, $VAR_NAME_nspace;
   xp_long $VAR_NAME_nnodes, *$VAR_NAME_dims;		
   float *$VAR_NAME_coord;",
#ifdef WORDLENGTH_64
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_dims_base(1)
      INTEGER $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_nnodes
      INTEGER*8 $VAR_NAME_offset, $VAR_NAME_dims, $VAR_NAME_coord
      REAL $VAR_NAME_crd_base(1)
">,
#else
		cgen_f_begin=<"      INTEGER $VAR_NAME_ndim, $VAR_NAME_dims_base(1)
      INTEGER $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_nnodes
      INTEGER $VAR_NAME_offset, $VAR_NAME_dims, $VAR_NAME_coord
      REAL $VAR_NAME_crd_base(1)
">,
#endif
		cgen_c_get="   /* Get $VAR_NAME structured mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get mesh dims array */
   FLDget_dims ($VAR_ID, &$VAR_NAME_dims, &$VAR_NAME_ndim);

   /* Get mesh nspace */
   FLDget_nspace ($VAR_ID, &$VAR_NAME_nspace);

   /* Get mesh coordinates */
   FLDget_coord ($VAR_ID, &$VAR_NAME_coord, &$VAR_NAME_nnodes, 
                 OM_GET_ARRAY_RD);",

		cgen_f_get=<"C   Get $VAR_NAME mesh
C   Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error finding mesh'
C   Get mesh dims array
      IF (FLDFget_dims($VAR_ID, $VAR_NAME_dims, $VAR_NAME_ndim) 
     .       .NE. 1) THEN
            PRINT*,'Error getting dims' 
            RETURN
      ENDIF
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)
C   Get mesh nspace
      IF (FLDFget_nspace($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .       PRINT*,'Error getting nspace'
C   Get mesh coordinates
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .   $VAR_NAME_nnodes, OM_GET_ARRAY_RD) .NE. 1)
     .        PRINT*,'Error getting coordinates'
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
">,

		cgen_c_set="   /* Set $VAR_NAME structured mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3 */
   FLDset_ndim ($VAR_ID, $VAR_NAME_ndim);

   /* Set mesh dims array */
   $VAR_NAME_dims = (xp_long *)ARRalloc(NULL, DTYPE_LONG, $VAR_NAME_ndim, NULL);

   /*** fill in dims array with your values ***/

   FLDset_dims ($VAR_ID, $VAR_NAME_dims);
   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);

   /* Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3 */
   FLDset_nspace ($VAR_ID, $VAR_NAME_nspace);

   /* Set mesh coordinates */
   /* first allocate $VAR_NAME_coord array */
   FLDget_nnodes ($VAR_ID, &$VAR_NAME_nnodes);
   
   $VAR_NAME_coord = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
                              $VAR_NAME_nspace*$VAR_NAME_nnodes, NULL);

   /*** fill in $VAR_NAME_coord array with X[,Y,Z] values at each node ***/

   FLDset_coord ($VAR_ID, $VAR_NAME_coord, $VAR_NAME_nspace*$VAR_NAME_nnodes, 
                 OM_SET_ARRAY_FREE);

   ",
		cgen_f_set=<"C   Set $VAR_NAME mesh
C  Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting mesh'
C  Set mesh dimensionality, $VAR_NAME_ndim can be 1,2 or 3
      $VAR_NAME_ndim = 2
      IF (FLDFset_ndim ($VAR_ID, $VAR_NAME_ndim) .NE. 1)
     .      PRINT*,'Error setting ndim'
C  Set mesh dims array
      $VAR_NAME_dims = ARRFalloc(0,DTYPE_LONG,$VAR_NAME_ndim,0)
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_dims,
     .   $VAR_NAME_dims_base,DTYPE_INT)      
      IF (FLDFset_dims ($VAR_ID, 
     .   $VAR_NAME_dims_base(1+$VAR_NAME_offset)) .NE. 1)
     .       PRINT*,'Error setting dims'
      CALL ARRFfree($VAR_NAME_dims)      
C  Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3
      $VAR_NAME_nspace = 2 
      IF (FLDFset_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .       PRINT*,'Error setting nspace'
C  Now, that nspace and dims are set, just get pointer to coordinate array
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .   $VAR_NAME_nnodes, OM_GET_ARRAY_RW) .NE. 1)
     .       PRINT*,'Error setting coordinates'
      $VAR_NAME_offset = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
C  Fill in $VAR_NAME_cnt_base array with coordinates x,y,z,x,y,z....
C  starting with $VAR_NAME_crd_base(1+$VAR_NAME_offset)
">,

		cgen_c_get_end="   if ($VAR_NAME_dims)
      ARRfree($VAR_NAME_dims);
   if ($VAR_NAME_coord)
      ARRfree($VAR_NAME_coord);",

		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_dims)
      CALL ARRFfree($VAR_NAME_coord)",

		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_coord)"
		>;

	Mesh CGEN_Mesh_1set<
		cgen_cxx_begin = "
   // $VAR_NAME.nspace (int) 
   // $VAR_NAME.nnodes (int)
   // $VAR_NAME.coordinates.values (float [])
   float *$VAR_NAME_coordinates = (float *)$VAR_NAME.coordinates.values.ret_array_ptr($VAR_GET_ARRAY_MODE);
   // $VAR_NAME.cell_set[0].ncells (int)
   // $VAR_NAME.cell_set[0]. cell_nnodes (int)
   // $VAR_NAME.cell_set[0]. cell_ndim (int)
   // $VAR_NAME.cell_set[0]. cell_order (int)
   // $VAR_NAME.cell_set[0]. cell_name (char *)
   // $VAR_NAME.cell_set[0].node_connect_list (int *)
   xp_long *$VAR_NAME_node_connect_list = (xp_long *)$VAR_NAME.cell_set[0].node_connect_list.ret_array_ptr($VAR_GET_ARRAY_MODE);
",
		cgen_cxx_end = "
   if ($VAR_NAME_coordinates)
      ARRfree($VAR_NAME_coordinates);
   if ($VAR_NAME_node_connect_list)
      ARRfree($VAR_NAME_node_connect_list);
",
		cgen_c_begin="   int $VAR_NAME_nspace;
   xp_long  $VAR_NAME_nnodes, $VAR_NAME_size;
   xp_long  $VAR_NAME_ncells, *$VAR_NAME_node_connect;
   int $VAR_NAME_cell_nnodes;
   OMobj_id $VAR_NAME_cell_set;
   float *$VAR_NAME_coord;",
#ifdef WORDLENGTH_64
		cgen_f_begin=<"      INTEGER  $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_nnodes, $VAR_NAME_size		
      INTEGER $VAR_NAME_nsets, $VAR_NAME_set
      XP_LONG_INT $VAR_NAME_ncells
      INTEGER $VAR_NAME_cell_nnodes, $VAR_NAME_con_base(1)
      INTEGER*8 $VAR_NAME_crd_off, $VAR_NAME_con_off
      INTEGER*8 $VAR_NAME_node_connect, $VAR_NAME_coord
      CHARCTER*32 $VAR_NAME_cell_name
      REAL $VAR_NAME_crd_base(1)
      INTEGER $VAR_NAME_cell_set(OIDSIZ)">,
#else
		cgen_f_begin=<"      INTEGER $VAR_NAME_nspace
	  XP_LONG_INT $VAR_NAME_nnodes, $VAR_NAME_size
      INTEGER $VAR_NAME_nsets, $VAR_NAME_set
      XP_LONG_INT $VAR_NAME_ncells
      INTEGER $VAR_NAME_cell_nnodes, $VAR_NAME_con_base(1)
      INTEGER $VAR_NAME_crd_off, $VAR_NAME_con_off
      INTEGER $VAR_NAME_node_connect, $VAR_NAME_coord
      CHARCTER*32 $VAR_NAME_cell_name
      REAL $VAR_NAME_crd_base(1)
      INTEGER $VAR_NAME_cell_set(OIDSIZ)">,
#endif
		cgen_c_get="   /* Get $VAR_NAME mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get mesh number of nodes */
   FLDget_nnodes ($VAR_ID, &$VAR_NAME_nnodes);

   /* Get mesh nspace */
   FLDget_nspace ($VAR_ID, &$VAR_NAME_nspace);

   /* Get mesh coordinates */
   FLDget_coord ($VAR_ID, &$VAR_NAME_coord, &$VAR_NAME_size, OM_GET_ARRAY_RD);

   /* Get cell set id */
   FLDget_cell_set($VAR_ID, 0, &$VAR_NAME_cell_set);

   /* Get number of cells */
   FLDget_ncells($VAR_NAME_cell_set, &$VAR_NAME_ncells);

   /* Get number of nodes in each cell */
   FLDget_cell_set_nnodes($VAR_NAME_cell_set, &$VAR_NAME_cell_nnodes);

   /* Get node connectivity list */
   FLDget_node_connect($VAR_NAME_cell_set, &$VAR_NAME_node_connect, 
		      &$VAR_NAME_size, OM_GET_ARRAY_RD);
   /*** NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
           if you want to get non-tesselated cells 
           use:
	FLDget_npolys ()         instead of       FLDget_ncells ()
        FLDget_poly_connect ()   instead of       FLDget_node_connect ()

           To check if a cell set is POLY type 
           use:
        FLDget_poly_flag($VAR_NAME_cell_set, &poly_flag)
   ***/
      " ,
		cgen_f_get=<"C   Get $VAR_NAME mesh
C   Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) . NE. 1)
     .      PRINT*,'Error getting mesh'
C   Get mesh nnodes
      IF (FLDFget_nnodes($VAR_ID, $VAR_NAME_nnodes) 
     .      .NE. 1) THEN
            PRINT*,'Error getting nnodes'
            RETURN
      ENDIF

C   Get mesh nspace
      IF (FLDFget_nspace($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .      PRINT*,'Error getting nspace'
C   Get mesh coordinates
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .            $VAR_NAME_nnodes, OM_GET_ARRAY_RD) .NE. 1)
     .      PRINT*,'Error getting coordinates'
      $VAR_NAME_crd_off = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
C   Get number of cell sets
      IF (FLDFget_ncell_sets($VAR_ID, $VAR_NAME_nsets) .NE. 1)
     .      PRINT*,'Error getting ncell sets'
C   For each cell_set get information  about cells 
C   do it for each $VAR_NAME_set from 0 to $VAR_NAME_nsets-1
      $VAR_NAME_set = 0
C   Get cell set id
      IF (FLDFget_cell_set($VAR_ID, 
     .   $VAR_NAME_set, $VAR_NAME_cell_set) .NE. 1)
     .      PRINT*,'Error getting cell set'
C   Get number of cells
      IF (FLDFget_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells) .NE. 1)
     .      PRINT*,'Error getting ncells'
C   Get number of nodes in each cell
      IF FLDFget_cell_set_nnodes($VAR_NAME_cell_set, 
     .   $VAR_NAME_cell_nnodes) .NE. 1)
     .      PRINT*,'Error getting cell nnodes'
C   Get node connectivity list
      IF (FLDFget_node_connect($VAR_NAME_cell_set, 
     .   $VAR_NAME_node_connect,$VAR_NAME_size,OM_GET_ARRAY_RD) .NE. 1)
     .      PRINT*,'Error getting connect list'
      $VAR_NAME_con_off = ARRFoffset($VAR_NAME_node_connect,
     .   $VAR_NAME_con_base,DTYPE_INT)
C   NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
C      if you want to get non-tesselated cells 
C      use:
C   FLDFget_npolys ()         instead of FLDFget_ncells ()
C   FLDFget_poly_connect ()   instead of FLDFget_node_connect ()
C
C   To check if a cell set is POLY type 
C        use:
C   FLDFget_poly_flag($VAR_NAME_cell_set, poly_flag)
">,
		cgen_c_set="   /* Set $VAR_NAME mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set mesh nnodes */
   FLDset_nnodes ($VAR_ID, $VAR_NAME_nnodes);

   /* Set mesh nspace */
   FLDset_nspace ($VAR_ID, $VAR_NAME_nspace);

   /* Set mesh coordinates */
   /* first allocate $VAR_NAME_coord array */
   
   $VAR_NAME_coord = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
                              $VAR_NAME_nspace*$VAR_NAME_nnodes, NULL);

   /*** fill in $VAR_NAME_coord array with X[,Y,Z] values at each node ***/

   FLDset_coord ($VAR_ID, $VAR_NAME_coord, $VAR_NAME_nspace*$VAR_NAME_nnodes, 
                 OM_SET_ARRAY_FREE);

   /* Set cell set id */
   FLDget_cell_set($VAR_ID, 0, &$VAR_NAME_cell_set);

   /* Set cell set type, if not specified in V template
         the name can be one of the following:
         Point, Line, Polyline, Tri, Polytri, Polhedron, 
         Tet, Hex, Prism, Pyr,
   */
   FLDset_cell_set($VAR_ID, \"Line\");

   /* Set number of cells */
   FLDset_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells);

   /* Set node connectivity list */
   /* first allocate $VAR_NAME_node_connect */

   FLDget_cell_set_nnodes($VAR_NAME_cell_set,  &$VAR_NAME_cell_nnodes);
   $VAR_NAME_node_connect = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 
                            $VAR_NAME_ncells*$VAR_NAME_cell_nnodes, NULL);

   /*** fill in  $VAR_NAME_node_connect array with node indecies for each cell ***/

   FLDset_node_connect($VAR_NAME_cell_set, $VAR_NAME_node_connect, 
                       $VAR_NAME_ncells*$VAR_NAME_cell_nnodes, OM_SET_ARRAY_FREE);


   /***  NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron 
            use:
	FLDset_npolys()          instead of       FLDset_ncells()
        FLDset_poly_connect()    instead of       FLDset_node_connect()
   ***/

   ",
		cgen_f_set=<"C   Set $VAR_NAME mesh
C  Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting mesh'
C  Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3
      $VAR_NAME_nspace = 2 
      IF (FLDFset_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .      PRINT*,'Error setting nspace'
C  Set mesh nodes
      $VAR_NAME_nnodes = 1
      IF (FLDFset_nnodes ($VAR_ID, $VAR_NAME_nnodes) .NE. 1)
     .      PRINT*,'Error setting nnodes'
C  Now, that nspace and nnodes are set, 
C  just get pointer to coordinate array
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .   $VAR_NAME_nnodes, OM_GET_ARRAY_RW) .NE. 1)
     .      PRINT*,'Error setting coordinates'
      $VAR_NAME_crd_off = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
C  Fill in $VAR_NAME_cnt_base array with coordinates x,y,z,x,y,z....
C  starting with $VAR_NAME_cnt_base(1+$VAR_NAME_crd_off)
C
C  Set number of cell sets $VAR_NAME_nsets variable
      $VAR_NAME_nsets = 1
      IF (FLDFset_ncell_sets($VAR_ID, $VAR_NAME_nsets) .NE. 1)
     .      PRINT*,'Error setting ncell sets'
C   For each cell_set set information  about cells 
C   do it for each $VAR_NAME_set from 0 to $VAR_NAME_nsets-1
      $VAR_NAME_set = 0
      IF (FLDFget_cell_set($VAR_ID, $VAR_NAME_set, 
     .  $VAR_NAME_cell_set) .NE. 1)
     .      PRINT*,'Error getting cell set'      
C   Set cell set to say, Tri
      $VAR_NAME_cell_name = 'Tri'
      IF (FLDFset_cell_set($VAR_NAME_cell_set, 
     .  $VAR_NAME_cell_name) .NE. 1)
     .      PRINT*,'Error setting cell set'

C   Set number of cells
      $VAR_NAME_ncells = 1
      IF (FLDFset_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells) .NE. 1)
     .      PRINT*,'Error getting ncells'
C   Get node connectivity list
      IF (FLDFget_node_connect($VAR_NAME_cell_set, 
     .   $VAR_NAME_node_connect,$VAR_NAME_size,OM_GET_ARRAY_RW)
     .      PRINT*,'Error getting node connectivity' 
      $VAR_NAME_con_off = ARRFoffset($VAR_NAME_node_connect,
     .   $VAR_NAME_con_base,DTYPE_INT)
C   Fill in  $VAR_NAME_con_base array with node indecies for each cell
C  starting with $VAR_NAME_con_base(1+$VAR_NAME_con_off)
C
C   NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
C       if you want to get non-tesselated cells 
C       use:
C     FLDFset_npolys ()         instead of  FLDFset_ncells ()
C     FLDFget_poly_connect ()   instead of  FLDFget_node_connect ()
C     
C       To check if a cell set is POLY type 
C       use:
C     FLDFget_poly_flag($VAR_NAME_cell_set, poly_flag)
">,
		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_coord)
      CALL ARRFfree($VAR_NAME_node_connect)",

		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_coord)
      CALL ARRFfree($VAR_NAME_node_connect)",

		cgen_c_get_end="   if ($VAR_NAME_coord)
      ARRfree($VAR_NAME_coord);
   if ($VAR_NAME_node_connect)
      ARRfree($VAR_NAME_node_connect);"
		> {
		ncell_sets = 1;
	};

	Mesh CGEN_Mesh<
		cgen_cxx_begin = "
   // $VAR_NAME.nspace (int) 
   // $VAR_NAME.nnodes (int)
   // $VAR_NAME.coordinates.values (float [])
   float *$VAR_NAME_coordinates = (float *)$VAR_NAME.coordinates.values.ret_array_ptr($VAR_GET_ARRAY_MODE);
   // $VAR_NAME.ncell_sets (int)
   int $VAR_NAME_set;
   int $VAR_NAME_ncell_sets = $VAR_NAME.ncell_sets;
   for ($VAR_NAME_set=0; $VAR_NAME_set < $VAR_NAME.ncell_sets; $VAR_NAME_set++) {
   	// $VAR_NAME.cell_set[$VAR_NAME_set].ncells (int)
   	// $VAR_NAME.cell_set[$VAR_NAME_set]. cell_nnodes (int)
   	// $VAR_NAME.cell_set[$VAR_NAME_set]. cell_ndim (int)
   	// $VAR_NAME.cell_set[$VAR_NAME_set]. cell_order (int)
   	// $VAR_NAME.cell_set[$VAR_NAME_set]. cell_name (char *)
   	// $VAR_NAME.cell_set[$VAR_NAME_set].node_connect_list (int *)

   	xp_long *$VAR_NAME_node_connect_list = (xp_long *)$VAR_NAME.cell_set[$VAR_NAME_set].node_connect_list.ret_array_ptr($VAR_GET_ARRAY_MODE);

	if ($VAR_NAME_node_connect_list)
           ARRfree($VAR_NAME_node_connect_list);
   }
",
		cgen_cxx_end = "
   if ($VAR_NAME_coordinates)
      ARRfree($VAR_NAME_coordinates);
",
		cgen_c_begin="   int $VAR_NAME_nspace;
   xp_long $VAR_NAME_nnodes, $VAR_NAME_size;
   int  $VAR_NAME_nsets, $VAR_NAME_set_count;
   xp_long $VAR_NAME_ncells;
   int  $VAR_NAME_cell_nnodes;
   xp_long *$VAR_NAME_node_connect;
   OMobj_id $VAR_NAME_cell_set;
   float *$VAR_NAME_coord;",
#ifdef WORDLENGTH_64
		cgen_f_begin=<"      INTEGER $VAR_NAME_nspace
      XP_LONG_INT $VAR_NAME_size, $VAR_NAME_nnodes
      INTEGER $VAR_NAME_nsets, $VAR_NAME_set
      XP_LONG_INT $VAR_NAME_ncells
      INTEGER $VAR_NAME_cell_nnodes, $VAR_NAME_con_base(1)
      INTEGER*8 $VAR_NAME_crd_off, $VAR_NAME_con_off
      INTEGER*8 $VAR_NAME_node_connect, $VAR_NAME_coord
      REAL $VAR_NAME_crd_base(1)
      CHARACTER*32 $VAR_NAME_cell_name
      INTEGER $VAR_NAME_cell_set(OIDSIZ)">,
#else
		cgen_f_begin=<"      INTEGER $VAR_NAME_nspace
	  XP_LONG_INT $VAR_NAME_nnodes, $VAR_NAME_size
      INTEGER $VAR_NAME_nsets, $VAR_NAME_set
      XP_LONG_INT $VAR_NAME_ncells
      INTEGER $VAR_NAME_cell_nnodes, $VAR_NAME_con_base(1)
      INTEGER $VAR_NAME_crd_off, $VAR_NAME_con_off
      INTEGER $VAR_NAME_node_connect, $VAR_NAME_coord
      REAL $VAR_NAME_crd_base(1)
      CHARACTER*32 $VAR_NAME_cell_name
      INTEGER $VAR_NAME_cell_set(OIDSIZ)">,
#endif
		cgen_c_get="   /* Get $VAR_NAME mesh */

   /* Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get mesh number of nodes */
   FLDget_nnodes ($VAR_ID, &$VAR_NAME_nnodes);

   /* Get mesh nspace */
   FLDget_nspace ($VAR_ID, &$VAR_NAME_nspace);

   /* Get mesh coordinates */
   FLDget_coord ($VAR_ID, &$VAR_NAME_coord, &$VAR_NAME_size, OM_GET_ARRAY_RD);

   /* Get_number of cell sets */
   FLDget_ncell_sets($VAR_ID, &$VAR_NAME_nsets);

   /* For each cell set get information about cells */
   for ($VAR_NAME_set_count=0; $VAR_NAME_set_count<$VAR_NAME_nsets; $VAR_NAME_set_count++) {
      /* Get cell set id */
      FLDget_cell_set($VAR_ID, $VAR_NAME_set_count, &$VAR_NAME_cell_set);

      /* Get number of cells */
      FLDget_ncells($VAR_NAME_cell_set, &$VAR_NAME_ncells);

      /* Get number of nodes in each cell */
      FLDget_cell_set_nnodes($VAR_NAME_cell_set, &$VAR_NAME_cell_nnodes);

      /* Get node connectivity list */
      FLDget_node_connect($VAR_NAME_cell_set, &$VAR_NAME_node_connect, 
					    &$VAR_NAME_size, OM_GET_ARRAY_RD);
      /*
       * NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
       *    if you want to get non-tesselated cells 
       *    use:
       * FLDget_npolys ()         instead of       FLDget_ncells ()
       * FLDget_poly_connect ()   instead of       FLDget_node_connect ()
       *
       *    To check if a cell set is POLY type 
       *    use:
       *  FLDget_poly_flag($VAR_NAME_cell_set, &poly_flag)
       */
      if ($VAR_NAME_node_connect)
         ARRfree($VAR_NAME_node_connect);

   }
      " ,

		cgen_f_get=<"C   Get $VAR_NAME mesh
C   Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting mesh'
C   Get mesh nnodes
      IF (FLDFget_nnodes($VAR_ID, $VAR_NAME_nnodes)
     .      .NE. 1) THEN
            PRINT*,'Error getting nnodes'
            RETURN
      ENDIF

C   Get mesh nspace
      IF (FLDFget_nspace($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .      PRINT*,'Error getting nspace'
C   Get mesh coordinates
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .   $VAR_NAME_nnodes, OM_GET_ARRAY_RD) .NE. 1)
     .      PRINT*,'Error getting coordinates'
      $VAR_NAME_crd_off = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
C   Get number of cell sets
      IF (FLDFget_ncell_sets($VAR_ID, $VAR_NAME_nsets) .NE. 1)
     .      PRINT*,'Error getting ncell sets'
C   For each cell_set get information  about cells 
C   do it for each $VAR_NAME_set from 0 to $VAR_NAME_nsets-1
      $VAR_NAME_set = 0
C   Get cell set id
      IF (FLDFget_cell_set($VAR_ID, 
     .   $VAR_NAME_set, $VAR_NAME_cell_set) .NE. 1)
     .      PRINT*,'Error getting cell set'
C   Get number of cells
      IF (FLDFget_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells) .NE. 1)
     .      PRINT*,'Error getting ncells'
C   Get number of nodes in each cell
      IF (FLDFget_cell_set_nnodes($VAR_NAME_cell_set, 
     .   $VAR_NAME_cell_nnodes) .NE. 1)
     .      PRINT*,'Error getting cell nnodes'
C   Get node connectivity list
      IF (FLDFget_node_connect($VAR_NAME_cell_set, 
     .   $VAR_NAME_node_connect,$VAR_NAME_size,OM_GET_ARRAY_RD)
     .   .NE. 1)
     .      PRINT*,'Error getting node connectivity' 
      $VAR_NAME_con_off = ARRFoffset($VAR_NAME_node_connect,
     .   $VAR_NAME_con_base,DTYPE_INT)
C   NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
C      if you want to get non-tesselated cells 
C      use:
C   FLDFget_npolys ()         instead of FLDFget_ncells ()
C   FLDFget_poly_connect ()   instead of FLDFget_node_connect ()
C
C   To check if a cell set is POLY type 
C        use:
C   FLDFget_poly_flag($VAR_NAME_cell_set, poly_flag)
">,
		cgen_c_set="   /* set  $VAR_NAME mesh */

   /*  Get mesh id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set mesh nnodes */
   FLDset_nnodes ($VAR_ID, $VAR_NAME_nnodes);

   /* Set mesh nspace */
   FLDset_nspace ($VAR_ID, $VAR_NAME_nspace);

   /* Set mesh coordinates */
   /* First allocate $VAR_NAME_coord array */
   
   $VAR_NAME_coord = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
                              $VAR_NAME_nspace*$VAR_NAME_nnodes, NULL);

   /*** Fill in $VAR_NAME_coord array with X[,Y,Z] values at each node ***/

   FLDset_coord ($VAR_ID, $VAR_NAME_coord, $VAR_NAME_nspace*$VAR_NAME_nnodes, 
                 OM_SET_ARRAY_FREE);


   /* Set_number of cell sets to 0 initially, 
      the real number of cell_sets should be assigned to $VAR_NAME_nsets variable */
   FLDset_ncell_sets($VAR_ID, 0);

   /* For each cell set set information about cells */
   for ($VAR_NAME_set_count=0; $VAR_NAME_set_count<$VAR_NAME_nsets; $VAR_NAME_set_count++) {
      /* add cell set, the name can be one of the following:
         Point, Line, Polyline, Tri, Polytri, Polhedron, 
         Tet, Hex, Prism, Pyr,
      */
      FLDadd_cell_set($VAR_ID, \"Line\");

      /* Get cell set id */
      FLDget_cell_set($VAR_ID, $VAR_NAME_set_count, &$VAR_NAME_cell_set);

      /* Set number of cells */
      FLDset_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells);

      /* Set node connectivity list */
      /* First allocate $VAR_NAME_node_connect */

      FLDget_cell_set_nnodes($VAR_NAME_cell_set,  &$VAR_NAME_cell_nnodes);
      $VAR_NAME_node_connect = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 
                               $VAR_NAME_ncells*$VAR_NAME_cell_nnodes, NULL);

      /*** fill in  $VAR_NAME_node_connect array with node indecies for each cell ***/

      FLDset_node_connect($VAR_NAME_cell_set, $VAR_NAME_node_connect, 
                          $VAR_NAME_ncells*$VAR_NAME_cell_nnodes, OM_SET_ARRAY_FREE);


      /***  NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron 
            use:
	FLDset_npolys()          instead of       FLDset_ncells()
        FLDset_poly_connect()    instead of       FLDset_node_connect()
      ***/

   }
   ",

		cgen_f_set=<"C   Set $VAR_NAME mesh
C  Get mesh id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting mesh' 
C  Set mesh nspace, $VAR_NAME_nspace can be 1,2 or 3
      $VAR_NAME_nspace = 2 
      IF (FLDFset_nspace ($VAR_ID, $VAR_NAME_nspace) .NE. 1)
     .      PRINT*,'Error getting nspace' 
C  Set mesh nodes
      $VAR_NAME_nnodes = 1
      IF (FLDFset_nnodes ($VAR_ID, $VAR_NAME_nnodes) .NE. 1)
     .      PRINT*,'Error getting nnodes' 
C  Now, that nspace and nnodes are set, 
C  just get pointer to coordinate array
      IF (FLDFget_coord($VAR_ID, $VAR_NAME_coord, 
     .   $VAR_NAME_nnodes, OM_GET_ARRAY_RW) .NE. 1)
     .      PRINT*,'Error getting coordinates'  
      $VAR_NAME_crd_off = ARRFoffset($VAR_NAME_coord,
     .   $VAR_NAME_crd_base,DTYPE_FLOAT)
C  Fill in $VAR_NAME_cnt_base array with coordinates x,y,z,x,y,z....
C  starting with $VAR_NAME_cnt_base(1+$VAR_NAME_crd_off)
C
C  Set number of cell sets $VAR_NAME_nsets variable
      $VAR_NAME_nsets = 1
      IF (FLDFset_ncell_sets($VAR_ID, $VAR_NAME_nsets) .NE. 1)
     .      PRINT*,'Error getting ncell sets' 
C   For each cell_set set information  about cells 
C   do it for each $VAR_NAME_set from 0 to $VAR_NAME_nsets-1
      $VAR_NAME_set = 0
      IF (FLDFget_cell_set($VAR_ID, $VAR_NAME_set, 
     .  $VAR_NAME_cell_set) .NE. 1)
     .      PRINT*,'Error getting cell set'      
C   Set cell set to say, Tri
      $VAR_NAME_cell_name = 'Tri'
      IF (FLDFset_cell_set($VAR_NAME_cell_set, 
     .  $VAR_NAME_cell_name) .NE. 1)
     .      PRINT*,'Error setting cell set'
C   Set number of cells
      $VAR_NAME_ncells = 1
      IF (FLDFset_ncells($VAR_NAME_cell_set, $VAR_NAME_ncells)
     .    .NE. 1)
     .      PRINT*,'Error getting ncells' 
C   Get node connectivity list
      IF (FLDFget_node_connect($VAR_NAME_cell_set, 
     .      $VAR_NAME_node_connect,$VAR_NAME_size,OM_GET_ARRAY_RW)
     .    .NE. 1)
     .      PRINT*,'Error getting node connectivity' 
      $VAR_NAME_con_off = ARRFoffset($VAR_NAME_node_connect,
     .   $VAR_NAME_con_base,DTYPE_INT)
C   Fill in  $VAR_NAME_con_base array with node indecies for each cell
C  starting with $VAR_NAME_con_base(1+$VAR_NAME_con_off)
C
C   NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron,
C       if you want to get non-tesselated cells 
C       use:
C     FLDFset_npolys ()         instead of  FLDFset_ncells ()
C     FLDFget_poly_connect ()   instead of  FLDFget_node_connect ()
C     
C       To check if a cell set is POLY type 
C       use:
C     FLDFget_poly_flag($VAR_NAME_cell_set, poly_flag)
">,

		cgen_c_get_end="   if ($VAR_NAME_coord)
       ARRfree($VAR_NAME_coord);",

		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_coord)
      CALL ARRFfree($VAR_NAME_node_connect)",

		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_coord)
      CALL ARRFfree($VAR_NAME_node_connect)"
		>;
};

group CGEN_ndata {
	Node_Data CGEN_Node_Data_Scalar<
		cgen_cxx_begin = "
   // $VAR_NAME.nnodes (int)
   // $VAR_NAME.node_data[0].veclen (int) 
   // $VAR_NAME.node_data[0].values (char []) 
   int  $VAR_NAME_data_size, $VAR_NAME_data_type;
   char *$VAR_NAME_node_data = (char *)$VAR_NAME.node_data[0].values.ret_array_ptr($VAR_GET_ARRAY_MODE, &$VAR_NAME_data_size, &$VAR_NAME_data_type);
",
		cgen_cxx_end = "
   if ($VAR_NAME_node_data)
      ARRfree($VAR_NAME_node_data);
",
        	cgen_c_begin="   int $VAR_NAME_veclen;
   int    $VAR_NAME_data_type
   xp_long $VAR_NAME_ndata;
   char  *$VAR_NAME_data;",
#ifdef WORDLENGTH_64
        	cgen_f_begin="      INTEGER $VAR_NAME_ncomp, $VAR_NAME_comp, $VAR_NAME_veclen
      INTEGER $VAR_NAME_data_type
      XP_LONG_INT $VAR_NAME_ndata
      INTEGER*8 $VAR_NAME_data, $VAR_NAME_data_offset
C  !!! The type of the $VAR_NAME_data_base array should be changed 
C  to the type of node data
      REAL $VAR_NAME_data_base(1)",
#else
        	cgen_f_begin="      INTEGER $VAR_NAME_ncomp, $VAR_NAME_comp, $VAR_NAME_veclen
      INTEGER $VAR_NAME_data_type
      XP_LONG_INT $VAR_NAME_ndata
      INTEGER $VAR_NAME_data, $VAR_NAME_data_offset
C  !!! The type of the $VAR_NAME_data_base array should be changed 
C  to the type of node data
      REAL $VAR_NAME_data_base(1)",
#endif
		cgen_c_get="   /* Get $VAR_NAME's node data */

   /* Get field id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get veclen */
   FLDget_node_data_veclen ($VAR_ID, 0, &$VAR_NAME_veclen);

   /* Get data array and data_type which is one of the following: 
         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
         DTYPE_INT, DTYPE_LONG, DTYPE_FLOAT, DTYPE_DOUBLE */

   FLDget_node_data ($VAR_ID, 0, &$VAR_NAME_data_type, &$VAR_NAME_data,
                    &$VAR_NAME_ndata, OM_GET_ARRAY_RD);

   /* Other useful calls:

          FLDget_node_data_id()
          FLDget_node_null_data()
          FLDget_node_data_minmax()
          FLDget_node_data_label()
   */
   ",
		cgen_f_get="C  Get $VAR_NAME's node data
C  Get field id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID)  .NE. 1)
     .      PRINT*,'Error getting mesh' 
C  Get number of node data components
      IF (FLDFget_node_data_ncomp ($VAR_ID, $VAR_NAME_ncomp) .NE. 1)
     .      PRINT*,'Error getting nnode comp' 
C  For each node data component get veclen, type and data arry itself
C  do it for each $VAR_NAME_comp from 0 to $VAR_NAME_ncomp-1
      $VAR_NAME_comp = 0
C  Get veclen 
      IF (FLDFget_node_data_veclen ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_veclen) .NE. 1)
     .      PRINT*,'Error getting data veclen' 
C  Get data array and data_type which is one of the following: 
C         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG
      IF (FLDFget_node_data ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_data_type, $VAR_NAME_data,
     .   $VAR_NAME_ndata, OM_GET_ARRAY_RD) .NE. 1)
     .      PRINT*,'Error getting data type' 
      $VAR_NAME_data_offset = ARRFoffset($VAR_NAME_data,
     .   $VAR_NAME_data_base,$VAR_NAME_data_type)
C  Other useful calls:
C          CALL FLDFget_node_data_id()
C          CALL FLDFget_node_null_data()
C          CALL FLDFget_node_data_minmax()
C          CALL FLDFget_node_data_label()
   ",

		cgen_c_set="   /* set  $VAR_NAME node data */

   /* Get field id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set veclen, assign $VAR_NAME_veclen before next call */
   FLDset_node_data_veclen ($VAR_ID, 0, $VAR_NAME_veclen);

   /* Set data array */
   /* data_type should be set to one of the following: 
         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG) */

   $VAR_NAME_data_type = DTYPE_CHAR;

   /* allocate $VAR_NAME_data array first */
   /* assume float array and $VAR_NAME_ndata is set to number of nodes */

   $VAR_NAME_data = (char *)ARRalloc(NULL, $VAR_NAME_data_type, 
                              $VAR_NAME_veclen*$VAR_NAME_ndata, NULL);

   FLDset_node_data ($VAR_ID, 0, $VAR_NAME_data, $VAR_NAME_data_type,
                     $VAR_NAME_ndata*$VAR_NAME_veclen, OM_SET_ARRAY_FREE);

   /*  Other useful calls:

          FLDset_node_data_id()
          FLDset_node_null_data()
          FLDset_node_data_label()
   */
   ",
		cgen_f_set="C  Set $VAR_NAME's node data
C  Get field id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting data' 
C  Get number of node data components
      $VAR_NAME_ncomp = 1
      IF (FLDFset_node_data_ncomp ($VAR_ID, $VAR_NAME_ncomp) .NE. 1)
     .      PRINT*,'Error getting ndata comp' 
C  For each node data component set veclen, type and data arry itself
C  do it for each $VAR_NAME_comp from 0 to $VAR_NAME_ncomp-1
      $VAR_NAME_comp = 0
C  Set veclen
      $VAR_NAME_veclen = 1
      IF (FLDFset_node_data_veclen ($VAR_ID, 
     .   $VAR_NAME_comp, $VAR_NAME_veclen) .NE. 1)
     .      PRINT*,'Error getting data veclen' 
C  Set data array and data_type which is one of the following: 
C         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG 
      $VAR_NAME_data_type = DTYPE_FLOAT
      IF (FLDFget_node_data ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_data_type, $VAR_NAME_data,
     .   $VAR_NAME_ndata, OM_GET_ARRAY_WR) .NE. 1)
     .      PRINT*,'Error getting data'
      $VAR_NAME_data_offset = ARRFoffset($VAR_NAME_data,
     .   $VAR_NAME_data_base,$VAR_NAME_data_type)
C  Fill in $VAR_NAME_data_base array with values
C  starting with $VAR_NAME_data_base(1+$VAR_NAME_data_offset)
C  Other useful calls:
C          CALL FLDFset_node_data_id()
C          CALL FLDFset_node_null_data()
C          CALL FLDFset_node_data_minmax()
   ",
		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_data)",
		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_data)",

		cgen_c_get_end="   if ($VAR_NAME_data)
      ARRfree($VAR_NAME_data);
	"
       > {
		nnode_data = 1;
        };
	Node_Data CGEN_Node_Data<
		cgen_cxx_begin = "
   // $VAR_NAME.nnodes (int)
   // $VAR_NAME.nnode_data (int)
   int  $VAR_NAME_data_comp;
   int  $VAR_NAME_data_size, $VAR_NAME_data_type;
   for ($VAR_NAME_data_comp = 0; $VAR_NAME_data_comp < $VAR_NAME.nnode_data; $VAR_NAME_data_comp++) { 
	// $VAR_NAME.node_data[$VAR_NAME_data_comp].veclen (int) 
   	// $VAR_NAME.node_data[$VAR_NAME_data_comp].values (char [])
   	char *$VAR_NAME_node_data = (char *)$VAR_NAME.node_data[$VAR_NAME_data_comp].values.ret_array_ptr($VAR_GET_ARRAY_MODE, &$VAR_NAME_data_size, &$VAR_NAME_data_type);
        if ($VAR_NAME_node_data)
           ARRfree($VAR_NAME_node_data);
   }
",
        	cgen_c_begin="   int $VAR_NAME_ncomp, $VAR_NAME_comp_count, $VAR_NAME_veclen;
   int    $VAR_NAME_data_type;
   xp_long $VAR_NAME_ndata;
   char  *$VAR_NAME_data;",
#ifdef WORDLENGTH_64
        	cgen_f_begin="      INTEGER $VAR_NAME_ncomp, $VAR_NAME_comp, $VAR_NAME_veclen
      INTEGER $VAR_NAME_data_type
      XP_LONG_INT $VAR_NAME_ndata
      INTEGER*8 $VAR_NAME_data, $VAR_NAME_data_offset
C  !!! The type of the $VAR_NAME_data_base array should be changed
C   to the type of node data
      REAL $VAR_NAME_data_base(1)",
#else
        	cgen_f_begin="      INTEGER $VAR_NAME_ncomp, $VAR_NAME_comp, $VAR_NAME_veclen
      INTEGER $VAR_NAME_data_type
      XP_LONG_INT $VAR_NAME_ndata
      INTEGER $VAR_NAME_data, $VAR_NAME_data_offset
C  !!! The type of the $VAR_NAME_data_base array should be changed
C   to the type of node data
      REAL $VAR_NAME_data_base(1)",
#endif
		cgen_c_get="   /* Get $VAR_NAME's node data */

   /* Get field id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Get number of node data components */
   FLDget_node_data_ncomp ($VAR_ID, &$VAR_NAME_ncomp);

   /* For each node data component get veclen, type and data arry itself */
   for ($VAR_NAME_comp_count=0; $VAR_NAME_comp_count < $VAR_NAME_ncomp; $VAR_NAME_comp_count++) {

      /* Get veclen */
      FLDget_node_data_veclen ($VAR_ID, $VAR_NAME_comp_count, &$VAR_NAME_veclen);

      /* Get data array and data_type which is one of the following: 
         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG */

      FLDget_node_data ($VAR_ID, $VAR_NAME_comp_count, &$VAR_NAME_data_type, &$VAR_NAME_data,
                        &$VAR_NAME_ndata, OM_GET_ARRAY_RD);

      /*  Other useful calls:

          FLDget_node_data_id()
          FLDget_node_null_data()
          FLDget_node_data_minmax()
          FLDget_node_data_label()
      */
      if ($VAR_NAME_data)
         ARRfree($VAR_NAME_data);
   }
   ",

		cgen_f_get="C  Get $VAR_NAME's node data
C  Get field id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting data' 
C  Get number of node data components
      IF (FLDFget_node_data_ncomp ($VAR_ID, $VAR_NAME_ncomp) .NE. 1)
     .      PRINT*,'Error getting ndata comp' 
C  For each node data component get veclen, type and data arry itself
C  do it for each $VAR_NAME_comp from 0 to $VAR_NAME_ncomp-1
      $VAR_NAME_comp = 0
C  Get veclen
      IF (FLDFget_node_data_veclen ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_veclen) .NE. 1)
     .      PRINT*,'Error getting data veclen' 
C  Get data array and data_type which is one of the following: 
C         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG 
      IF (FLDFget_node_data ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_data_type, $VAR_NAME_data,
     .   $VAR_NAME_ndata, OM_GET_ARRAY_RD) .NE. 1)
     .      PRINT*,'Error getting data' 
      $VAR_NAME_data_offset = ARRFoffset($VAR_NAME_data,
     .   $VAR_NAME_data_base,$VAR_NAME_data_type)
C  Other useful calls:
C          CALL FLDFget_node_data_id()
C          CALL FLDFget_node_null_data()
C          CALL FLDFget_node_data_minmax()
C          CALL FLDFget_node_data_label()
   ",

		cgen_c_set="   /* set  $VAR_NAME node data */

   /* Get field id */
   $VAR_ID = OMfind_subobj($MOD_ID, OMstr_to_name(\"$VAR_NAME\"), $MODE);

   /* Set number of node data components */
   FLDset_node_data_ncomp ($VAR_ID, $VAR_NAME_ncomp);

   /* For each node data component set veclen, type and data arry itself */
   for ($VAR_NAME_comp_count=0; $VAR_NAME_comp_count < $VAR_NAME_ncomp; $VAR_NAME_comp_count++) {

      /* Set veclen, assign $VAR_NAME_veclen before next call */
      FLDset_node_data_veclen ($VAR_ID,$VAR_NAME_comp_count,$VAR_NAME_veclen);

      /* Set data array */
      /* data_type should be set to one of the following: 
         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG) */

      $VAR_NAME_data_type = DTYPE_CHAR;

      /* allocate $VAR_NAME_data array first */
      /* assume float array and $VAR_NAME_ndata is set to number of nodes */

      $VAR_NAME_data = (char *)ARRalloc(NULL, $VAR_NAME_data_type, 
                                 $VAR_NAME_veclen*$VAR_NAME_ndata, NULL);

      FLDset_node_data ($VAR_ID, $VAR_NAME_comp_count, $VAR_NAME_data, $VAR_NAME_data_type,
                        $VAR_NAME_ndata*$VAR_NAME_veclen, OM_SET_ARRAY_FREE);

      /*  Other useful calls:

          FLDset_node_data_id()
          FLDset_node_null_data()
          FLDset_node_data_label()
      */
   }
   ",
		cgen_f_set="C  Set $VAR_NAME's node data
C  Get field id
      IF (OMFfind_subobj($MOD_ID, 
     .   OMFstr_to_name('$VAR_NAME'),
     .   $MODE, $VAR_ID) .NE. 1)
     .      PRINT*,'Error getting data'
C  Get number of node data components
      $VAR_NAME_ncomp = 1
      IF (FLDFset_node_data_ncomp ($VAR_ID, $VAR_NAME_ncomp) .NE. 1)
     .      PRINT*,'Error setting ndata comp'
C  For each node data component set veclen, type and data arry itself
C  do it for each $VAR_NAME_comp from 0 to $VAR_NAME_ncomp-1
      $VAR_NAME_comp = 0
C  Set veclen
      $VAR_NAME_veclen = 1
      IF (FLDFset_node_data_veclen ($VAR_ID, 
     .   $VAR_NAME_comp, $VAR_NAME_veclen) .NE. 1)
     .      PRINT*,'Error setting data veclen'
C  Set data array and data_type which is one of the following: 
C         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE, DTYPE_LONG 
      $VAR_NAME_data_type = DTYPE_FLOAT
      IF (FLDFget_node_data ($VAR_ID, $VAR_NAME_comp, 
     .   $VAR_NAME_data_type, $VAR_NAME_data,
     .   $VAR_NAME_ndata, OM_GET_ARRAY_WR) .NE. 1)
     .      PRINT*,'Error setting data'
      $VAR_NAME_data_offset = ARRFoffset($VAR_NAME_data,
     .   $VAR_NAME_data_base,$VAR_NAME_data_type)
C  Fill in $VAR_NAME_data_base array with values
C  starting with $VAR_NAME_data_base(1+$VAR_NAME_data_offset)
C  Other useful calls:
C          CALL FLDFset_node_data_id()
C          CALL FLDFset_node_null_data()
C          CALL FLDFset_node_data_minmax()
   ",

		cgen_f_get_end="      CALL ARRFfree($VAR_NAME_data)",
		cgen_f_set_end="      CALL ARRFfree($VAR_NAME_data)"
       >;
};

group CGENdev_studio_strings {

string dev_studio_header = 

<"# Microsoft Developer Studio Project File - Name="express" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **
">

+<"# TARGTYPE "Win32 (x86) Application" 0x0101
">

+<"CFG=express - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "express.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "express.mak" CFG="express - Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
">
+<"!MESSAGE "express - Win32 Release" (based on "Win32 (x86) Application")
">
+<"!MESSAGE 

# Begin Project
# PROP Scc_ProjName "express"
# PROP Scc_LocalPath "."
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe
# PROP BASE Use_MFC 6
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 6
# PROP Use_Debug_Libraries 0

">;

string dev_studio_cpp = 

#ifdef XP_DOTNET
<"# ADD CPP /nologo /W2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D_WIN32 -DEXPRESS -J -D_MT -D_DLL /DXP_WINDOWS /DMSDOS /D "_AFXDLL" /D "_MBCS" /DWINVER=0x0500 /D XP_STD_IOSTREAM /MD /GX -Zi -Od /c 
">
#else
<"# ADD CPP /nologo /W2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D_WIN32 -DEXPRESS -J -D_MT -D_DLL /DXP_WINDOWS /DMSDOS /D "_AFXDLL" /D "_MBCS" /MD /GX -Zi -Od /c 
">
#endif

+<"# ADD CPP -D"_X86_=1"
">

+<"# ADD BASE RSC /l 0x409
# ADD RSC /l 0x409

">;

 

   
string dev_studio_link32 = 


<"BSC32=bscmake.exe
LINK32=link.exe
">

+<"# ADD BASE LINK32 /machine:IX86
">

+<"# ADD LINK32 maincxx.obj express.res wsock32.lib express.lib 
">

#ifdef AG_KIT
+<"# ADD LINK32 libagx.lib
">
#endif

#ifdef ODBC_KIT
+<"# ADD LINK32 odbc32.lib
">
#endif

#ifdef ANIM_KIT
+<"# ADD LINK32 vfw32.lib 
">
#endif

#ifdef XP_DOTNET 
+<"# ADD LINK32_FLAGS /nologo /subsystem:windows,5.0 /STACK:16384000  /debug /debugtype:cv /NODEFAULTLIB:libc.lib /NODEFAULTLIB:libcmt.lib 
">;
#else
+<"# ADD LINK32_FLAGS /nologo /subsystem:windows,4.0 /STACK:16384000  /debug /debugtype:cv /NODEFAULTLIB:libc.lib /NODEFAULTLIB:libcmt.lib 
">;
#endif



string dev_studio_workspace =

<"Microsoft Developer Studio Workspace File, Format Version 6.00
# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!

###############################################################################

Project: "express"=.\express.dsp - Package Owner=<4>

Package=<5>
{{{
    begin source code control
    express
    .
    end source code control
}}}

Package=<4>
{{{
}}}

###############################################################################

Global:

Package=<5>
{{{
}}}

Package=<3>
{{{
}}}

###############################################################################
">;

};


};

