/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/cmap_edtr.v#1 $
*/
flibrary+buffered CMAP_EDTR
<
  build_dir     = "cmap_edtr",
  cxx_name      = "",
  lib_deps      = "DMAP",
  use_src_file  = 0,
  link_files    = "-lcmap",
  build_cmd	= "$(MAKE)",
  out_src_file  = "cmap_gen",
  out_hdr_file  = "cmap_gen.h",
  cxx_hdr_files = "fld/Xfld.h"
>
{

library+global+buffered Modules {

    module modHistogram
    {
      // Allow input from either an explicit field or from
      // the field connected to the GDobject.  If both are set,
      // then take the explcit field.
      Node_Data+IPort2 &in_field;
      group+IPort2     &in_obj {
        Node_Data &input;
      };
      int+IPort2 data_component = 0;
      int+IPort2 threshold;
      int+IPort2 logmode = 0;

      float+OPort2 x_values[256] = init_array(256,0,255);
      float+OPort2 hist_values[256] = init_array(256,0,0);
      int+OPort2   hist_valid = 0;

      cxxmethod ComputeHistogram
      (
        in_field       +read+notify,
        in_obj         +read+notify,
        data_component +read+notify+req,
        threshold      +read+notify+req,
        logmode        +read+notify+req,
        hist_values    +write,
        hist_valid     +write
      );
    };

    module modHSPosConverter
    {
      enum           calculate_toggle {
        choices = {"position", "hs_value"};
      } = 0;
      float+IPort2   x_position;    // x position in the HS color wheel (radius=1)
      float+IPort2   y_position;    // y position in the HS color wheel (radius=1)
      float+IPort2   hue;           // hue value
      float+IPort2   saturation;    // saturation value

      cxxmethod+notify_inst+req update
      (
        .x_position  +read+write+notify,
        .y_position  +read+write+notify,
        .hue         +read+write+notify,
        .saturation  +read+write+notify
      );
    };

    module modMakeDmap
    {
      // The export properties are to control C++ code generation.
      // The dmap stuff uses the old dbxx C++ layer, which clashes
      // with the omx C++ layer.  Unfortunately, the export properties
      // prevent the NE from treating the items as parameters.
      group+IPort2 &obj_in<export=0,NEcolor0=0xff0000> {
        DMAP.DatamapTempl &dmap<export_all=0>;
      };
      DefaultLinear+Port2 dmap_out<export=0> {
        dataMin = 0;
        dataMax = 255;
      };
      int+IPort2 set;
      int mode;
      int refresh;
      int color_model;
      float a;
      float v2;
      float v3;
      float v4;
      float value;
      float delta = 1;
      float dataMin => dmap_out.dataMin;
      Mesh+Node_Data+IPort2 &map_field;
      long curRange;
      int regen;
      int done;

      // Read the external datamap associated with the GDobject obj_in
      // (it needn't be a GDobject, but it must have a subobj called 'dmap')
      // and initialize both dmap_out and map_field.
      cxxmethod+notify_inst+req init
      (
        .set              +read+write+notify,
        .obj_in           +read+notify,
        .obj_in.dmap      +read+notify,
        .dmap_out         +write,
        .delta            +write,
        .map_field        +read+write+req,
        .done             +write
      );

      // Whenever map_field is edited or the color point a/v2/v3/v4 changes
      // then update dmap_out to match and sometimes update the external
      // datamap (obj_in.dmap) as well.
      cxxmethod+req update
      (
        .set              +read,
        .obj_in           +read+write,
        .dmap_out         +read+write,
        .mode             +read,
        .a                +read,
        .v2               +read,
        .v3               +read,
        .v4               +read,
        .value            +read+notify,
        .color_model      +read+notify,
        .delta            +read,
        .dataMin          +read,
        .map_field        +read+req+notify,
        .curRange         +read,
        .refresh          +read+notify,
        .regen            +read+write,
        .done             +read
      );
    };

    module modPointEditor
    {
      int     active = 1;            // = 0, ignore inputs
      prim    delete_all;            // trigger to delete all points

      // Mouse click process mode
//      enum    mode {
//        choices = { "Add", 
//		    "Delete", 
//		    "Edit" };
//      } = 0;

      // Valid edit region
      float valid_min_x;
      float valid_max_x;
      float valid_min_y;
      float valid_max_y;

      // Add mode options
      enum    insert_order {
        choices = { "First",         // start of array 
		    "Last",          // end of array
		    "X Value",       // first occurence of X(i) < X(new) < X(i+1)
		    "Y Value",       // first occurence of Y(i) < Y(new) < Y(i+1)
		    "Specified" };   // user specified
      } = 0;
      int     specified_index = 0;   // required for "Specified" mode 

      // Edit mode options
      int     no_x_overlap = 0;      // = 1, don't allow points overlap in x
      int     no_y_overlap = 0;      // = 1, don't allow points overlap in y 
      enum    translation {
        choices = { "XY Arbitrary", 
		    "X Only", 
		    "Y Only" };
      } = 0;
      int     fixed_x_first_point = 0; // = 1, "Y Only" translation for first point
      int     fixed_x_last_point = 0;  // = 1, "Y Only" translation for last point

      // Draw characteristics
      float   highlight_color[3] = {1,0,0};
      float   highlight_width = 1;
      enum    draw_mode {
        choices = {"Copy", "XOR"};
      } = 0;

      // Required state info
      group  &interactor <NEportLevels={2,0}>
      {
        int x;
        int y;
        int state;
      };
      group  &view          <NEportLevels={2,0}>;
      group  &camera        <NEportLevels={2,0}>;
      group  &point_object  <NEportLevels={2,0}>;
      // Local storage
      ptr     point_buffer  <NEvisible=0>;

      // Outputs
      float   current_point[2];
      int     current_point_id = 0;
      // convert between screen positions and data value
      float   convert_ratio;
      float   real_scalar;
      float   data_min;
      group   &datamap;

      // Methods
      cxxmethod+notify_inst    create_buffer( );

      cxxmethod+notify_deinst  delete_buffer( );

      cxxmethod+req            clear_buffer( .delete_all +notify );

      cxxmethod+req            update( 
        .active                +req+read+write,
        .valid_min_x           +read,
        .valid_max_x           +read,
        .valid_min_y           +read,
        .valid_max_y           +read,
        .insert_order          +req+read,
        .specified_index       +req+read,
        .no_x_overlap          +req+read,
        .no_y_overlap          +req+read,
        .translation           +req+read,
        .highlight_color       +req+read,
        .highlight_width       +req+read,
        .draw_mode             +req+read,
        .interactor.state      +req+read+notify,
        .interactor            +req+read,
        .view                  +req+read,
        .camera                +req+read,
        .point_object          +req+read,
        .point_buffer          +read+write,
        .current_point         +write,
        .convert_ratio         +read,
        .real_scalar           +read+write,
        .data_min              +read,
        .datamap               +read );
    };

    module modSaveLoadColorMap
    {
      string+IPort2           filename;
      float                   min;
      float                   max;
      int                     regen;
      int                     rescale = 0;
      int+IPort2              save_trigger;
      int+IPort2              load_trigger;
      Mesh+Node_Data+IPort2   &point_mesh;

      cxxmethod+req save
      (
        .filename      +read+req,
        // It seems logical to add +req here to some of these guys
        // but it causes funny dependency bugs due to interaction
        // with the load method.
        .min           +read,
        .max           +read,
        .point_mesh    +read,
        .save_trigger  +notify+req
      );
      cxxmethod+notify_inst+req load
      (
        .filename      +read+req,
        .rescale       +read,
        .load_trigger  +notify+req,
        .min           +write,
        .max           +write,
        .regen         +write,
        .point_mesh    +write 
      );
    };


// Loads a preset into point_mesh
module preset_load<cxx_name="ColorMap_preset_load">
{
   // This guy gets side-affected
   Mesh+Node_Data+IPort2  &point_mesh;

   // The five components are ... data, alpha, red, green, blue
   // all are normalized to 0.0 - 1.0, including the data value.
   //
   // A preset must have length of at least two (* 5), with the first
   // data value equal to 0.0 an the last data value equal to 1.0
   //
   float+IPort2 preset[][5];

   cxxmethod+notify_inst+req load
   (
      .preset        +read+notify+req,
      .point_mesh    +read+write+req 
   );
};

}; // Modules

library+global+buffered Macro <compile_subs=0>
{
   // Utility
   macro UIbuttonPanel {
      ilink parent;
      int x = 0;
      int y = 0;
      float width = 24;
      float height = 24;
      float xoffset = 0;
      float yoffset = 0;
      string pixmap;
      string type;
      int rows = 1;
      int cols = 1;
      float sizex => (width-2*xoffset)/cols;
      float sizey => (height-2*yoffset)/rows;
      // define one panel with bitmap that looks like NxM buttons.
      // mouse clicks are caught, x&y offset into image is used to
      // determine which part of image was hit, similar to
      // html image maps.
      UIpanel UIbuttons {
	 parent => <-.parent;
	 x => <-.x;
	 y => <-.y;
	 width => <-.width;
	 height => <-.height;
	 pixmap {
	    filename => <-.<-.pixmap;
	    fileType => <-.<-.type;
	 };
      };
      UIonePoint pick {
	 view => <-.UIbuttons;
#ifndef MSDOS	    
	 runEvent = "<Btn1Down>";
#else
	 runEvent = "<BtnLDown>";
#endif	    
      };
      int yindex => (pick.y-1-yoffset)/sizey;
      int xindex => (pick.x-1-xoffset)/sizex;
      GMOD.copy_on_change set_max_index {
	 input => <-.yindex*<-.cols+ xindex;
	 output => <-.index;
	 on_inst = 0;
      };
      int index<NEportLevels={1,2}> = 0;
   };

    macro ColorMapEditor {

      //*****Input*********************************************************
      link InObj<NEportLevels={2,1}>;
      int initialize<NEportLevels={2,1}> = 1;
      Node_Data &in_field<NEportLevels={2,1}>;
      int visible<NEportLevels={2,1}> = 1;

      //*****Output********************************************************
      link histogram_values<NEportLevels={1,2}> => TransferFunction.Histogram.hist_values;
      //*******************************************************************

      // Make sure the color legend, color wheel, etc., have the same
      // color brightness settings.
      // Surface rendering = "No Lighting"
      int CommonModes[] => {0,0,2,0,0};
      // Ambient Lighting, Diffuse, Specular, Gloss
      int CommonProps[] => {0.9, 0., 0., 0.};

      group ColorMapEditorParams {
        int+OPort2 checkerboard = 0;
        int+OPort2 histo_enable = 0;
        int+OPort2 histo_log    = 0;
      };

      UIshell UIshell {
        visible => <-.visible;
        width = 377;
        // argh, clientHeight is what we really want to control,
        // height is what we are able to control.
        //height => <-.PresetFrame.y + <-.PresetFrame.height + 50;
        height = 568;
        showStatusBar = 0;
        title => name_of(<-.<-);
        menu => <-.MenuBar.UIcmdList;
      };

      UIframe UIframe {
        parent => <-.UIshell;
        x = 0;
        y = 0;
        width => parent.clientWidth;
        // Should be height >= TransferFunction.localUI.bottom
#ifdef MSDOS
        height = 386;
#else
        height = 392;
#endif
      };

      UIframe LegendFrame {
         parent => <-.UIshell;
	 x = 0;
         y => <-.UIframe.y + <-.UIframe.height + 2;
         width => .parent.clientWidth;
         height = 40;
      };

      UIframe PresetFrame {
         parent => <-.UIshell;
	 x = 0;
	 y => <-.LegendFrame.y + <-.LegendFrame.height + 2;
	 width => .parent.clientWidth;
	 height = 90; 
      };

      macro DmapRamp {
         link parent<NEportLevels={2,1}> => <-.LegendFrame;

         int width  => <-.TransferFunction.Scene.View.View.render_view.width;
         int height => parent.clientHeight - 3;

         macro Dmap2ImageLegend {

            link dmap<NEportLevels={3,1}> => <-.<-.MakeDmap.dmap_out;

            // Split image, checkerboard, alpha blending legend mode
            DMAP.Dmap2Image Dmap2Image {
               dmap =>   <-.dmap;
               width =>  <-.<-.width;
               // Little white stripe at top without the +2 (why?)
               height => <-.<-.height + 2;
               Mode => ColorMapEditorParams.checkerboard;
            };

            GDM.DataObjectLite DataObject {
               in => <-.Dmap2Image.out;
               Modes.mode => CommonModes;
               Props {
                  material => CommonProps;
                  inherit = 0;	// needed in XP 6.3
               };
            };

            olink out_fld => .Dmap2Image.out;
            olink out_obj => .DataObject.obj;
         };

         GDM.Mscene2D Scene {
            Top {
               child_objs => {<-.<-.Dmap2ImageLegend.out_obj};
               Top {
                  pickable = 0;
               };
               Xform {
                  dcenter = {7.99634,27.4545,0.};
               };
            };
            Camera {
               Camera {
                  norm_scale = 1.;
                  from = {0.,-0.02,12.};
                  at = {0.,-0.02,11.};
               };
               CameraXform {
                  xlate = {0.,0.02,-12.};
               };
            };
            View {
               //PickCtrl {
               //   x => <-.View.pick_interactor.x;
               //   y => <-.View.pick_interactor.y;
               //   event => <-.View.pick_interactor.state;
               //};
               View {
                  renderer = "OpenGL";
                  aspect = "Biggest";
                  back_col = {1.,1.,1.};
                  UIrenderView render_view {
                     parent<NEportLevels={5,0}> => <-.<-.<-.<-.parent;
                     x = 15;
                     y = 2;
                     width =>  <-.<-.<-.<-.width;
                     height => <-.<-.<-.<-.height;
                  };
                  //UImouseEvents mouse_events {
                  //   view => <-.render_view;
                  //};
                  //UIonePoint pick_interactor {
                  //   view => <-.render_view;
                  //   runEvent = "<BtnLDown>";
                  //};
                  handle<NEportLevels={0,0}> => .render_view.handle;
               };
            };
         };
      }; // DmapRamp

      macro MenuBar {
        // File menu
        UIcmd UIcmdSave {
          label => "Save...";
        };
        UIcmd UIcmdOpen {
          label => "Load...";
        };
        UIcmd UIcmdOpenScaled {
          label => "Load Scaled...";
        };
        UImenuSeparator UImenuSeparator;
        UIcmd UIcmdClose {
          label => "Close";
          do => !(<-.<-.visible);
        };
        UIcmdList File {
          cmdList => {<-.UIcmdOpen, <-.UIcmdOpenScaled, <-.UIcmdSave,
                      <-.UImenuSeparator,
                      <-.UIcmdClose};
          label = "File";
        };

        // Options menu
        UIoption UIoptCheckerboard {
          label => "Transparency Checkerboard";
          set => ColorMapEditorParams.checkerboard;
        };
        UIoption UIoptHistEnable {
          label => "Histogram Enable";
          set => ColorMapEditorParams.histo_enable;
        };
        UIoption UIoptHistLog {
          label => "Histogram Log mode";
          set => ColorMapEditorParams.histo_log;
        };
        UIoptionList Options {
          cmdList => {<-.UIoptCheckerboard,<-.UIoptHistEnable,<-.UIoptHistLog};
          label = "Options";
        };

        // The menu bar
        UIcmdList UIcmdList<NEportLevels={0,2}> {
          cmdList => {<-.File, <-.Options};
        };

        int load_scaled = 0;
        GMOD.parse_v parse1 {
           relative => <-;
           trigger => UIcmdOpen.do;
           on_inst = 0;
           v_commands => "load_scaled = 0;";
        };
        GMOD.parse_v parse2 {
           relative => <-;
           trigger => UIcmdOpenScaled.do;
           on_inst = 0;
           v_commands => "load_scaled = 1;";
        };

        string filename;
        UIfileDialog SaveDialog {
          visible => UIcmdSave.do;
          title = "Save Color Map";
          filename => <-.filename;
          searchPattern = "*.cmp";
          confirmFileWrite = 1;
        };
        GMOD.copy_on_change coc {
           trigger => <-.UIcmdOpen.do || <-.UIcmdOpenScaled.do;
           input = 1;
           on_inst = 0;
        };
        UIfileDialog OpenDialog {
          visible => <-.coc.output;
          title = "Load Color Map";
          filename => <-.filename;
          searchPattern = "*.cmp";
        };
      };

      //***********************************************************************

      macro EditFields {

        link parent<NEportLevels={2,1}> => <-.UIframe;

        GMOD.rgb_or_hsv rgb_or_hsv {
          r => <-.<-.EditFields.UIfieldRed.value;
          g => <-.<-.EditFields.UIfieldGreen.value;
          b => <-.<-.EditFields.UIfieldBlue.value;
          h<NEportLevels={3,1}> => <-.<-.ColorWheel.hue;
          s<NEportLevels={3,1}> => <-.<-.ColorWheel.saturation;
          v<NEportLevels={3,1}> => <-.<-.ValueCone.value;
          mode = 1;
        };

        UIlabel UIlabelRed {
          parent => <-.parent;
          label => switch((UIradioBox.selectedItem + 1),"Hue","Red");
          x = 3;
          y => UIradioBox.y + UIradioBox.height + 3;
          width => <-.UIlabelScalar.width;
          height => UIfieldRed.height;
          alignment = "left";
        };
        UIfield UIfieldRed {
          parent => <-.parent;
          x => (UIlabelRed.x + UIlabelScalar.width);
          y => UIlabelRed.y - 3;
          width = 60;
          immediateMode = 1;
          min = 0;
          max = 1;
          updateMode = 7;
          value<NEportLevels={3,1}> => <-.<-.TransferFunction.RedValue;
          visible => UIradioBox.selectedItem;
        };
        UIfieldRed UIfieldHue {
          value<NEportLevels={3,1}> => <-.<-.ColorWheel.hue;
          visible => 1 - UIradioBox.selectedItem;
        };
        UIlabel UIlabelGreen {
          parent => <-.parent;
          label => switch((UIradioBox.selectedItem + 1),"Sat","Green");
          x => UIlabelRed.x;
          y => (UIlabelRed.y + UIlabelRed.height);
          width => <-.UIlabelScalar.width;
          height => UIfieldRed.height;
          alignment = "left";
        };
        UIfield UIfieldGreen {
          parent => <-.parent;
          x => (UIlabelGreen.x + UIlabelScalar.width);
          y => UIlabelGreen.y - 3;
          width = 60;
          immediateMode = 1;
          min = 0;
          max = 1;
          updateMode = 7;
          value<NEportLevels={3,1}> => <-.<-.TransferFunction.GreenValue;
          visible => UIradioBox.selectedItem;
        };
        UIfieldGreen UIfieldSat {
          value<NEportLevels={3,1}> => <-.<-.ColorWheel.saturation;
          visible => 1 - UIradioBox.selectedItem;
        };
        UIlabel UIlabelBlue {
          parent => <-.parent;
          label => switch((UIradioBox.selectedItem + 1),"Val","Blue");
          x => UIlabelRed.x;
          y => (UIlabelGreen.y + UIlabelGreen.height);
          width => <-.UIlabelScalar.width;
          height => UIfieldRed.height;
          alignment = "left";
        };
        UIfield UIfieldBlue {
          parent => <-.parent;
          x => (UIlabelBlue.x + UIlabelScalar.width);
          y => UIlabelBlue.y - 3;
          width = 60;
          immediateMode = 1;
          min = 0;
          max = 1;
          updateMode = 7;
          value<NEportLevels={3,1}> => <-.<-.TransferFunction.BlueValue;
          visible => UIradioBox.selectedItem;
        };
        UIfieldBlue UIfieldVal {
          value<NEportLevels={3,1}> => <-.<-.ValueCone.value;
          visible => 1 - UIradioBox.selectedItem;
        };
        UIlabel UIlabelAlpha {
          parent => <-.parent;
          label = "Alpha";
          x => UIlabelRed.x;
          y => (UIlabelBlue.y + UIlabelBlue.height);
          width => <-.UIlabelScalar.width;
          height => UIfieldRed.height;
          alignment = "left";
        };
        UIfield UIfieldAlpha {
          parent => <-.parent;
          x => (UIlabelAlpha.x + UIlabelScalar.width);
          y => UIlabelAlpha.y - 3;
          width = 60;
          immediateMode = 1;
          min = 0;
          max = 1;
          updateMode = 7;
          value<NEportLevels={3,1}> => <-.<-.TransferFunction.AlphaValue;
        };
        UIlabel UIlabelScalar {
          parent => <-.parent;
          label = "Scalar";
          x => UIlabelRed.x;
          y => (UIlabelAlpha.y + UIlabelAlpha.height);
          width = 45;
          height => UIfieldRed.height;
          alignment = "left";
        };
        UIfield UIfieldScalar {
          parent => <-.parent;
          x => (UIlabelScalar.x + UIlabelScalar.width);
          y => UIlabelScalar.y - 3;
          width = 60;
          immediateMode = 1;
          active => (1 - ((value == max) || (value == min)));
          mode = "real";
          min => <-.<-.MakeDmap.dmap_out.dataMin;
          max => <-.<-.MakeDmap.dmap_out.dataMax;
          updateMode = 7;
          format = "mixed";
          value<NEportLevels={3,1}> => <-.<-.TransferFunction.ScalarValue;
        };

        int lastX => (UIoptionBoxRefresh.x + UIoptionBoxRefresh.width);
        UIbutton UIbuttonRefresh{
          parent => <-.parent;
          label = "Apply"; // was "Refresh Now"
          x => <-.UIlabelRed.x;
          y => ((<-.UIoptionBoxRefresh.y + <-.UIoptionBoxRefresh.height) + 2);
          width => UIoptionBoxRefresh.width;
        };
        UIoption UIoptionRefresh {
          label = "Auto Apply"; // was "Auto Refresh"
          isUIoption = 1;
        };
        UIoptionBox UIoptionBoxRefresh {
          parent => <-.parent;
          cmdList => {<-.UIoptionRefresh};
          x => <-.UIlabelRed.x;
          y => <-.UIlabelScalar.y + <-.UIlabelScalar.height + 2;
          width = 95;
        };
        int lastY<NEportLevels=1> => (.UIoptionBoxRefresh.y + .UIoptionBoxRefresh.height);
         UIradioBox UIradioBox {
            parent => <-.parent;
            cmdList => {<-.UIoptionHSV,
              <-.UIoptionRGB};
            selectedItem = 0;
            x => UIlabelRed.x;
            y = 3;
            width = 55;
         };
         UIoption UIoptionRGB {
            label = "RGB";
            set = 1;
         };
         UIoption UIoptionHSV {
            label = "HSV";
         };
      };

      //***********************************************************************

      macro ColorWheel {

        link parent<NEportLevels={2,1}> => <-.UIframe;

        Mesh+Node_Data_Byte ColorField<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 37;
          coordinates {
	    values => {
	       0.0000,  0.0000,
	       1.0000,  0.0000,
	       0.9848,  0.1736,
	       0.9397,  0.3420,
	       0.8660,  0.5000,
	       0.7660,  0.6428,
	       0.6428,  0.7660,
	       0.5000,  0.8660,
	       0.3420,  0.9397,
	       0.1736,  0.9848,
	       0.0000,  1.0000,
	      -0.1736,  0.9848,
	      -0.3420,  0.9397,
	      -0.5000,  0.8660,
	      -0.6428,  0.7660,
	      -0.7660,  0.6428,
	      -0.8660,  0.5000,
	      -0.9397,  0.3420,
	      -0.9848,  0.1736,
	      -1.0000,  0.0000,
	      -0.9848, -0.1736,
	      -0.9397, -0.3420,
	      -0.8660, -0.5000,
	      -0.7660, -0.6428,
	      -0.6428, -0.7660,
	      -0.5000, -0.8660,
	      -0.3420, -0.9397,
	      -0.1736, -0.9848,
	       0.0000, -1.0000,
	       0.1736, -0.9848,
	       0.3420, -0.9397,
	       0.5000, -0.8660,
	       0.6428, -0.7660,
	       0.7660, -0.6428,
	       0.8660, -0.5000,
	       0.9397, -0.3420,
	       0.9848, -0.1736
	    };
          };
          int ncell_sets = 1;
          Tri cell_set {
	    ncells = 36;
	    node_connect_list = {
	      0,1,2,
	      0,2,3,
	      0,3,4,
	      0,4,5,
	      0,5,6,
	      0,6,7,
	      0,7,8,
	      0,8,9,
	      0,9,10,
	      0,10,11,
	      0,11,12,
	      0,12,13,
	      0,13,14,
	      0,14,15,
	      0,15,16,
	      0,16,17,
	      0,17,18,
	      0,18,19,
	      0,19,20,
	      0,20,21,
	      0,21,22,
	      0,22,23,
	      0,23,24,
	      0,24,25,
	      0,25,26,
	      0,26,27,
	      0,27,28,
	      0,28,29,
	      0,29,30,
	      0,30,31,
	      0,31,32,
	      0,32,33,
	      0,33,34,
	      0,34,35,
	      0,35,36,
	      0,36,1
	    };
          };
          nnode_data = 1;
          node_data {
	    veclen = 3;
	    id = 667;
	    values => {
	      1,1,1,
	      1.,0.,0.,
	      1.,0.166667,0.,
	      1.,0.333333,0.,
	      1.,0.5,0.,
	      1.,0.666667,0.,
	      1.,0.833333,0.,
	      1.,1.,0.,
	      0.833333,1.,0.,
	      0.666667,1.,0.,
	      0.5,1.,0.,
	      0.333333,1.,0.,
	      0.166667,1.,0.,
	      0.,1.,0.,
	      0.,1.,0.166667,
	      0.,1.,0.333333,
	      0.,1.,0.5,
	      0.,1.,0.666667,
	      0.,1.,0.833333,
	      0.,1.,1.,
	      0.,0.833333,1.,
	      0.,0.666667,1.,
	      0.,0.5,1.,
	      0.,0.333333,1.,
	      0.,0.166667,1.,
	      0.,0.,1.,
	      0.166667,0.,1.,
	      0.333333,0.,1.,
	      0.5,0.,1.,
	      0.666667,0.,1.,
	      0.833333,0.,1.,
	      1.,0.,1.,
	      1.,0.,0.833333,
	      1.,0.,0.666667,
	      1.,0.,0.5,
	      1.,0.,0.333333,
	      1.,0.,0.166667
	    };
          };
        };

        GDM.DataObjectLite ColorDataObject {
          in => <-.ColorField;
          obj {
	    pickable = 0;
          };
          Modes.mode     => CommonModes;
          Props {
            material => CommonProps;
            inherit = 0;	// needed in XP 6.3
          };
        };

        Mesh PickField<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 8;
          coordinates {
	    values => {
	       0.000,     0.0,
	       0.050,     0.0,
	       0.025,  0.0433,
	      -0.025,  0.0433,
	      -0.050,     0.0,
	      -0.025, -0.0433,
	       0.025, -0.0433,
	       0.050,     0.0
	    };
          };
          int ncell_sets = 1;
          Tri cell_set {
	    ncells = 6;
	    node_connect_list = {
	      0,1,2,
	      0,2,3,
	      0,3,4,
	      0,4,5,
	      0,5,6,
	      0,6,1
	    };
          };

        };

        GDM.DataObjectLite PickDataObject {
          in => <-.PickField;
          Props {
	    col => {1,1,1};
            inherit = 0;	// needed in XP 6.3
          };
        };

        Mesh OutlineField<NEportLevels={0,1}> {
          nspace => PickField.nspace;
          nnodes => PickField.nnodes;
          coordinates {
	    values => <-.<-.PickField.coordinates.values;
          };
          int ncell_sets = 1;
          Polyline cell_set {
	    npolys = 1;
	    poly_connect_list = {1,7};
          };
          xform {
	    xlate => <-.<-.PickField.xform.xlate;
          };
        };

        GDM.DataObjectLite OutlineDataObject {
          in => <-.OutlineField;
          Props {
	    col => {0,0,0};
            inherit = 0;	// needed in XP 6.3
          };
          obj {
	    pickable = 0;
          };
        };

        GDM.Mscene2D Scene {
          Top {
	    child_objs => {<-.<-.ColorDataObject.obj, 
		           <-.<-.PickDataObject.obj, 
		           <-.<-.OutlineDataObject.obj };
	    Top {
	      pickable = 0;
	    };
	    Camera {
	      Camera {
	        norm_scale = 0.98;
	      };
	    };
	    View {
	      PickCtrl {
	        x => View.pick_interactor.x;
	        y => View.pick_interactor.y;
	        event => View.pick_interactor.state;
	      };
	      View {
	        renderer = "OpenGL";
	        back_col = {1,1,1};
	        UIrenderView render_view {
	          parent<NEportLevels={5,0}> => <-.<-.<-.<-.parent;
	          x => <-.<-.<-.<-.<-.ValueCone.lastX + 10;
	          y = 30;
	          width = 200;
	          height => width;
	        };
	        UImouseEvents mouse_events {
	          view => render_view;
	          state = 3;
	        };
	        UIonePoint pick_interactor {
	          view => render_view;
    #ifndef MSDOS
	          runEvent = "<Btn1Down>";
    #else
	          runEvent = "<BtnLDown>";
    #endif
	        };
	        handle<NEportLevels={0,0}> => render_view.handle;
	      };
	      UIlabel UIlabel {
	        parent => <-.View.render_view.parent;
	        label => "Hue/Saturation";
	        x => View.render_view.x + View.render_view.width/2 - .width/2;
	        y => View.render_view.y - .height;
	        width => View.render_view.width;
	        height = 20;
	      };
	    };
          };
        };

        GDM.GDtrack_edit GDtrack_edit {
          event => switch( PickDataObject.PickInfo.npicked + 1, 
		           3, view.mouse_events.state );
          x => view.mouse_events.x;
          y => view.mouse_events.y;
          mode = 2;
          trans_mode = "Object";
          view => <-.Scene.View.View;
          camera => view.picked_camera;
          obj => <-.PickDataObject.obj;
        };

        modHSPosConverter HSPosConverter {
          calculate_toggle => (<-.Scene.View.View.mouse_events.state == 3);
          x_position => PickField.xform.xlate[0];
          y_position => PickField.xform.xlate[1];
          // hue<NEportLevels={0,2}> = 0;
          // saturation<NEportLevels={0,2}> = 0;
        };

        float hue<NEportLevels={1,2}> => HSPosConverter.hue;
        float saturation<NEportLevels={1,2}> => HSPosConverter.saturation;
      };

      //***********************************************************************

      macro ValueCone {

        link parent<NEportLevels={2,1}> => <-.UIframe;

        GMOD.hsv_to_rgb hsv_to_rgb {
          h<NEportLevels={3,1}> => <-.<-.ColorWheel.hue;
          s<NEportLevels={3,1}> => <-.<-.ColorWheel.saturation;
          v = 1.;
          r = 0;
          g = 0;
          b = 0;
        };

        Mesh+Node_Data_Float ValueField<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 4;
          coordinates {
	    values => {
	       0.0,    0.0,
	       0.3,    0.0,
	       0.3,    1.02,
	       0.0,    1.02
	    };
          };
          int ncell_sets = 1;
          Quad cell_set {
	    ncells = 1;
	    node_connect_list = {0,1,2,3};
          };
          nnode_data = 1;
          node_data {
	    veclen = 3;
	    id = 667;
	    values => {
	      0,0,0,
	      0,0,0,
	      hsv_to_rgb.r, hsv_to_rgb.g, hsv_to_rgb.b,
	      hsv_to_rgb.r, hsv_to_rgb.g, hsv_to_rgb.b
	    };
          };
        };

        GDM.DataObjectLite ValueDataObject {
          in => <-.ValueField;
          obj {
	    pickable = 0;
          };
          Modes.mode     => CommonModes;
          Props {
            material => CommonProps;
            inherit = 0;	// needed in XP 6.3
          };
        };

        Mesh PickField<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 5;
          coordinates {
	    values => {
	      0.0, 0.00,
	      0.3, 0.00,
	      0.3, 0.02,
	      0.0, 0.02,
	      0.0, 0.00
	    };
          };
          int ncell_sets = 1;
          Quad cell_set {
	    ncells = 1;
	    node_connect_list = {0,1,2,3};
          };
          xform {
	    xlate = {0,1,0};
          };

        };

        GDM.DataObjectLite PickDataObject {
          in => <-.PickField;
          Props {
	    col => {1,1,1};
            inherit = 0;	// needed in XP 6.3
          };
          obj {
	    pickable = 0;
          };
        };

        Mesh OutlineField<NEportLevels={0,1}> {
          nspace => PickField.nspace;
          nnodes => PickField.nnodes;
          coordinates {
	    values => <-.<-.PickField.coordinates.values;
          };
          int ncell_sets = 1;
          Polyline cell_set {
	    npolys = 1;
	    poly_connect_list = {0,4};
          };
          xform {
	    xlate => <-.<-.PickField.xform.xlate;
          };
        };

        GDM.DataObjectLite OutlineDataObject {
          in => <-.OutlineField;
          Props {
	    col => {0,0,0};
            inherit = 0;	// needed in XP 6.3
          };
        };

        GDM.Mscene2D Scene {
          Top {
	    child_objs => {<-.<-.ValueDataObject.obj, 
		           <-.<-.PickDataObject.obj,
		           <-.<-.OutlineDataObject.obj };
	    Top {
	      pickable = 0;
	    };
	    Camera {
	      Camera {
	        norm_scale = 1.0;
	      };
	    };
	    View {
	      PickCtrl {
	        x => View.pick_interactor.x;
	        y => View.pick_interactor.y;
	        event => View.pick_interactor.state;
	      };
	      View {
	        renderer = "OpenGL";
	        aspect = "Biggest";
	        back_col = {1,1,1};
	        UIrenderView render_view {
	          parent<NEportLevels={5,0}> => <-.<-.<-.<-.parent;
	          x => <-.<-.<-.<-.<-.EditFields.lastX + 10;
	          y = 30;
            width = 38;
	          height => <-.<-.<-.<-.<-.ColorWheel.Scene.View.View.render_view.height;
	        };
	        UImouseEvents mouse_events {
	          view => render_view;
	          state = 3;
	        };
	        UIonePoint pick_interactor {
	          view => render_view;
    #ifndef MSDOS
	          runEvent = "<Btn1Down>";
    #else
	          runEvent = "<BtnLDown>";
    #endif
	        };
	        handle<NEportLevels={0,0}> => render_view.handle;
	      };
	      UIlabel UIlabel {
	        parent => <-.View.render_view.parent;
	        label => "Value";
	        x => View.render_view.x + View.render_view.width/2 - .width/2;
	        y => View.render_view.y - .height;
	        width => <-.View.render_view.width;
	        height = 20;
	      };
	    };
          };
        };

        GDM.GDtrack_edit GDtrack_edit {
          event => switch( OutlineDataObject.PickInfo.npicked + 1, 
		           3, view.mouse_events.state );
          x => view.mouse_events.x;
          y => view.mouse_events.y;
          mode = 2;
          xlate_mode = "Y";
          trans_mode = "Object";
          view => <-.Scene.View.View;
          camera => view.picked_camera;
          obj => <-.OutlineDataObject.obj;
        };

        int lastX =>(Scene.View.View.render_view.x +  
                     Scene.View.View.render_view.width);
        int lastY =>(Scene.View.View.render_view.y +  
                     Scene.View.View.render_view.height);

        float value<NEportLevels={1,2}> => PickField.xform.xlate[1];
      };

      //***********************************************************************

      macro TransferFunction {

        link parent<NEportLevels={2,1}> => <-.UIframe;

        link dmap<NEportLevels={2,1}> => <-.MakeDmap.dmap_out;

        float+nres delta => (dmap.dataMax - dmap.dataMin) / 255.0;

        Grid+Space2+Xform+Node_Data_Float+nosave PointMesh<NEportLevels={0,2}> {
          nnodes = 2;
          coordinates {
	          values = {0.,0.,255.,1.};
          };
          int  ncell_sets = 1;
          Point  cell_set {
	          ncells => <-.nnodes;
	          node_connect_list => init_array(ncells, 0, ncells-1);
          };
          nnode_data = 1;
          node_data {
	          veclen = 3;
	          values = { 0,0,1, 1,0,0 };
	          labels = "rgb";
          };
        };
        GDM.DataObjectLite DataObjectPoint {
          in => PointMesh;
        };

        Mesh LineMesh<NEportLevels={0,1}> {
          nspace = 2;
          nnodes => PointMesh.nnodes;
          coordinates {
	          values => <-.<-.PointMesh.coordinates.values;
          };
          int ncell_sets = 1;
          Polyline cell_set {
	    npolys = 1;
	    poly_connect_list => {0,(nnodes - 1)};
          };
        };
        GDM.DataObjectLite DataObjectLine {
          in => <-.LineMesh;
          Props {
	    col => {0, 0, 0};	// black
            inherit = 0;	// needed in XP 6.3
          };
          Obj {
	    pickable = 0;
          };
        };

        Mesh SelectedPointMesh<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 4;
          coordinates {
	    values => {<-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][0], 
                       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][1] - 0.1,
		       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][0], 
                       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][1] + 0.1,
	               <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][0] - 6.4, 
                       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][1],
		       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][0] + 6.4, 
                       <-.<-.PointMesh.coordinates.
		       values[<-.<-.PointEditor.current_point_id][1] };
          };
          int ncell_sets = 1;
          Polyline cell_set {
	    npolys = 2;
	    poly_connect_list => {0,1,2,3};
          };
        };
        GDM.DataObjectLite DataObjectSelected {
          in => <-.SelectedPointMesh;
          Props {
	    col => {1,0,0};
            inherit = 0;	// needed in XP 6.3
          };
          Obj {
	    pickable = 0;
          };
        };

        modSaveLoadColorMap SaveLoadColorMap {
          filename => <-.<-.MenuBar.filename;
          min => <-.dmap.dataMin;
          max => <-.dmap.dataMax;
          regen => <-.<-.MakeDmap.regen;
          rescale => <-.<-.MenuBar.load_scaled;
          save_trigger => <-.<-.MenuBar.SaveDialog.ok;
          load_trigger => <-.<-.MenuBar.OpenDialog.ok;
          point_mesh => <-.PointMesh;
        };

        modHistogram Histogram {
          in_field<NEportLevels={3,0}> =>
              switch( ColorMapEditorParams.histo_enable, 
                      <-.<-.in_field );
          in_obj<NEportLevels={3,0}>   =>
              switch( ColorMapEditorParams.histo_enable, 
                      <-.<-.InObj );
          data_component<NEportLevels={4,0}>;
          logmode => ColorMapEditorParams.histo_log;
          hist_values<NEportLevels={0,3}>;
        };
        FLD_MAP.interleave_2_arrays interleave_2_arrays {
          in1 => <-.Histogram.x_values;
          in2 => <-.Histogram.hist_values;
        };
        Mesh HistogramLineMesh<NEportLevels={0,1}> {
          nspace = 2;
          nnodes = 256;
          coordinates {
      	    values => <-.<-.interleave_2_arrays.out;
          };
          int ncell_sets = 1;
          Polyline cell_set {
	    npolys = 1;
	    poly_connect_list => {0,(nnodes - 1)};
          };
        };
        GDM.DataObjectLite DataObjectHistogram {
          in => <-.HistogramLineMesh;
          Props {
	    col => {0,0,1};
            inherit = 0;	// needed in XP 6.3
          };
          Obj {
	    visible => <-.<-.Histogram.hist_valid;
	    pickable = 0;
          };
        };

        modPointEditor PointEditor {
          interactor => <-.Scene.View.View.mouse_events;
          view => <-.Scene.View.View;
          camera => <-.Scene.Camera.Camera;
          point_object => <-.DataObjectPoint.obj;
          insert_order = "X Value";
          translation = "XY Arbitrary";
          no_x_overlap = 1;
          no_y_overlap = 0;
          valid_min_x = 0;
          valid_max_x = 255;
          valid_min_y = 0;
          valid_max_y = 1;
          fixed_x_first_point = 1;
          fixed_x_last_point = 1;
          draw_mode = "Copy";
          current_point_id = 0;
          convert_ratio => <-.delta;
          real_scalar=0;
          data_min => <-.<-.EditFields.UIfieldScalar.min;
          datamap<NEportLevels={2,0}> => <-.dmap;
        };

        macro localUI {
          link parent<NEportLevels={2,1}> => <-.parent;
/*
          UIoption UIoptionAdd {
	          label => "Add";
          };
          UIoption UIoptionDelete {
            label => "Delete";
          };
          UIoption UIoptionEdit {
	          label => "Edit";
	          set = 1;
          };
          UIradioBox UIradioBox {
	          parent => <-.parent;
	          cmdList => {<-.UIoptionAdd,<-.UIoptionDelete,<-.UIoptionEdit};
	          x => <-.<-.<-.ValueCone.Scene.View.UIlabel.x;
	          y => cache(<-.<-.<-.ValueCone.Scene.View.View.render_view.y + 
	                     <-.<-.<-.ValueCone.Scene.View.View.render_view.height + 3);
	          width => itemWidth * dims;
            height => UIdata.UIfonts[0].lineHeight;
            selectedItem<NEportLevels={0,3}> = 2;
            orientation = 1;
            itemWidth = 70;
          };
*/

          link render_view => <-.Scene.View.View.render_view;

          int value_cone_bottom => 
             cache(<-.<-.ValueCone.Scene.View.View.render_view.y + 
	           <-.<-.ValueCone.Scene.View.View.render_view.height );

          int total_height => render_view.height + 
                              transferLabel.height +
                              xMin.height;

          int available_height => parent.clientHeight - value_cone_bottom;

          // Labels on the top of the TransferFunction render window
          UIlabel transferLabel {
             parent => <-.parent;
             label => "Transfer Function Points";
             x => render_view.x + render_view.width/2 - .width/2;
             // y => render_view.y - .height;
             // Bias it downwards so that it is closer to the colorbar
             y => value_cone_bottom + (available_height - total_height) * .66;
             width => <-.render_view.width/2;
          };

          // Labels on the side of the TransferFunction render window
          UIlabel yMax {
	          parent => <-.parent;
	          label = "1";
	          x = 5;
	          y => <-.render_view.y;
	          width = 7;
	          alignment = "left";
          };
          UIlabel yMin {
	          parent => <-.parent;
	          label = "0";
	          x => yMax.x;
	          y => yMax.y + <-.render_view.height - .height;
	          width = 7;
	          alignment = "left";
          };

          // Labels on the bottom of the TransferFunction render window
          UIlabel xMin {
             parent => <-.parent;
             label => str_format("%.2e", <-.<-.<-.MakeDmap.dmap_out.dataMin);
             x => <-.render_view.x;
             //y => <-.yMin.y + .height;
             y => <-.render_view.y + <-.render_view.height;
             width = 60;
             alignment = "left";
          };
          UIlabel xMax {
             parent => <-.parent;
             label => str_format("%.2e",<-.<-.<-.MakeDmap.dmap_out.dataMax);
             x => <-.xMin.x + <-.render_view.width - width;
             y => xMin.y;
             width = 60;
             alignment = "right";
          };

          int bottom => xMax.y + xMax.height;
        };

        GDM.Mscene2D Scene {
          Top {
	          child_objs => {<-.<-.DataObjectPoint.obj,
		           <-.<-.DataObjectLine.obj,
	                   <-.<-.DataObjectSelected.obj,
		           <-.<-.DataObjectHistogram.obj };
	    Top {
	      pickable = 0;
	      Xform {
	        mat = {0.0375,0,0,0,
		       0,2.4,0,0,
		       0,0,1,0,
		       0,0,0,1};
	        xlate = {-4.8,-1.2,0};
	      };
	    };
	    Camera {
	      Camera {
	        auto_norm = "None";
	      };
	    };
	    View {
	      PickCtrl {
	        x => View.mouse_events.x;
	        y => View.mouse_events.y;
	        event => (View.mouse_events.state == 2);
	      };
	      View {
	        renderer = "OpenGL";
	        aspect = "Biggest";
	        back_col = {1,1,1};
	        UIrenderView render_view {
	          parent<NEportLevels={5,0}> => <-.<-.<-.<-.parent;
	          x = 15;
	          //y => cache(<-.<-.<-.<-.localUI.value_cone_bottom +
	          //           <-.<-.<-.<-.localUI.transferLabel.height + 6 );
	          y => cache(<-.<-.<-.<-.localUI.transferLabel.y +
	                     <-.<-.<-.<-.localUI.transferLabel.height + 2 );

	          width  => ((parent.clientWidth - .x) - 4);
	          height = 100;
	        };
	        UImouseEvents mouse_events {
	          view => render_view;
                  onButtonDown = 0;
	          state = 3;
	        };
	        handle<NEportLevels={0,0}> => render_view.handle;
	      };
	    };
          };
        };

        float AlphaValue  <NEportLevels={1,2}>
          => PointMesh.coordinates.values[PointEditor.current_point_id][1];
        float   ScalarValue <NEportLevels={1,2}>
          => PointEditor.real_scalar;
        float RedValue    <NEportLevels={1,2}>
          => PointMesh.node_data[0].values[PointEditor.current_point_id][0];
        float GreenValue  <NEportLevels={1,2}>
          => PointMesh.node_data[0].values[PointEditor.current_point_id][1];
        float BlueValue   <NEportLevels={1,2}>
          => PointMesh.node_data[0].values[PointEditor.current_point_id][2];

      }; // TransferFunction


      modMakeDmap MakeDmap {
        obj_in => <-.InObj;
        // Update datamap if either automatic mode is selected
        // or the refresh button is pressed.
        dmap_out {
          currentColorModel => <-.color_model;
        };
        mode => EditFields.UIoptionRefresh.set;
        refresh => EditFields.UIbuttonRefresh.do;
        color_model => EditFields.UIradioBox.selectedItem;
        // trigger the update method when any color component or range is changed
        map_field => TransferFunction.PointMesh;
        curRange => TransferFunction.PointEditor.current_point_id;
        a => TransferFunction.AlphaValue;
        v2 => switch((dmap_out.currentColorModel + 1),ColorWheel.hue,TransferFunction.RedValue);
        v3 => switch((dmap_out.currentColorModel + 1),ColorWheel.saturation,TransferFunction.GreenValue);
        v4 => switch((dmap_out.currentColorModel + 1),ValueCone.value,TransferFunction.BlueValue);
        value => TransferFunction.ScalarValue;
        set => <-.initialize;
        done = 0;
      }; // MakeDmap

      macro Presets {

        link parent<NEportLevels={2,1}> => <-.PresetFrame;

        UIlabel preset_label {
          parent => <-.parent;
          x = 0;
          y = 2;
          width => parent.width;
          label = "Transfer Function Presets";
        };

      UIbuttonPanel mapbutton {
         parent => <-.parent;
         // Width needs to be carefully matched with the width of the pixmap.
         width = 356;
         height = 56;
         x => (.parent.width - .width) / 2;
         y => <-.preset_label.y + <-.preset_label.height + 2;
	 xoffset = 3;
	 yoffset = 3;
	 cols = 19;
         pixmap = "$XP_PATH<0>/runtime/pixmaps/cme_presets.x";
         type = "avs_image";
      };
 
      int idx => mapbutton.index;

     // RGB preset table
      string colormap_table[] = {
            // first 8 are simple single range
            // d, a, r,g,b    d, a, r,g,b
            "{{0, 0, 0,0,1}, {1, 1, 1,0,0}}",  // 0,  blue-red
            "{{0, 0, 1,0,0}, {1, 1, 0,0,1}}",  // 1,  red-blue
            "{{0, 0, 1,1,1}, {1, 1, 0,0,0}}",  // 2,  white-black
            "{{0, 0, 0,0,0}, {1, 1, 1,1,1}}",  // 3,  black-white
            "{{0, 0, 1,1,0}, {1, 1, 1,0,0}}",  // 4,  yellow-red
            "{{0, 0, 1,1,1}, {1, 1, 1,0,0}}",  // 5,  white-red
            "{{0, 0, 0,0,0}, {1, 1, 0,1,1}}",  // 6,  black-cyan
            "{{0, 0, 0,0,1}, {1, 1, 1,1,0}}",  // 7,  blue-yellow

            // next 11 are multi-range

            // 8, blue-red step
            "{{0.0, 0, 0,0,1}, {0.5, 0, 0,0,1},
              {0.5, 1, 1,0,0}, {1.0, 1, 1,0,0 }}",
            // 9, gray-blue-red-gray narrow
            "{{0.0, 0, 0.5,0.5,0.5}, {0.4, 0, 0.0,0.0,1.0},
              {0.6, 1, 1.0,0.0,0.0}, {1.0, 1, 0.7,0.7,0.7}}",
            // 10, blue-red-red low
            "{{0.0, 1, 0,0,1}, {0.1, 0, 1,0,0},  {1.0, 0, 1,0,0}}",
            // 11, blue-blue-red high
            "{{0.0, 0, 0,0,1}, {0.9, 0, 0,0,1},  {1.0, 1, 1,0,0}}",
            // 12, blue-green-red scallop
            "{{0.00, 0, 0,0,1}, {0.33, 1, 1,1,1},
              {0.33, 0, 0,1,0}, {0.66, 1, 1,1,1},
              {0.66, 0, 1,0,0}, {1.00, 1, 1,1,1}}",
            // 13, complex-astrophysics
            "{ 0.0, 1, 0.3,0.3,0.3, 0.2,1,  0,0,1,
               0.4, 1, 0,1,0,       0.6,1,  1,1,0,
               0.7, 1, 1,0,0,       0.75,1, 1,0,0.3,
               0.8, 1, 1,0,1,       1,1,    1,1,1 }",
            // 14, stairstep, blue green yellow red
            "{ 0,0, 0,0,1,          0.25,0, 0,0,1, 
               0.25,0.33, 0,1,0,    0.5,0.33, 0,1,0,
               0.5,0.66, 1,1,0,      0.75,0.66, 1,1,0,
               0.75,1, 1,0,0,        1,1, 1,0,0 }",
            // 15, hat
            "{ 0,0, 0.3,0.3,0.3,    0.4,0, 0.3,0.3,0.3,
               0.4,1, 0,0,1,        0.6,1, 1,0,0,
               0.6,0, 1,1,1,        1,0, 1,1,1 }",
            // 16, blue-blue-red-red narrow
            "{ 0.0, 0, 0,0,1,  0.4, 0, 0,0,1,
               0.6, 1, 1,0,0,  1.0, 1, 1,0,0 }",
            // 17, 8-stairsteps,
            // blue, cyan, green, yellow, orange, red, violet, white
            "{ 0.00,  0.00, 0,0,1,   0.125, 0.00, 0,0,1,
               0.125, 0.15, 0,1,1,   0.250, 0.15, 0,1,1,
               0.250, 0.30, 0,1,0,   0.375, 0.30, 0,1,0,
               0.375, 0.45, 1,1,0,   0.500, 0.45, 1,1,0,
               0.500, 0.55, 1,0.5,0, 0.625, 0.55, 1,0.5,0,
               0.625, 0.70, 1,0,0,   0.750, 0.70, 1,0,0,
               0.750, 0.85, 1,0,1,   0.875, 0.85, 1,0,1,
               0.875, 1.00, 1,1,1,   1.000, 1.00, 1,1,1 }",
            // 18, blue-red cyclic
            "{ 0.0, 0, 0,0,1,    0.1 ,1, 1,0,0,
               0.2, 0, 0,0,1,    0.3, 1, 1,0,0,
               0.4, 0, 0,0,1,    0.5, 1, 1,0,0,
               0.6, 0, 0,0,1,    0.7, 1, 1,0,0,
               0.8, 0, 0,0,1,    0.9, 1, 1,0,0,
               1.0, 0, 0,0,1 }"
     };

      string setstring => colormap_table[idx];

      // note long distance hop, up to upper level of macro!
      // This will fire when 'setstring' changes.
      GMOD.parse_v set_colormap {
         relative => <-.<-;
         on_inst = 0;
         v_commands => "$push -usr\n"
                      +"Presets.preset_load { preset = "
                      + setstring
                      +"; };\n"
                      + "MakeDmap.regen=1;\n"
                      +"$pop\n"
                      ;
      };

      preset_load preset_load {
         point_mesh => <-.<-.TransferFunction.PointMesh;
      };

      }; // Presets

    }; // ColorMapEditor

  }; // Macro

}; // CMAP_EDTR
