/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv.v#1 $
*/

flibrary+global+sort DV <
   locked=1,
   indexed=1,
   build_dir="modules",
   build_cmd="$(MAKE)",
   libdeps="DV_FLD",
   need_virtual="methods",
   need_objs="Block_Table",
#ifdef NO_DL_LOAD
   // Image libs must be explicitly specified if dlopen is unavailable.
   link_files="-lmods -lavsx -lbmp -lgif -ljpeg -lpbm -lsunrs -lsgiim -ltif",
#else
   link_files="-lmods",
#endif
   edit_lic="DV"
> {

$include ../include/$MACHINE/config.h

/**
module DVloop {
	link+notify+IPort2  trigger;
	float+Iparam     start;
	float+Iparam     end;
	float+Iparam     incr;
	float+Oparam       count;
	int+Oparam         done;
	method+notify_val+notify_inst loop_update = "DVloop_update";
};
**/

module DVswitch {
	group+IPort2 &in[];
	int+IPort2   index;
	olink+nres out=>in[index];
};

module DVswitch_prim {
	prim+IPort2 &in[];
	int+IPort2   index;
	olink+nres out=>in[index];
};

module DVfld_match {
	Mesh+Iparam &in {
		xform+nonotify; /* this will not cause a field type change */
	};
	int+Oparam   index=0;
	group+write+nonotify links {
		link+OPort3 link0;
		link+OPort3 link1;
		link+OPort3 link2;
		link+OPort3 link3;
	};
	method+notify_val+notify_inst match_update<status=1> = "DVfld_match_update";
};

module DVgen_fld {	/* generates field */
	int+Iparam fld_type;	// 0=unstruct, 1=structured, 2=unif, 3=rectilinear
	int+Iparam ndim;
	long+Iparam dims[ndim];
	int+Iparam nspace;
	float+Iparam extents[2][nspace];
	string cell_type;
	int+Iparam ndata_veclen;
	int+Iparam ndata_type;	// same as defines in include/avs/dtype.h
	float+Iparam  ndata_coeff[10];
	int        null_flag;
	float      null_value;
	Field+Oparam   &out;		/* output field */
	method+notify_val+notify_inst gen_fld_update<status=1> = "DVgen_fld_update";
};

/*
module DVwrite_field {
	Mesh_Struct+Node_Data+Iparam   in;
	string+Iparam  filename;
	int+Iparam portable;
	int+Iparam write_extents;
	int+Iparam write_minmax;
	method+notify_val+notify_inst write_field_update<status=1> = "DVwrite_field_update";
};
*/

module DVwrite_ucd {
	Mesh+nonotify+IPort2   &in;
	string+Iparam  filename;
	int+nonotify+IPort2 format;
	method+notify_val+notify_inst write_ucd_update<status=1> = "DVwrite_ucd_update";
};

module DVread_field<need_objs="Field_Unif Field_Struct Field_Rect"> {

#ifdef OLD_FIELD_READER
	string+Iparam  filename;	/* name of file to read */
	int+Iparam portable=1;
	int+Iparam swap=0;
	int+Iparam     flip=0;
	Mesh_Struct+Node_Data+Oparam   &out;		/* output field */
	method+notify_val+notify_inst read_field_update<status=1> = "DVread_field_update";
#else	// new multistep reader from KGT

	string+Iparam filename;
	int+Iparam portable=1;
	int+Iparam swap=0;
	int+Iparam flip=0;

        int+read store_all;
        int+read+write store_all_visible = 0;
	int+read+write+notify stepno;
	int+read+notify forward;
	int+read+notify backward;
	int+read+write+nonotify nsteps = 0;
	string+write+nonotify time_string<NEportLevels={0,2}> = "";

	ptr+read+write file_ptr<NEvisible=0> = 0;
	ptr+read+write RF_ptr<NEvisible=0> = 0;
	ptr+read+write coord_ptr<NEvisible=0> = 0;

	Mesh_Struct+Node_Data+Oparam &out;
        Time_Mesh_Struct+Time_Node_Data+Oparam &out_all {
               nsteps+opt;
               time+opt;
               time_coordinates+opt;
               time_node_data+opt;
               nnode_data+opt;
        };
	omethod+notify_val+notify_inst read_field_update<status=1> =
				"DVread_field_update";
	method+notify_deinst read_field_delete() = "DVread_field_delete";
#endif
};

group DVprint_params<NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        int gridout<NEportLevels={1,2}>;
        int cellout<NEportLevels={1,2}>;
        int xformout<NEportLevels={1,2}>;
        int nodesout<NEportLevels={1,2}>;
        int htmlout<NEportLevels={1,2}>;
        int allout<NEportLevels={1,2}>;
        int trigger<NEportLevels={1,2}>;
        long nvals<NEportLevels={1,2}>;
        long start_index<NEportLevels={1,2}>;
        string message<NEportLevels={1,2}>;
        string notes<NEportLevels={1,2}>;
};

module DVprint_field {
         omethod+req print_fld(
            filename+read+notify+req,
            gridout+read+notify+req,
            cellout+read+notify+req,
            xformout+read+notify+req,
            nodesout+read+notify+req,
            htmlout+read+notify+req,
            allout+read+notify+req,
            trigger+read+notify+req,
            nvals+read+notify+req,
            start_index+read+notify+req,
            message+write,
            notes+write,
            field_to_print+read+notify+req ) = "DVprint_field_update";
         DVprint_params &DVprint_params<NEportLevels={2,1}>;
         string filename<NEportLevels={1,1}> => DVprint_params.filename;
         int gridout<NEportLevels={1,1}> => DVprint_params.gridout;
         int cellout<NEportLevels={1,1}> => DVprint_params.cellout;
         int xformout<NEportLevels={1,1}> => DVprint_params.xformout;
         int nodesout<NEportLevels={1,1}> => DVprint_params.nodesout;
         int htmlout<NEportLevels={1,1}> => DVprint_params.htmlout;
         int allout<NEportLevels={1,1}> => DVprint_params.allout;
         int trigger<NEportLevels={1,1}> => DVprint_params.trigger;
         long nvals<NEportLevels={1,1}> => DVprint_params.nvals;
         long start_index<NEportLevels={1,1}> => DVprint_params.start_index;
         string message<NEportLevels={1,1}> => DVprint_params.message;
         string notes<NEportLevels={1,1}> => DVprint_params.notes;
         Mesh+Node_Data &field_to_print<NEportLevels={2,0}>;
};

module DVread_ucd {

#ifdef OLD_UCD_READER
	string+Iparam  filename;	/* name of file to read */
	Mesh+Cell_Data+Node_Data+Oparam   out;		/* output field */
	method+notify_val+notify_inst read_ucd_update<status=1> = "DVread_ucd_update";
#else	// new multistep reader from KGT

	string+Iparam filename;

        int+read store_all;
        int+read+write store_all_visible = 0;
	int+read+write+notify current_step;
	int+read+notify forward;
	int+read+notify backward;
	int+read+write+nonotify total = 0;
	string+write+nonotify step_title<NEportLevels={0,2}> = "";

	ptr+read+write file_ptr<NEvisible=0> = 0;
	ptr+read+write file_pos<NEvisible=0> = 0;
	ptr+read+write top<NEvisible=0> = 0;
	string+read+write cycle_type = 0;
	int+read+write new_format = 0;
        ptr+read+write all_comments<NEvisible=0> = 0;

	Mesh+Cell_Data+Node_Data+Oparam out;
        Time_Mesh+Time_Cell_Data+Time_Node_Data+Oparam out_all;
	omethod+notify_val+notify_inst read_ucd_update<status=1> =
				"DVread_ucd3_update";
	method+notify_deinst read_ucd_delete() = "DVread_ucd3_delete";
#endif
};

module DVread_image {
	string+Iparam  filename;
	int+Iparam     flip;
	int+Iparam+opt format;
	string+Oparam  info;
	Mesh_Unif+Dim2+Space2+Node_Data+Vector4+Oparam   out;
	method+notify_val+notify_inst read_image_update<status=1> = "DVread_image_update";
};

/* output an Express field of supported format */
module DVwrite_image {
        Mesh_Unif+Dim2+Space2+Node_Data+Iparam &in;      /* input field */
        string+Iparam  filename;		/* name of file to write */
	int+opt        output;			/* oneshot write the file */
	int+IPort      flip;			/* pre-3.0 param: no change! */
	int+nonotify+opt       format;
	int+nonotify+opt       filetype;
	int+nonotify+opt       depth;
	int+nonotify+opt       colortype;
	int+nonotify+opt       compresstype;
	float+nonotify+opt     compressqual;
	int+nonotify+opt       reducetype;
	int+IPort+nonotify+opt overwrite;
	ptr+nonotify           local_ptr<NEvisible=0>;
        method+notify_val+notify_inst write_image_update<status=1> = "DVwrite_image_update";
	method+notify_deinst write_image_delete = "DVwrite_image_delete";
};

module DVread_img2vol {
    string+IPort2  filename;
    int+IPort2     format;
    int+IPort2     start;
    int+IPort2     end;
    int+IPort2     out_format;

    string+OPort2 info;
    Mesh_Unif+Dim3+Space3+Node_Data+OPort2 out;

    omethod+notify_inst+req update<status=1> (
        .filename+read+notify+req,
        .format+read+notify+opt,
        .start+read+notify+req,
        .end+read+notify+req,
        .out_format+read+notify+req,
        .info+write,
        .out+write
    ) = "DVread_img2vol_update";
};

// Read triangles from RAW, STL, SLP, TIN files.
module DVread_triangle {
    string+Iparam filename;

    // cell data sometimes ... depends on file.
    Mesh+Space3+Oparam outFld {
       Tri+Cell_Data_Set cell_set[ncell_sets];
    };

    omethod+notify_val+notify_inst update<status=1> =
        "DVread_triangle_update";
};

// Read polygons from OBJ, PLY, VTK files.
module DVread_polygon {
    string+Iparam filename;

    // cell data sometimes ... depends on file.
    Mesh+Space3+Oparam outFld {
       Polyhedron+Cell_Data_Set_Poly cell_set[ncell_sets];
    };

    omethod+notify_val+notify_inst update<status=1> =
        "DVread_polygon_update";
};

// Read (ASCII) DXF files.
module DVread_dxf {
    string+Iparam filename;

    // cell data sometimes ... depends on file.
    // Could be Point, Line, Tri, Quad.
    Mesh+Cell_Data+Space3+Oparam outFld;

    omethod+notify_val+notify_inst update<status=1> =
        "DVread_dxf_update";
};

module DViso<need_objs="Cell_Data_Set"> {
	Mesh+Node_Data+Iparam  &in {
		xform+nonotify;
		nnodes+req;
		nspace+req;  /* in case we have just data */
	};
	float+Iparam  level;
	int+read+notify+opt+IPort2   cell_data[];
	int+read+notify+opt+IPort2   component;
	Mesh+Oparam  out {
		&xform+nowrite => in.xform;
	};
	NParam_Data+Oparam nparam;
	method+notify_val+notify_inst iso_update<status=1> = "DViso_update";
};

/**
macro DViso_level_array {
   float+IPort2 in_levels[];
   int size => array_size(in_levels);
   ilink in_field;
   DViso      isos[size] {
      in<NEportLevels={3,0}> => in_field;
      level => in_levels[index_of(isos)];
      out<NEportLevels={0,3}>;
   };
};
***/

module DVsurf_ribbons {
	Mesh_Unif+Dim2+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
		dims+req;
	};
	int+IPort2    ribbon_dir;
	int+IPort2    height_comp;
	int+IPort2    map_comp;
	float+IPort2  scale;
	float+IPort2  offset;
	Mesh+Node_Data+Oparam out {
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst surf_ribbons_update<status=1> = "DVsurf_ribbons_update";
};

module DVisotrace {
	Mesh_Struct+Dim3+Node_Data+Iparam  &in {
		nnodes+req;
	};
	Grid+Xform+Iparam &probe {
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	float+Oparam  level;
	Mesh+Oparam  out {
		&xform+nowrite => in.xform;
	};
	NParam_Data+Oparam nparam;
	method+notify_val+notify_inst isotrace_update<status=1> = "DVisotrace_update";
};

module DVisoline {	/* creates lines of constant value */
	Mesh+Node_Data+Iparam  &in {	/* input field */
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    component;
	float+Iparam  level[];		/* isoline level */
	int+Iparam    color;		/* toggle for colored lines */
	Mesh+Node_Data+Oparam  out {	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst isoline_update<status=1> = "DVisoline_update";
};

module DVisoline_trace {
	Mesh_Struct+Dim2+Node_Data+Iparam  &in {
		nnodes+req;
	};
	Grid+Xform+Iparam &probe{
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam    component;
	int+Iparam    color;
	float+Oparam  level;
	Mesh+Node_Data+Oparam  out {
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst isoline_trace_update<status=1> = "DVisoline_trace_update";
};

module DVcut<need_objs="Cell_Data_Set"> {	/* cuts off a portion of a field on one side of a plane */
	Mesh+Node_Data+Iparam  &in {	/* input field (to be sliced) */
		xform+nonotify;
		nnodes+req;
		nnode_data+req;
	};
	int+Iparam    cut_comp;
	int+read+notify+opt+IPort2    map_comp[];
	float+Iparam  level;
	int+Iparam   above;		/* toggle for specifying which side 
					   of the plane will be removed */
	int+read+notify+opt+IPort2   cell_data[];

	Mesh+Node_Data+Oparam  out { 	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst cut_update<status=1> = "DVcut_update";
};

module DVcontour {		/* cuts off a portion of a field between two contours */
	Mesh+Node_Data+Iparam  &in {	/* input field (to be sliced) */
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    contour_comp;
	int+read+notify+opt+IPort2    map_comp[];
	float+Iparam  level_min;
	float+Iparam  level_max;
	Mesh+Node_Data+Oparam  out { 	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst contour_update<status=1> = "DVcontour_update";
};

module DVsolid_contour {
	Mesh+Node_Data+Iparam  &in {
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    contour_comp;
	float+Iparam  level[];

	int+Iparam+opt    contour_lines;
	int+Iparam+opt    color_lines;

	Mesh+Cell_Data+Oparam  out {
		&xform+nowrite => in.xform;
	};
	group+write+nonotify lines {
		int ncell_sets;
		Line+Cell_Data_Set cell_set[ncell_sets];
	};
	Mesh+OPort2 &out_line => merge(lines, out);
	method+notify_val+notify_inst solid_contour_update<status=1> = "DVsolid_contour_update";
};

module DVplane_dist {	/* compute distance to a plane */
	Mesh+Iparam  &in {
		nnodes+req;
	};
	Plane_Grid+Xform+Iparam  &plane {
		points+req;
	};
	Node_Data+Scalar+Float+Oparam  out;
	float+Oparam     dist;
	method+notify_val+notify_inst plane_dist_update<status=1> = "DVplane_distance_update";
}; 

module DVcomb_mesh_and_data {
	Mesh+IPort2 &in_mesh ;
	Node_Data+nres+IPort2 &in_nd;
        Mesh+Node_Data+OPort2 &out => merge(in_nd, in_mesh);
};

module DVmesh_add_data {
	Mesh+IPort2 &in_mesh ;
	Node_Data+nres+IPort2 &in_nd;
        Mesh+Node_Data+OPort2 &out => merge(in_mesh, in_nd);
};

module DVnmap {
	Node_Data+Iparam  &in {
		nnodes+req;
	};
	NParam_Data+Iparam &nparam {
		nnodes+req;
	};
	int+read+notify+opt+IPort2 iso_comp;
	float+read+notify+opt+IPort2 iso_val;
	int+Iparam    map_comp[];
	Node_Data+Oparam  out;
	method+notify_val+notify_inst nmap_update<status=1> = "DVnmap_update";
};

module DVslice_unif {	/* slice a uniform data set */
	Mesh_Unif+Dim3+Node_Data+Iparam  &in {	/* uniform input field */
		nnodes+req;
		nnode_data+opt;
		node_data+opt;
	};
	Plane_Grid+Xform+Iparam  &plane {		/* slice plane */
		points+req;
	};
	float+notify+IPort2  dist;			/* plane distance */
	int+read+notify+opt+IPort2    map_comp[];
	Mesh_Unif+Dim2+Node_Data+Oparam  out;	/* output field */
	method+notify_val+notify_inst slice_update<status=1> = "DVslice_update";
};

module DVslice_rect {	/* slice a rectilinear field */
	Mesh_Rect+Dim3+Node_Data+Iparam  &in { 	/* rectilinear input field */
		nnodes+req;
		nnode_data+opt;
		node_data+opt;
	};
	Plane_Grid+Xform+Iparam  &plane {		/* slice plane */
		points+req;
	};
	float+notify+IPort2  dist;		/* plane distance */
	int+read+notify+opt+IPort2    map_comp[];
	Mesh_Rect+Dim2+Node_Data+Oparam out;	/* output field */
	method+notify_val+notify_inst slice_update<status=1> = "DVslice_update";
};

module DVslice_gen {
	Mesh+IPort2  &in; 	/*  input field */

	Plane_Grid+Xform+IPort2  &plane;	/* slice plane */

	float+IPort2  dist;		/* plane distance */
	int+IPort2    map_comp[];
	int+IPort2   cell_data[];

	int+nres has_node_data => (is_valid(in.nnode_data) && in.nnode_data > 0);

	DVplane_dist DVplane_dist {
		in => <-.in;
		plane => <-.plane;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data {
		in_mesh => <-.in;
		in_nd => DVplane_dist.out;
	};
	DViso DViso {
		in => DVcomb_mesh_and_data.out;
		level => DVplane_dist.dist+(<-.dist);
		&cell_data => <-.cell_data;
	};
	DVnmap DVnmap {
		in => switch(<-.has_node_data, <-.in);
		nparam => DViso.nparam;
		map_comp => <-.map_comp;
	};
	DVcomb_mesh_and_data DVcomb_mesh_and_data_1 {
		in_mesh => DViso.out;
		in_nd => DVnmap.out;
	};
	Mesh+nres+OPort2 &out => switch(has_node_data+1, DViso.out, DVcomb_mesh_and_data_1.out);
};

macro DVslice {
	Mesh+Iparam  &in { 	/*  input field */
		nnodes+req;
	};
	Plane_Grid+Xform+Iparam  &plane {		/* slice plane */
		points+req;
	};
	float+notify+IPort2  dist;		/* plane distance */
	int+read+notify+opt+IPort2     map_comp[];
	int+read+notify+opt+IPort2    cell_data[];

	DVslice_gen DVslice_gen {
		in => <-.DVfld_match.links.link2;
		plane => <-.plane;
		&dist => <-.dist;
		&map_comp => <-.map_comp;
		&cell_data => <-.cell_data;
	};
	DVslice_unif DVslice_unif {
		in => <-.DVfld_match.links.link0;
		plane => <-.plane;
		&dist => <-.dist;
		&map_comp => <-.map_comp;
	};
	DVslice_rect DVslice_rect {
		in => <-.DVfld_match.links.link1;
		plane => <-.plane;
		&dist => <-.dist;
		&map_comp => <-.map_comp;
	};

	DVfld_match DVfld_match {
		in => <-.in;
	};

	DVswitch DVswitch {
		in => {DVslice_unif.out, DVslice_rect.out, DVslice_gen.out};
		index => DVfld_match.index;
	};
	olink out => DVswitch.out;
}; 

module DVadjust_slice_spacing {
    Mesh_Unif+IPort2 &in;
    int+IPort2       spacing_axis;
    float+IPort2     &slice_position[];

    Mesh_Rect+OPort2 out;

    omethod+notify_inst+req update<status=1> (
        .in+read+notify+req,
        .spacing_axis+read+notify+req,
        .slice_position+read+notify+req,
        .out+write
    ) = "DVadjust_slice_spacing_update";
};

module DVthresh_null {	/* removes cells containing NULL node data */
	Mesh+Node_Data+Iparam  &in {		/* input field */
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    thresh_component;	/* component to be thresholded */
	Mesh+Oparam   &out;
	Mesh+Node_Data+write+nonotify  out_thresh {	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst thresh_null_update<status=1> = "DVthresh_null_update";
};

module DVthresh_null_cells {	/* removes cells containing NULL cell data */
	Mesh+Cell_Data+Iparam  &in {		/* input field */
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    thresh_component;	/* component to be thresholded */
	Mesh+Oparam   &out;
	Mesh+Cell_Data+write+nonotify  out_thresh {	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst thresh_null_cells_update<status=1> = "DVthresh_null_cells_update";
};

module DVplane_crop {
	Mesh+Node_Data_Opt+Iparam  &in {		/* input field */
		xform+nonotify;
		nnodes+req;
	};
	Plane_Grid+Xform+Iparam  &plane[] {    /* slice planes */
		points+req;
	};
	int+Iparam in_out;
	int+Iparam and_or = 1;
	Mesh+Node_Data+Oparam  out {	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst plane_crop_update<status=1> = "DVplane_crop_update";
};

/* Uses node data from the first field to interpolate data at the nodes
 * of the second field. No assumptions are made about the shape or type
 * of the second field. For example, it could be just a single point.
 */
module DVinterp_data {
	Mesh+Node_Data+Iparam &in {	/* input field */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	Mesh+Iparam &probe {		/* field grid */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam    comps[];
	Node_Data+write+nonotify  out_nd;	/* output field */
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd, probe);
	method+notify_val+notify_inst interp_data_update<status=1> = "DVinterp_data_update";
};

/* Uses cell data from the first field to interpolate data at the nodes
 * of the second field. No assumptions are made about the shape or type
 * of the second field.
 */
module DVinterp_cell_data {
	Mesh+Cell_Data+Iparam &in {	/* input field */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	Mesh+Iparam &probe {		/* field grid */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam    component;
	Node_Data+write+nonotify  out_nd;	/* output field */
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd, probe);
	method+notify_val+notify_inst interp_data_update<status=1> = "DVinterp_cell_data_update";
};

/* Uses node data from the first field to interpolate data at the nodes
 * of the second field. For performance reasons, the probe field is
 * restricted to be a uniform field. Performance is better if the
 * fields have the identity transform or at least have the same transform.
 * This is intended to be a fast algorithm that can be used to preprocess
 * fields for volume rendering.
 */
module DVinterp_data_to_unif {
	Mesh+Node_Data+Iparam &in {	/* input field */
		nnodes+req;
		nspace+req;
		nnode_data+req;
	};
	Mesh_Unif+Iparam &probe {	/* uniform grid */
		nnodes+req;
		nspace+req;
	};

	int+Iparam    comps[];
	float+read+IPort2  null_values[];	/* Optional: override default null values */

        // algorithm = 0. Faster. For each probe point grab the first
        // cell from 'in' that passes a simple bounding box test.  Then loop
        // over the nodes of the cell and do a distance test to determine
        // which node value to use.
        //
        // algorithm = 1. Better Quality. For each probe point,
        // use the same tests that are used by DVinterp_data to
        // determine if the probe point is contained by a 'in' cell.
        //
	int+Iparam    algorithm = 1;

	Node_Data+write+nonotify  out_nd;	/* output field */
	Mesh_Unif+Node_Data+nonotify+OPort2 &out => merge(out_nd, probe);

	omethod+notify_val+notify_inst interp_data_update<status=1> = "DVinterp_data_to_unif_update";
};

/* Uses cell data from the first field to interpolate data at the nodes
 * of the second field. Uses same algorithms as DVinterp_data_to_unif
 */
module DVinterp_cell_data_to_unif {
	Mesh+Cell_Data+Iparam &in {	/* input field */
		nnodes+req;
		nspace+req;
		ncell_sets+req;
	};
	Mesh_Unif+Iparam &probe {	/* uniform grid */
		nnodes+req;
		nspace+req;
	};

	int+Iparam    component;
	float+read+IPort2  null_value;	/* Optional: override default null values */
        // See comments in DVinterp_data_to_unif
        // algorithm = 0. Faster. 
        // algorithm = 1. Better Quality. 
	int+Iparam    algorithm = 1;

	Node_Data+write+nonotify  out_nd;	/* output field */
	Mesh_Unif+Node_Data+nonotify+OPort2 &out => merge(out_nd, probe);

	omethod+notify_val+notify_inst interp_data_update<status=1> = "DVinterp_cell_data_to_unif_update";
};

module DVgrad {
	Mesh+Node_Data+Iparam &in {	/* input field */
		nnodes+req;
		xform+nonotify;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam  comp;
	Node_Data+write+nonotify  out_nd;
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd, in);
	method+notify_val+notify_inst grad_update<status=1> = "DVgrad_update";
}; 

module DVcurl {
	Mesh+Node_Data+Iparam &in {	/* input field */
		nnodes+req;
		xform+nonotify;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam  comp;
	Node_Data+write+nonotify  out_nd;
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd, in);
	method+notify_val+notify_inst curl_update<status=1> = "DVcurl_update";
};

module DVdivrg {
	Mesh+Node_Data+Iparam &in {	/* input field */
		xform+nonotify;
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam  comp;
	Node_Data+write+nonotify  out_nd;
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd, in);
	method+notify_val+notify_inst divrg_update<status=1> = "DVdivrg_update";
};

module DVglyph { /* produces scaled, colored glyphs at nodal locations */
	Mesh+Node_Data_Opt+Iparam &in {	/* input field */
		nnodes+req;
		nspace+req;
		coordinates+req;
		coordinates.values+req;
	};
	Mesh+read+IPort2 &glyph;	/* glyph geometry */
	int+Iparam vector;	/* toggle to transform glyph by vector data */
	int+Iparam glyph_comp;	/* glyph data component */
	int+Iparam map_comp;	/* color glyph by data */
	int+Iparam scale_comp;	/* scale glyph by data */
	float+Iparam scale;	/* scale factor applied to glyph */
	int+Iparam scale_x;     /* do scale in x */
	int+Iparam scale_y;     /* do scale in y */
	int+Iparam scale_z;     /* do scale in z */
	int+Iparam normalize;	/* toggle to normalize glyphs */
	Mesh+Node_Data+Oparam  out { /* output field */
		xform+nowrite;
	};
	method+notify_val+notify_inst glyph_mod_update<status=1> = "DVglyph_update";
};

module DVgeo_glyph { /* produces scaled, colored glyphs at nodal locations */
	Mesh+Node_Data_Opt+Iparam &in {	/* input field */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	Mesh+Node_Data_Opt+Iparam &glyph[] {	/* glyph geometry */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	float+Iparam scale;	/* scale factor applied to glyph */
	float+Iparam color[3];	/* color  applied to glyph */
	int+Iparam normalize;   /* normalize glyph index */
	Mesh+Node_Data+Oparam  out { /* output field */
		xform+nowrite;
	};
	method+notify_val+notify_inst geo_glyph_update<status=1> = "DVgeo_glyph_update";
};

module DVscat_to_tet {	/* converts scattered data into triangular 
			   or tetrahedral mesh */
	Grid+Xform+Iparam  &in {	/* input field */
		nnodes+req;
		nspace+req;
	};
	int+Iparam	triangle=0;
	Cells+write+nonotify  out_mesh;
	Mesh+nonotify+OPort2 &out => merge(out_mesh, in);
	method+notify_val+notify_inst scat_to_tet_update<status=1> = "DVscat_to_tet_update";
};

module DVscat_to_unif {	/* interpolates scattered data into uniform mesh */
	Grid+Node_Data+Iparam  &in {	/* input field */
		nnodes+req;
	};
	int+Iparam	rndim;
	long+Iparam	rdims[rndim];
	float+Iparam    min_xyz[rndim] => in.coordinates.min_vec[0:rndim-1];
	float+Iparam    max_xyz[rndim] => in.coordinates.max_vec[0:rndim-1];
	int+Iparam	search_cube[rndim];
	int+Iparam	interp_order = 2;
	float+notify+IPort2    null_value;
	Mesh_Unif+Node_Data+Oparam  out {	/* output field */
		ndim => rndim;
		dims => rdims;
		nspace => rndim;
	};
	omethod+notify_val+notify_inst scat_to_unif_update<status=1> = "DVscat_to_unif_update";
}; 

module DVscat_bin {	/* interpolates scattered data into uniform mesh */
	Grid+Node_Data+Iparam  &in {	/* input field */
		nnodes+req;
	};
	int+Iparam	rndim;
	long+Iparam	rdims[rndim];
	float+Iparam    min_xyz[rndim] => in.coordinates.min_vec[0:rndim-1];
	float+Iparam    max_xyz[rndim] => in.coordinates.max_vec[0:rndim-1];
	float+notify+IPort2    null_value;
	Mesh_Unif+Node_Data+Oparam  out {	/* output field */
		ndim => rndim;
		dims => rdims;
		nspace => rndim;
	};
	method+notify_val+notify_inst scat_bin_update<status=1> = "DVscat_bin_update";
}; 

module DVextr_vector {	/* extract a vector component from a field */
	Node_Data+Iparam  &in {		/* input field */
		nnodes+req;
	};
	int+Iparam    veclen;		/* length of vector to be extracted */
	int+Iparam    components[veclen];
	int+Iparam    sub_components[veclen];
	Node_Data+Oparam  out;		/* output field */
	method+notify_val+notify_inst upd_extr_vector<status=1> = "DVextr_vector_update";
}; 

module DVextr_scalar {	/* extract scalar data from a field */
	Node_Data+Iparam  &in {		/* input field */
		nnodes+req;
	};
	int+Iparam    component;	/* which component to extract */
	Node_Data+Oparam  out;		/* output field */
	method+notify_val+notify_inst upd_extr_scalar<status=1> = "DVextr_scalar_update";
}; 

module DVcoord_math {
	Mesh+IPort2+nonotify &in1;
	Mesh+IPort2+nonotify &in2;
	Mesh+IPort2+nonotify &in3;
	Mesh+IPort2+nonotify &in4;

	int+nres+IPort2 nspace => in1.nspace+0;
	int+nres+IPort2 nnodes => in1.nnodes+0;
	string+IPort2 operation_x = "#1x";
	string+IPort2 operation_y = "#1y";
	string+IPort2 operation_z = "#1z";

	float+write+nonotify x_coord[nnodes][1];
	float+write+nonotify y_coord[nnodes][1];
	float+write+nonotify z_coord[nnodes][1];

	Grid+write+nonotify out_grid {
		nnodes => in1.nnodes;
		nspace => <-.nspace;
		coordinates{
			values => switch(nspace, cache(x_coord), 
				cache(combine_array(x_coord, y_coord)),
				cache(combine_array(x_coord, y_coord, z_coord)));
		};
	};
	Mesh+nonotify+OPort2 &out => merge(out_grid,in1);
	method+notify_val+notify_inst upd_coord_math<status=1> = "DVcoord_math_update";
};

module DVdata_math {
	string+IPort2 operation = "#1";
	Mesh+Node_Data+IPort2+nonotify &in1;
	Mesh+Node_Data+IPort2+nonotify &in2;
	Mesh+Node_Data+IPort2+nonotify &in3;
	Mesh+Node_Data+IPort2+nonotify &in4;
	int+IPort2 data_type = 4;	// 4 == DTYPE_FLOAT
	Node_Data+write+nonotify out_nd {
		nnodes => in1.nnodes;
		nnode_data = 1;
		!node_data[0] {
			/*
			 * Work around error from seismic demo
			 */
			id+nres => in1.node_data[0].id;
			veclen+nres => in1.node_data[0].veclen;
			prim values[nvals][veclen]; 
			labels = "data_math";
		};
	};
	Mesh+Node_Data+nonotify+OPort2 &out => merge(out_nd,in1);
	method+notify_val+notify_inst upd_data_math<status=1> = "DVdata_math_update";
};

module DVcell_data_math {
	string+IPort2 operation = "#1";
	Mesh+Cell_Data+IPort2+nonotify &in1;
	Mesh+Cell_Data+IPort2+nonotify &in2;
	Mesh+Cell_Data+IPort2+nonotify &in3;
	Mesh+Cell_Data+IPort2+nonotify &in4;
	int+IPort2 data_type = 4;	// 4 == DTYPE_FLOAT

	int  dim => in1.ncell_sets;
	group+nonotify out_data[dim] {
		int ncells => in1.cell_set[index_of(out_data)].ncells;
		int ncell_data=1;
		Data_Array cell_data[ncell_data] {
			nvals => ncells;
			&veclen => in1.cell_set[index_of(out_data)].cell_data[0].veclen;
			&id => in1.cell_set[index_of(out_data)].cell_data[0].id;
			prim values[nvals][veclen]; 
			labels = "cell_data_math";
		};
	};
	group+nonotify out_sets[dim] {
		group &out_set => merge(out_data[index_of(out_sets)],
				    in1.cell_set[index_of(out_sets)]);
	};
	Cells+Cell_Data+write+nonotify   out_cd {
		*cell_set[];
		ncell_sets => array_size(cell_set);
/*
		group &cell_set[ncell_sets] => {out_sets[0].out_set, ..., ...};
*/
	};
	Mesh+OPort2+nonotify &out =>merge(out_cd, in1);
	method+notify_val+notify_inst upd_data_math<status=1> = "DVcell_data_math_update";
};

module DVthreshold {	/* sets NULL data for all values below and/or 
			above min/max threshold level(s) */
	Node_Data+Iparam  &in {		/* input field */
		nnodes+req;
	};
	int+Iparam    check_vector;	/* which component will be compared against min_value and max_value */
	int+Iparam    check_comp;	/* which subcomponent of check_vector will be compared */
	int+Iparam    thresh_vector;	/* which component of the input field to threshold */
	int+Iparam    below;		/* toggle to turn on lower thresholding */
	int+Iparam    above;		/* toggle to turn on upper thresholding */
	float+Iparam  min_value;	/* lower threshold value */
	float+Iparam  max_value;	/* upper threshold value */
	float+Iparam  null_value;	/* value to set when data is out of range */
	/* Output always has a single node data component */
	Node_Data+Oparam  out;		/* output field */
	method+notify_val+notify_inst upd_threshold<status=1> = "DVthreshold_update";
}; 

module DVthreshold_cell {	/* sets NULL data for all values below and/or 
			above min/max threshold level(s) */
	Mesh+Cell_Data+Iparam  &in {		/* input field */
		nnodes+req;
		xform+nonotify;
	};
	int+Iparam    check_vector;	/* which component will be compared against min_value and max_value */
	int+Iparam    check_comp;	/* which subcomponent of check_vector will be compared */
	int+Iparam    thresh_vector;	/* which component of the input field to threshold */
	int+Iparam    below;		/* toggle to turn on lower thresholding */
	int+Iparam    above;		/* toggle to turn on upper thresholding */
	float+Iparam  min_value;	/* lower threshold value */                
	float+Iparam  max_value;	/* upper threshold value */              
	float+Iparam  null_value;	/* value to set when data is out of range */

	int  dim => in.ncell_sets;
	group+nonotify out_data[dim] {
		int ncells => in.cell_set[index_of(out_data)].ncells;
		/* Output always has a single cell data component */
		int ncell_data = 1;
		Data_Array cell_data[ncell_data] {
			nvals => ncells;
		};
	};
	group+nonotify out_sets[dim] {
		group &out_set => merge(out_data[index_of(out_sets)],
				    in.cell_set[index_of(out_sets)]);
	};
	Cells+Cell_Data+nonotify+write   out_cd {
		*cell_set[];
		ncell_sets => array_size(cell_set);
/*
		group &cell_set[ncell_sets] => {out_sets[0].out_set, ..., ...};
*/
	};
	Mesh+OPort2+nonotify &out =>merge(out_cd, in);
	method+notify_val+notify_inst upd_threshold<status=1> = "DVthreshold_cell_update";
}; 

module DVclamp {		/* clamps data to min/max values */
	Node_Data+Iparam  &in {		/* input field */
		nnodes+req;
	};
	/* Confusing terminology: it always clamps the first node data
	 * component; if the node data component happens to have
	 * veclen greater than one, then you can select which
	 * vector sub-component to clamp.
	 */
	int+Iparam    component;	/* which vector component to clamp */
	int+Iparam    below;		/* toggle to turn on lower clamping */
	int+Iparam    above;		/* toggle to turn on upper clamping */
	int+Iparam    reset_minmax;
	float+Iparam  min_value;	/* lower clamping value */
	float+Iparam  max_value;	/* upper clamping value */ 
	/* Output always has a single node data component */
	Node_Data+Oparam  out;		/* output field */
	method+notify_val+notify_inst upd_clamp = "DVclamp_update";
}; 

module DVclamp_cell {		/* clamps data to min/max values */
	Mesh+Cell_Data+Iparam  &in {		/* input field */
		xform+nonotify;
	};
	/* It always clamps the first cell data component */
	int+Iparam    component;	/* which vector component to clamp */
	int+Iparam    below;		/* toggle to turn on lower clamping */
	int+Iparam    above;		/* toggle to turn on upper clamping */
	int+Iparam    reset_minmax;
	float+Iparam  min_value;	/* lower clamping value */
	float+Iparam  max_value;	/* upper clamping value */ 

	int  dim => in.ncell_sets;
	group+nonotify out_data[dim] {
		int ncells => in.cell_set[index_of(out_data)].ncells;
		/* Output always has a single cell data component */
		int ncell_data = 1;
		Data_Array cell_data[ncell_data] {
			nvals => ncells;
		};
	};
	group+nonotify out_sets[dim] {
		group &out_set => merge(out_data[index_of(out_sets)],
				    in.cell_set[index_of(out_sets)]);
	};
	Cells+Cell_Data+nonotify+write out_cd {
		*cell_set[];
		ncell_sets => array_size(cell_set);
	};
	Mesh+OPort2+nonotify &out => merge(out_cd, in);
	method+notify_val+notify_inst upd_clamp = "DVclamp_cell_update";
}; 

module DVfilter_1d {		/* filters 1 D data with kernels */
	Node_Data+Iparam  &in {		/* input field */
		nnodes+req;
	};
	float+Iparam  kernels[];	/* neighbours weights */
	Node_Data+Oparam  out;		/* output field */
	method+notify_val+notify_inst upd_filetr_1d<status=1> = "DVfilter_1d_update";
}; 

module DVleast_squares {		/* fits polynomial */
	Grid+Node_Data+Iparam  &in {		/* input field */
		nspace=1;
		nnodes+req;
		nnode_data=1;
	};
	int+Iparam    order;    /* order of polynom */
	Node_Data+write+nonotify  out_nd;
	Grid+Node_Data+nonotify+OPort2 &out => merge(out_nd, in); 
	double+Oparam  coeff[order+1];	/* polynomial coefficient */
	method+notify_val+notify_inst upd_least_squares<status=1> = "DVleast_squares_update";
}; 

module DVedges {	/* extract all edges from a field */

	Mesh+read+IPort2  &in { 		/* input field */
		xform+nonotify;
	};
	Cells+Oparam out_cells {
		*cell_set[];
		ncell_sets => array_size(cell_set);
	};
	Cells+write+nonotify out_sets;

	Mesh+OPort2+nonotify &out =>merge(out_cells, in);
	method+notify_val+notify_inst edges_update<status=1> = "DVedges_update";
}; 

module DVext_face {	/* extract external faces from a field */

	Mesh+read+IPort2  &in { 		/* input field */
		xform+nonotify;
	};
	Cells+Oparam out_cells {
		*cell_set[];
		ncell_sets => array_size(cell_set);
	};
	Cells+Cell_Data+write+nonotify out_sets;

	Mesh+OPort2+nonotify &out =>merge(out_cells, in);
	method+notify_val+notify_inst external_face_update<status=1> = "DVext_face_update";
}; 

module DVext_edge {	/* extract external edges from a field */
	Mesh+Node_Data_Opt+read+IPort2 &in {		/* input field */
		xform+nonotify;
	};
	float+Iparam  angle;		/* mamximum face amgle */
	Mesh+Node_Data+nonotify out_field {
		&xform+nowrite => in.xform;
	};
	// This is set up this way so that the 'write' flag is not set
	// on objects that will be connected to the input field.
	group+Oparam &out {
		int ncell_sets;
	} => out_field;
	method+notify_val+notify_inst exernal_edge_update<status=1> = "DVext_edge_update";
}; 

module DVbounds {
	Mesh_Struct+Iparam &in {
		ndim+req;
		dims+req;
		xform+nonotify;
	};
	int+Iparam  hull;
	int+Iparam  edges;
	int+Iparam  faces;
	int+Iparam  imin;
	int+Iparam  imax;
	int+Iparam  jmin;
	int+Iparam  jmax;
	int+Iparam  kmin;
	int+Iparam  kmax;
	int+Iparam  data;
	int+notify+IPort2  component;
	Mesh+Node_Data+Oparam  out {
		&xform+nowrite => in.xform;
	};				/* output field */
	method+notify_val+notify_inst upd_bounds<status=1> = "DVbounds_update";
}; 

module DVaxis {
	Mesh+Iparam &in {
		nnodes+req;
	};
	string+Iparam+opt axis_name;
	string+Iparam+opt axis_labels[];
	float+req+Iparam limits[2];
	float+req+Iparam reference;
	float+req+Iparam tick_step;
	float+req+Iparam tick_y_below;
	float+req+Iparam tick_y_above;
	float+req+Iparam tick_z_below;
	float+req+Iparam tick_z_above;
	int+req+Iparam minor_ticks;
	float+req+Iparam minor_scale;
	int+req+Iparam ndig;
	float+req+Iparam y_anno;
	float+req+Iparam z_anno;

	int+write+nonotify  ntick;
	string+write+nonotify labels[ntick];
	float+write+nonotify  xyz[ntick*3];

	string+write+nonotify name;
	float+write+nonotify  name_xyz[3];

	Mesh+Oparam  out;
	Mesh+Oparam  out_minor {
		&xform => <-.out.xform;
	};
	TextField+OPort2+nonotify out_anno {
		nspace=3;
		nnodes => <-.ntick;
		text_values => <-.labels;
		coordinates {
			&values+nres => <-.<-.xyz;
		};
		&xform => <-.out.xform;
	};
	TextField+OPort2+nonotify  out_name {
		nspace=3;
		nnodes => 1;
		text_values => <-.name;
		coordinates {
			&values+nres => <-.<-.name_xyz;
		};
		&xform => <-.out.xform;
	};

	method+notify_val+notify_inst upd_axis<status=1> = "DVaxis_update";
}; 

module DVexplode_materials {
	Mesh+Iparam  &in {
		nnodes+req;
		xform+nonotify;
	};
	int+Iparam  property;
	int+Oparam  nfld;
	Cells+write+nonotify out_sets[nfld] {
		*cell_set[];
		ncell_sets => array_size(cell_set);
	};
	group out_mrgs[nfld] {
		int+nres arr_ind => index_of(out_mrgs);
		Mesh+Node_Data+Cell_Data+nres &out_flds => merge(out_sets[arr_ind],in);
	};
	mlink+nonotify+OPort2 out => out_mrgs.out_flds;

	method+notify_val+notify_inst upd_explode_mat<status=1> = "DVexplode_mat_update";
};

module DVexplode_xform {
	Mesh+Iparam  &in[] {
		nnodes+req;
	};
	float+Iparam  x_factor;
	float+Iparam  y_factor;
	float+Iparam  z_factor;
	group+write+nonotify out[array_size(in)] {
		DefaultXform xform;
	};
	group+nonotify out_field_mrg[array_size(in)] {
		int+nres arr_ind => index_of(out_field_mrg);
		Mesh+nres &out_fld => merge(out[arr_ind],in[arr_ind]);
	};
	mlink+nonotify+OPort2 out_flds => out_field_mrg.out_fld;

	method+notify_val+notify_inst upd_xform_mat<status=1> = "DVexplode_xform_update";
};


module DVcompute_extent {
	Mesh+Iparam  &in {
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	group+write+nonotify tmp_coord {
		float min_vec[];
		float max_vec[];
	};

	group+nonotify out_coord {
		Data_Array+nonotify  &coordinates => merge(tmp_coord, in.coordinates);
	};

	Mesh+OPort2+nonotify &out => merge(out_coord, in);

	method+notify_val+notify_inst upd_compute_extent<status=1> = "DVcompute_extent_update";
};

module DVmesh_extent {
	Grid+Iparam  &in {
		nnodes+req;
	};
	float+Oparam min_ext[3];
	float+Oparam max_ext[3];
	float+Oparam extent;
	method+notify_val+notify_inst upd_compute_extent = "DVmesh_extent_update";
};

module DVstream {		/* integrates velocity field (sroduces streamlines) */
	Mesh+Node_Data+Iparam  &in {	/* input field */
		nnodes+req;
		nspace+req;
		nnode_data+req;
	};
	Grid+Xform+Iparam   &probe {		/* where the streamlines originate */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam    order;		/* order of integration */
	int+Iparam    forw_back;		/* toggle to generate lines forward */
	int+Iparam    nseg;
	float+Iparam  min_vel;
	int+Iparam    max_seg;
	int+Iparam    stream_comp;
	int+Iparam    ribbons;
	float+notify    rib_width;
	float+notify    rib_angle;
	Mesh+Node_Data+Oparam out {
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst stream_update<status=1> = "DVstream_update";
}; 

module DVstream_multi_block {		/* integrates velocity field (sroduces streamlines) */
	Multi_Block+Iparam  &in {	/* input field */
		nblocks+req;
	};
	Grid+Xform+Iparam   &probe {		/* where the streamlines originate */
		nnodes+req;
		coordinates+req;
		coordinates.values+req;
	};
	int+Iparam    order;		/* order of integration */
	int+Iparam    forw_back;		/* toggle to generate lines forward */
	int+Iparam    nseg;
	float+Iparam  min_vel;
	int+Iparam    max_seg;
	int+Iparam    stream_comp;
	int+Iparam    ribbons;
	float+notify    rib_width;
	float+notify    rib_angle;
	Mesh+Node_Data+Oparam out;
	method+notify_val+notify_inst stream_multi_block<status=1> = "DVstream_multi_block_update";
}; 

module DVadvect {		/* releases particles into a velocity field */
	Mesh+Node_Data+Iparam  &in {	/* input field */
		nnodes+req;
		xform+nonotify;
	};
	float+Iparam  time;		/* time  */
	int+Iparam    direction;	/* direction of integration */
	float+read+notify+opt+IPort2  start_time;	/* start time for release */
	float+read+notify+opt+IPort2  release_interval;	/* release time interval */
	Mesh+Node_Data+Oparam out {	/* output field */
		&xform+nowrite => in.xform;
	};
	omethod+notify_val+notify_inst upd_advect = "DVadvect_update";
}; 

module DVintegr_vol {	/* determine volume and mass of a field */
	Mesh+Iparam  &in {		/* input field */
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam    component=0;
	int+Iparam    dim;
	float+Oparam  volume;		/* volume of field */
	float+Oparam  mass;		/* mass of field */
	method+notify_val+notify_inst upd_integr_vol<status=1> = "DVintegr_vol_update";
}; 

module DVprobe {		/* interactively shows numeric data values */
	group+notify+IPort2  *picked_fld;
	Mesh+nonotify+IPort2  &probe_fld;

	float+notify+Iparam    &picked_xyz[3];
	GDxform_templ+Iparam  &picked_xform;
	DefaultXform+Port2   probe_xform;

	float+Oparam out_xyz[3];
	method+notify_val+notify_inst upd_probe<status=1> = "DVprobe_update";
}; 

module DVcreate_line {		/* creates polyline */
	float+Iparam    &picked_xyz[3];
	GDxform_templ+Iparam  &picked_xform;
	int+Iparam   pick=1;
	int+IOparam  new=0;
	int+nonotify new_cell=0;
	Mesh+Node_Data+Oparam out {
		nnodes = 0;
		nspace = 3;
		ncell_sets = 1;
		Polyline cell_set; 
	};
	method+notify_val+notify_inst upd_create_line<status=1> = "DVcreate_line_update";
}; 

module DVset_null {
	Node_Data+IOparam &in {
		nnodes+req;
	};
	int+Iparam   component;
	int+Iparam   unset;
	float+Iparam null_value;
	Node_Data+Oparam out;
	method+notify_val+notify_inst upd_set_null<status=1> = "DVset_null_update";
};

module DVset_slice_data {
	Mesh_Unif+Node_Data+Port2+nonotify &inField;
	Mesh_Unif+Node_Data+Iparam &sliceField;
	int+Iparam slice;
	method+notify_val update<status=1> = "DVset_slice_data_update";
};

// Formerly called DVcopy_mesh in Express versions prior to 6.0.
// Copies cells and cell data.  Does not copy node data.
// Output is always unstructured even if input is Struct/Rect/Unif.
// A further quirk is that the output does not have a transform, thus
// the output cannot be connected directly to a GD DataObject.
module DVcopy_cells {
        Grid+Cells+IPort2 &inMesh;
        int+IPort2 trigger;
        Grid+Cells+Data+Oparam outMesh;
        method+notify_val update<status=1> = "DVcopy_cells_update";
};

module DVcopy_field {
    Mesh+Node_Data_Opt+Cell_Data_Opt+IPort2 &inFld;
    int+IPort2 trigger;
    // Customize by making this output type more specific,
    // adding Mesh_Struct, Data, Cell_Data, Node_data, etc.
    Mesh+Oparam &outFld;
    omethod+notify_val update<status=1> = "DVcopy_field_update";
};

// Keep this in sync (same variable names, etc.) with DVcopy_field,
// because they share the same update method.
module DVcopy_mesh {
    Mesh+IPort2 &inFld;
    int+IPort2 trigger;
    boolean mesh_only = 1;
    // Customize by making this output type more specific,
    // adding Mesh_Struct, etc.
    Mesh+Oparam &outFld;
    omethod+notify_val update<status=1> = "DVcopy_field_update";
};

module DVexcavate_brick3d {
	Mesh_Unif+Dim3+Node_Data+Iparam  &in {	/* uniform input field */
		xform+nonotify;
		ndim+req;
	};
	int+Iparam x;
	int+Iparam y;
	int+Iparam z;
	int+Iparam flip_x;
	int+Iparam flip_y;
	int+Iparam flip_z;
	int+Iparam draw_sides;
	Mesh+Node_Data+Oparam out {	/* output field */
		&xform+nowrite => in.xform;
	};
	method+notify_val+notify_inst upd_excavate_brick3d<status=1> = "DVexcavate_brick3d_update";
};

module DVnode_data_labels {
	group+Iparam   &in{
		group+opt node_data {
			string+opt labels;
		};
	};
	string+Oparam  labels[];
	int+OPort2+nonotify ncomp =>array_size(labels);
	method+notify_val+notify_inst upd_node_data_labels<weight=0> = "DVnode_data_labels_update";
}; 

module DVcell_data_labels {
	group+Iparam   &in{
		group+opt cell_set {
			group+opt cell_data {
				string+opt labels;
			};
		};
	};
	string+Oparam  labels[];
	int+OPort2+nonotify ncomp =>array_size(labels);
	double+Oparam min_data[ncomp];
	double+Oparam max_data[ncomp];
	method+notify_val+notify_inst upd_cell_data_labels<weight=0> = "DVcell_data_labels_update";
}; 

module DVcell_labels {
	group+Iparam   &in{
		group+opt cell_set {
			string+opt cell_name;
			string+opt name;
		};
	};
	string+Oparam  labels[];
	int+OPort2+nonotify nsets =>array_size(labels);
	method+notify_val+notify_inst upd_cell_labels<weight=0> = "DVcell_labels_update";
}; 

module DVselect_cells {
	Mesh+Cell_Data_Opt+read+IPort2  &in {
		xform+opt+nonotify;
	};
	int+Iparam sets[];
	Cells+Oparam out_cells {
		*cell_set[];
		ncell_sets => array_size(cell_set);
	};
	Mesh+nonotify+OPort2 &out =>merge(out_cells, in);
	method+notify_val+notify_inst upd_select_cells<status=1> = "DVselect_cells_update";
};

module DVextr_cell_comp {
	Mesh+Cell_Data+Iparam  &in {
		xform+nonotify;
	};
	int+IPort2+nonotify comp;
	int+nres+nonotify  dim => in.ncell_sets;
	group+nonotify out_data[dim] {
		int+nres ncells => in.cell_set[index_of(out_data)].ncells;
		int ncell_data=1;
		group+nres &cell_data => {in.cell_set[index_of(out_data)].cell_data[comp]};
	};
	group+nonotify out_sets[dim] {
		group+nres &out_set => merge(out_data[index_of(out_sets)],
				    in.cell_set[index_of(out_sets)]);
	};
	Cells+Cell_Data+nonotify+write   out_cd {
		*cell_set[];
		ncell_sets => array_size(cell_set);
/*
		group &cell_set[ncell_sets] => {out_sets[0].out_set, ..., ...};
*/
	};
	Mesh+OPort2+nonotify &out =>merge(out_cd, in);
	method+notify_val+notify_inst upd_extr_cell_comp<status=1> = "DVextr_cell_comp_update";
};

module DVcell_to_node {
	Mesh+Cell_Data+Iparam  &in {
		xform+nonotify;
	};
	int+Iparam comps[];
	int+Iparam order;
	Node_Data+Oparam out_nd {
		nnodes+nowrite => in.nnodes;
		node_data.nvals+nowrite;
	};
	Mesh+Node_Data+OPort2+nonotify &out => merge(out_nd,in);
	method+notify_val+notify_inst upd_cell_to_node<status=1> = "DVcell_to_node_update";
};

/* read an AVS volume (.dat) file and output an Express field */
module DVread_vol {
	string+Iparam filename;		/* .dat file */
	Mesh_Unif+Dim3+Space3+Node_Data+Scalar+Byte+Oparam out;	/* output field */
	method+notify_val+notify_inst upd_read_vol<status=1> = "DVread_vol_update";
}; 

module DVextract_comp {
   int+IPort2 component = 0;
   Mesh+Node_Data+IPort2 &in;
   Node_Data out_nd {
      nnodes => switch((in.nnodes>0)+1, 0, in.nnodes);
      nnode_data => switch((component<in.nnode_data)+1, 0, 1);
      &node_data+nres => {switch(component<in.nnode_data,
                                 in.node_data[component])};
   };
   Mesh+Node_Data+OPort2 &out => merge(out_nd,in);
};


module DVcomb_comp {
	Node_Data+Iparam &nd1 {
		nnodes+req;
	};
	Node_Data+Iparam &nd2 {
		nnodes+req;
	};
	int+Iparam comp1[];
	int+Iparam comp2[];
		Node_Data+Oparam out {
		nnodes+nowrite => nd1.nnodes;
		node_data.nvals+nowrite;
		// we are only modifying the pointer value of node_data
		// the '*' here prevents us from getting dependencies on
		// the upstream guys.
		*node_data[];
		nnode_data => array_size(node_data);
	};
	method+notify_val+notify_inst upd_comb_comp<status=1> = "DVcomb_comp_update";
};

module DVextract_mesh {
	Mesh+IPort2 &in;
	Node_Data out_nd {
		nnodes => <-.in.nnodes;
		nnode_data = 0;
	};
	Mesh+Node_Data+OPort2 &out=>merge(out_nd, in);
};

module DVaverage_coord {
	Mesh+Node_Data+IPort2 &in1;
	Mesh+Node_Data+IPort2 &in2;
	float+IPort2 t=0.5;
	Grid+Xform out_grid {
		nnodes => in1.nnodes;
		nspace => in1.nspace;
		&xform => in1.xform;
		long   npoints => nnodes;
		float points[nnodes][nspace];
		coordinates {
			values+nres => (1-t)*in1.coordinates.values + t*in2.coordinates.values;
		};
	};
	Mesh+Node_Data+OPort2 &out => merge(out_grid, in1);
};

module DVmagnitude {
	int+IPort2 component = 0;
	Mesh+Node_Data+IPort2 &in;
	Node_Data out_nd {
		nnodes => in.nnodes;
		nnode_data = 1;
		node_data {
			veclen+nres = 1;
			values+nres => cache(magnitude(in.node_data[component].values));
			null_flag+nres => in.node_data[component].null_flag;
			null_value+nres => in.node_data[component].null_value;
			&min => in.node_data[component].min;
			&max => in.node_data[component].max;
			labels+nres = "magnitude_update";
		};
	};
	Mesh+Node_Data+OPort2 &out => merge(out_nd,in);
};

module DVsurf_plot {
	Mesh+Node_Data+Port2 &in;
	int+IPort2    component;
	float+IPort2  scale;
	float+IPort2  offset;
	int+IPort2    nspace;
	Grid+Xform out_grid {
		nnodes => in.nnodes;
		nspace+nres => <-.nspace+in.node_data[component].veclen;
		&xform => in.xform;
		// If the input field is Unif or Rect, the output is a Struct
		// field.  Clearing the following variables makes sure that the
		// out field isn't accidently interpreted as a Unif or Rect.
		long   npoints;
		float points[npoints][nspace];
                int grid_type;
		coordinates {
			values+nres => combine_array(in.coordinates.values[][0:<-.<-.nspace-1], 
				 offset+scale*in.node_data[component].values);
		};
	};
	Mesh+Node_Data+OPort2 &out => merge(out_grid, in);
};

module DVoffset {
	Mesh+Node_Data+IPort2 &in;
	int+IPort2    component;
	float+IPort2  scale;
	Grid+Xform out_grid {
		nnodes => in.nnodes;
		nspace => in.nspace;
		&xform => in.xform;
		long   npoints => nnodes;
		float points[nnodes][nspace];
		coordinates {
			values+nres => in.coordinates.values +
				 scale*in.node_data[component].values;
		};
	};
	Mesh+Node_Data+OPort2 &out => merge(out_grid, in);
};

module DVset_xform {
	Mesh+IPort2 &in;
	group+IPort2 &in_xfm {
		GDxform_templ &xform;
	};
	group set_xform {
		GDxform_templ &xform => in_xfm.xform;
	};
	Mesh+OPort2 &out => merge(set_xform, in);
};

module DVconcat_xform {
	GDxform_templ+Iparam &xform_in1;
	GDxform_templ+Iparam &xform_in2;
	DefaultXform+Oparam xform_out;
	method+notify_val+notify_inst upd_concat_xform = "DVconcat_xform_update";
}; 

module DVinvert_xform {
	GDxform_templ+Iparam &xform_in;
	DefaultXform+Oparam xform_out;
	method+notify_val+notify_inst upd_invert_xform = "DVinvert_xform_update";
}; 

module DVcopy_xform {
	GDxform_templ+Iparam &xform_in;
	GDxform_templ+Oparam xform_out;
	omethod+notify_val+notify_inst upd_copy_xform = "DVcopy_xform_update";
}; 

module DVrotate_xform {
	int+Iparam axis;
	float+Iparam center[3];
	float+Iparam angle;
	DefaultXform+Oparam xform_out;
	omethod+notify_val+notify_inst upd_rotate_xform = "DVrotate_xform_update";
};

module DVxform_3points {
	float+Iparam point0[];
	float+Iparam point1[];
	float+Iparam point2[];
	int+Iparam+opt origin_point;
	int+Iparam+opt flip;
	DefaultXform+Oparam xform_out;
	method+notify_val+notify_inst upd_xform_3points = "DVxform_3points_update";
}; 

module DVxform_coord {
	Mesh+Iparam &in {
		nnodes+req;
		nspace+req;
	};
	int+Iparam comp[];
	int+write coord_nspace;
	float+Oparam coord[in.nnodes][coord_nspace];
	method+notify_val+notify_inst upd_xform_coord = "DVxform_coord_update";
};

module DVnormalize {
         Mesh+IPort2 &in;
         float+IPort2 size=4;
         float xmin => in.coordinates.min_vec[0];
         float xmax => in.coordinates.max_vec[0];
         float ymin => in.coordinates.min_vec[1];
         float ymax => in.coordinates.max_vec[1];
         float zmin => in.coordinates.min_vec[2];
         float zmax => in.coordinates.max_vec[2];
         float xscale => 1.0 / (xmax - xmin);
         float yscale => 1.0 / (ymax - ymin);
         float zscale => 1.0 / (zmax - zmin);
         float scale => size * (0.33 * (xscale + yscale + zscale));
         float xcent => 0.5 * (xmin+xmax);
         float ycent => 0.5 * (ymin+ymax);
         float zcent => 0.5 * (zmin+zmax);
         float local_xlate[3]  => {-scale*xcent, -scale*ycent, -scale*zcent};
         float local_center[3] => {xcent,  ycent,  zcent};

        DefaultXform xform {
            mat => {{scale,0,0,0},
                    {0,scale,0,0},
                    {0,0,scale,0},
                    {0,0,0,1}};
            xlate  => local_xlate;
            center => local_center;
        };
	group set_xform {
		GDxform_templ &xform => <-.xform;
	};
	Mesh+OPort2 &out => merge( set_xform, in);
};

module DVconcat_xform_field {
	Mesh+IPort2 &in ;
	group+IPort2 &in_xform {
		GDxform_templ &xform;
	};
	group+Oparam  out_xform {
		DefaultXform xform;
	};
	DVconcat_xform DVconcat_xform {
		xform_in1 => in.xform;
		xform_in2 => in_xform.xform;
		&xform_out => out_xform.xform; 
	};
	Mesh+OPort2 &out => merge(out_xform, in);
};

module DVinvert_xform_field {
	Mesh+IPort2 &in ;

	group+Oparam  out_xform {
		DefaultXform xform;
	};
	DVinvert_xform DVinvert_xform {
		xform_in => in.xform;
		&xform_out => out_xform.xform; 
	};
	Mesh+OPort2 &out => merge(out_xform, in);
};

module DVcopy_xform_field {
	Mesh+IPort2 &in ;

	group+Oparam  out_xform {
		GDxform_templ xform;
	};
	DVcopy_xform DVcopy_xform {
		xform_in => in.xform;
		&xform_out => out_xform.xform; 
	};
	Mesh+OPort2 &out => merge(out_xform, in);
};

module DVxform_to_plane {
	Mesh+IPort2 &in;
	Plane_Mesh+Iparam  &plane {
		points+req;
	};
	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	DVcopy_xform_field DVcopy_xform_plane {
		in => <-.plane;
	};
	DVinvert_xform_field DVinvert_xform_field {
		in => DVcopy_xform_plane.out;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVcopy_xform_field.out;
		in_xform => DVinvert_xform_field.out;
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};


module DVrotate_mesh {
	Mesh+IPort2 &in;
	float+Iparam  center[3];
	int+Iparam  axis;
	float+Iparam  angle;

	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	group+Oparam  rotate_xform {
		DefaultXform xform;
	};
	DVrotate_xform DVrotate_xform {
		axis => <-.axis;
		center => <-.center;
		angle => <-.angle;
		&xform_out => <-.rotate_xform.xform;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVcopy_xform_field.out;
		in_xform => <-.rotate_xform; 
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};

module DVmirror {
	Mesh+IPort2 &in;
	float+Iparam  mir_x = -1.0;
	float+Iparam  mir_y = -1.0;
	float+Iparam  mir_z = -1.0;
	group mirr {
		DefaultXform+nonotify  xform {
		mat => {{mir_x, 0.0, 0.0, 0.0},
		       {0.0, mir_y, 0.0, 0.0},
		       {0.0, 0.0, mir_z, 0.0},
		       {0.0, 0.0, 0.0, 1.0}};
		xlate = {0.0, 0.0, 0.0};
		center = {0.0, 0.0, 0.0};
		};
	};
	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVcopy_xform_field.out;
		in_xform => mirr;
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};

module DVscale {
	Mesh+IPort2 &in ;
	float+Iparam  scale_x = 1.0;
	float+Iparam  scale_y = 1.0;
	float+Iparam  scale_z = 1.0;
	group scale {
		DefaultXform+nonotify  xform {
		mat => {{scale_x, 0.0, 0.0, 0.0},
		       {0.0, scale_y, 0.0, 0.0},
		       {0.0, 0.0, scale_z, 0.0},
		       {0.0, 0.0, 0.0, 1.0}};
		xlate = {0.0, 0.0, 0.0};
		center = {0.0, 0.0, 0.0};
		};
	};
	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVcopy_xform_field.out;
		in_xform => scale;
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};

module DVproject {
	Mesh+IPort2 &in;
	int+Iparam  plane;  /* 0-xy, 1-yz, 2-zx */
	float scale[3][3] = {{1,1,0},{0,1,1},{1,0,1}};
	group proj {
		DefaultXform+nonotify  xform {
		mat =>{{scale[plane][0], 0.0, 0.0, 0.0},
		       {0.0, scale[plane][1], 0.0, 0.0},
		       {0.0, 0.0, scale[plane][2], 0.0},
		       {0.0, 0.0, 0.0, 1.0}};
		xlate = {0.0, 0.0, 0.0};
		center = {0.0, 0.0, 0.0};
		};
	};
	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVcopy_xform_field.out;
		in_xform => proj;
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};

module DVproject_to_plane {
	Mesh+IPort2 &in;
	Plane_Mesh+IPort2  &plane {
		points+req;
	};

	DVcopy_xform_field DVcopy_xform_field {
		in => <-.in;
	};
	DVcopy_xform_field DVcopy_xform_field#1 {
		in => <-.plane;
	};

	DVinvert_xform_field DVinvert_xform_field {
		in => <-.DVcopy_xform_field#1.out;
	};
	DVconcat_xform_field DVconcat_xform_field#1 {
		in => <-.DVcopy_xform_field.out;
		in_xform => <-.DVinvert_xform_field.out;
	};

	DVproject DVproject {
		in => <-.DVconcat_xform_field#1.out;
		plane = 0;
	};
	DVconcat_xform_field DVconcat_xform_field {
		in => <-.DVproject.out;
		in_xform => <-.DVcopy_xform_field#1.out;
	};
	Mesh+OPort2 &out => DVconcat_xform_field.out;
	olink user_xform => DVcopy_xform_field.out.xform;
};

module DVcombine_rgb {
	Mesh_Unif+Dim2+Byte+Space2+Node_Data+Iparam &in1;
	Mesh_Unif+Dim2+Byte+Space2+Node_Data+Iparam &in2;
	Mesh_Unif+Dim2+Byte+Space2+Node_Data+Iparam &in3;

	Node_Data+Byte out_nd {
		nnodes => in1.nnodes;
		nnode_data = 1;
		node_data {
			veclen = 3;
			id = 669;
			values+nres => cache(combine_array(in1.node_data[0].values,
						in2.node_data[0].values,
						in3.node_data[0].values));
		};
	};

	Mesh_Unif+Dim2+Byte+Space2+Node_Data+OPort2 &out => merge(out_nd, in1, in2, in3);
};

module DVcompute_uv {
	Mesh+IPort2 &in;

	float u_values[in.nnodes][1] => (in.coordinates.values[][0] - in.coordinates.min_vec[0]) / 
					(in.coordinates.max_vec[0] - in.coordinates.min_vec[0]);
	float v_values[in.nnodes][1] => (in.coordinates.values[][1] - in.coordinates.min_vec[1]) / 
					(in.coordinates.max_vec[1] - in.coordinates.min_vec[1]);
	Node_Data+OPort2  out {
		nnodes => <-.in.nnodes;
		nnode_data = 1;
		node_data {
			veclen = 2;
			id = 670;
			values => cache(combine_array(u_values, v_values));
		};
	};
};

module DVmesh_uv {
	Mesh+IPort2 &in;
	int+IPort2  uv_switch = 0;
	int+IPort2  u_flip = 0;
	int+IPort2  v_flip = 0;
	float+IPort2 u_shift = 0; 
	float+IPort2 v_shift = 0; 
	float+IPort2 u_scale = 1; 
	float+IPort2 v_scale = 1; 

	group u0 {
	float values[in.nnodes][1] => u_shift + u_scale*((in.coordinates.values[][0] - 
					in.coordinates.min_vec[0]) / 
					(in.coordinates.max_vec[0] - in.coordinates.min_vec[0]));
	};
	group v0 {
	float values[in.nnodes][1] => v_shift + v_scale*((in.coordinates.values[][1] - 
					in.coordinates.min_vec[1]) / 
					(in.coordinates.max_vec[1] - in.coordinates.min_vec[1]));
	};
	group u1 {
	float values[in.nnodes][1] => u_shift + u_scale*((in.coordinates.max_vec[0] -
					in.coordinates.values[][0]) /
					(in.coordinates.max_vec[0] - in.coordinates.min_vec[0]));
	};
	group v1 {
	float values[in.nnodes][1] => v_shift + v_scale*((in.coordinates.max_vec[1] -
					in.coordinates.values[][1]) /
					(in.coordinates.max_vec[1] - in.coordinates.min_vec[1]));
	};

	DVswitch  switch_u {
		in => {u0, u1};
		index =>u_flip;
	};
	DVswitch  switch_v {
		in => {v0, v1};
		index =>v_flip;
	};

	DVswitch  switch_uv {
		in => {switch_u.out, switch_v.out};
		index =>uv_switch;
	};
	DVswitch  switch_vu {
		in => {switch_v.out, switch_u.out};
		index =>uv_switch;
	};

	Node_Data uv_data {
		nnodes => <-.in.nnodes;
		nnode_data = 1;
		node_data {
			veclen = 2;
			id = 670;
			values => combine_array(switch_uv.out.values,switch_vu.out.values);
		};
	};

	Mesh+Node_Data+OPort2 &out => merge(uv_data, in);
};

module DVorthoslice_struct {
	Mesh_Struct+Node_Data+Iparam &in {
	   nnodes+req;
	   nnode_data+opt;
	   node_data+opt;
	};
	int+Iparam axis;
	int+Iparam plane;
	Mesh_Struct+Node_Data+Oparam out;
        method+notify_val+notify_inst upd_orthoslice<status=1> = "DVorthoslice_update";
}; 

module DVorthoslice_unif {
	Mesh_Unif+Node_Data+Iparam &in {
	   nnodes+req;
	   nnode_data+opt;
	   node_data+opt;
	};
	int+Iparam axis;
	int+Iparam plane;
	Mesh_Unif+Node_Data+Oparam out;
        method+notify_val+notify_inst upd_orthoslice<status=1> = "DVorthoslice_unif_update";
}; 

module DVorthoslice_rect {
	Mesh_Rect+Node_Data+Iparam &in {
	   nnodes+req;
	   nnode_data+opt;
	   node_data+opt;
	};
	int+Iparam axis;
	int+Iparam plane;
	Mesh_Rect+Node_Data+Oparam out;
        method+notify_val+notify_inst upd_orthoslice<status=1> = "DVorthoslice_rect_update";
}; 

macro DVorthoslice {
	Mesh_Struct+Node_Data+Iparam &in {
	   nnodes+req;
	};
	int+Iparam axis;
	int+Iparam plane;

	DVorthoslice_struct DVorthoslice_struct {
		in => <-.DVfld_match.links.link2;
		&axis => <-.axis;
		&plane => <-.plane;
	};
	DVorthoslice_unif DVorthoslice_unif {
		in => <-.DVfld_match.links.link0;
		&axis => <-.axis;
		&plane => <-.plane;
	};
	DVorthoslice_rect DVorthoslice_rect {
		in => <-.DVfld_match.links.link1;
		&axis => <-.axis;
		&plane => <-.plane;
	};

	DVfld_match DVfld_match {
		Mesh_Struct+IPort2 &in=> <-.in;
	};

	DVswitch DVswitch {
		in => {DVorthoslice_unif.out, DVorthoslice_rect.out, DVorthoslice_struct.out};
		index => DVfld_match.index;
	};
	olink out => DVswitch.out;
}; 


module DVdownsize_struct {
	Mesh_Struct+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	float+Iparam factor[in.ndim];
	Mesh_Struct+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_downsize<status=1> = "DVdownsize_update";
}; 

module DVdownsize_unif {
	Mesh_Unif+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	float+Iparam factor[in.ndim];
	Mesh_Unif+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_downsize<status=1> = "DVdownsize_unif_update";
}; 

module DVdownsize_rect {
	Mesh_Rect+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	float+Iparam factor[in.ndim];
	Mesh_Rect+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_downsize<status=1> = "DVdownsize_rect_update";
}; 

macro DVdownsize {
	Mesh_Struct+Node_Data+Iparam &in {
	   nnodes+req;
	};

	float+Iparam factor[in.ndim];

	DVdownsize_struct DVdownsize_struct {
		in => <-.DVfld_match.links.link2;
		&factor => <-.factor;
	};
	DVdownsize_unif DVdownsize_unif {
		in => <-.DVfld_match.links.link0;
		&factor => <-.factor;
	};
	DVdownsize_rect DVdownsize_rect {
		in => <-.DVfld_match.links.link1;
		&factor => <-.factor;
	};

	DVfld_match DVfld_match {
		Mesh_Struct+IPort2 &in=> <-.in;
	};

	DVswitch DVswitch {
		in => {DVdownsize_unif.out, DVdownsize_rect.out, DVdownsize_struct.out};
		index => DVfld_match.index;
	};
	olink out => DVswitch.out;
}; 

module DVcrop_struct {
	Mesh_Struct+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam min[in.ndim];
	int+Iparam max[in.ndim];
	Mesh_Struct+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_crop<status=1> = "DVcrop_update";
};

module DVcrop_unif {
	Mesh_Unif+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam min[in.ndim];
	int+Iparam max[in.ndim];
	Mesh_Unif+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_crop<status=1> = "DVcrop_unif_update";
}; 

module DVcrop_rect {
	Mesh_Rect+Node_Data+Iparam &in {
		xform+nonotify;
		nnodes+req;
	};
	int+Iparam min[in.ndim];
	int+Iparam max[in.ndim];
	Mesh_Rect+Node_Data+Oparam out{
		&xform+nowrite => in.xform;
	};
        method+notify_val+notify_inst upd_crop<status=1> = "DVcrop_rect_update";
}; 

macro DVcrop {
	Mesh_Struct+Node_Data+Iparam &in {
	   nnodes+req;
	};
	int+Iparam min[in.ndim];
	int+Iparam max[in.ndim];

	DVcrop_struct DVcrop_struct {
		in => <-.DVfld_match.links.link2;
		&min => <-.min;
		&max => <-.max;
	};
	DVcrop_unif DVcrop_unif {
		in => <-.DVfld_match.links.link0;
		&min => <-.min;
		&max => <-.max;
	};
	DVcrop_rect DVcrop_rect {
		in => <-.DVfld_match.links.link1;
		&min => <-.min;
		&max => <-.max;
	};

	DVfld_match DVfld_match {
		Mesh_Struct+IPort2 &in=> <-.in;
	};

	DVswitch DVswitch {
		in => {DVcrop_unif.out, DVcrop_rect.out, DVcrop_struct.out};
		index => DVfld_match.index;
	};
	olink out => DVswitch.out;
}; 

module DVload_script {
   int+Iparam trigger;
   string+IPort2+nonotify filename;
   group+nonotify *dst;
   method+notify_val+notify_inst update<status=1> = "DVload_script_update";
};

module DVpoint_mesh {
	prim+IPort2 &in[][];

	int in_dims[2] => array_dims(in);

	Mesh+OPort2  out {
		nnodes => <-.in_dims[1];
		nspace => <-.in_dims[0];
		coordinates.values => in;
		ncell_sets = 1;
		Point cell_set {
			ncells=> <-.nnodes;
			node_connect_list => init_array(ncells, 0, ncells-1);
		};
	};
};

module DVunif_field {
	ilink  in;

	long in_dims[] => array_dims(in);
	int init0[] => init_array(array_size(in_dims),0,0);
	Mesh_Unif+Node_Data+OPort2 out {
		ndim => array_size(in_dims);
		dims => <-.in_dims;
		nspace => ndim;
		points => {<-.init0, dims-1};
		nnode_data = 1;
		node_data {
			veclen = 1;
			values => in;
		};
	};
};

module DVunstruct_mesh {
	prim+IPort2 &coord[][];
	long+IPort2 &connect[][];
	int+IPort2 cell_ndim;

	long coord_dims[2] => array_dims(coord);
	long connect_dims[2] => array_dims(connect);

	Mesh+OPort2  out {
		nnodes => <-.coord_dims[1];
		nspace => <-.coord_dims[0];
		coordinates.values => <-.<-.coord;
		ncell_sets = 1;
		cell_set {
			cell_ndim => <-.<-.cell_ndim;
			cell_order = 1;
			poly_flag = 0;
			cell_nnodes=> connect_dims[0];
			ncells => connect_dims[1];
			node_connect_list => <-.<-.connect;
		};
	};
};

DVunstruct_mesh DVunstruct_mesh1D {
	int cell_ndim =1;
};

DVunstruct_mesh DVunstruct_mesh2D {
	int cell_ndim =2;
};

module DVnode_scalar {
	prim+IPort2 &in[];

	Node_Data+OPort2 out {
		nnodes => array_size(<-.in);
		nnode_data = 1;
		node_data {
			veclen = 1;
			values => <-.<-.in;
		};
	};
};

module DVnode_vector {
	prim+IPort2 &in[][];
	long dims[2] => array_dims(in);
	Node_Data+OPort2 out {
		nnodes => <-.dims[1];
		nnode_data = 1;
		node_data {
			veclen => <-.<-.dims[0];
			values => <-.<-.in;
		};
	};
};

module DVcombine_arrays_2 {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];

	int dim=>array_size(in1);

	prim rin1[dim][1] => in1;
	prim rin2[dim][1] => in2;

	prim+OPort2 out[array_size(in1)][2]=>combine_array(rin1,rin2);
};

module DVcombine_arrays_3 {
	prim+IPort2 &in1[];
	prim+IPort2 &in2[];
	prim+IPort2 &in3[];

	int dim=>array_size(in1);

	prim rin1[dim][1] => in1;
	prim rin2[dim][1] => in2;
	prim rin3[dim][1] => in3;

	prim+OPort2 out[array_size(in1)][3]=>combine_array(rin1,rin2,rin3);
};

/**  DB table convert modules **/

group DVtable_xyz {
	int     discrete;
	float   min => cache(min_array(values, null_flag, null_value));
	float   max => cache(max_array(values, null_flag, null_value));
	float   bin_size;
	int	normalize;
	int	set_labels;
	int	label_step;
	int	index_labels;

	prim	values[];
	int     null_flag;
	prim    null_value;
	string  name;
	long    nvals => array_size(values);
};

group DVtable_data {
	int     valid;
	int     count_records;
	int     operation;
	float   min => cache(min_array(values, null_flag, null_value));
	float   max => cache(max_array(values, null_flag, null_value));

	prim	values[];
	int     null_flag;
	prim    null_value;
	string  name;
	int     nvals => array_size(values);
};

group DVtable_xyz_select {
	int  xyz_axis[3];
	int+nonotify  xyz_set[3];
	int  ndim => sum(xyz_set);
};

group DVtable_data_select {
	int  data[];
	int  ndata => array_size(data);
};

module DVtable_xyz_create {
	Data_Array+Iparam           &columns[];
	int+read+write              reset;
	int+Oparam                  ncol;
	string+read+write+nonotify  names[];
	string+Oparam               xyz_names[];
	DVtable_xyz_select+Oparam   xyz_select;
	DVtable_xyz+Oparam          field_xyz[];
	omethod+notify_inst+notify_val  upd_func<val_state=1> = "DVtable_xyz_create_update";
};

module DVtable_data_create {
	Data_Array+Iparam           &columns[];
	int+read+write              reset;
	int+read+write              count_records;
	int+Iparam                  ncol;
	DVtable_data_select+Oparam  data_select;
	string+read+write+nonotify  names[];
	string+Oparam               data_names[];
	DVtable_data+Oparam         field_data[];
	omethod+notify_inst+notify_val  upd_func<val_state=1> = "DVtable_data_create_update";
};

module DVtable_to_unif {
	DVtable_xyz_select+Iparam   &xyz_select;
	DVtable_xyz+Iparam          &field_xyz[];
	DVtable_data_select+Iparam  &data_select;
	DVtable_data+Iparam         &field_data[];
	Mesh_Unif+Node_Data+Oparam  out;
	string+Oparam  x_labels[];
	string+Oparam  y_labels[];
	string+Oparam  z_labels[];
	string+Oparam  x_name;
	string+Oparam  y_name;
	string+Oparam  z_name;
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVtable_to_unif_update";
};

module DVtable_to_scat {
	DVtable_xyz_select+Iparam   &xyz_select;
	DVtable_xyz+Iparam          &field_xyz[];
	DVtable_data_select+Iparam  &data_select;
	DVtable_data+Iparam         &field_data[];
	enum cell_type { choices = { "Point", "Polyline" }; values = { 0, 1 }; };
	Mesh+Node_Data+Oparam  out;
	string+Oparam  x_name;
	string+Oparam  y_name;
	string+Oparam  z_name;
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVtable_to_scat_update";
};

group DVtable_column {
	string	name;
	int     type;
	int	use;
	float	null_value;
};

module DVtable_read_init {
	int+Iparam	init_file;	// initialize columns names and types
	string+read+notify+opt   filename;
	string+Iparam	delimiter;
	int+Iparam	header;		// has a header to be read
	int+Iparam	skip_lines;	// lines at the start of the file to skip
	int+IOparam	ncol;		// num columns found in file.  Its also
					// an input if init_file == 0
	DVtable_column+Oparam	out[];
	omethod+notify_inst+notify_val  upd_func<val_state=1> = "DVtable_read_init_update";
};

module DVtable_read {
	DVtable_column+Iparam	&columns[];
	int+read+write+notify+opt	do;
	string+Iparam 	filename;
	string+Iparam	delimiter;
	int+Iparam	header;		// has a header to be read
	int+Iparam	skip_lines;	// lines at the start of the file to skip
	int+Iparam	index_column;	// generate a synthetic index column
	Data_Array+Oparam	out[] {
		veclen = 1;
	};
	int+Oparam	tbl_nrow;	// number of table rows read
	int+Oparam	tbl_ncol;	// number of table columns read
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVtable_read_update";
};

module DVgrid_read {
	string+Iparam 	filename;
	string+Iparam	delimiter;	// column seperator, e.g. space, tab, comma
	int+read+IPort2	skip_lines;	// lines at the start of the file to skip

	int+read+IPort2	col_header;	// top row is header
	int+read+IPort2	row_header;	// left column is header
	int+read+IPort2	data_type;	// Same as #defs in include/avs/dtype.h

	Mesh_Unif+Node_Data+Oparam out;
	string+Oparam	x_labels[];
	string+Oparam	y_labels[];

	omethod+notify_inst+notify_val upd_func<status=1> = "DVgrid_read_update";
};


group DVread_seq_var {
	int veclen;
	int data_type;
	string label;
	string units;
};

//
// Kinda like read_field, but the user supplies the header information
// Saves the new user from having to learn the .fld file keyword syntax.
//
module DVread_seq_binary {

	string+Iparam  filename;	/* name of file to read */
	int+Iparam skip_bytes = 0;
	int+Iparam ndim = 3;
	long+Iparam dims[ndim];
	int+Iparam endian = 0;	// endianness of the data.
	int+Iparam ncomp  = 1;
	DVread_seq_var comps[ncomp] {
		veclen = 1;
		data_type = 4;	// 4 = DTYPE_FLOAT
	};

	Mesh_Unif+Node_Data+Oparam  out;

	omethod+notify_val+notify_inst read_update<status=1> =
		"DVread_seq_binary_update";
};

//
// Kinda like read_field, but the user supplies the header information
// Saves the new user from having to learn the .fld file keyword syntax
//
module DVread_seq_ascii {

	string+Iparam  filename;	/* name of file to read */
	string+Iparam  delimiter = " ";
	int+Iparam skip_lines = 0;
	int+Iparam ndim = 3;
	long+Iparam dims[ndim];
	int+Iparam ncomp  = 1;
	DVread_seq_var comps[ncomp] {
		veclen = 1;
		data_type = 13;	// 13 = DTYPE_UNDEF
	};

	Mesh_Unif+Node_Data+Oparam  out;

	omethod+notify_val+notify_inst read_update<status=1> =
		"DVread_seq_ascii_update";
};


module DVcyl_plot {
	Mesh_Unif+Dim2+Node_Data+Iparam  &in {
		nnodes+req;
		xform+nonotify;
	};
	Grid+Iparam+opt		&in_locations;
	int+Iparam	component;
	int+Iparam	vertical;
	int+Iparam	scale_height;
	int+Iparam	scale_radius;
	int+Iparam	color_sides;

	float+Iparam	radius;
	float+Iparam	scale;
	float+Iparam	angle;
	int+Iparam	nseg;
	float+Iparam    default_rgb[3];

	Mesh+Cell_Data+Oparam  out {
		&xform+nowrite => in.xform;
	};
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVcyl_plot_update";
};

module DVseparate_cells {
	Mesh+Node_Data_Opt+Cell_Data_Opt+read+IPort2 &in {
		xform+nonotify;
	};
	int+Iparam		shrink;
	float+Iparam+opt	scale;
	Mesh+Node_Data+Cell_Data+Oparam out {
		&xform+nowrite => in.xform;
	};
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVseparate_cells_update";
};

module DVcell_centres {
	Mesh+Cell_Data_Opt+Iparam &in {
		nnodes+req;
		xform+nonotify;
	};
	Mesh+Node_Data+Oparam     out {
		&xform+nowrite => in.xform;
		ncell_sets = 1;
		Point cell_set {
			ncells=> <-.nnodes;
			node_connect_list => init_array(ncells, 0, ncells-1);
		};
	};
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVcell_centres_update";
};

module DVextrude_cells {
	Mesh+Cell_Data+read+IPort2 &in {
		xform+nonotify;
	};
	int+Iparam	height_comp;
	float+Iparam    scale;
	int+Iparam	draw_sides;
	int+Iparam	color_sides;
	int+Iparam	flip_sides_normals;
	Mesh+Cell_Data+write+nonotify out_mesh {
		&xform+nowrite => in.xform;
	};
	Mesh+OPort2+nonotify &out => merge(out_mesh, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVextrude_cells_update";
};

module DVsurf_optimize {
	Mesh_Unif+Dim2+Node_Data+Scalar+Iparam  &in {
		nnodes+req;
		dims+req;
		xform+nonotify;
	};
	float+Iparam    tolerance;

	Mesh+Node_Data out {
		&xform+nowrite => in.xform;
	};
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVsurf_optimize_update";
};

group SCTrace<NEportLevels={0,1}> {
   string+opt+IPort2 name => name_of(<-);
   float+opt color[3] = {1.0, 1.0, 1.0};
   float+IPort2 data[][2];
};

module DVsmith_chart {
   // inputs:
   // an array of traces (meshes, arrays of floats?)
   // input array of RGB values (or some kind of color spec) 1 per trace.
   // an array of strings naming the traces (1 per trace)
   // a color for the minor gridlines, if implemented
   // a color for the major gridlines
   // color for the annotation text.
   // scale factor for functional zoom
   // 
   SCTrace+IPort2+read+notify &in_traces[];

   float+read+notify+req min_spacing = 0.1;
   float+read+notify+req chord_factor = 25.0;
   int+read+notify+req spacing_plans[] =
        { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
          1, 2, 4, 6, 8, 10,
          2, 3, 5, 10,
          5, 10,
          2, 5, 10 };

   // must output multiple meshes, so they can pick the meshes.
   // 1 mesh contains graticule
   // 1 mesh contains points for annotation
   // 1 string array containing the annotation strings.
   // N meshes, one for each trace (polyline cell sets).
   //
   Mesh+Space3+OPort2+write+nonotify out;

   Mesh+Space3+Node_Data+Scalar+Float+OPort2+write+nonotify line_ann_out;
   Mesh+Space3+Node_Data+Scalar+Float+OPort2+write+nonotify top_rim_ann_out;
   Mesh+Space3+Node_Data+Scalar+Float+OPort2+write+nonotify bot_rim_ann_out;

   string+OPort2+write+nonotify annotation[];

   float+OPort2+write+nonotify ann_offset[3] = {0.01, 0.01, 0.0};

   Mesh+Space3+OPort2+write+nonotify traces {
      nspace = 3;
      Polyline cell_set[ncell_sets] {
         int ncell_data = 1;
         Data_Array cell_data[ncell_data] {
            nvals => npolys;
            veclen = 3;
            id = 667;    // GD_COLOR_DATA_ID;
         };
      };
   };

   omethod+notify_inst+req update = "CreateSmithChartMesh";
};

module DVroi_to_surf {
	Mesh+Iparam &in[] {
		xform+nonotify;
	};
	float+Iparam+opt z_coord[];
	int+Iparam	start_angle;
	int+Iparam	flip_normals;
	int+Iparam	cap_surface;
	Mesh+Oparam out {
		&xform+nres+nowrite => in[0].xform;
	};
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVroi_to_surf_update";
};

module DVextract_time_step {
	Time_Mesh+Time_Node_Data+Time_Cell_Data+Iparam &in {
		nsteps+opt;
		time+opt;
		time_coordinates+opt;
		time_node_data+opt;
		nnode_data+opt;
		nnodes+req;
		cell_set {
			nsteps+opt;
			time+opt;
			time_cell_data+opt;
			ncell_data+opt;
		};
	};
	int+Iparam+opt step;

	Mesh+Node_Data+Cell_Data+write+nonotify out_step;
	Mesh+OPort2+nonotify &out => merge(out_step, in);

	omethod+notify_inst+notify_val  upd_func<status=1> = "DVextract_time_step_update";
};

module DVinterp_time_step {
	Time_Mesh+Time_Node_Data+Time_Cell_Data+Iparam &in {
		nsteps+opt;
		time+opt;
		time_coordinates+opt;
		time_node_data+opt;
		nnode_data+opt;
		nnodes+req;
		cell_set {
			nsteps+opt;
			time+opt;
			time_cell_data+opt;
			ncell_data+opt;
		};
	};
	float+Iparam time;

	Mesh+Node_Data+Cell_Data+write+nonotify out_step;
	Mesh+OPort2+nonotify &out => merge(out_step, in);

	omethod+notify_inst+notify_val  upd_func<status=1> = "DVinterp_time_step_update";
};

module DVset_global_extent {
	Time_Mesh+Iparam &in {
		nsteps+req;
		time_coordinates+req;
	};

	Time_Mesh+write+nonotify out_mesh;
	Time_Mesh+OPort2+nonotify &out => merge(out_mesh, in);

	omethod+notify_inst+notify_val  upd_func<status=1> = "DVset_global_extent_update";
};

module DVset_global_minmax {
	Time_Node_Data+Iparam &in {
		nsteps+req;
		time_node_data+req;
	};

	Time_Node_Data+write+nonotify out_nd;
	Time_Node_Data+OPort2+nonotify &out => merge(out_nd, in);

	omethod+notify_inst+notify_val  upd_func<status=1> = "DVset_global_minmax_update";
};

module DVset_global_minmax_cell {
	Time_Cell_Data+Iparam &in {
		cell_set {
			nsteps+req;
			time_cell_data+req;
			ncell_data+req;
		};
	};

	Time_Cell_Data+write+nonotify out_cd;
	Time_Cell_Data+OPort2+nonotify &out => merge(out_cd, in);

	omethod+notify_inst+notify_val  upd_func<status=1> = "DVset_global_minmax_cell_update";
};

module DVreset_extent {
	Mesh+Iparam &in {
		nnodes+req;
		coordinates+req;
	};
	Mesh+write+nonotify out_grid;
	Mesh+OPort2+nonotify &out => merge(out_grid, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVreset_extent_update";
};

module DVreset_minmax {
	Node_Data+Iparam &in {
		nnodes+req;
		nnode_data+req;
	};
	int+Iparam comp[];
	Node_Data+write+nonotify out_nd;
	Node_Data+OPort2+nonotify &out => merge(out_nd, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVreset_minmax_update";
};

module DVreset_minmax_cell {
	Mesh+Cell_Data+Iparam &in;
	int+Iparam comp[];
	Mesh+Cell_Data+write+nonotify out_cd;
	Mesh+Cell_Data+OPort2+nonotify &out => merge(out_cd, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVreset_minmax_cell_update";
};

module DVset_minmax {
	Node_Data+Iparam &in {
		nnodes+req;
		nnode_data+req;
	};
	int+Iparam comp;
	double+Iparam min;
	double+Iparam max;
	Node_Data+write+nonotify out_nd;
	Node_Data+OPort2+nonotify &out => merge(out_nd, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVset_minmax_update";
};

module DVset_minmax_cell {
	Mesh+Cell_Data+Iparam &in;
	int+Iparam comp;
	double+Iparam min;
	double+Iparam max;
	Mesh+Cell_Data+write+nonotify out_cd;
	Mesh+Cell_Data+OPort2+nonotify &out => merge(out_cd, in);
	omethod+notify_inst+notify_val  upd_func<status=1> = "DVset_minmax_cell_update";
};

/////////////////////////////////////////////
/***   FORTRAN test stuff
module get_fld_unif {
	Mesh_Unif+Node_Data+Iparam &in_mesh;
	fmethod+notify_inst+notify_val update = "get_fld_unif";
};

module get_fld_rect {
	Mesh_Rect+Node_Data+Iparam &in_mesh;
	fmethod+notify_inst+notify_val update = "get_fld_rect";
};

module get_fld_struct {
	Mesh_Struct+Node_Data+Iparam &in_mesh;
	fmethod+notify_inst+notify_val update = "get_fld_struct";
};

module get_fld_gen {
	Mesh+Node_Data+Iparam &in_mesh;
	fmethod+notify_inst+notify_val update = "get_fld_gen";
};

module set_fld_unif {
	Mesh_Unif+Node_Data+Scalar+Float+Oparam out_mesh;
	fmethod+notify_inst+notify_val update = "set_fld_unif";
};

module set_fld_rect {
	Mesh_Rect+Node_Data+Scalar+Float+Oparam out_mesh;
	fmethod+notify_inst+notify_val update = "set_fld_rect";
};

module set_fld_struct {
	Mesh_Struct+Node_Data+Scalar+Float+Oparam out_mesh;
	fmethod+notify_inst+notify_val update = "set_fld_struct";
};

module set_fld_gen {
	Mesh+Node_Data+Oparam out_mesh;
	fmethod+notify_inst+notify_val update = "set_fld_gen";
};
***/

/////////////////////////////////////////////
// Time dependent data test
/********************************
module test_time_field_create {
	Time_Mesh+Time_Node_Data_Int+Oparam out {
		ncell_sets = 1;
		Tri+Time_Cell_Data_Set_Float cell_set;
	};
	omethod+notify_inst+notify_val  upd_func = "DVtest_time_field_create";
};

module test_time_field_output {
	Time_Mesh+Time_Node_Data_Int+Iparam &in {
		ncell_sets = 1;
		Tri+Time_Cell_Data_Set_Float cell_set;
	};
	omethod+notify_val  upd_func = "DVtest_time_field_output";
};
********************************/

module DVarray_fld_collect<locked=0> {
	Mesh+Node_Data+Iparam	&in {
		nnodes+req;
		nnode_data+opt;
		node_data+opt;
	};
	int+read+write+nonotify index=0;
	int+read+write+nonotify run=0;
	int+req+Iparam	dim;
	Mesh+Oparam	&out[];
	omethod+notify_val+notify_inst array_collect_update<status=1> = "DVarray_collect_update";
	method+notify_deinst array_collect_delete() = "DVarray_collect_delete";
};

library+buffered DV_BackwardCompatibility
                 <compile_subs=0, NEvisible=0, user_library=0> {

#ifdef NETCDF_KIT
NETCDF.NCread_object  DVread_net_cdf;
NETCDF.NCwrite_object DVwrite_net_cdf;
#endif

CFD.CFDread_PLOT3D DVread_PLOT3D_mb;

}; // BackwardCompatibility

};
