//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/bin_seq_1.v#1 $

APPS.SingleWindowApp Bin_Sequence_Synth<NEdisplayMode="maximized",
                                  NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the Binary Sequence reader being used to read a synthetic data file that contains 3 arrays that are read into a uniform field with 3 node data components. The data file contains no \"meta-data\", that is, there is no usable information about the contents of the data file in the file.  All information about the number of arrays, size of the arrays, data types of the arrays, etc., must be specified through the user interface.";
      helpfile = "examples/examples_help.htm";
#ifdef MSDOS
      UItext.rows = 11;
#else
      UItext.rows = 13;
#endif
   };

   UI {
      shell {
         x = 10;
         y = 10;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=261.,NEy=323.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.surf_plot.out_obj,
               <-.<-.<-.Axis3D.out_obj};
            Xform {
               mat = {
                  0.134537,0.0271025,0.0580998,0.,0.057885,0.00670359,-0.137167,
0.,-0.0275581,0.146393,-0.00447517,0.,0.,0.,0.,1.
               };
               xlate = {-3.30253,-2.46796,-1.79403};
               center = {22.16,16.56,12.0379};
            };
         };
      };
   };

   MODS.extract_component extract_component<NEx=261.,NEy=98.> {
      in_field => <-.Rd_Bin_Sequence.field;
      ExtrCompParam {
         component = 2;
      };
   };
   GEOMS.Axis3D Axis3D<NEx=261.,NEy=248.> {
      in_field => <-.surf_plot.out_fld;
   };
   MODS.surf_plot surf_plot<NEx=261.,NEy=173.> {
      in_field => <-.extract_component.out_fld;
      SurfPlotParam {
         scale = 0.67;
      };
   };
   MODS.Read_Binary_Sequence Rd_Bin_Sequence {
      DVread_seq_binary {
         do = 1;
      };
      param {
         filename = "$XP_PATH<0>/data/misc/sine_seq.dat";
         ndim = 2;
         dims = {50,40};
         ncomp = 3;
         endian = 1;
         comps = {
            {label="Sine",,},
            {label="Cosine",,},
            {label="SquareRoot",,}};
      };
   };
};
