//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/bin_seq_2.v#1 $

APPS.SingleWindowApp Bin_Sequence_Hydro<NEdisplayMode="maximized", NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the Binary Sequence reader being used to read the familiar hydrogen dataset.  Switch to the UI of the reader and compare the parameters entered in the UI of the reader with the keywords in the (text) field file data/field/hydrogen.fld.  Note that for byte data, the byte order does not matter.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Binary_Sequence Read_Binary_Sequence {
      param {
         filename = "$XP_PATH<0>/data/volume/hydrogen.dat";
         skip_bytes = 3;
         dims = {64,64,64};
         comps = {{data_type=0,,}};
      };
      DVread_seq_binary.do = 1;
   };

   MODS.orthoslice orthoslice {
      in_field => <-.Read_Binary_Sequence.field;
      OrthoSliceParam {
         axis = 2;
         plane => 28;
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Binary_Sequence.field;
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.orthoslice.out_obj};
            Xform {
               mat = {
                  0.107711,-0.00181516,-0.0157326,0.,0.000612589,0.108549,-0.00833001,
0.,0.0158251,0.00815289,0.107404,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-4.};
            };
         };
      };
   };
};
