/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cell_cut.v#1 $
*/

APPS.MultiWindowApp Cell_Cut<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Cell_Cut shows how the cut_plane and slice_plane macros can be used. Read_UCD is used to read in the avs_cell.inp dataset, and the modules work directly on the cell data in the field. Use the object editor in the NE (RMB->Object Editor) to look at the fields in the network and see how the cell data is organised.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D<NEx=308.,NEy=330.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.cut_plane.out_obj_cut,
               <-.<-.<-.external_edges.out_obj,
               <-.<-.<-.slice_plane.out_obj_slice};
            Xform {
               mat = {
                  0.238634,-0.0266138,0.0903959,0.,-0.0034264,0.243507,0.0807363,
0.,-0.0941701,-0.0763008,0.226133,0.,0.,0.,0.,1.
               };
               xlate = {-4.12651,-1.85343,-5.76231};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 833;
                        defaultY = 249;
                     };
                  };
               };
            };
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
            IUI {
               optionList {
                  selectedItem = 0;
                  selectedCmd => General.UI.option;
               };
               General {
                  IUI {
                     AllFrame {
                        y = 0;
                     };
                     Reset_All {
                        y = 0;
                     };
                     CurrentLight {
                        OPmenu {
                           selectedCmd => OPcmdList[0];
                        };
                     };
                     LightType {
                        OPcmdList = {,,,
                           {
                              do=1,,,set=1,,
                           }};
                        OPmenu {
                           selectedCmd => OPcmdList[3];
                        };
                     };
                     VUIColorEditor {
                        rgb_or_hsv {
                           h = 0.;
                           s = 0.;
                           v = 1.;
                        };
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_UCD Read_UCD<NEx=132.,NEy=33.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/avs_cell.inp";
      };
   };
   MODS.cut_plane cut_plane<NEx=209.,NEy=198.> {
      in_field => <-.Read_UCD.field;
      CutParam {
         dist = -6.91;
         above = 0;
         cell_data = {1};
      };
   };
   MODS.external_edges external_edges<NEx=330.,NEy=143.> {
      in_field => <-.Read_UCD.field;
   };
   MODS.slice_plane slice_plane<NEx=33.,NEy=187.> {
      in_field => <-.Read_UCD.field;
      SliceParam {
         dist = 8.37;
         cell_data = {0,1};
      };
   };

   group &field<NEportLevels={1,0},NEx=506.,NEy=22.,NEdisplayMode="open",NEwidth=220.,NEheight=352.> => .Read_UCD.field;
};
