/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/celld.v#1 $
*/

APPS.MultiWindowApp Cell_Data<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Cell_Data shows how you can threshold fields using their cell data and then convert cell data into node data using the cell_to_node macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEx=77,NEy=22> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/cells.inp";
      };
   };
   MODS.select_cells select_cells<NEx=77,NEy=99> {
      in_field => Read_UCD.field;
      sets = {0,1,2,3};
   };
   MODS.extract_cell_component extract_cell_component<NEx=77,NEy=176> {
      in_field => <-.select_cells.out_fld;
   };
   MODS.threshold_cell threshold_cell<NEx=77,NEy=242> {
      in_field => <-.extract_cell_component.out_fld;
   };
   MODS.cell_to_node cell_to_node<NEx=88,NEy=297> {
      in_field => <-.threshold_cell.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEx=99,NEy=374> {
      Scene {
         Top {
            child_objs => {cell_to_node.out_obj};
         };
      };
   };
};
