/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cgns1.v#1 $
*/

APPS.SingleWindowApp CGNS_Unstr<NEdisplayMode="maximized",disabled => Templates.CONFIG.cfd_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=30.,NEy=150> {
      demo_text = "This shows the reader for CFD General Notation System (CGNS) data.  See www.cgns.org.  Because AVS/Express does not have a Multi_Block data structure for unstructured fields, the output of the reader is actually an array of unstructured fields.  Thus the reader output is connected to an \"ARR\" module which can handle the array of fields.";
      helpfile = "examples/examples_help.htm";
   };

   string Credits<NEx=30.,NEy=30.,NEwidth=350.,NEheight=80.,NEdisplayMode="open"> = "Sample data from www.cgns.org";

   CFD.Read_CGNS read_cgns {
      CgnsParams {
         filename = "$XP_PATH<0>/data/cgns/tut21.cgns";
      };
   };

   GMOD.parse_v parse_v {
      v_commands = "read_cgns.CgnsParams.load = 1;";
      on_inst = 1;
      relative => <-;
   };

   MODS_ARR.extract_cell_component_ARR extract_cell_component_ARR {
      in_field => <-.read_cgns.unstr_fields;
      obj {
         // Enable line rendering to get an outline
         Modes.mode = { 0,2,0,0,0 };
      };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.extract_cell_component_ARR.out_obj
            };
            Xform {
               ocenter = {0.0508,0.0762,0.0127};
               dcenter = {2.66667,4.,0.666667};
               mat = {
                  41.9642,13.0868,-28.6933,0.,4.71815,44.6176,27.2501,0.,
31.1819,-24.3632,34.4919,0.,0.,0.,0.,1.
               };
               xlate = {-2.66667,-4.,-0.666667};
            };
         };
      };
   };

};
